EXCMS.Ask.Answer = {
	baseAction:'index.php?M=Modules&EM=ask&A=AskAction',
	display:[],
	// load component
	load:function(item){
		this.qid = item.qid || 0;
		this.title = item.title;
		this.mainPanel =  item.container;
		this.init_Panel();
	},
	//初始化面板
	init_Panel : function(){
		if(this.display[this.qid]){
		    this.mainPanel.unhideTabStripItem(this.display[this.qid]);
			this.display[this.qid].setVisible(true);
		}else{
			this.display[this.qid] = this.init_grid();
			this.mainPanel.add(this.display[this.qid]);
		    this.mainPanel.activate(this.display[this.qid]);
		}
		this.getStore().load();
	},
	getGrid : function(){return this.display[this.qid].items.items[0]},
	getStore : function(){return this.display[this.qid].items.items[0].getStore();},
	getDtail : function(){return this.display[this.qid].items.items[1]},
	getSoField : function(){return this.display[this.qid].items.items[0].getTopToolbar().items.items[9];},
	//初始化grid
	init_grid : function(){
	 	var answer_d = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=answerstore'}),
            baseParams : {qid:this.qid},
            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'aid',
                fields: ['qid','title','username','checked','ishidden','isbest','votecount','ip','createdate','content','catename']
            }),
            remoteSort: true
        });
        var soField = new Ext.form.TwinTriggerField({emptyText:'内容',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
		
	    var answer_grid = new Ext.grid.GridPanel({store:answer_d,region:'center',
	      	tbar:[
	      		{text:'采纳为答案',handler:this.setBest,scope:this},
	      		{text:'删除',handler:this.del,scope:this},
      			{text:'设置',menu: {items:[
      				{text:'审核',menu: {items:[
						{text:'通过',iconCls:'btnico btn_check',handler:this.setChecked,scope:this,mode:2},
						{text:'不通过',handler:this.setChecked,scope:this,mode:1}
      				]}},
      				{text:'答案隐藏',menu: {items:[
						{text:'隐藏',handler:this.setHidden,scope:this,mode:1},
						{text:'不隐藏',handler:this.setHidden,scope:this,mode:0}
					]}}
		       ]}},
		       {text:'显示',menu: {items:[
		       		{text:'全部',group: 'checked',checked: true,handler:this.displayChecked,scope:this,mode:-1},
					{text:'未审核',group: 'checked',checked: false,handler:this.displayChecked,scope:this,mode:0},
					{text:'未通过',group: 'checked',checked: false,handler:this.displayChecked,scope:this,mode:1},
					{text:'已通过',group: 'checked',checked: false,handler:this.displayChecked,scope:this,mode:2}
				]}},'-',
				{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.getStore().reload();},scope:this},
				'->','搜索 ',soField
		    ],
            columns:[
            	 new Ext.grid.RowNumberer(),
				{header:"标题",width:250,sortable:true,dataIndex:'title'},
                {header:"回答者",width:80,sortable:false,dataIndex:'username'},
                {header:"审核",width:80,sortable:true,dataIndex:'checked',renderer:this.renderStatus,scope:this},
                {header:"是否隐藏",width:80,sortable:false,dataIndex:'ishidden',renderer:this.renderHidden,scope:this},
                {header:"最佳答案",width:80,sortable:false,dataIndex:'isbest',renderer:this.renderBest,scope:this},
                {header:"投票数",width:60,sortable:true,dataIndex:'votecount'},
                {header:"回答者IP",width:100,sortable:false,dataIndex:'ip'},
                {header:"回答时间",width:130,sortable:true,dataIndex:'createdate'}
            ],
            enableColumnMove:false,collapsible:true,animCollapse:false,loadMask: true,border:false,
            bbar: new Ext.PagingToolbar({pageSize: 25,store:answer_d,displayInfo: true,displayMsg: '当前显示：{0} - {1} 总记录：{2}',emptyMsg: "暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
        });
		
        answer_grid.on('rowclick', function(g,r,e){
			this.showContent(this.getStore().getAt(r));
		},this);
        var previewPanel = new Ext.Panel({region:'south',height:100,border:false,split:true,bodyStyle:'background:#FCFCFC',maxSize:300,minSize:35,autoScroll:true});
	    var asnwer_mainPanel = new Ext.Panel({title:this.title,layout:'border',cls:'rsb-win',border:false,closable:true,items:[answer_grid,previewPanel]});
        return asnwer_mainPanel;
	},
	soOnTrigger1Click:function(){
		this.getSoField().reset();
		this.getStore().baseParams.key = '';
		this.getStore().reload();
	},
	soOnTrigger2Click:function(){
	    var key = this.getSoField().getValue().trim();
	    if(key != ''){
	        this.getStore().baseParams.key = key;
	        this.getStore().reload();
	    }
	},
	//显示详细信息
	showContent : function(data){
		data = data.data;
		if(!this.contentTemplate){
			this.contentTemplate = new Ext.XTemplate(
				'<tpl for=".">',
					'<div class="details-info">',
					'<div>{title}</div>',
					'<div><em>创建日期:</em>{createdate}</div>',
					'<div><em>修改日期:</em>{modifieddate}</div>',
					'<div><em>内容:</em>{content}</div></div>',
				'</tpl>'
			);
			this.contentTemplate.compile();
		}
        this.contentTemplate.overwrite(this.getDtail().body, data);
	},
	//采纳最佳答案
	setBest : function(){
		var record = this.getGrid().getSelectionModel().getSelected();
		if(record){
			Ext.Ajax.request({
	            url: this.baseAction+'&method=isbest',
	            method: 'POST', 
	            params:{aid:record.id},
	            failure:function(response,options){
		             alert("出现异常错误！请联系管理员！");
	            },  
	            success:function(response,options){
	                var r=jsonReturn(response);
	                alert(r.message);
	                if(r.success){
	                	var d = this.getStore();
	                	for(var i=0;i< d.getCount();i++){
	                		d.getAt(i).set('isbest',0);
	                	}
	                    d.getById(record.id).set('isbest',1);
	                    d.commitChanges();
	                }
	            }.createDelegate(this)                                    
	       });
		}else{
			alert("请选择一条或多条记录");
		}
	},
	//设置隐藏
	setHidden : function(item){
		this.setting('ishidden',item.mode);
	},
	//设置审核
	setChecked : function(item){
		this.setting('answerchecked',item.mode);
	},
	//设置属性
	setting : function(action,value){
		var data = [];
		var selected = this.getGrid().getSelectionModel().getSelections();
		if(selected.length > 0){
	        for (var i = 0, len = selected.length; i < len; i++) {data.push(selected[i].id);}
		}else{
			alert("请选择一条或多条记录");
			return false;
		}
		Ext.Ajax.request({
            url: this.baseAction+'&method=' + action,
            method: 'POST', 
            params:{aids:data.join(','),value:value},
            failure:function(response,options){
               	alert("出现异常错误！请联系管理员！");
            },  
            success:function(response,options){
                var r=jsonReturn(response);
                alert(r.message);
                if(r.success){
                	if(action == 'answerchecked') action = 'checked';
					for(var i=0; i<data.length; i++){
						this.getStore().getById(data[i]).set(action,value);
					}
					this.getStore().commitChanges();
                }
            },scope:this         
        },this);
	},
	//删除回答
	del : function(){
		var selected = this.getGrid().getSelectionModel().getSelections();
        if(selected.length > 0){
            var data = [];
            for (var i = 0, len = selected.length; i < len; i++) {data.push(selected[i].id);}
	   		Ext.MessageBox.confirm('提示','您确实要删除选定的记录吗？', function(optional){
	               if(optional=='yes'){
	                   Ext.Ajax.request({
	                        url: this.baseAction+"&method=deleteanswer",
	                        method: 'POST', 
	                        params:{aids:data.join(",")},
	                        failure:function(response,options){
	                           alert("出现异常错误！请联系管理员！");
	                        },  
	                        success:function(response,options){
	                            var r=jsonReturn(response);
	                            if(r.success){
	                              	for(var i=0;i<data.length;i++){
	                              		this.getStore().remove(this.getStore().getById(data[i]));
	                              	}
	                              	this.getStore().commitChanges();
	                            }
	                        },scope:this                               
	                   },this);
	               }
	               else return
	           },this);
         }else alert('请至少选择一条记录！');
	},
	//显示审核状态
	displayChecked : function(item){
		this.getStore().baseParams.checked = item.mode;
		this.getStore().reload();
	},
	renderHidden : function(v){return v=='1' ? "<font color='green'>是</font>" : "<font color='red'>否</font>"; },
	renderBest : function(v){return v=='1' ? "<span style='color:green;'>是</span>":''},
	renderStatus:function(v){var r=['<span class="ccheck_u" title="未经审核"></span>','<span class="ccheck_n" title="审核未通过"></span>','<span class="ccheck" title="已审核"></span>'];return r[v > (r.length-1) ? 0:( v < 0 ? 0: v)];}
};