<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskAction.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 2252 $
 */
/* $Id: AskAction.php 2252 2010-08-17 10:11:48Z zhanghaisong $ */
/**
 * EXCMS 问问动作请求程序
 */
if (!defined('EXCMS') || !defined('EXCMS_ADMIN') || !defined('ASK_PATH'))
{
    exit('Access Denied');
}
$IS_AJAX_REQUEST = true;

$message = array();
/**
 * 动作分析，执行
 */
switch($method){
	/**
	 * 加载问题分类树
	 */
	case 'tree' :
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$message = $askcate->getAskCategoryTree($_POST['node']);
		break;
	case 'catestore' :
		$paging = array(
			'limit' => $_POST['limit'],
        	'start' => $_POST['start'],
            'sort' => $_POST['sort'],
            'dir' => $_POST['dir'],
            'total' => $_POST['TotalCount'],
            'pid' => (int)$_POST['pid'],
        	'keywords' => trim($_POST['key']),
        );
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$message = $askcate->getPaging($paging);
		break;
	/**
	 * 添加/修改问题分类
	 */
	case 'catecommit' :
		$data = array(
			'pid' =>$_POST['pid'],
			'name' =>$_POST['name'],
			'description' => $_POST['description'],
			'questioncheck' => $_POST['questioncheck'],	
			'answercheck' => $_POST['answercheck'],
			'sort' => $_POST['sort']
		);
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$id = (int)$_POST['cid'];
		if($id>0){
			$askcate->update($id,$data);
		}else{
			$id = $askcate->insert($data);
		}
		$message['id']  = $id;
        $message['success'] = true;
        $message['message'] = "保存成功";
		break;
	/**
	 * 删除问题分类
	 */
	case 'delcate' :
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		// 获取待删除的分类id
		$ids = $askcate->getAskCategoryChilds($_POST['ids']);
		//删除分类下所有问题
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$questions->deleteByCid($ids);
		//删除分类信息
		$message['success'] = $askcate->delete($ids);
		$message['message'] = "删除问题分类成功";
		unset($questions,$askcate);
		break;
	/**
     * 获取问题列表数据
     */
	case 'store' :
		$paging = array(
			'limit' => $_POST['limit'],
        	'start' => $_POST['start'],
            'sort' => $_POST['sort'],
            'dir' => $_POST['dir'],
            'total' => $_POST['TotalCount'],
            'cid' => (int)$_POST['cid'],
            'checked' => $_POST['checked'],
            'status' => $_POST['status'],
            'urgent' => $_POST['urgent'],
            'elite' => $_POST['elite'],
        	'keywords' => trim($_POST['key']),
        );
    	include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message = $questions->getPaging($paging);
		unset($questions,$paging);
        break;
   /**
    * 问题添加/修改
    */
	case 'questionCommit' :
		//获取登陆用户ID
		$session = EXCMS::getSession();
		 $data = array(
        	'cid' => $_POST['cid'],
        	'title' => trim($_POST['title']),
        	'score' => $_POST['score'],
            'content' => $_POST['content'],
            'urgent' => $_POST['urgent'],
            'anonymous' => $_POST['anonymous'],
            'uid' => $session['user']['uid'],
            'ip' => $_SERVER['REMOTE_ADDR']
        );
        include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
        $id = (int)$_POST['qid'];
        if($id>0){
			$questions->update($id,$data);
		}else{			
			$id = $questions->insert($data);
		}
		$message['message'] = "保存成功";
        $message['success'] = true;
		$message['id']  = $id;
		unset($questions,$data);
		break;
	/**
	 * 加载问题详细信息
	 */
	case 'getById' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message = $questions->getById($_POST['id']);
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$cate_array =  $askcate->getById($message['cid']);
		$message['catename'] = $cate_array['name'];
		$message['createdate'] = formatDate("Y-m-d H:i:s",$message['createdate']);
    	$message['modifieddate'] = formatDate("Y-m-d H:i:s",$message['modifieddate']);
        unset($questions,$askcate,$cate_array);
		break;
	/**
	 * 删除问题
	 */
	case 'delete' : 
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message['success']  = $questions->delete($_POST['ids']);
        $message['message'] = "删除问题成功";
        unset($questions,$askcate);
		break;
	/**
	 * 设置审核状态
	 */
	case 'checked' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message['success'] = $questions->updateChecked($_POST['qids'],$_POST['value']);
		$message['message'] = $message['success'] ? '设置成功' : '设置失败';
		break;
	/**
	 * 设置问题显示状态
	 */
	case 'status' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message['success'] = $questions->updateStatus($_POST['qids'],$_POST['value']);
		$message['message'] = $message['success'] ? '设置成功' : '设置失败';
		break;
	/**
	 * 设置问题紧急程度
	 */
	case 'urgent' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message['success'] = $questions->updateUrgent($_POST['qids'],$_POST['value']);
		$message['message'] = $message['success'] ? '设置成功' : '设置失败';
		break;
	/**
	 * 设置精华问题
	 */
	case 'elite' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$questions = new AskQuestion();
		$message['success'] = $questions->updateElite($_POST['qids'],$_POST['value']);
		$message['message'] = $message['success'] ? '设置成功' : '设置失败';
		break;
		
	/**
	 * 删除答案
	 */
	case 'deleteanswer' : 
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$message['success']  = $answer->delete($_POST['aids']);
        $message['message'] = $message['success'] ? '删除答案成功' : '删除答案失败';
        unset($answer);
		break;
	/**
	 * 审核答案
	 */
	case 'answerchecked' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$message['success'] = $answer->updateStatus($_POST['aids'],$_POST['value']);
		$message['message'] = $message['success'] ? '审核成功' : '审核失败';	
		unset($answer);
		break;
	/**
	 * 隐藏答案
	 */
	case 'ishidden' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$message['success'] = $answer->updateHidden($_POST['aids'],$_POST['value']);
		$message['message'] = $message['success'] ? '设置成功' : '设置失败';	
		unset($answer);
		break;
	/**
	 * 采纳答案
	 */
	case 'isbest' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$message['success'] = $answer -> updateIsbast($_POST['aid'],true);
		$message['message'] = $message['success'] ? '采纳答案成功' : '采纳答案失败';	
		unset($answer);
		break;
	/**
	 * 显示回答列表
	 */
	case 'answerstore' :
        $paging = array(
			'limit' => $_POST['limit'],
        	'start' => $_POST['start'],
            'sort' => $_POST['sort'],
            'dir' => $_POST['dir'],
            'total' => $_POST['TotalCount'],
            'qid' => (int)$_POST['qid'],
            'checked' => $_POST['checked'],
            'cid'	=> (int)$_POST['cid'],
        	'keywords' => trim($_POST['key']),
        );
    	include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$message = $answer->getPaging($paging);
		if($paging['qid']>0){
			include_once ASK_LIB_PATH . 'AskQuestion.class.php';
			$questions = new AskQuestion();
			$questions->updateNewAnswer($paging['qid'],false);
		}
		break;
}
EXCMS::json_print($message);
?>