EXCMS.Ask.Category = {
	baseAction : 'index.php?M=Modules&EM=ask&A=AskAction',
	pid:0,
	render : function(){
		this.parent = EXCMS.Ask;
        this.D = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=catestore'}),
            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'cid',
                fields: [{name: 'cid', type: 'int'},{name: 'pid', type: 'int'},{name: 'pname', type: 'string'},{name: 'name', type: 'string'},{name: 'type', type: 'int'},{name: 'childnum', type: 'int'},
                    {name: 'wordgroupnum', type: 'int'},{name: 'description', type:'string'},{name: 'asknumber', type:'int'},{name: 'questioncheck',type:'int'},
                    {name: 'answercheck',type:'int'},{name: 'sort', type: 'int'}
                ]
            }),
            remoteSort: true
        });
        this.soField = new Ext.form.TwinTriggerField({emptyText:'名称,描述',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
		this.menu = [
		   {text:'浏览',iconCls:'btnico btn_preview',handler:this.browse,scope:this},
	       {text:'新建',iconCls:'btnico btn_add',handler:this.categoryEdit,scope:this,mode:0},
	       {text:'编辑',iconCls:'btnico btn_edit',handler:this.categoryEdit,scope:this,mode:1},
	       {text:'删除',iconCls:'btnico btn_del',handler:this.categoryDel,scope:this}
	    ];
        this.toolbar = new Ext.Toolbar({items:[
    		this.menu,'-',
            {text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload();},scope:this},
            '->','搜索 ',this.soField
        ]});
        
        this.grid = new Ext.grid.GridPanel({title:'分类列表',store:this.D,closable:true,
            columns:[
                {header:"ID",width:50,sortable:true,dataIndex:'cid'},
				{header:"分类名称",width:150,sortable:true,dataIndex:'name'},
				{header:"所属分类",width:150,sortable:true,dataIndex:'pname'},
				//{header:"分类类型",width:70,sortable:true,dataIndex:'type',renderer:this.renderType,scope:this},
				//{header:"子分类数",width:70,sortable:true,dataIndex:'childnum'},
				//{header:"关键分组数",width:70,sortable:true,dataIndex:'wordgroupnum'},
				{header:"问题数",width:70,sortable:true,dataIndex:'asknumber'},
				{header:"问题审核",width:60,sortable:true,dataIndex:'questioncheck',renderer:this.renderChecked,scope:this},
                {header:"答案审核",width:60,sortable:true,dataIndex:'answercheck',renderer:this.renderChecked,scope:this},
				{header:"序号",width:50,sortable:true,dataIndex:'sort'}
            ],
            enableColumnMove:false,collapsible:true,animCollapse:false,loadMask:{msg:'分类数据加载中...'},border:false,
            tbar:this.toolbar,
            bbar: new Ext.PagingToolbar({pageSize: 25,store:this.D,displayInfo: true,displayMsg: '当前显示：{0} - {1} 总记录：{2}',emptyMsg: "暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
        });
        this.cateMenu = new Ext.menu.Menu({items: this.menu});
		this.grid.on('rowclick', function(g,r,e){this.record=this.D.getAt(r);this.cid = this.record.id;},this);
		this.grid.on('rowcontextmenu',function(g,r,e){
			this.record=this.D.getAt(r);
			this.cid = this.record.id;
			var stm = g.getSelectionModel();
			stm.getSelections().indexOf(g.getStore().getAt(r))!=-1?stm.selectRow(r,true):stm.selectRow(r);
			this.cateMenu.showAt(e.getXY());
		},this);
		this.grid.on('activate', function(g,r,e){this.container.activatePanl='category';},this);
		this.container.add(this.grid);
		this.container.activate(this.grid);
		var request={start:0,limit:25};
		this.D.baseParams = {pid:this.pid};
        this.D.load({params:request});
		this.grid.getEl().dom.oncontextmenu = function(){return false}
		this.grid.getEl().dom.onselectstart=function(){return false}
	},
	soOnTrigger1Click:function(){
		this.soField.reset();
		this.D.baseParams.key = '';
		this.D.reload();
	},
	soOnTrigger2Click:function(){
	    var key = this.soField.getValue().trim();
	    if(key != ''){
	        this.D.baseParams.key = key;
	        this.D.reload();
	    }
	},
	load:function(item){
		if(!this.grid){
			this.container = item.container;
			this.pid = item.pid
			this.render();
		}else{
			this.container.unhideTabStripItem(this.grid);
			this.container.activate(this.grid);
			if(item.pid&&this.pid!=item.pid){
				this.D.baseParams.pid = this.pid =item.pid;
				this.D.reload();
			}
		}
	},
	//分类删除
	categoryDel:function(item){
		if(item.mode){
			if(item.categoryid < 1){Ext.MessageBox.alert('提示','请选择要删除问题分类！');return;}
			var Data = [item.categoryid];
		}else{
			var selected = this.grid.getSelectionModel().getSelections();
			if (selected.length < 1) {Ext.MessageBox.alert('提示','请选择要删除问题分类！');return;}
			var Data = [];
        	for (var i = 0, len = selected.length; i < len; i++) {Data.push(selected[i].id);}
		}
   		Ext.MessageBox.confirm('提示','删除问题分类的同时将删除该分类下面所有问题列表，您确实要删除选定的分类吗？', function(optional){
           if(optional=='yes'){
               Ext.Ajax.request({
                    url: this.baseAction+"&method=delcate",
                    method: 'POST', 
                    params:{ids:Data.join(",")},
                    failure:function(response,options){ReturnValue = Ext.MessageBox.alert("警告","出现异常错误！请联系管理员！");},  
                    success:function(response,options){
                        var r=jsonReturn(response);
                        if(r.success){
                          	for(var i=0;i<Data.length;i++){
								var r = this.D.getById(Data[i]);
								if(r) this.D.remove(r);
								if(item.mode) try{this.parent.categoryNode.parentNode.removeChild(this.parent.categoryNode);}catch(e){}
								else try{var node = this.parent.tree.getNodeById(Data[i]);if(node) node.parentNode.removeChild(node);}catch(e){}
                          	}
                          	this.D.commitChanges();
                        }
                    },scope:this
               });
           }else return
       },this);
	},
	//分类编辑
	categoryEdit : function(item){
		var title = '';
	    if(item.mode == 1){
            var record = this.grid.getSelectionModel().getSelected();
            if(!record){alert('请选择一个分类！');return;}
            title = record.get("name") + " 分类修改";
        }else if(item.mode == 3){
			if(!item.category){alert('请选择一个分类！');return;}
            var record = item.category;
            record.cid = record.id;
            title = record.text + " 分类修改";
        }else{
	        title = "新建分类";
	    }
	    if(!this.categoryEditor){
            this.categoryTree = new Ext.form.ComboBox({fieldLabel:'上级类型',store:new Ext.data.SimpleStore({fields:[],data:[[]]}),editable:false,mode: 'local',triggerAction:'all',maxHeight: 200,anchor:'100%',
                 name:'pname',tpl: "<tpl for='.'><div style='height:200px'><div id='categoryTree'></div></div></tpl>",selectedClass:'',onSelect:Ext.emptyFn,
                allowBlank:false,blankText:"上级分类",emptyText:"选择问题上级类型"
            });
            this.categoryTree.tree = new Ext.tree.TreePanel({
                border:false,cls:'channel-tree ask-tree',bodyStyle:'padding:8px 1px',lines:false,useArrows:true,
                loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=tree'}),
                root:new Ext.tree.AsyncTreeNode({id:'0',text:'问题分类',iconCls:'channel-tree-root',expanded:true})
            });
            this.categoryTree.tree.on('click',function(node){
            	this.categoryTree.setValue(node.text); 
            	this.parentid.setValue(node.id);
            	this.catepath = node.getPath();
            	this.categoryTree.collapse();
            },this);
            this.categoryTree.on('expand',function(){this.categoryTree.tree.render('categoryTree');}.createDelegate(this));
            this.parentid = new Ext.form.Hidden({name:'pid'});
            this.categoryEditorForm = new Ext.form.FormPanel({labelWidth:70,baseCls:'x-plain editorbody',bodyStyle:'padding:10px 15px;',layout:'form',url:this.baseAction+'&method=catecommit',border:false,defaultType:'textfield',items:[
           		{xtype:'hidden',name:'cid'},
            	this.parentid,
	            this.categoryTree,
	            {fieldLabel:'分类名称',name:'name',anchor:'100%',allowBlank:false,blankText:"分类名称不能为空"},
	            {fieldLabel:'问题审核',xtype:'radiogroup',columns:2,itemCls:'x-check-group-alt',anchor:'60%',items:[
					{boxLabel:'默认审核',name:'questioncheck',inputValue:1,checked:true},
					{boxLabel:'默认未审核',name:'questioncheck',inputValue:0}
				]},
				{fieldLabel:'答案审核',xtype:'radiogroup',columns:2,itemCls:'x-check-group-alt',anchor:'60%',items:[
					{boxLabel:'默认审核',name:'answercheck',inputValue:1,checked:true},
					{boxLabel:'默认未审核',name:'answercheck',inputValue:0}
				]},
	           	{fieldLabel:'描述',name:'description',xtype:'textarea',anchor:'99%',height:60},
	           	{fieldLabel:'序号',name:'sort',xtype:'numberfield',anchor:'30%'}
            ]});
            this.categoryEditor = new Ext.Window({id:'dlg-Ask-category-editor',title:title,layout:'fit',minimizable:true,modal:false,resizable:false,width:460,height:290,closeAction:'hide',plain:false,
                items: this.categoryEditorForm,bodyStyle:'background:#FFF',
                buttons: [{text:'确定',handler: this.categorySave,scope:this},{text: '取消',handler: function(){this.categoryEditor.hide();},scope:this}]
            });
            this.categoryEditorForm.form.on('actioncomplete',function(form,action){
                if(action.result.success){
					alert(action.result.message);
					this.categoryEditor.hide();
					this.parent.renderNode(this.parentid.getValue());
                }               
            }, this);
	    }
        this.categoryEditor.setTitle(title);
        this.categoryEditor.show(this);
         if(item.mode == 1){
        	this.categoryEditorForm.form.setValues(record.data);
        }else if(item.mode == 3){
		 	record.name = record.text;
        	this.categoryEditorForm.form.setValues(record);
        }else{
        	this.categoryEditorForm.form.reset();
			if(item.mode == 2){
				this.categoryTree.setValue(item.pname); 
            	this.parentid.setValue(item.pid);
			}
        }
	},
    //分类保存
	categorySave : function(){
	    if(!this.categoryEditorForm.form.isValid()){Ext.MessageBox.show({title:'错误',msg:"请检查红线处的错误",buttons:Ext.MessageBox.OK,icon:'ext-mb-error'});return ;}
	    this.categoryEditorForm.form.submit();
	},
	//浏览
	browse : function(item){
		if(this.record && this.cid > 0){
			EXCMS.util.RequestUrl(this.parent.ask_config.list,{cid:this.cid});
		}else{
			alert("请选择问题分类");
		}
	},
	renderType : function(v){var r=['','分类','关键组','关键字'];return r[v]},
	renderChecked:function(v){return v ? '需审核':'无需审核';}
};