EXCMS.Ask.Config = {
	baseAction: 'index.php?M=Modules&A=Index&moduleid=ask',
	display:[],
	// load component
	load:function(item){
		this.mainPanel = item.container;
		this.init_Panel();
	},
	//加载模块基本配置信息
	init_Panel : function(){
		if(!this.configGrid){
			this.configD = new Ext.data.Store({proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=settingStore'}),
	            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'id',
	                fields:["id","name","value","description",{name:'type',type:'int'},"sort",{name:'issystem',type:'int'},{name:'multisite',type:'int'}]
	            }),remoteSort:false
	        });
			this.configGrid = new Ext.grid.EditorGridPanel({title:'问答参数设置',store:this.configD,loadMask:{msg:'正在加载ASK模块配置信息,请稍后...'},
				minColumnWidth:2,autoExpandColumn:3,border:false,sm:new Ext.grid.RowSelectionModel(),closable:true,
	            columns:[
					new Ext.grid.RowNumberer(),
					{header:"变量名",width:150,sortable:true,dataIndex:'name'},
					{header:"变量值",width:220,sortable:true,dataIndex:'value',renderer:this.renderValue,scope:this},
					{header:"描述",width:150,sortable:true,dataIndex:'description'},
					{header:"数据类型",width:80,sortable:true,dataIndex:'type',renderer:this.renderType,scope:this},
					{header:"系统变量?",width:70,align:'center',sortable:true,dataIndex:'issystem',renderer:this.renderIsSys,scope:this},
					{header:'排序',width:60,sortable:true,dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
				],
				tbar:[
					{text:'新建',iconCls:'btnico btn_add',handler:this.editConfig,scope:this,mode:0},
					{text:'编辑',iconCls:'btnico btn_edit',handler:this.editConfig,scope:this,mode:1},
					{text:'删除',iconCls:'btnico btn_del',handler:this.delSetting,scope:this},'-',
					{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.configD.reload()},scope:this}
				]
			});
			
			this.configGridMenu = new Ext.menu.Menu({items:[
	            {text:'新建',icon:ico,iconCls:'ico add',handler:this.editConfig,scope:this,mode:0},
	            {text:'编辑',icon:ico,iconCls:'ico edit',handler:this.editConfig,scope:this,mode:1},
	            {text:'删除',icon:ico,iconCls:'ico del',handler:this.delSetting,scope:this},
	            '-',
	            {text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.configD.reload()},scope:this}
	        ]}); 
			
			this.configGrid.on('celldblclick',function(g,r,c,e){if(c!=6){this.settingRecord=this.configD.getAt(r);this.editConfig({mode:1});}},this);
			this.configGrid.on('rowcontextmenu',function(g,r,e){var s=g.getSelectionModel();s.getSelections().indexOf(g.getStore().getAt(r))!= -1?s.selectRow(r,true):s.selectRow(r);this.settingRecord=this.configD.getAt(r);this.configGridMenu.showAt(e.getXY())},this);
			this.configGrid.on('afteredit',this.saveSettingSort,this);
			this.mainPanel.add(this.configGrid);
			this.mainPanel.activate(this.configGrid);
			this.configGrid.getEl().dom.oncontextmenu = function(){return false;}
			this.configGrid.getEl().dom.onselectstart = function(){return false;}
	        this.configD.load();
		}
		this.mainPanel.unhideTabStripItem(this.configGrid);
		this.mainPanel.activate(this.configGrid);
	},
	
	editConfig : function(item){
		var title;
		if(item.mode==1){
			this.settingRecord = this.configGrid.getSelectionModel().getSelected();
			if(this.settingRecord){title ='修改 '+ this.settingRecord.get('name');}else{alert('请选择要编辑的变量');return ;}
		}else{title='新建变量';}
		if(!this.editConfigWin){
				this.configformPanel = new Ext.form.FormPanel({labelWidth:70,autoScroll:false,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
					{name:'id',xtype:'hidden'},{name:'issystem',xtype:'hidden'},
					{fieldLabel:'变量名',name:'name',allowBlank:false,blankText:'变量名不能为空'},
					{fieldLabel:'变量类型',xtype:'radiogroup',items:[
						{boxLabel:'布尔型',name:'type',inputValue:1},
						{boxLabel:'数字',name:'type',inputValue:2},
						{boxLabel:'文本',name:'type',inputValue:3,checked:true},
						{boxLabel:'多行文本',name:'type',inputValue:4}
					]},
					{fieldLabel:'变量值',xtype:'radiogroup',items:[
						{boxLabel:'是',name:'value',inputValue:1,checked:true},
						{boxLabel:'否',name:'value',inputValue:0}
					]},
					{fieldLabel:'变量值',name:'value1',xtype:'numberfield'},
					{fieldLabel:'变量值',name:'value2'},
					{fieldLabel:'变量值',name:'value3',xtype:'textarea'},
					{xtype:'textarea',fieldLabel:'描述',name:'description',height:60},
					{xtype:'numberfield',fieldLabel:'排序',value:100,name:'sort',maxLength:6,anchor:'30%'},
					{name:'moduleid',xtype:'hidden'}
				]});
				
	            this.editConfigWin=new Ext.Window({layout:'fit',modal:false,resizable:false,width:520,height:300,closeAction:'hide',plain: true,
	                items:this.configformPanel,
	                buttons:[{text:'确定',handler:this.saveSetting,scope:this},{text:'取消',handler:function(){this.editConfigWin.hide()},scope:this}]
	            });
	            this.configformPanel.form.on('actioncomplete',function(form,action){
	                if(action.result.success){this.editConfigWin.hide();this.configD.reload();}
	            }, this);
		}
		this.editConfigWin.setTitle(title);
		this.editConfigWin.show();
		this.configformPanel.form.items.items[3].items.each(function(f){f.on('check',function(s,c){if(c){this.setVisible(s.inputValue)}},this);},this);
		if(item.mode==1){
			var data = this.settingRecord.data;
        	this.configformPanel.form.setValues(data);
			this.setValue(data.type, data.value);
			this.setDisabled(data.issystem);
			this.setVisible(data.type);
		}else{
            this.configformPanel.form.reset();
			this.setDisabled();
			this.setVisible(3);
		}
	},
	
	saveSetting : function(){
		if(!this.configformPanel.form.isValid()){alert('请检查红线处的错误提示！');return}
		var act = this.configformPanel.form.items.items[0].getValue() == '' ? '&method=settingInsert' : '&method=settingUpdate';
		var type = this.configformPanel.form.items.items[3].getValue();
		var name = this.configformPanel.form.items.items[2].value;
		this.configformPanel.form.submit({url:this.baseAction+act,params: {type: type,name: name}});
	},
	saveSettingSort : function(){
		var records = this.configD.getModifiedRecords();
		var data=[];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].data.id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			this.configGrid.getEl().mask('搜索设置排序数据保存中,请稍候');
			Ext.Ajax.request({url:this.baseAction+'&method=updateSettingSort',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data)},
				failure:function(){this.categoryGrid.getEl().unmask();},
				success:function(r,o){
					this.configGrid.getEl().unmask();
					r=jsonReturn(r);
					if (r.success) {
						this.configD.commitChanges();
					}
				}
			});
		}
	},
	
	//删除系统变量
	delSetting:function(){
        var records = this.configGrid.getSelectionModel().getSelections();
        var flag = false
        if(records.length > 0){
			var ids=[]
            for(var i=0,len=records.length;i<len; i++){
            	if(records[i].data.issystem) {flag = true;break;}
            	ids.push(records[i].id);
            }
        }else{
			alert('请选择要删除的变量');
			return ;
		}
        if(flag){alert('模块系统变量不允许删除！');return;}
       	if(confirm('您确实要删除选定的记录吗？')){
			Ext.Ajax.request({
				url:this.baseAction + '&method=settingDelete',method:'POST', params:{ids:ids.join(',')},scope:this,
				success:function(r,o){
					r=jsonReturn(r);
					if(r.success){this.configD.reload();}
				}
			});
        }
	},
	
	setDisabled : function(issystem){
		for(var i=1;i<4;i++){
			this.configformPanel.form.items.items[i].setDisabled(issystem=='1'?true:false);
		}
	},
	
	renderType:function(v){var d=['布尔型','数字','文本','多行文本'];return v>0&&v<5?d[v-1]:d[2]},
	renderIsSys:function(v){return v=='1'?'<font color=red>是</font>':'<font color=green>否</font>'},
	renderValue:function(v,m,r){return r.get('type')==1?(v==1?"<font color='green'>是</font>":"<font color='red'>否</font>"):v},
	
	//设置显示变量类型
	setVisible:function(type){
		type = type > 0 && type < 5 ? type : 3;
		for(var i=4;i<8;i++){
			this.configformPanel.form.items.items[i].container.dom.parentNode.style.display = (type + 3) == i ? '' : 'none';
		}
	},
	
	setValue:function(type, value){
		for(var i=4;i<8;i++){
			this.configformPanel.form.items.items[i].setValue((type + 3) == i ? value : '');
		}
	}
};