EXCMS.namespace('EXCMS.Ask');
EXCMS.Ask = {
	baseAction : 'index.php?M=Modules&EM=ask&A=AskAction',
	modulesAction : 'index.php?M=Modules&A=ModulesAction&moduleid=ask',
	checked: -1,
	urgent: -1,
	init:function(){
	    Ext.QuickTips.init();
	    this.ask_config = _EXCMS_ASK_CONFIG;
	    this.view();
	},
	view : function(){
        this.D = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=store'}),
            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'qid',
                fields: [{name: 'qid', type: 'int'},
                    {name: 'catename', type: 'string'},{name: 'title', type: 'string'},{name: 'score', type: 'string'},{name: 'hot', type: 'string'},
                    {name: 'checked', type: 'int'},{name: 'elite', type:'int'},{name: 'status', type:'int'},{name: 'newanswer',type:'int'},
                    {name: 'answernumber',type:'int'},{name: 'createdate'}, {name: 'modifieddate'},{name: 'username', type: 'string'}
                ]
            }),
            remoteSort: true
        });
        this.soField = new Ext.form.TwinTriggerField({emptyText:'内容,标题',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
		this.menu = [
		   {text:'浏览',iconCls:'btnico btn_preview',handler:this.browse,scope:this,mode:0},
		   {text:'查看回答',iconCls:'btnico btn_preview',handler:this.viewanswer,scope:this},
	       {text:'新建',iconCls:'btnico btn_add',handler:this.QuestionEdit,scope:this,mode:0},
	       {text:'编辑',iconCls:'btnico btn_edit',handler:this.QuestionEdit,scope:this,mode:1},
	       {text:'删除',iconCls:'btnico btn_del',handler:this.QuestionDel,scope:this},
	       {text:'设置',menu: {items:[
		       	{text:'审核',menu: {items:[
					{text:'通过',iconCls:'btnico btn_check',handler:this.setChecked,scope:this,mode:2},
					{text:'不通过',handler:this.setChecked,scope:this,mode:1}
				]}},
				{text:'问题状态',menu: {items:[
					{text:'待解决',handler:this.setStatus,scope:this,mode:2},
					{text:'已解决',handler:this.setStatus,scope:this,mode:3},
					{text:'已过期',handler:this.setStatus,scope:this,mode:4},
					{text:'投票',handler:this.setStatus,scope:this,mode:5},
					{text:'关闭',handler:this.setStatus,scope:this,mode:6}
				]}},
				{text:'紧急程度',menu: {items:[
					{text:'紧急',handler:this.setUrgent,scope:this,mode:1},
					{text:'普通',handler:this.setUrgent,scope:this,mode:0}
				]}},
				//{text:'推荐',handler:this.setElite,scope:this,mode:1},
				{text:'设置精华',menu: {items:[
					{text:'精华',handler:this.setElite,scope:this,mode:1},
					{text:'非精华',handler:this.setElite,scope:this,mode:0}
				]}}
				
	       ]}},
	       {text:'显示',menu: {items:[
		       {text:'审核状态',menu: {items:[
		       		{text:'全部',group: 'checked',checked: true,handler:this.displayChecked,scope:this,mode:-1},
					{text:'未审核',group: 'checked',checked: false,handler:this.displayChecked,scope:this,mode:0},
					{text:'未通过',group: 'checked',checked: false,handler:this.displayChecked,scope:this,mode:1},
					{text:'已通过',group: 'checked',checked: false,handler:this.displayChecked,scope:this,mode:2}
				]}},
				{text:'问题',menu: {items:[
					{text:'全部',group: 'status',checked: true,handler:this.displayStatus,scope:this,mode:0},
		       		{text:'待解决',group: 'status',checked: false,handler:this.displayStatus,scope:this,mode:2},
					{text:'已解决',group: 'status',checked: false,handler:this.displayStatus,scope:this,mode:3},
					{text:'已过期',group: 'status',checked: false,handler:this.displayStatus,scope:this,mode:4},
					{text:'投票',group: 'status',checked: false,handler:this.displayStatus,scope:this,mode:5},
					{text:'关闭',group: 'status',checked: false,handler:this.displayStatus,scope:this,mode:6}
				]}},
				{text:'紧急程度',menu: {items:[
					{text:'全部',group: 'urgent',checked: true,handler:this.displayUrgent,scope:this,mode:-1},
					{text:'紧急',group: 'urgent',checked: false,handler:this.displayUrgent,scope:this,mode:1},
					{text:'普通',group: 'urgent',checked: false,handler:this.displayUrgent,scope:this,mode:0}
				]}},
				{text:'精华',menu: {items:[
					{text:'全部',group: 'elite',checked: true,handler:this.displayElite,scope:this,mode:3},
					{text:'精华',group: 'elite',checked: false,handler:this.displayElite,scope:this,mode:1},
					{text:'非精华',group: 'elite',checked: false,handler:this.displayElite,scope:this,mode:0}
				]}}
	       ]}}
	    ];
        this.toolbar = new Ext.Toolbar({items:[
    		this.menu,'-',
            {text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload();},scope:this},
            '->','搜索 ',this.soField
        ]});
        
        this.grid = new Ext.grid.GridPanel({title:'问题列表',store:this.D,
            columns:[
                {header:"ID",width:50,sortable:true,dataIndex:'qid'},
				{header:"标题",width:250,sortable:true,dataIndex:'title'},
				{header:"分类",width:100,sortable:true,dataIndex:'catename'},
				{header:"悬赏分",width:50,sortable:true,dataIndex:'score'},
                {header:"提问者",width:80,sortable:true,dataIndex:'username'},
                {header:"审核",width:36,sortable:true,dataIndex:'checked',renderer:this.renderChecked,scope:this},
				{header:"状态",width:70,sortable:true,dataIndex:'status',renderer:this.renderStatus,scope:this},
                {header:"精华",width:46,sortable:true,dataIndex:'elite',renderer:this.formateScore,scope:this},
                {header:"答案数",width:50,sortable:true,dataIndex:'answernumber'},
                {header:"点击",width:50,sortable:true,dataIndex:'hot'},
                {header:"提问时间",width:130,sortable:true,dataIndex:'createdate'}
            ],
			autoExpandColumn:1,autoExpandMin:250,autoExpandMax:400,
            enableColumnMove:false,collapsible:true,animCollapse:false,loadMask:{msg:'问题数据加载中...'},border:false,
            tbar:this.toolbar,
            bbar: new Ext.PagingToolbar({pageSize: 25,store:this.D,displayInfo: true,displayMsg: '当前显示：{0} - {1} 总记录：{2}',emptyMsg: "暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
        });
        
        this.questionMenu = new Ext.menu.Menu({items: this.menu});
		this.grid.on('rowclick', function(g,r,e){
			this.currentQid = g.getStore().getAt(r).id;
		},this);
		this.grid.on('rowcontextmenu',function(g,r,e){
			this.record=this.D.getAt(r);
			this.currentQid = g.getStore().getAt(r).id;
			var stm = g.getSelectionModel();
			stm.getSelections().indexOf(g.getStore().getAt(r))!=-1?stm.selectRow(r,true):stm.selectRow(r);
			this.questionMenu.showAt(e.getXY());
		},this);
		this.grid.on('activate', function(g,r,e){this.tabPanel.activatePanl='question';},this);
		this.tabPanel = new Ext.TabPanel({region:'center',border:false,style:'border:1px solid #99BBE8;border-width:0px 0px 0px 1px',activeTab:0,enableTabScroll:true,autoDestroy:false,items:this.grid});
		this.tabPanel.on('beforeremove',function(t,c){t.activate(0);t.hideTabStripItem(c);return false;},this);
		this.tree = new Ext.tree.TreePanel({title:'问题分类',cls:'channel-tree ask-tree',bodyStyle:'padding:8px 1px;border-bottom:1px solid #99BBE8;',collapsible:false,
			rootVisible:true,lines:true,useArrows:true,border:false,autoScroll:true,
		    loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=tree'}),root:new Ext.tree.AsyncTreeNode({id:'0',text:'问题分类',cls:'category-tree-root',expanded:true}),
		    tbar: this.treemenu
		});
		this.treeMenu = [
			new Ext.menu.Menu({items: [
				{text:'浏览',iconCls:'ico preview',handler:this.browse,scope:this,mode:1},'-',
				{text:'新建',iconCls:'btnico btn_add',menu:new Ext.menu.Menu({items:[
					{text:'新建分类',handler:this.categoryEdit,scope:this,mode:0},
			   	 	{text:'新建下级分类',handler:this.categoryEdit,scope:this,mode:2},'-',
					{text:'新建问题',icon:ico,iconCls:'ico add_article',handler:this.QuestionEdit,scope:this,mode:0}
			  	]}),scope:this},
				{text:'修改',iconCls:'ico edit',handler:this.categoryEdit,scope:this,mode:3},
				{text:'删除',iconCls:'ico del',handler:this.categoryDel,scope:this,mode:1},'-',
				{text:'刷新分类节点',iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this}
			]}),
			new Ext.menu.Menu({items: [
				{text:'浏览',iconCls:'btnico btn_preview',handler:this.browse,scope:this,mode:1},
				{text:'新建问题',iconCls:'ico add_article',handler:this.QuestionEdit,scope:this,mode:0},
				{text:'刷新分类节点',iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this}
			]}),
			new Ext.menu.Menu({items: [
				{text:'浏览',iconCls:'btnico btn_preview',handler:this.browse,scope:this,mode:1},'-',
				{text:'刷新分类节点',iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this}
			]}),
			new Ext.menu.Menu({items: [
				{text:'刷新分类节点',iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this}
			]})
		];
		this.tree.on('contextmenu',function(n,e){
			n.select();
			this.categoryNode = n;
			if(n.id == 0){
				this.treeMenu[3].showAt(e.getXY());return;
			}
			if (this.tabPanel.activatePanl == 'category') {
				this.treeMenu[0].showAt(e.getXY());
			}else if(this.tabPanel.activatePanl == 'question'){
				this.treeMenu[1].showAt(e.getXY());
			}else{
				this.treeMenu[2].showAt(e.getXY());
			}
			this.catepath = n.getPath();
		},this);
		this.tree.on('click',function(n,e){
        	this.D.baseParams.cid = n.id;
        	this.categoryNode = n;
			if(this.tabPanel.activatePanl == 'category'){
				try{
					if(n.id&&EXCMS.Ask.Category.D.baseParams.pid!=n.id){
						EXCMS.Ask.Category.D.baseParams.pid=n.id;
						EXCMS.Ask.Category.D.reload();
					}
				}catch(e){}
			}else if(this.tabPanel.activatePanl == 'question'){
				this.D.reload();
			}else{
				this.container.activate(this.grid);
				this.D.reload();
			}
			this.catepath = n.getPath();
        },this);    
		this.main = new Ext.Viewport({layout:'border',items:[{region:'west',border:false,style:'border:1px solid #99BBE8;border-width:0px 1px 0px 0px',
					title:'控制面板',split:true,width:200,minSize:35,maxSize:400,layout:'accordion',layoutConfig:{animate:true},
                    items: [this.tree,{title:'问答管理',contentEl:'ask-action',border:false}]},this.tabPanel]});
		this.D.setDefaultSort('createdate', 'DESC');
		var request={start:0,limit:25};
        this.D.load({params:request});
		this.grid.getEl().dom.oncontextmenu = function(){return false}
		this.grid.getEl().dom.onselectstart=function(){return false}
		this.tree.getEl().dom.oncontextmenu = function(){return false}
		this.tree.getEl().dom.onselectstart=function(){return false}
	},
	soOnTrigger1Click:function(){
		this.soField.reset();
		this.D.baseParams.key = '';
		this.D.reload();
	},
	soOnTrigger2Click:function(){
	    var key = this.soField.getValue().trim();
	    if(key != ''){
	        this.D.baseParams.key = key;
	        this.D.reload();
	    }
	},
	refreshTree : function(item){
		if(this.categoryNode.id == 0) {if(this.tree.root.loaded)this.tree.getLoader().load(this.tree.root);this.tree.root.expand();}
		else {if(this.categoryNode.loaded)this.tree.getLoader().load(this.categoryNode);this.categoryNode.expand();}
	},
	//刷新分类树
	renderNode : function(nodeId){
		var newParentNode = this.tree.getNodeById(nodeId);
		if(newParentNode){
			if(newParentNode.loaded){
				this.tree.getLoader().load(newParentNode);
			}
			newParentNode.expand();
		}else{
			this.tree.expandPath(this.catepath);
		}
    },
	reload:function(){
		
	},
	categoryEdit:function(item){
		if(item.mode==2){
			item.pid = this.categoryNode.id;
			item.pname = this.categoryNode.text;
		}else if(item.mode==3){
			item.category = this.categoryNode.attributes;
			item.category.pid = this.categoryNode.parentNode.id;
			item.category.pname = this.categoryNode.parentNode.text;
		}
		try{EXCMS.Ask.Category.categoryEdit(item);}catch(e){}
	},
	categoryDel:function(item){
		item.categoryid=this.categoryNode.id;
		try{EXCMS.Ask.Category.categoryDel(item);}catch(e){}
	},
	//编辑问题
	QuestionEdit : function(item){
	    var title = '';
	    if(item.mode == 0){
	        title = "新建问题";
	    }else if(item.mode == 1){
	    	var record = this.grid.getSelectionModel().getSelected();
            if(!record){alert('请选择一个问题！');return;}
            title = record.get("title")
            title = title.length > 10 ? title.substring(0,10)+"..." : title;            
        }
	    if(!this.QuestionForm){
	    	this.Ask_category=new Ext.form.ComboBox({fieldLabel:'问题分类',store:new Ext.data.SimpleStore({fields:[],data:[[]]}),editable:false,
				mode:'local',triggerAction:'all',maxHeight:200,hidename:'AskCategory',name:'catename',width:300,
				tpl: "<tpl for='.'><div style='height:200px'><div id='AskCategory'></div></div></tpl>",
				selectedClass:'',onSelect:Ext.emptyFn,allowBlank:false,blankText:"问题分类",emptyText:'请选择问题分类'
			});
	        this.Ask_category.tree = new Ext.tree.TreePanel({
	             border:false,
	             loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=tree'}),
	             root:new Ext.tree.AsyncTreeNode({id:'0',text:'问题分类树',expanded:true})
              });
			this.Ask_category.tree.on('click',function(node){
				if(node.id=='0'){ return ;} 
				this.Ask_category.setValue(node.text);  
				this.askcid.setValue(node.id);
				this.Ask_category.collapse();
			},this);
            this.Ask_category.on('expand',function(){this.Ask_category.tree.render('AskCategory');}.createDelegate(this));
          	this.askcid = new Ext.form.Hidden({name:'cid'});
          	this.QuestionForm = new Ext.FormPanel({region:'center',autoScroll:false,title:title,border:false,baseCls:'x-plain',url:this.baseAction+'&method=questionCommit',closable:true,
                items:[
                	{xtype:'hidden',name:'qid'},this.askcid,
					{layout:'form',anchor:'100%',height:140,bodyStyle:'background:#DFE8F6;padding:10px 0 0 10px;',labelWidth:60,border:false,items:[
						this.Ask_category,
	                    {layout:'column',border:false,anchor:'98%',height:26,bodyStyle:'background:#DFE8F6;',items:[
							{xtype:'label',text:'主题:',width:65,cls:'x-form-item',style:'line-height:22px'},
							{xtype:'textfield',width:400,name:'title',allowBlank:false,blankText:"问题不能为空"},
	                        {xtype:'label',text :'请将标题描述清晰易懂',cls:'x-form-item',style:'padding-left:10px;line-height:20px'}
	           			]},
	           			{fieldLabel:'悬赏分',hiddenName:'score',xtype:'combo',width:140,editable:false,mode:'local',
							triggerAction:'all',selectOnFocus:true,value:0,
							store: [[0,'0分'],[5,'5分'],[10,'10分'],[15,'15分'],[20,'20分'],[30,'30分'],[50,'50分'],[80,'80分'],[100,'100分']]
						},
	           			{fieldLabel:'匿名设定',xtype:'checkbox',anchor:'98%',boxLabel:'您可以对问题设定匿名，但您需要付出财富值10分',name:'anonymous',inputValue:1},
                        {fieldLabel:'紧急程度',xtype:'checkbox',anchor:'98%',boxLabel:'您能当前所提的问题是否紧急,但您需要付出财富值20分',name:'urgent',inputValue:1}
					]},
           			{xtype:'htmleditor',name:'content',hideLabel:true,enableAlignments:false,anchor:'100% -90'}
            	],
               tbar:[
                   {text:'保存',handler:this.QuestionSave,scope:this},
                   {text:'重置',handler:function(){this.QuestionForm.form.reset();},scope:this},
                   {text:'取消',handler:function(){this.tabPanel.activate(0);this.tabPanel.hideTabStripItem(this.QuestionForm);},scope:this}
		        ]
            });
          
            this.QuestionForm.form.on('actioncomplete',function(form,action){
            	if(action.result.success){
            		alert(action.result.message);
            		this.tabPanel.activate(0);
            		this.tabPanel.hideTabStripItem(this.QuestionForm);
            		this.D.reload();
            	}
            }, this);
	    	this.tabPanel.add(this.QuestionForm);
	        this.tabPanel.activate(this.QuestionForm);
	    }else{
	    	this.tabPanel.unhideTabStripItem(this.QuestionForm);
			this.tabPanel.activate(this.QuestionForm);
	    }
        this.QuestionForm.setTitle(title);
         if(item.mode == 1){
         	this.loadQuestionData();
        }else this.QuestionForm.form.reset();	
	},
	//加载问题数据
	loadQuestionData : function(){
		 this.QuestionForm.el.mask('问题数据加载中...');
		 Ext.Ajax.request({
            url: this.baseAction+'&method=getById',
            method: 'POST', 
            params:{id:this.currentQid},
            failure:function(response,options){
            	this.QuestionForm.el.unmask();
                alert("请求服务失败");
            },  
            success:function(response,options){
                 var r=jsonReturn(response);
                 this.QuestionForm.el.unmask();
                 this.QuestionForm.form.setValues(r);
                 this.askcid.setValue(r.cid);
            },scope:this                                    
        });
	},
	//保存问题
	QuestionSave : function(){
		if(!this.QuestionForm.form.isValid()){Ext.MessageBox.show({title:'错误',msg:"请检查红线处的错误",buttons:Ext.MessageBox.OK,icon:'ext-mb-error'});return ;}
	    this.QuestionForm.form.submit();
	},
	//问题删除
	QuestionDel : function(){
        var selected = this.grid.getSelectionModel().getSelections();
        if(selected.length > 0){
            var Data = [];
            for (var i = 0, len = selected.length; i < len; i++) {Data.push(selected[i].id);}
	   		Ext.MessageBox.confirm('提示','您确实要删除选定的记录吗？', function(optional){
	               if(optional=='yes'){
	                   Ext.Ajax.request({
	                        url: this.baseAction+"&method=delete",
	                        method: 'POST', 
	                        params:{ids:Data.join(",")},
	                        failure:function(response,options){
	                            ReturnValue = Ext.MessageBox.alert("警告","出现异常错误！请联系管理员！");
	                        },  
	                        success:function(response,options){
	                            var r=jsonReturn(response);
	                            if(r.success){
	                              	for(var i=0;i<Data.length;i++){
	                              		this.D.remove(this.D.getById(Data[i]));
	                              	}
	                              	this.D.commitChanges();
	                            }
	                        }.createDelegate(this)                                    
	                   });
	               }
	               else return
	           }.createDelegate(this));
         }else Ext.MessageBox.alert('提示','请至少选择一条记录！');
	},
	//设置审核
	setChecked : function(item){
		this.setting('checked',item.mode);
	},
	//设置问题状态
	setStatus : function(item){
		this.setting('status',item.mode);
	},
	//设置问题紧急程度
	setUrgent : function(item){
		this.setting('urgent',item.mode);
	},
	//设置精华问题
	setElite : function(item){
		this.setting('elite',item.mode);
	},
	//按审核状态显示
	displayChecked : function(item){
		this.checked = item.mode;
		this.display();
	},
	//按问题状态显示
	displayStatus : function(item){
		this.status = item.mode;
		this.display();
	},
	//按紧急程序显示
	displayUrgent : function(item){
		this.urgent = item.mode
		this.display();
	},
	//按精华显示
	displayElite  : function(item){
		this.elite = item.mode;
		this.display();
	},
	//显示方式
	display : function(){
		this.D.baseParams = {checked:this.checked,status:this.status,urgent:this.urgent,elite:this.elite};
		if(this.categoryNode){
			this.D.baseParams.cid = this.categoryNode.id;
		}
		this.D.reload();
	},
	//设置
	setting : function(action,value){
		var data = [];
		var selected = this.grid.getSelectionModel().getSelections();
		if(selected.length > 0){
	        for (var i = 0, len = selected.length; i < len; i++) {data.push(selected[i].id);}
		}else{
			alert("请选择一条或多条记录");
			return false;
		}
		Ext.Ajax.request({
            url: this.baseAction+'&method=' + action,
            method: 'POST', 
            params:{qids:data.join(','),value:value},
            failure:function(response,options){
               	alert("警告","出现异常错误！请联系管理员！");
            },  
            success:function(response,options){
                var r=jsonReturn(response);
                if(r.success){
           			alert(r.message);
					for(var i=0; i<data.length; i++){
						this.D.getById(data[i]).set(action,value);
					}
					this.D.commitChanges();
                }
            },scope:this         
        },this);
	},
	
	//浏览
	browse : function(item){
		//浏览问题分类
		if(item.mode==1){
			if(this.categoryNode){
				EXCMS.util.RequestUrl(this.ask_config.list,{cid:this.categoryNode.id});
			}else{
				alert("请选择问题分类");
			}
		}else{	//浏览问题
			if(this.currentQid){
				EXCMS.util.RequestUrl(this.ask_config.question,{id:this.currentQid});
			}else{
				alert("请选择一条记录");
			}
		}
	},
	//显示回答列表
	viewanswer : function(){
		var title;
		if(this.grid.getSelectionModel().getSelected()){
			title = this.grid.getSelectionModel().getSelected().get("title");
			title = title.length > 10 ? title.substring(0,10)+"..." : title;
		}else{
			title ='全部回答列表';
		}
		EXCMS.util.script('../ask/admin/Answer.js',{object:'EXCMS.Ask.Answer',container:this.tabPanel,qid:this.currentQid,title:title});
	},
	active : function(o){
		this.type = o;
		switch(o){
			//显示问题列表
			case 'category' :
				EXCMS.util.script('../ask/admin/Category.js',{object:'EXCMS.Ask.Category',container:this.tabPanel,'pid':this.categoryNode&&this.categoryNode.id?this.categoryNode.id:0});
				this.main.items.items[0].items.items[0].expand();
				break;
			//显示问题列表
			case 'question' :
				this.tabPanel.activate(this.grid);
				this.main.items.items[0].items.items[0].expand();
				break;
			//显示回答列表
			case 'answer' :
				EXCMS.util.script('../ask/admin/Answer.js',{object:'EXCMS.Ask.Answer',container:this.tabPanel,title:'答案列表'});
				break;
			//显示头衔
			case 'actor' :
				EXCMS.util.script('../ask/admin/Actor.js',{object:'EXCMS.Ask.Actor',container:this.tabPanel});
				break;
			//显示积分排行
			case 'scorerank' :
				EXCMS.util.script('../ask/admin/ScoreRank.js',{object:'EXCMS.Ask.ScoreRank',container:this.tabPanel});
				break;
			//显示用户详细积分
			case 'score' :
				EXCMS.util.script('../ask/admin/Score.js',{object:'EXCMS.Ask.Score',container:this.tabPanel});
				break;
			//配置管理
			case 'config' :
				EXCMS.util.script('../ask/admin/Config.js',{object:'EXCMS.Ask.Config',container:this.tabPanel});
				break;
		}
	},
	renderStatus : function(v){var r=['','疑难问题','待解决','已解决','已过期','投票中','关闭'];return r[v]},
	renderNewAnswer : function(v){return v ? "<span style='color:green;'>有</span>":''},
	formateScore : function(v){return v == 1 ? "<span style='color:green;'>精华</span>" : ''},
	renderChecked:function(v){var r=['<span class="ccheck_u" title="未经审核"></span>','<span class="ccheck_n" title="审核未通过"></span>','<span class="ccheck" title="已审核"></span>'];return r[v>(r.length-1)?0:(v<0?0:v)]}

};
EXCMS.onReady(EXCMS.Ask.init,EXCMS.Ask);