EXCMS.Ask.Score = {
	baseAction:'index.php?M=Modules&EM=ask&A=ScoreAction',
	display:[],
	// load component
	load:function(item){
		this.mainPanel =  item.container;
		if(!this.grid){
			this.render();
		}else{
			this.mainPanel.unhideTabStripItem(this.grid);
			this.mainPanel.activate(this.grid);
		}
	},
	//初始化grid
	render : function(){
	 	this.D = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=userstore'}),
            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'uid',
                fields: ['uid','username','score','score_operate','score_answer','score_question','score_punish','score_other','question','question_elite','answer','answer_best','favorable']
            }),
            remoteSort: true
        });
        this.soField = new Ext.form.TwinTriggerField({emptyText:'用户名',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
	    this.grid = new Ext.grid.GridPanel({store:this.D,region:'center',title:'用户积分',closable:true,
	      	tbar:[
	      		{text:'清空',iconCls:'btnico btn_del',handler:this.clear,scope:this},'-',
				{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload();},scope:this},
				'->','搜索 ',this.soField
		    ],
            columns:[
            	new Ext.grid.RowNumberer(),
                {header:"用户",width:150,sortable:false,dataIndex:'username'},
                {header:"总积分",width:80,sortable:true,dataIndex:'score'},
                {header:"日常操作",width:80,sortable:true,dataIndex:'score_operate'},
                {header:"回答得分",width:80,sortable:true,dataIndex:'score_answer'},
                {header:"提问扣分",width:80,sortable:true,dataIndex:'score_question'},
                {header:"处罚积分",width:80,sortable:true,dataIndex:'score_punish'},
                {header:"其它",width:80,sortable:true,dataIndex:'score_other'},
                {header:"提问数",width:80,sortable:true,dataIndex:'question'},
                {header:"精华提问数",width:80,sortable:true,dataIndex:'question_elite'},
                {header:"回答数",width:80,sortable:true,dataIndex:'answer'},
                {header:"回答采纳数",width:80,sortable:true,dataIndex:'answer_best'},
                {header:"好评数",width:80,sortable:true,dataIndex:'favorable'}
            ],
            enableColumnMove:false,collapsible:true,animCollapse:false,loadMask:{msg:'正在加载用户积分数据,请稍后...'},border:false,
            bbar: new Ext.PagingToolbar({pageSize: 25,store:this.D,displayInfo: true,displayMsg: '当前显示：{0} - {1} 总记录：{2}',emptyMsg: "暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
        });
        this.grid.on('rowclick', function(g,r,e){
			this.reocrd = g.getStore().getAt(r);
		},this);
		this.mainPanel.add(this.grid);
		this.mainPanel.activate(this.grid);
		this.grid.getEl().dom.oncontextmenu = function(){return false;}
		this.grid.getEl().dom.onselectstart = function(){return false;}
		this.D.load();
	},
	soOnTrigger1Click:function(){
		this.soField.reset();
		this.D.baseParams.key = '';
		this.D.reload();
	},
	soOnTrigger2Click:function(){
	    var key = this.soField.getValue().trim();
	    if(key != ''){
	        this.D.baseParams.key = key;
	        this.D.reload();
	    }
	},
	//显示方式
	displayScore : function(item){
		this.D.baseParams.sort = item.mode;
		this.D.reload();
	},
	//清空排行数据
	clear : function(item){
		var selected = this.grid.getSelectionModel().getSelections();
        if(selected.length > 0){
            var data = [];
            for (var i = 0, len = selected.length; i < len; i++) {data.push(selected[i].id);}
	   		Ext.MessageBox.confirm('提示','您确实要删除选定的记录吗？', function(optional){
	               if(optional=='yes'){
	                   Ext.Ajax.request({
	                        url: this.baseAction+"&method=scoredelete",
	                        method: 'POST', 
	                        params:{uid:data.join(",")},
	                        failure:function(response,options){
	                            alert("出现异常错误！请联系管理员！");
	                        },
	                        success:function(response,options){
	                            var r=jsonReturn(response);
	                            if(r.success){
	                            	for(var i=0;i<data.length;i++){
	                            		this.D. remove(this.D.getById(data[i]));
	                            	}
	                              	this.D.commitChanges();
	                            }
	                        }.createDelegate(this)                                    
	                   });
	               }
	               else return
	           }.createDelegate(this));
         }else alert('请至少选择一条记录！');
	}
};