EXCMS.Ask.ScoreRank = {
	baseAction:'index.php?M=Modules&EM=ask&A=ScoreAction',
	display:[],
	// load component
	load:function(item){
		this.mainPanel =  item.container;
		if(!this.grid){
			this.render();
		}else{
			this.mainPanel.unhideTabStripItem(this.grid);
			this.mainPanel.activate(this.grid);
		}
	},
	//初始化grid
	render : function(){
	 	this.D = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=store'}),
            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'uid',
                fields: ['uid','username','exp','exp_operate','exp_question','exp_answer','exp_punish','exp_other','exp_year','exp_month','exp_week','actorname']
            }),
            remoteSort: true
        });
        this.soField = new Ext.form.TwinTriggerField({emptyText:'用户名',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
	    this.grid = new Ext.grid.GridPanel({store:this.D,region:'center',title:'积分排行',closable:true,
	      	tbar:[
	      		{text:'清空',iconCls:'btnico btn_del',handler:this.clear,scope:this},
	      		{text:'显示',menu: {items:[
		      		{text:'总积分',group: 'score',checked: true,handler:this.displayScore,scope:this,mode:'exp'},
		      		{text:'年积分',group: 'score',checked: false,handler:this.displayScore,scope:this,mode:'exp_year'},
		      		{text:'月积分',group: 'score',checked: false,handler:this.displayScore,scope:this,mode:'exp_month'},
					{text:'周积分',group: 'score',checked: false,handler:this.displayScore,scope:this,mode:'exp_week'}
				]}},'-',
				{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload();},scope:this},'->','搜索 ',this.soField
		    ],
            columns:[
            	new Ext.grid.RowNumberer(),
                {header:"用户",width:150,sortable:false,dataIndex:'username'},
                {header:"总积分",width:80,sortable:true,dataIndex:'exp'},
                {header:"日常操作",width:100,sortable:true,dataIndex:'exp_operate'},
                {header:"提问",width:100,sortable:true,dataIndex:'exp_question'},
                {header:"回答",width:100,sortable:true,dataIndex:'exp_answer'},
                {header:"处罚",width:100,sortable:true,dataIndex:'exp_punish'},
                {header:"其它",width:100,sortable:true,dataIndex:'exp_other'},
                {header:"年积分",width:80,sortable:false,dataIndex:'exp_year'},
                {header:"本月积分",width:80,sortable:false,dataIndex:'exp_month'},
                {header:"本周积分",width:80,sortable:false,dataIndex:'exp_week'},
                {header:"头衔",width:100,sortable:false,dataIndex:'actorname'}
            ],
            enableColumnMove:false,collapsible:true,animCollapse:false,loadMask:{msg:'正在加载用户排行数据,请稍后...'},border:false,
            bbar: new Ext.PagingToolbar({pageSize: 25,store:this.D,displayInfo: true,displayMsg: '当前显示：{0} - {1} 总记录：{2}',emptyMsg: "暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
        });
        this.grid.on('rowclick', function(g,r,e){
			this.reocrd = g.getStore().getAt(r);
		},this);
		this.mainPanel.add(this.grid);
		this.mainPanel.activate(this.grid);
		this.grid.getEl().dom.oncontextmenu = function(){return false;}
		this.grid.getEl().dom.onselectstart = function(){return false;}
		this.D.load();
	},
	soOnTrigger1Click:function(){
		this.soField.reset();
		this.D.baseParams.key = '';
		this.D.reload();
	},
	soOnTrigger2Click:function(){
	    var key = this.soField.getValue().trim();
	    if(key != ''){
	        this.D.baseParams.key = key;
	        this.D.reload();
	    }
	},
	//显示方式
	displayScore : function(item){
		this.D.baseParams.sort = item.mode;
		this.D.reload();
	},
	//清空排行数据
	clear : function(item){
		var selected = this.grid.getSelectionModel().getSelections();
        if(selected.length > 0){
            var data = [];
            for (var i = 0, len = selected.length; i < len; i++) {data.push(selected[i].id);}
	   		Ext.MessageBox.confirm('提示','您确实要删除选定的记录吗？', function(optional){
	               if(optional=='yes'){
	                   Ext.Ajax.request({
	                        url: this.baseAction+"&method=delete",
	                        method: 'POST', 
	                        params:{uid:data.join(",")},
	                        failure:function(response,options){
	                            alert("出现异常错误！请联系管理员！");
	                        },
	                        success:function(response,options){
	                            var r=jsonReturn(response);
	                            if(r.success){
	                              	this.D.reload();
	                            }
	                        }.createDelegate(this)                                    
	                   });
	               }
	               else return
	           }.createDelegate(this));
         }else alert('请至少选择一条记录！');
	}
};