<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		action.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 2292 $
 */
/* $Id: common.inc.php 2292 2010-08-21 03:31:06Z zhanghaisong $ */
/**
 * EXCMS 问答初始化配置
 */
require_once (dirname(dirname(dirname(dirname(__FILE__)))) . '/configuration/inc/common.inc.php');
define('ASK_CONF', substr(dirname(__FILE__), 0, -4) . '/');
define('ASK_PATH', substr(ASK_CONF, 0, -15) . '/');	// 问答路径
define('ASK_INC_PATH', ASK_CONF . 'inc/');			// 模块配置信息
define('ASK_LIB_PATH', ASK_CONF . 'libs/');			// 模块处理类
define('ASK_LANG_PATH', ASK_CONF . 'lang/');		// 模块语言包
define('ASK_LOG_PATH', ASK_CONF . 'logs/');			// 模块日志信息
//define('ASK_TEMPLATE_DIR', $EXCMS_CONFIG['template_dir'] . $EXCMS_CONFIG['template_name'] . '/ask/'); // 模板路径
define('MODULE_ID','ask');

// 检查模块是否安装
$module_array = EXCMS::getModuleCache(MODULE_ID);

if(!is_array($module_array) || count($module_array) < 1){
	$install_path = ASK_PATH.'install/index.php';
	file_exists(realpath($install_path)) ? header('Location: install/index.php') :	throw_exception('无法找到 ASK 安装程序位置，请手工输入安装程序路径。<br /> 默认安装程序位置在 ASK 安装目录下的 install 文件夹中。');
	exit;
}
//注册模块语言包
regeditLangPackage(MODULE_ID);
// load ask config
loadModuleConfig(MODULE_ID,true);
// load User class and creat user object, set page user
include_once LIB_MODULES_PATH . 'account/User.class.php';
$_USER = new User();
$_PAGE_USER = $_USER->getSession();
define('EXCMS_SESSION_UID', $_PAGE_USER['uid']);
define('EXCMS_SESSION_UNUMBER', $_PAGE_USER['unumber']);

if(EXCMS_SESSION_UID > 0){
	include_once ASK_LIB_PATH.'AskScore.class.php';
	$score = new AskScore();
	$score->checkLogin();
}

// is ajax request
$ajax = $_POST['ajax'] ? $_POST['ajax'] : $_GET['ajax'];

// ajax 编码处理
if($ajax && CHARSET != JSON_CHARSET){
	$_POST = EXCMS::iconv_all(JSON_CHARSET, CHARSET, $_POST);
}

// 问答状态文本
$_QUESTION_STATUS = array('pending', 'solved', 'offer', 'urgent', 'hot', 'elite', 'expired', 'vote', 'close');
$_QUESTION_STATUS_TEXT = array(1 => '疑难问题', 2 => '待解决', 3 => '已解决', 4 => '已过期', 5 => '投票中', 6 => '关闭');


$method = $_POST['action'] ? $_POST['action'] : $_GET['action'];

// excms file end