<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		Actor.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 * @version $Rev: 2201 $
 */
/* $Id: Actor.class.php 2201 2010-08-11 15:09:16Z zhangxuelin $ */
/**
 * EXCMS 问吧头衔
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 */
class Actor
{
	/**
     * 问题头衔数据库表
     *
     * @access private
     * @var string
     */
    private $table = 'ask_actor';
    /**
     * 构造函数
     *
     */
    function __construct ()
    {
        $this->table = TABLE_PREFIX . $this->table;
    }
    /**
     * 兼容PHP4构造函数
     *
     */
    function Actor ()
    {
        $this->__construct();
    }
    /**
	 * 根据ID获取头衔
	 *
	 * @param integer $id	头衔ID
	 * @return array	头衔详细信息
	 */
	public function getById($id){
		 if (! ($id >= 0)) {
            throw_exception('ASK_ACTOR_LACK_ID');
        }
        $sql = "SELECT * FROM `{$this->table}` WHERE `id` = '{$id}' LIMIT 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetch();
	}
    /**
     * 新建头衔 
     *
     * @param array $data	头衔数据
     * <ul>
     * <li>string $data['name'] 头衔 </li>
     * <li>integer $data['catename'] 类型 </li>
     * <li>string $data['grade'] 等级</li>
     * <li>integer $data['min'] 最小积分 </li>
     * <li>integer $data['max'] 最大积分</li>
     * </ul>
     * 
     * @return integer 头衔 ID
     */
    function insert ($data)
    {
        if(trim($data['name'])==''){
        	throw_exception('ASK_ACTOR_LACK_NAME');
        }
        if($data['catename'] == ''){
        	throw_exception('ASK_ACTOR_LACK_CATENAME');
        }
       if(trim($data['grade'])==''){
        	throw_exception('ASK_ACTOR_LACK_GRADE');
        }
        $data = array(
        	'catename' => $data['catename'],
        	'grade' => $data['grade'],
        	'name' => $data['name'],
        	'min' => $data['min'],
        	'max' => $data['max']
        );
        $sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->insert_id();
    }
    /**
     * 更新指定ID头衔
     *
     * @param integer $id 	头衔ID
     * @param array $data	头衔数据
     * <ul>
     * <li>string $data['name'] 头衔 </li>
     * <li>integer $data['catename'] 类型 </li>
     * <li>string $data['grade'] 等级</li>
     * <li>integer $data['min'] 最小积分 </li>
     * <li>integer $data['max'] 最大积分</li>
     * </ul>
     * 
     * @return boolean
     */
    function update ($id, $data)
    {
        if (! ($id > 0)) {
            throw_exception('ASK_ACTOR_LACK_ID');
        }
        if(trim($data['name'])==''){
        	throw_exception('ASK_ACTOR_LACK_NAME');
        }
        if($data['catename']==''){
        	throw_exception('ASK_ACTOR_LACK_CATENAME');
        }
       if(trim($data['grade'])==''){
        	throw_exception('ASK_ACTOR_LACK_GRADE');
        }
        $data = array(
        	'name' => $data['name'],
        	'catename' => $data['catename'],
        	'grade' => $data['grade'],
        	'min' => $data['min'],
        	'max' => $data['max']
        );
        $set = array();
        foreach ($data as $k => $v) {
            $set[] = "`{$k}` = '{$v}'";
        }
        $set = implode(", ", $set);
                $sql = "UPDATE `{$this->table}` SET {$set} WHERE `id` = '{$id}' LIMIT 1";
        return $GLOBALS['db']->query($sql);
    }
	/**
     * 删除指定ID头衔
     *
     * @param string|integer|array $id 头衔ID
     * 
     * @return boolean
     */
    public function delete ($id)
    {
        $id = EXCMS::convertToIntArray($id);
        if ($id === false) {
            throw_exception('ASK_ACTOR_LACK_ID');
        }
        $num = count($id);
        $where = $num > 1 ? "`id` IN ('" . implode("', '", $id) . "') LIMIT {$num}" : "`id` = '" . $id[0] . "'";
        $sql = "DELETE FROM `{$this->table}` WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 获取所属分类
     *
     * @return array
     */
    public function  getCategory(){
    	$sql = "SELECT DISTINCT `catename` FROM `{$this->table}` ";
            $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetchAll();
    }
    /**
     * 根据积分获取头衔
     *
     * @param integer $score	积分
     * @return array
     */
    public function getActorByScore($score){
    	$score = (int)$score;
        	$sql = "SELECT * FROM `{$this->table}` WHERE `min` <= '{$score}' AND (`max` >= '{$score}' OR `max` = 0) LIMIT 1";
    	$GLOBALS['db']->query($sql);
    	$actor_array = $GLOBALS['db']->fetch();
    	if(is_array($actor_array) && count($actor_array) > 0){
    		return $actor_array;
    	}
    	$sql = "SELECT * FROM `{$this->table}` ORDER BY min LIMIT 1";
    	$GLOBALS['db']->query($sql);
    	return $GLOBALS['db']->fetch();
    }
   /**
     * 获取头衔分页列表
     *
     * @param array $paging 分页数组
     * <ul>
     * <li>integer $paging['limit'] 分页大小 default 0</li>
     * <li>integer $paging['start'] 分页起始大小 default 0</li>
     * <li>integer $paging['total'] 总数 default 0</li>
     * <li>integer $paging['sort'] 排序字段</li>
     * <li>integer $paging['dir'] 排序方式 ASC or DESC, </li>
     * <li>integer $paging['catename'] 角色ID </li>
     * </ul>
     * @return array Paging 数组
     * <ul> 
     * <li> $array['total'] 总数 </li>
     * <li> $array['data'] 分页数据 </li>
     * </ul>
     */
  	public function getPaging ($paging = array())
	{
        if($paging['catename']!=''){
        	$where .= " and `catename`='{$paging['catename']}' ";
        }
                if (! isset($paging['total'])) {
            $sql = "SELECT COUNT(*) as `total` FROM `{$this->table}` WHERE 1 {$where}";
            $GLOBALS['db']->query($sql);
            $rs = $GLOBALS['db']->fetch();
            $total = $rs['total'];
        } else {
            $total = (int) $paging['total'];
        }
        if (empty($paging['sort'])) {
            $sort = "`id` ASC";
        } else {
            $dir = strtoupper($paging['dir']) == "DESC" ? "DESC" : "ASC";
            $sort = "`" . $paging['sort'] . "` {$dir}";
        }
        $orderby = "ORDER BY {$sort}";
        $start = (int) $paging['start'];
        $limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
        $limit = "LIMIT {$start}, {$limit}";
        $sql = "SELECT * FROM `{$this->table}` WHERE 1 {$where} {$orderby} {$limit}";
        $GLOBALS['db']->query($sql);
        $rs = $GLOBALS['db']->fetchAll();
        return array('total' => $total , 'data' => $rs);
    }
}

// excms file end