<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		Answer.class.php
 *
 * A product of PUTOYO Inc.
 *  
 * EXCMS is a tens of millions of data-level and human-base content management system.
 * 
 * For ANSWER, help, comments, discussion, etc., please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 * @version $Rev: 2154 $
 */
/* $Id: Answer.class.php 2154 2010-08-10 09:24:54Z zhangxuelin $ */
/**
 * EXCMS 回答
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 */
class Answer
{
	/**
     * 回答数据表
     *
     * @access private
     * @var string
     */
    private $table = 'ask_answers';
    /**
     * 构造函数
     *
     */
    function __construct ()
    {
        $this->table = TABLE_PREFIX . $this->table;
    }
    /**
     * 兼容PHP4构造函数
     *
     */
    function Answer ()
    {
        $this->__construct();
    }
    /**
	 * 根据内容ID获取回答
	 *
	 * @param integer $aid	回答ID
	 * @return array	回答详细信息
	 */
	public function getById($aid){
		if (! ($aid > 0)) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $sql = "SELECT * FROM `{$this->table}` WHERE `aid` = '{$aid}' LIMIT 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetch();
	}
    /**
     * 添加回答 
     *
     * @param array $data 回答数据
     * <ul>
     * <li>integer $data['qid'] 回答ID</li>
     * <li>integer $data['cid'] 问题分类ID</li>
     * <li>integer $data['ip'] IP地址</li>
     * <li>integer $data['anonymous'] 是否为匿名提问(默认为否) </li>
     * <li>integer $data['content'] 内容</li>
     * </ul>
     * 
     * @return integer 回答 aid
     */
    public function insert ($data)
    {
    	if((int)$data['qid']<1){
    		throw_exception('ASK_QUESTIONS_LACK_ID');
    	}
    	if((int)$data['cid']<1){
    		throw_exception('ASK_CATEGORY_LACK_ID');
    	}
        if(trim($data['content'])==''){
        	throw_exception('ASK_ANSWER_LACK_CONTENT');
        }
        global $EXCMS;
        $data = array(
        	'qid' => $data['qid'],
        	'cid' => $data['cid'],
        	'checked' => $EXCMS_MODULE['ask']['answer_check'] ==1 ? 0 : 2,
        	'ishidden' => 0,
        	'isbest' => 0,
        	'content' => trim($data['content']),
        	'anonymous' => $data['anonymous'] ? 1 : 0,
        	'vote' => 0,
        	'votecount' => 0,
        	'uid' => $data['uid'],
        	'ip' => $data['ip'],
            'createdate' => time(),
        	'modifieddate' => time()
        );
        $sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
                $GLOBALS['db']->query($sql);
       
        include_once ASK_LIB_PATH . 'AskQuestion.class.php';
        $question = new AskQuestion();
		$question->updateAnswerNumber($data['qid']);		 			//更新问题回答数量
		$question->updateSolve(EXCMS_SESSION_UID,$data['qid'],true);	//更新是否求助的提问
		
		include_once ASK_LIB_PATH.'AskAccount.class.php';
		$account = new AskAccount();
		$account->updateAnswer($data['uid']);			//更新用户回答数
		
		include_once ASK_LIB_PATH.'AskScore.class.php';
		$score = new AskScore();
		$score->scoreAnswer(EXCMS_SESSION_UID);			//回答问题所得分
		
		unset($question,$account,$score,$data);
		return true;
    }
    /**
     * 更新指定ID回答
     *
     * @param integer $aid 	回答ID
     * @param array $data	回答数据
     * <ul>
     * <li>integer $data['ip'] IP地址</li>
     * <li>integer $data['content'] 内容</li>
     * </ul>
     * 
     * @return boolean
     */
    function update ($aid, $data)
    {
        if (! ($aid > 0)) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        if(trim($data['content'])==''){
        	throw_exception('ASK_ANSWER_LACK_CONTENT');
        }
        $data = array(
        	'ip'=> $data['ip'],
        	'modifieddate' => time(),
            'content' => trim($data['content'])
        );      
        $set = array();
        foreach ($data as $k => $v) {
            $set[] = "`{$k}` = '{$v}'";
        }
        $set = implode(", ", $set);
                $sql = "UPDATE `{$this->table}` SET {$set} WHERE `aid` = '{$aid}' LIMIT 1";
        return $GLOBALS['db']->query($sql);
    }
    /**
     * 根据问题ID删除回答列表
     *
     * @param integer $qid	问题ID
     * @return boolean
     */
    public function deleteByQid($qid){
    	$qid = EXCMS::convertToIntArray($qid);
        if ($qid === false) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
                $num = count($qid);
        $where = $num > 1 ? "`qid` IN ('" . implode("', '", $qid) . "') LIMIT {$num}" : "`qid` = '" . $qid[0] . "'";
        $sql = "SELECT `uid` FROM {$this->table} WHERE {$where}";
        $GLOBALS['db']->query($sql);
        $answer_array = $GLOBALS['db']->fetchAll();
        $sql = "DELETE FROM {$this->table} WHERE {$where}";
        $success = $GLOBALS['db']->query($sql);
        if($success && count($answer_array) > 0){
        	include_once ASK_LIB_PATH.'AskAccount.class.php';
			$account = new AskAccount();
        	foreach ($answer_array as $value){
        		if($value['uid'] > 0)	$account->updateAnswer($value['uid'],-1);		//减少回答数
        	}
	        unset($account,$answer_array);
        }
        return $success;
    }
	/**
     * 删除指定ID回答
     *
     * @param string|integer|array $aid 回答ID
     * 
     * @return boolean
     */
    public function delete ($aid)
    {
        $aid = EXCMS::convertToIntArray($aid);
        if ($aid === false) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
                $num = count($aid);
        $where = $num > 1 ? "`aid` IN ('" . implode("', '", $aid) . "') LIMIT {$num}" : "`aid` = '" . $aid[0] . "'";
        $sql = "SELECT `qid`,`uid`,`isbest` FROM {$this->table} WHERE {$where}";
        $GLOBALS['db']->query($sql);
        $answer_array = $GLOBALS['db']->fetchAll();
        $sql = "DELETE FROM `{$this->table}` WHERE {$where}";
        $success = $GLOBALS['db']->query($sql);
        $success = true;
        if($success && is_array($answer_array) && count($answer_array) > 0){
        	include_once ASK_LIB_PATH . 'AskQuestion.class.php';
			$question = new AskQuestion();
			
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			
			include_once ASK_LIB_PATH.'AskAccount.class.php';
			$account = new AskAccount();
	        foreach ($answer_array as $value){
				$question->updateAnswerNumber($value['qid'],false);						//减少回答数
				$value['isbest'] = 1;
				//更新积分
		        if($value['uid'] > 0){
		        	if($value['isbest']){												//最佳答案被删除 回答者和提问者扣分
		        		$question_array = $question->getById($value['qid']);	
		        		if($question_array['uid'] > 0)	$score->scoreDeleteBestAnswer($question_array['uid']);				
		        		$score->scoreDeleteBestAnswer($value['uid']);	
		        		$account->updateAnswerBest($value['uid'],-1);					
		        	}else{
		        		$score->scoreDeleteAnswer($value['uid']);							//回答被删除  回答者减10分
						$account->updateAnswer($value['uid'],-1);							//回答数减一
		        	}
				}
	        }
	        unset($question,$score,$account,$answer_array);
        }
        return $success;
    }
    /**
	 * 更新匿名回答
	 *
	 * @param integer $aid
	 * @param boolean $anonymous
	 * @return boolean
	 */
	public function updateAnonymous($aid,$anonymous=true){
		$answer_array = $this->getById($aid);
		$anonymous = $anonymous ? 1 : 0;
		$sql = "UPDATE `{$this->table}` SET `anonymous` = '{$anonymous}' WHERE `aid` = '{$aid}'";
		return $GLOBALS['db']->query($sql);
	}
    /**
     * 更新审核状态
     *
     * @param integer $aid	回答ID
     * @param integer $checked	是否审核0:未审核 1:未通过审核 2:通过审核
     * 
     * @return boolean
     */
    public function updateStatus($aid,$checked){
    	$aid = EXCMS::convertToIntArray($aid);
        if ($aid === false) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $num = count($aid);
        $where = $num > 1 ? "`aid` IN ('" . implode("', '", $aid) . "') LIMIT {$num}" : "`aid` = '" . $aid[0] . "'";
        $sql = "SELECT `uid`,`checked` FROM {$this->table} WHERE {$where}";
            	$GLOBALS['db']->query($sql);
    	$answer_array = $GLOBALS['db']->fetchAll();
    	if(is_array($answer_array) && count($answer_array) > 0){
    		include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
    		foreach ($answer_array as $value){
    			if($checked == $value['checked'] || $value['checked']==2) continue;
    			if($value['uid'] > 0){
    				if($value['checked']==0 && $checked == 1){											//未通过审核
    					$score->scoreCheckAnswer($value['uid'],false);								
    				}else if($value['checked']==1 && $checked == 2){									//通过审核返回20分
    					$score->scoreCheckAnswer($value['uid'],true);
    				}
				}
    		}
    	}
        $sql = "UPDATE `{$this->table}` SET `checked` = '{$checked}' WHERE {$where}";
        return $GLOBALS['db']->query($sql);
    }
    /**
     * 更新评价数量
     *
     * @param integer $aid	回答ID
     * @return boolean
     */
    public function updateEvaluated($aid){
    	if (! ($aid > 0)) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
    	$sql = "UPDATE `{$this->table}` SET `evaluated` = evaluated+1 WHERE `aid`='{$aid}'";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 更新追加信息
     * @param int $aid
     * @param bool $append 
     * @return bool
     */
    public function append($aid,$append=true){
    	if (! ($aid > 0)) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $append = $append ? 1 : 0;
    	$sql = "UPDATE `{$this->table}` SET `append` = {$append} WHERE `aid`='{$aid}'";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 更新隐藏回答 0否1隐藏   
     *
     * @param integer $aid	回答ID
     * @param integer $status	更新状态
     * 
     * @return boolean
     */
    public function updateHidden($aid,$ishidden){
    	$aid = EXCMS::convertToIntArray($aid);
        if ($aid === false) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $ishidden = $ishidden ? 1 : 0;
        $num = count($aid);
        $where = $num > 1 ? "`aid` IN ('" . implode("', '", $aid) . "') LIMIT {$num}" : "`aid` = '" . $aid[0] . "'";
        $sql = "UPDATE `{$this->table}` SET `ishidden` = '{$ishidden}' WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 更新采纳回答 0否1为采纳
     *
     * @param integer $aid	回答ID
     * @param integer $isbast 0否1为采纳
     * 
     * @return boolean
     */
    public function updateIsbast($aid,$isbast=true){
        $isbast = $isbast ? 1 : 0;
        $num = count($aid);
        $answer_array = $this->getById($aid);
        if($answer_array['isbest']) return true;
        $sql = "UPDATE `{$this->table}` SET `isbest` = '{$isbast}' WHERE `aid` = '{$aid}'";
                $success = $GLOBALS['db']->query($sql);
        if($success){
        	include_once ASK_LIB_PATH . 'AskQuestion.class.php';			//加载问题类,创建问题AskQuestion对像
			$question = new AskQuestion();
			$question_array = $question -> getById($answer_array['qid']);
			
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			if($question_array['uid'] > 0 && $question_array['status'] == 4){								//过期问题采纳答案还提问者10分积分
				$score->scoreExpiredDeal($question_array['uid']);
			}
			//更新问题已解决
			$question->updateStatus($answer_array['qid'],3);
			
			$question->updateSolveddate($answer_array['qid'],0,time());	//更新解决时间
			
			if($answer_array['uid'] > 0){
				$score->scoreAnswerAdopt($answer_array['uid'],$question_array['score']);					//增加回答者得分
				include_once ASK_LIB_PATH.'AskAccount.class.php';
				$account = new AskAccount();
				$account->updateAnswerBest($answer_array['uid']);											//更新回答者回答采纳数
			}
			if($question_array['uid'] > 0 && $question_array['score'] > 0){
				$score->scoreCentQuestion($question_array['uid'],$question_array['score']);					//悬赏付出
			}
			
			unset($question,$question_array,$score,$account);
        }
        return $success;
    }
    /**
     * 更新回答是否转入投票
     *
     * @param integer $aid	回答ID
     * @param boolean $vote	是否投票
     * @return boolean
     */
    public function updateVote($aid,$vote = true){
    	$aid = EXCMS::convertToIntArray($aid);
        if ($aid === false) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $num = count($aid);
        $where = $num > 1 ? "`aid` IN ('" . implode("', '", $aid) . "') LIMIT {$num}" : "`aid` = '" . $aid[0] . "'";
        $vote = $vote ? 1 : 0;
        $sql = "UPDATE `{$this->table}` SET `vote` = '{$vote}' WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 根据问题ID设置所有投票
     *
     * @param integer $qid
     * @param boolean $vote
     * @return boolean
     */
    public function updateVoteByQid($qid,$vote = true){
        if (!($qid > 0)) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
        $vote = $vote ? 1 : 0;
        $sql = "UPDATE `{$this->table}` SET `vote` = '{$vote}' WHERE `qid` = '{$qid}' ";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 更新投票数量
     *
     * @param integer $aid	回答ID
     * 
     * @return boolean
     */
    public function updateVotecount($aid){
    	$aid = EXCMS::convertToIntArray($aid);
        if ($aid === false) {
            throw_exception('ASK_ANSWER_LACK_ID');
        }
        $num = count($aid);
        $where = $num > 1 ? "`aid` IN ('" . implode("', '", $aid) . "') LIMIT {$num}" : "`aid` = '" . $aid[0] . "'";
        $sql = "UPDATE `{$this->table}` SET `votecount` = votecount+1 WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 根据问题ID和用户ID获取回答ID
     *
     * @param integer $qid	问题ID
     * @param integer $uid	用户ID
     * @return integer
     */
    public function isAnswerByQid($qid,$uid){
    	if (! ($qid > 0)) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
                $sql = "SELECT `aid` FROM `{$this->table}`   WHERE `qid` = '{$qid}' AND `uid`='{$uid}' LIMIT 1";
        $GLOBALS['db']->query($sql);
        $answer_array = $GLOBALS['db']->fetch();
        return $answer_array['aid'];
    }
    /**
     * 根据问题ID获取第一个答案
     *
     * @param integer $qid
     * @return array
     */
    public function getAnswerByQid($qid){
    	if (! ($qid > 0)) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
        $sql = "SELECT * FROM `{$this->table}`   WHERE `qid` = '{$qid}'  LIMIT 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetch();
    }
    /**
     * 获取最佳答案列表
     *
     * @param integer $qid	问题ID
     * 
     * @return array
     */
    public function getBestAnswer($qid){
		if (! ($qid > 0)) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
        $sql = "SELECT * FROM `{$this->table}`   WHERE `qid` = '{$qid}' AND `isbest` = 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetchAll();
    }
    /**
     * 统计回答字数大于30的回答个数
     *
     * @param integer $qid	问题ID
     * @param integer $number	字符数
     * @return boolean
     */
    public function statAnswerContentNumber($qid,$number=30){
    	if (! ($qid > 0)) {
            throw_exception('ASK_QUESTIONS_LACK_ID');
        }
        $sql = "SELECT COUNT(*) AS total FROM (SELECT LENGTH(`content`) AS number  FROM {$this->table} WHERE `qid`= '{$qid}') AS tmp WHERE number > '{$number}'";
                $GLOBALS['db']->query($sql);
        $answer_array = $GLOBALS['db']->fetch();
        return $answer_array['total'] > 0 ? true :false;
    }
   /**
     * 获取回答列表分页数据
     *
     * @param array $paging 分页数组
     * <ul>
     * <li>integer $paging['limit'] 分页大小 default 0</li>
     * <li>integer $paging['start'] 分页起始大小 default 0</li>
     * <li>integer $paging['total'] 总数 default 0</li>
     * <li>integer $paging['sort'] 排序字段</li>
     * <li>integer $paging['dir'] 排序方式 ASC or DESC, </li>
     * <li>integer $paging['keywords'] 搜索关键字</li>
     * <li>integer $paging['cid'] 问题分类ID</li>
     * <li>integer $paging['qid'] 问题ID</li>
     * <li>integer $paging['checked'] 状态,0:未审核 1:未通过审核 2:通过审核</li>
     * </ul>
     * @return array Paging 数组
     * <ul> 
     * <li> $array['total'] 总数 </li>
     * <li> $array['data'] 分页数据 </li>
     * </ul>
     */
   function getPaging ($paging = array())
    {
        $keywords = trim($paging['keywords']);
        if (! empty($keywords)) {
            $where = " and `content` like '%{$keywords}%' ";
        }
        if($paging['cid']>0){
        	$where .= " and `cid`='{$paging['cid']}' ";
        }
        if($paging['qid']>0){
        	$where .=" and qid={$paging['qid']} ";
        }
        if($paging['checked']!=''){
        	$where .= " and `checked`='{$paging['checked']}' ";
        }
                if (! isset($paging['total'])) {
            $sql = "SELECT COUNT(*) as `total` FROM `{$this->table}` WHERE 1 {$where}";
            $GLOBALS['db']->query($sql);
            $rs = $GLOBALS['db']->fetch();
            $total = $rs['total'];
        } else {
            $total = (int) $paging['total'];
        }
        if($total <= 0){
        	return array('total' => $total , 'data' => array());
        }
        if(!in_array($paging['sort'],array('createdate','votecount','checked'))) $paging['sort'] = 'createdate';
       
        $dir = strtoupper($paging['dir']) == "DESC" ? "DESC" : "ASC";
        $sort = "`" . $paging['sort'] . "` {$dir}";
        
        $orderby = "ORDER BY {$sort}";
        $start = (int) $paging['start'];
        $limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
        $limit = "LIMIT {$start}, {$limit}";
        $sql = "SELECT * FROM `{$this->table}` WHERE 1 {$where} {$orderby} {$limit}";
        $GLOBALS['db']->query($sql);
        $rs = $GLOBALS['db']->fetchAll();
        if(is_array($rs) && count($rs)>0 ){
        	include_once ASK_LIB_PATH . 'AskCategory.class.php';
        	$cate = new AskCategory();
        	include_once ASK_LIB_PATH . 'AskQuestion.class.php';
        	$question = new AskQuestion();
        	include_once LIB_MODULES_PATH . 'account/Account.class.php';
        	$account = new Account();
        	foreach ($rs as $key=>$value){
        		$cate_array =  $cate->getById($value['cid']);
        		$rs[$key]['catename'] =$cate_array['name'];
        		$question_array = $question->getById($value['qid']);
        		$rs[$key]['title'] = $question_array['title'];
        		if($value['uid'] > 0){
        			$account_array = $account->getById($value['uid']);
        			$rs[$key]['username'] = $account_array['username'];
        		}
        		$rs[$key]['createdate'] = formatDate("Y-m-d H:i:s",$rs[$key]['createdate']);
        		$rs[$key]['modifieddate'] = formatDate("Y-m-d H:i:s",$rs[$key]['modifieddate']);
        	}
        	unset($cate,$user,$cate_array,$user_array,$question,$question_array);
        }
        return array('total' => $total , 'data' => $rs);
    }
}

?>
