<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskAccount.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package Hit
 * @author $Author: hukuizhi $
 * @version $Rev: 1700 $
 */
/* $Id: AskAccount.class.php 1700 2010-06-08 02:44:30Z hukuizhi $ */
/**
 * EXCMS 用户问答统计
 * @category EXCMS
 * @package AskAccount
 * @author $Author: hukuizhi $
 */
class AskAccount{
	/**
	 * 问答统计表
	 *
	 * @access private
	 * @var string
	 */
	private $table = "ask_account";
	/**
	 * 构造函数
	 * 
	 */
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
	}
	/**
	 * 兼容PHP4构造函数
	 * 
	 */
	function AskAccount(){
		$this->__construct();
	}
	/**
     * 根据用户ID获取用户统计数据
     *
     * @param integer $uid	用户ID
     * @return array
     */
    public function getByUid($uid){
    	if((int)$uid < 1){
    		throw_exception('LACK_PARAM_UID');
    	}
		$GLOBALS['db']->query("SELECT * FROM `{$this->table}` WHERE `uid` = '{$uid}' LIMIT 1");
		return $GLOBALS['db']->fetch();
    }
	/**
	 * 添加统计数据
	 *
	 * @param integer $uid
	 * @return integer
	 */
	public function insert($uid){
		if((int)$uid < 1){
    		throw_exception('LACK_PARAM_UID');
    	}
		$data = array(
			'uid' => $uid,
			'level' => 0,
			'question' => 0,
			'question_elite' => 0,
			'answer' => 0,
			'answer_best' => 0,
			'answer_elite' => 0,
			'adopt' => 0,
			'favorable' => 0
		);
        $sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
                $GLOBALS['db']->query($sql);
        return $uid;
	}
	/**
     * 更新指定字段数据
     *
     * @param integer $uid	会员ID
     * @param string $field	字段名称
	 * @param	integer  $value	字段值
     * @param boolean $type	true增加false减少
     * @return boolean
     */
    public function update ($uid,$field,$value=1,$type=true)
    {
       if(in_array($field,array('question','question_elite','answer','answer_best','answer_elite','adopt','favorable'))){
	    	    	$account_array = $this->getByUid($uid);
	    	if(!is_array($account_array) || count($account_array) < 1 ){
				$this->insert($uid);
			}
	        $value = (int)$value;
	        $total = $type ? (int)$account_array[$field] + $value : (int)$account_array[$field] - $value; 
	        if($field == 'answer_best' && $account_array['answer'] > 0){
	        	$adopt = round($total/$account_array['answer'],2);
	        	$adopt = ",`adopt` = '{$adopt}' ";
	        }else if($field == 'answer' && $total > 0){
	        	$adopt = round($account_array['adopt']/$total,2);
	        	$adopt = ",`adopt` = '{$adopt}' ";
	        }
	        $set = " `{$field}` = '{$total}'".$adopt;
	        $sql = "UPDATE `{$this->table}` SET  {$set} WHERE `uid` = '{$uid}' LIMIT 1";
	        return $GLOBALS['db']->query($sql);
       }
       return true;
    }
    /**
     * 更新等级
     *
     * @param integer $uid	用户ID
     * @param integer $exp	用户经验值
     * @return boolean
     */
    public function updateLevel($uid,$exp){
    	$account_array = $this->getByUid($uid);
    	if(!is_array($account_array) || count($account_array) < 1 ){
			$this->insert($uid);
		}
		include_once ASK_LIB_PATH.'Actor.class.php';
		$actor = new Actor();
		$actor_array = $actor->getActorByScore($exp);
		$sql = "UPDATE `{$this->table}` SET `level` = '{$actor_array['grade']}'  WHERE `uid` = '{$uid}' LIMIT 1";
		unset($actor,$actor_array,$account_array);
		return $GLOBALS['db']->query($sql);
    }
    /**
     * 更新提问数
     *
    * @param integer 	$uid	用户ID
     * @param integer	$number	数量
     * @return boolean
     */
    public function updateQuestion($uid,$number=1){
    	return $this->update($uid,'question',$number);
    }
    /**
     * 更新精华提问数
     *
     * @param integer 	$uid	用户ID
     * @param integer	$number	数量
     * @return boolean
     */
    public function updateQuestionElite($uid,$number=1){
    	return $this->update($uid,'question_elite',$number);
    }
    /**
     * 更新回答数
     *
     * @param integer 	$uid	用户ID
     * @param integer	$number	数量
     * @return boolean
     */
    public function updateAnswer($uid,$number=1){
    	return $this->update($uid,'answer',$number);
    }
    /**
     * 更新回答采纳数
     *
     * @param integer 	$uid	用户ID
     * @param integer	$number	数量
     * @return boolean
     */
    public function updateAnswerBest($uid,$number=1){
    	return $this->update($uid,'answer_best',$number);
    }
    /**
     * 更新精华回答数
     *
     * @param integer 	$uid	用户ID
     * @param integer	$number	数量
     * @return boolean
     */
    public function updateAnswerElite($uid,$number=1){
    	return $this->update($uid,'answer_elite',$number);
    }
    /**
     * 更新好评数
     *
     * @param integer 	$uid	用户ID
     * @param integer	$number	数量
     * @return boolean
     */
    public function updateFavorable($uid,$number=1){
    	return $this->update($uid,'favorable',$number);
    }
}
?>