<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskAnswerList.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 2220 $
 */
/* $Id: AskAnswerList.class.php 2220 2010-08-13 08:22:17Z zhanghaisong $ */
/**
 * EXCMS 答案列表标签类
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 */
class AskAnswerList{
	/**
	 * 问题ID
	 *
	 * @var integer
	 */
	private $qid;
	/**
	 * 用户ID
	 *
	 * @var integer
	 */
	private $uid;
	/**
	 * 是否隐藏回答0否1隐藏   
	 *
	 * @var boolean
	 */
	private $hidden = false;
	/**
	 * 排序字段
	 *
	 * @var string
	 */
	private $orderby;
	/**
	 * 排序方式
	 *
	 * @var string
	 */
	private $orderway;
	/**
	 * 显示数量
	 *
	 * @var string
	 */
	private $limit;
	/**
	 * 显示行数
	 *
	 * @var integer
	 */
	private $row;
	/**
	 * 分页大小
	 *
	 * @var integer
	 */
	private $pagesize;
	/**
	 * 当前页
	 *
	 * @var integer
	 */
	private $pageon = 1;
	/**
	 * 审核内容
	 *
	 * @var integer
	 */
	private $checked;
	/**
	 * 匿名
	 */
	private $anonymous;
	/**
	 * 投票
	 *
	 * @var boolean
	 */
	private $vote;
	/**
	 * 答案列表类型：mine：我的回答，best：最佳答案，默认为空答案列表
	 * @var string
	 */
	private $listtype="";
	/**
	 * 条件
	 *
	 * @var array
	 */
	private $where = array();
	public function setQid($qid){
		$this->qid = $qid;
	}
	public function setHidden($hidden){
		$this->hidden = $hidden;
	}
	public function setBest($best){
		$this->best = $best;
	}
	public function setOrderby($orderby){
		$this->orderby = $orderby;
	}
	public function setOrderway($orderway){
		$this->orderway = $orderway;
	}
	public function setLimit($limit){
		$this->limit = $limit;
	}
	public function setRow($row){
		$this->row = (int)$row;
	}
	public function setPagesize($pagesize){
		$this->pagesize = (int)$pagesize;
	}
	public function setUid($uid){
		$this->uid = (int)$uid;
	}
	public function setChecked($checked){
		$this->checked = $checked;
	}
	public function setAnonymous($anonymous){
		$this->anonymous = $anonymous;
	}
	public function setVote($vote){
		$this->vote = $vote;
	}
	public function setListType($listtype){
		$listtype = trim($listtype);
		$this->listtype = in_array($listtype,array('mine','best','normal','vote')) ? $listtype : '';
	}
	/**
	 * 获取问题ID
	 *
	 * @return integer
	 */
	public function getQid(){
		$this->qid = (int)$this->qid;
		if($this->qid > 0){
			$this->where['qid'] = "AND `qid` = '" . $this->qid . "'";
		}
		return $this->qid;
	}
	/**
	 * 获取是否隐藏回答
	 *
	 * @return boolean
	 */
	public function getHidden(){
		if(isset($this->hidden) && $this->hidden !== ''){
			if(empty($this->hidden)){
				$this->where['hidden'] = "AND `ishidden` = '0' ";
			}else{
				$this->where['hidden'] = "AND `ishidden` = '1' ";
			}
		}
		return $this->hidden;
	}
	/**
	 * 获取分页
	 *
	 */
	public function getLimit(){
		if($this->listtype == 'mine'){
			return $this->limit = "limit 1";
		}
		if(isset($this->limit) && !empty($this->limit)){
			$this->limit = explode(',', trim($this->limit));
			$this->limit[0] = (int)$this->limit[0];
			$this->limit[1] = isset($this->limit[1]) && (int)$this->limit[1] ? (int)$this->limit[1] : $this->row;
			if($this->listtype == 'best'){
				global $EXCMS_MODULE;
				if($this->limit[1] > $EXCMS_MODULE['ask']['answer_best_allow']){
					$this->limit[1] = $EXCMS_MODULE['ask']['answer_best_allow'] > 0 ? $EXCMS_MODULE['ask']['answer_best_allow'] : 1;
				}
			}
			$this->limit = "limit " . $this->limit[0] . "," . $this->limit[1];
		}else if(isset($this->row) && !empty($this->row)){
			if($this->listtype == 'best'){
				global $EXCMS_MODULE;
				if($this->row > $EXCMS_MODULE['ask']['answer_best_allow']){
					$this->row = $EXCMS_MODULE['ask']['answer_best_allow'] > 0 ? $EXCMS_MODULE['ask']['answer_best_allow'] : 1;
				}
			}
			$this->limit = "limit " . $this->row;
		}else{
			$pagesize = $this->getPagesize();
			if($this->listtype == 'best'){
				global $EXCMS_MODULE;
				if($pagesize > $EXCMS_MODULE['ask']['answer_best_allow']){
					$pagesize = $EXCMS_MODULE['ask']['answer_best_allow'] > 0 ? $EXCMS_MODULE['ask']['answer_best_allow'] : 1;
				}
			}
			$this->limit = "limit " . $pagesize * ($this->pageon - 1) . "," . $pagesize;
		}
		return $this->limit;
	}
	/**
	 * 获取内容分页大小 默认为10
	 *
	 * @return integer
	 */
	public function getPagesize(){
		if($this->pagesize == "" || $this->pagesize <= 0 || $this->pagesize == null) return 10;
		return $this->pagesize;
	}
	/**
	 * 获取排序
	 *
	 * @return string
	 */
	public function getOrderBy(){
		$orderbyArr = explode(',', trim($this->orderby));
		$orderwayArr = explode(',', trim($this->orderway));
		$order = ' ORDER BY ';
		$seprator = ' ';
		foreach($orderbyArr as $k => $v){
			switch($v){
				//投票数量
				case 'vote' :
					$order .= $seprator . ((isset($orderwayArr[$k]) && strtolower($orderwayArr[$k]) == "desc") ? "`hot` DESC, `aid` ASC" : "`hot` ASC, `aid` ASC");
					break;
				//创建时间
				case 'createdate' :
					$order .= $seprator . ((isset($orderwayArr[$k]) && strtolower($orderwayArr[$k]) == "desc") ? "`createdate` DESC, `aid` ASC" : "`createdate` ASC, `aid` ASC");
					break;
				default :
					$order .= "`aid` ASC";
			}
			$seprator = ",";
		}
		return $order;
	}
	/**
	 * 获取用户条件
	 *
	 * @return unknown
	 */
	public function getUid(){
		if($this->uid > 0){
			$this->where['uid'] = " AND `uid` = '{$this->uid}' ";
		}
		return $this->uid;
	}
	/**
	 * 获取审核状态
	 *
	 * @return string
	 */
	public function getChecked(){
		if(isset($this->checked) && $this->checked !== ''){
			if(empty($this->checked)){
				$this->where['checked'] = " AND `checked` = '0'";
			}else{
				$this->where['checked'] = " AND `checked` = '1'";
			}
		}else{
			$this->where['checked'] = " AND `checked` = '2'";
		}
		return $this->checked;
	}
	/**
	 * 获取匿名回答
	 *
	 * @return boolean
	 */
	public function getAnonymous(){
		if(isset($this->anonymous) && $this->anonymous !== ''){
			if(empty($this->anonymous)){
				$this->where['anonymous'] = " AND `anonymous` = '0'";
			}else{
				$this->where['anonymous'] = " AND `anonymous` = '1'";
			}
		}
		return $this->anonymous;
	}
	/**
	 * 获取投票回答
	 *
	 * @return boolean
	 */
	public function getVote(){
		if(isset($this->vote) && $this->vote !== ''){
			if(empty($this->vote)){
				$this->where['vote'] = "AND `vote` =  '0' ";
			}else{
				$this->where['vote'] = "AND `vote` =  '1' ";
			}
		}
		return $this->vote;
	}
	/**
	 * 获取查询条件
	 *
	 * @return string
	 */
	private function getWhere(){
		$this->getQid();
		$this->getHidden();
		$this->getUid();
		$this->getAnonymous();
		$this->getChecked();
		$this->getVote();
		switch($this->listtype){
			case 'mine' :
				$uid = EXCMS_SESSION_UID > 0 ? EXCMS_SESSION_UID : 0;
				$this->where['mine'] = "AND `uid` =  '{$uid}' ";
				break;
			case 'best' :
				$this->where['best'] = "AND `isbest` =  '1' ";
				break;
			case 'vote' :
				$this->where['vote'] = "AND `vote` =  '1' ";
				break;
			case 'normal' :
				$uid = EXCMS_SESSION_UID > 0 ? EXCMS_SESSION_UID : 0;
				if($uid > 0){
					$this->where['best'] = "AND `isbest` =  '0' AND `vote` = '0' AND `uid`<>'{$uid}' ";
				}else{
					$this->where['best'] = "AND `isbest` =  '0' AND `vote` = '0'";
				}
				break;
		}
		return join(' ', $this->where);
	}
	/**
	 * 获取当前登录用户的uid
	 * @return int
	 */
	private function getCurrentUserid(){
		include_once LIB_MODULES_PATH . 'account/User.class.php';
		$userObj = new User();
		$userinfo = $userObj->getSession();
		return $userinfo['uid'];
	}
	/**
	 * 获取答案列表
	 *
	 * @param array $array	字段属性
	 * 
	 * @return array	答案列表数据
	 * <ul> 
	 * <li> $array['from'] 答案列表数据 </li>
	 * <li> $array['item'] 总数 </li>
	 * <li> $array['pager'] 分页数据 </li>
	 * </ul>
	 */
	public function getAskAnswerList($array){
		global $_PAGE;
		$array['qid'] = $array['qid'] ? $array['qid'] : $_PAGE['ASK_QUESTION']['qid'];
		//设置参数
		$this->setQid($array['qid']);
		$this->setListType($array['listtype']);
		$this->setHidden($array['hidden']);
		$this->setBest($array['best']);
		$this->setOrderby($array['orderby']);
		$this->setOrderway($array['orderway']);
		$this->setRow($array['row']);
		$this->setLimit($array['limit']);
		$this->setPagesize($array['pagesize']);
		$this->setAnonymous($array['anonymous']);
		$this->setChecked($array['checked']);
		$this->setUid($array['uid']);
		$this->setVote($array['vote']);
		$fields = explode(',', $array['fields']);
		//初始化变量
		$this->pageon = max($_PAGE['page'], 1);
		//查询总数
		$sql = "SELECT COUNT(*) as total FROM " . TABLE_PREFIX . "ask_answers WHERE 1 {$this->getWhere()} ";
		$GLOBALS['db']->query($sql);
		$total = $GLOBALS['db']->fetch();
		$total = $total['total'];
		if(!($total > 0))	return null;
		//查询答案列表
		$sql = "SELECT * FROM " . TABLE_PREFIX . "ask_answers WHERE 1 {$this->getWhere()} {$this->getOrderBy()} {$this->getLimit()}";
		$GLOBALS['db']->query($sql);
		$ask_array = $GLOBALS['db']->fetchAll();
		if(is_array($ask_array) && count($ask_array)){
			if(in_array('category', $fields)){
				include_once ASK_LIB_PATH . 'AskCategory.class.php';
				$ask_cate = new AskCategory();
				$category_array = $ask_cate->getCateCache();
				unset($ask_cate);
			}
			if(in_array('user', $fields)){
				include_once LIB_MODULES_PATH . 'account/Account.class.php';
				$account = new Account();
			}
			if(in_array('question', $fields)){
				include_once ASK_LIB_PATH . 'AskQuestion.class.php';
				$question = new AskQuestion();
			}
			if(in_array('askaccount', $fields)){
				include_once ASK_LIB_PATH.'AskAccount.class.php';
				$askaccount = new AskAccount();
			}
			if(in_array('actor', $fields) || in_array('score', $fields) || in_array('exp', $fields)){
				include_once ASK_LIB_PATH.'AskScore.class.php';
				$score = new AskScore();
				if(in_array('actor', $fields)){
					include_once ASK_LIB_PATH.'Actor.class.php';
					$actor = new Actor();
				}
			}
			$vote_total = 0;
			foreach($ask_array as $key => $value){
				if($value['uid'] > 0){
					if(in_array('category', $fields)) $ask_array[$key]['category'] = $category_array[$value['cid']];
					if(in_array('actor', $fields) || in_array('exp', $fields)){
						$ask_array[$key]['exp'] = $score->getExpByUid($value['uid']);
						if(in_array('actor', $fields)){
							$ask_array[$key]['actor'] = $actor->getActorByScore($ask_array[$key]['exp']['exp']);
						}
					}
					if(in_array('score', $fields)){
						$ask_array[$key]['score'] = $score->getScoreByUid($value['uid']);
					}
					if(in_array('askaccount', $fields)){
						$ask_array[$key]['askaccount'] = $askaccount->getByUid($value['uid']);
					}
				}
				if(in_array('user', $fields) && $value['uid'] > 0 && !$value['anonymous']) $ask_array[$key]['user'] = $account->getById($value['uid']);
				else $ask_array[$key]['user'] = array('username' => '匿名');
				if(in_array('question', $fields) && $value['qid'] > 0) $ask_array[$key]['question'] = $question->getByQid($value['qid']);
				
				// count vote total
				if($this->listtype == 'vote'){
					$vote_total += $value['votecount'];
					$ask_array[$key]['vote_percent'] = '0%';
				}
			}
			if($this->listtype == 'vote' && $vote_total > 0){
				foreach($ask_array as $key => $value){
					$ask_array[$key]['vote_percent'] = round(($value['votecount'] * 100 / $vote_total), 1) . '%';
				}
			}
			$result = array('from' => &$ask_array, 'total' => $total, 'item' => array('total' => $total), 'pager' => array('total' => $total, 'pagesize' => $this->getPagesize(), 'dynamic' => true, 'pageon' => $_PAGE['page'],'encodepage' => 'nocode'));
		}else{
			$result = null;
		}
		return $result;
	}
}
// excms file end