<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskAppendList.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author hukuizhi
 * @version $Rev: 2076 $
 */
/* $Id: AskAppendList.class.php 2076 2010-08-04 02:54:13Z zhangxuelin $ */
/**
 * EXCMS 问题列表标签类
 * @category EXCMS
 * @package ask
 * @author hukuizhi
 */
class AskAppendList{
	/**
	 * 追加问题答案表
	 * @access private
	 * @var string
	 */
	private $table = 'ask_answers_append';
	/**
	 * 问题补充表
	 * @access private
	 * @var string
	 */
	private $table_supplement = 'ask_questions_append';
	/**
	 * 列表类型：0:问题的补充，1:追加的问题和答案
	 * @access private
	 * @var int
	 */
	private $type;
	/**
	 * 问题id
	 * @access private
	 * @var int
	 */
	private $qid;
	/**
	 * 答案id
	 * @access private
	 * @var int
	 */
	private $aid;
	/**
	 * 显示行数
	 * @access private
	 * @var int
	 */
	private $row;
	/**
	 * 获取记录数：如“1,2”
	 * @access private
	 * @var string
	 */
	private $limit;
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
		$this->table_supplement = TABLE_PREFIX . $this->table_supplement;
	}
	function AskAppendList(){
		$this->__construct();
	}
	/**
	 * 设置列表类型
	 * @param int $_type
	 */
	public function setType($_type){
		$this->type = $_type=='answer' ? 1 : 0;
	}
	/**
	 * 设置问题id
	 * @param int $_qid
	 */
	public function setQid($_qid){
		$this->qid = (int)$_qid;
	}
	/**
	 * 设置答案id
	 * @param int $_aid
	 */
	public function setAid($_aid){
		$this->aid = (int)$_aid;
	}
	/**
	 * 设置limit
	 * @param string $_limit
	 */
	public function setLimit($_limit){
		$this->limit = $_limit;
	}
	/**
	 * 设置获取行数
	 * @param int $_row
	 */
	public function setRow($_row){
		$this->row = $_row;
	}
	/**
	 * 获取limit语句
	 */
	public function getLimit(){
		if(isset($this->limit) && !empty($this->limit)){
			$limit = explode(',', trim($this->limit));
			$limit[0] = (int)$limit[0];
			$limit[1] = is_numeric($limit[1]) && $limit[1]>0 ? $limit[1] : $this->row;
			$limit = "limit " . $limit[0] . "," . $limit[1];
		}elseif(isset($this->row) && $this->row>0){
			$limit = "limit " . $this->row;
		}
		return $limit;
	}
	/**
	 * 获取问答补充列表
	 * @param array $array
	 * @return array
	 */
	public function getAskAppendList($array){
		global $_PAGE;
		// 设置参数
		$this->setType($array['type']);
		$this->setQid($array['qid'] ? $array['qid'] : $_PAGE['QUESTION']['qid']);
		$this->setAid($array['aid']);
		$this->setRow($array['row']);
		$this->setLimit($array['limit']);
		unset($array);
		$limit = $this->getLimit();
		if($this->type){ //追加
			if($this->aid < 1){
				return null;
			}
			$sql = "SELECT * FROM `{$this->table}` WHERE aid={$this->aid} ORDER BY `date` " . $limit;
		}else{ // 补充
			if($this->qid < 1){
				return null;
			}
			$sql = "SELECT * FROM `{$this->table_supplement}` WHERE qid={$this->qid} ORDER BY `date` " . $limit;
		}
		$GLOBALS['db']->query($sql);
		$rs = $GLOBALS['db']->fetchAll();
		if(count($rs) > 0){
			return array('from' => &$rs, 'item' => array('total' => count($rs)));
		}else{
			return null;
		}
	}
}

// excms file's end