 <?php
	/**
	 * Project:		EXCMS: the PHP content management system.
	 * File:		AskCateList.class.php
	 *
	 * A product of PUTOYO Inc.
	 * 
	 * EXCMS is a ten million data-level,high speed,human-based content management system.
	 *
	 * EX is Excellence & Express & Exceed & Expert.
	 * 
	 * For questions, help, comments, discussion, please join the
	 * EXCMS mailing list. Send a blank e-mail to
	 * join@excms.cn
	 * or join the EXCMS forum
	 * www.excms.cn/forum
	 * 
	 * @link http://www.excms.cn/
	 * @copyright Copyright (c) 2010 PUTOYO Inc.
	 * @license http://www.excms.cn/licenses/LICENSE-1.0
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 * @version $Rev: 2220 $
	 */
	/* $Id: AskCateList.class.php 2220 2010-08-13 08:22:17Z zhanghaisong $ */
	/**
	 * EXCMS 问题分类标签类
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 */
	include_once ASK_LIB_PATH . 'AskCategory.class.php';
	
	class AskCateList{
		/**
		 * 问题分类
		 *
		 * @var integer
		 */
		private $cid;
		/**
		 * top 顶栏目,self同级栏目,son子栏目, 默认是self
		 *
		 * @var boolean
		 */
		private $type;
		/**
		 * 显示栏目级别
		 *
		 * @var integer
		 */
		private $levels;
		/**
		 * 分类缓存
		 *
		 * @var array
		 */
		private $category_cache;
		/**
		 * 是否显示问题数
		 *
		 * @var boolean
		 */
		private $answer = false;
		/**
		 * 获取分类对像
		 *
		 * @return object
		 */
		public function __construct(){
			if(!is_array($this->category_cache)){
				$category = new AskCategory();
				$this->category_cache = $category->getCateCache();
				unset($category);
			}
		}
		public function AskCateList(){
			$this->__construct();
		}
		/**
		 * 设置分类ID
		 *
		 * @param integer $cid
		 */
		public function setCid($cid){
			$this->cid = $cid;
		}
		public function setType($type){
			$this->type = $type;
		}
		public function setLevels($levels){
			$this->levels = $levels;
		}
		public function setAnswer($answer){
			$this->answer = $answer;
		}
		/**
		 * 获取分类ID
		 *
		 * @return integer
		 */
		public function getCid(){
			return empty($this->cid) ? 0 : $this->cid;
		}
		/**
		 * top 顶级分类,self同级分类,son子分类 默认是self
		 *
		 * @return boolean
		 */
		public function getType(){
			switch($this->type){
				case 'top' :
					$typeid = 0;
					break;
				case 'son' :
					$typeid = $this->getCid();
					if(!is_array($this->category_cache[$typeid]['childids']) || count($this->category_cache[$typeid]['childids']) < 1){
						$typeid = $this->category_cache[$this->getCid()]['pid'];
					}
					break;
				case 'self' :
				default :
					$typeid = $this->category_cache[$this->getCid()]['pid'];
					break;
			}
			return $typeid;
		}
		/**
		 * 获取分类级别
		 *
		 * @return integer
		 */
		public function getLevels(){
			return $this->levels <= 0 ? 0 : $this->levels;
		}
		/**
		 * 获取显示问题分类数
		 *
		 * @return boolean
		 */
		public function getAnswer(){
			return $this->answer;
		}
		/**
		 * 获取问题分类列表
		 *
		 * @return array
		 * <ul>
		 * <li>$array['cid'] 分类ID</li>
		 * <li>$array['type'] top 顶栏目,self同级栏目,son子栏目,cross交叉栏目 默认是self</li>
		 * <li>$array['levels'] 显示栏目级别 </li>
		 * </ul>
		 */
		public function getAskCateList($array){
			global $_CATEGORY;
			$array['cid'] = $array['cid'] > 0 ? $array['cid'] : $_CATEGORY['cid'];
			$this->setCid($array['cid']);
			$this->setType($array['type']);
			$this->setLevels($array['levels']);
			$askcate_array = $this->category_cache[$this->getType()]['childids'];
			$result = null;
			if(is_array($askcate_array) && count($askcate_array) > 0){
				$category_array = array();
				foreach($askcate_array as $key => $value){
					$category_array[$key] = $this->category_cache[$value];
					$category_array[$key]['url'] = EXCMS::url(array('name' => 'ask.list', 'cid' => $value, 'type' => '', 'word' => ''));
				}
				$result = array('from' => &$category_array);
				unset($ask_cate);
			}
			return $result;
		}
		/**
		 * 获取所有问题列表
		 * 
		 * @param array $array 参数
		 * <ul>
		 * <li>$array['cid'] 分类ID</li>
		 * <li>$array['type'] top 顶栏目,self同级栏目,son子栏目,cross交叉栏目 默认是self</li>
		 * <li>$array['levels'] 显示栏目级别,默认为所有栏目级别</li>
		 * <li>$array['answer'] 是否显示问题数 </li>
		 * <li>$array['levels1'] 设置一级分类显示数量 </li>
		 * <li>$array['levels2'] 设置二级分类显示数量下面依此类推 </li>
		 * </ul>
		 * 
		 * @return array
		 */
		public function getAskCate($array){
			global $_PAGE;
			$array["cid"] = $array['cid'] > 0 ? $array["cid"] : $_PAGE['ASK_CATEGORY']['cid'];
			$this->setCid($array['cid']);
			$this->setType($array['type']);
			$this->setLevels($array['levels']);
			$this->setAnswer($array['answer']);
			foreach($array as $key => $value){
				$pos = strpos($key, 'level');
				if($pos !== false){
					$level = trim(substr($key, $pos + 5));
					$levelNum[$level] = $value;
				}
			}
			return $this->getAskCateTree($this->getType(), $this->getLevels(), $levelNum);
		}
		/**
		 * 获取问题分类树
		 *
		 * @param integer $cid	问题分类ID
		 * @param integer $levels	分类级别
		 * @param integer $levelNum	问题分类数量
		 * @param integer $curLevel	当前问题分类级别
		 * 
		 * @return string 
		 */
		public function getAskCateTree($cid, $levels, $levelNum, $curLevel = 1){
			$askcate_array = $this->category_cache[$cid]['childids'];
			if(is_array($askcate_array) && count($askcate_array) > 0){
				$count = 0;
				$str = "<ul class=\"level{$curLevel}-ul clearfix channelid{$cid}\">\n";
				foreach($askcate_array as $value){
					$category_array = $this->category_cache[$value];
					//(当级别为零 或者 当前级别小于设置级别) 并且 (级别数不能为空 或者 总数小于当前栏目级别数)
					if(($levels == 0 || $levels >= $curLevel) && (empty($levelNum[$curLevel]) || $count < $levelNum[$curLevel])){
						$str .= "<li class=\"level{$curLevel}-li\">";
						$url = EXCMS::url(array('name' => 'ask.list', 'cid' => $category_array['cid'], 'type' => '', 'word' => ''));
						if($this->getAnswer()){
							$answernum = " (" . $category_array['asknumber'] . ")";
						}
						$childs =  is_array($this->category_cache[$category_array['cid']]['childids']) && count($this->category_cache[$category_array['cid']]['childids']) > 0;
						if(!($levels == $curLevel) && $childs){
							$str .= "\n<h3 class=\"level{$curLevel}-h3\"><a href=\"{$url}\">" . $category_array['name'] . "</a>{$answernum}</h3>\n";
							$str .= $this->getAskCateTree($category_array['cid'], $levels, $levelNum, $curLevel + 1);
						}else{
							if($curLevel == 1){
								$str .= "\n<h3 class=\"level{$curLevel}-h3\"><a href=\"{$url}\">" . $category_array['name'] . "</a>{$answernum}</h3>\n";
							}else{
								$str .= "<a href=\"{$url}\">" . $category_array['name'] . "</a>{$answernum}";
							}
						}
						$str .= "</li>\n";
						$count++;
					}
				}
				$str .= "</ul>\n";
			}
			return $str;
		}
	}

 // excms file end