<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskCategory.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: yaoyanan $
 * @version $Rev: 2226 $
 */
/* $Id: AskCategory.class.php 2226 2010-08-14 07:06:38Z yaoyanan $ */
/**
 * EXCMS 问题分类
 * @category EXCMS
 * @package ask
 * @author $Author: yaoyanan $
 */
class AskCategory{
	/**
	 * 问题分类数据表
	 *
	 * @access private
	 * @var string
	 */
	private $table = 'ask_category';
	/**
	 * 分页数据获取时缓存
	 * @var array
	 */
	private $cache;
	/**
	 * 构造函数
	 *
	 */
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
	}
	/**
	 * 兼容PHP4构造函数
	 *
	 */
	function AskCategory(){
		$this->__construct();
	}
	/**
	 * 根据内容ID获取问题类型
	 *
	 * @param integer $cid	问题类型ID
	 * @return array	问题类型详细信息
	 */
	public function getById($cid){
		if(!($cid >= 0)){
			throw_exception('ASK_CATEGORY_LACK_ID');
		}
		$sql = "SELECT * FROM `{$this->table}` WHERE `cid` = '{$cid}' LIMIT 1";
		global $EXCMS;
		$GLOBALS['db']->query($sql);
		$askcate_array = $GLOBALS['db']->fetch();
		$askcate_array['url'] = EXCMS::url(array('name' => 'ask.list', 'cid' => $cid, 'type' => '', 'word' => ''));
		return $askcate_array;
	}
	/**
	 * 根据分类id获取分类名称
	 * @param int $cid
	 * @return string
	 */
	public function getNameById($cid){
		if(!($cid >= 0)){
			throw_exception('ASK_CATEGORY_LACK_ID');
		}
		$sql = "SELECT `name` FROM `{$this->table}` WHERE `cid` = '{$cid}' LIMIT 1";
		global $EXCMS;
		$GLOBALS['db']->query($sql);
		$askcate_array = $GLOBALS['db']->fetch();
		return $askcate_array['name'];
	}
	/**
	 * 新建问题类型 
	 *
	 * @param array $data	问题分类数据 
	 * <ul>
	 * <li>string $data['name'] 分类名称 </li>
	 * <li>integer $data['pid'] 上级分类ID </li>
	 * <li>string $data['description'] 分类描述</li>
	 * <li>string $data['asknumber'] 问题数量</li>
	 * <li>integer $data['isspecia'] 是否专家分类(1专家分类.2:不是) </li>
	 * </ul>
	 * 
	 * @return integer 问题类型 ID
	 */
	function insert($data){
		if(trim($data['name']) == ''){
			throw_exception('ASK_CATEGORY_LACK_NAME');
		}
		$data = array(
			'pid' => (int)$data['pid'],
			'name' => trim($data['name']),
			'type' => $data['type'] == 1 ? 1 : $data['type'] == 2 ? 2 : 0,
			'description' => trim($data['description']),
			'asknumber' => 0,
			'questioncheck' => $data['questioncheck'] ? 1 : 0,
			'answercheck' => $data['answercheck'] ? 1 : 0,
			'sort' => (int)$data['sort']
		);
		$sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
		$GLOBALS['db']->query($sql);
		$cid = $GLOBALS['db']->insert_id();
		if($data['pid'] > 0){ // 更新父级分类属性
			$GLOBALS['db']->query("UPDATE `{$this->table}` SET `childnum` = `childnum` + 1 WHERE `cid` = '{$data['pid']}' LIMIT 1");
		}
		EXCMS::cacheWrite(CACHE_CHANNEL_PATH . 'askcate.php', $this->getAllCate());
		return $cid;
	}
	/**
	 * 更新指定ID问题类型
	 *
	 * @param integer $cid 	问题类型ID
	 * @param array $data	问题分类数据 
	 * <ul>
	 * <li>string $data['name'] 分类名称 </li>
	 * <li>integer $data['pid'] 上级分类ID </li>
	 * <li>string $data['description'] 分类描述</li>
	 * </ul>
	 * @return boolean
	 */
	function update($cid, $data){
		if(!($cid > 0)){
			throw_exception('ASK_CATEGORY_LACK_ID');
		}else if(trim($data['name']) == ''){
			throw_exception('ASK_CATEGORY_LACK_NAME');
		}
		$data = array('name' => $data['name'], 'pid' => trim($data['pid']), 'description' => $data['description'], 'questioncheck' => $data['questioncheck'] ? 1 : 0, 'answercheck' => $data['answercheck'] ? 1 : 0, 'sort' => (int)$data['sort']);
		$set = array();
		foreach($data as $k => $v){
			$set[] = "`{$k}` = '{$v}'";
		}
		$set = implode(", ", $set);
		$sql = "UPDATE `{$this->table}` SET {$set} WHERE `cid` = '{$cid}' LIMIT 1";
		$GLOBALS['db']->query($sql);
		EXCMS::cacheWrite(CACHE_CHANNEL_PATH . 'askcate.php', $this->getAllCate());
		return true;
	}
	/**
	 * 删除指定ID问题类型
	 *
	 * @param string|integer|array $cid 问题类型ID
	 * 
	 * @return boolean
	 */
	public function delete($cid){
		$cid = EXCMS::convertToIntArray($cid);
		if($cid === false){
			throw_exception('ASK_CATEGORY_LACK_ID');
		}
		$num = count($cid);
		$where = $num > 1 ? "`cid` IN ('" . implode("', '", $cid) . "') LIMIT {$num}" : "`cid` = '" . $cid[0] . "'";
		$sql = "DELETE FROM `{$this->table}` WHERE {$where}";
		$GLOBALS['db']->query($sql);
		EXCMS::cacheWrite(CACHE_CHANNEL_PATH . 'askcate.php', $this->getAllCate());
		return true;
	}
	/**
	 * 获取问题分页列表
	 *
	 * @param array $paging 分页数组
	 * <ul>
	 * <li>integer $paging['limit'] 分页大小 default 0</li>
	 * <li>integer $paging['start'] 分页起始大小 default 0</li>
	 * <li>integer $paging['total'] 总数 default 0</li>
	 * <li>integer $paging['sort'] 排序字段</li>
	 * <li>integer $paging['dir'] 排序方式 ASC or DESC, </li>
	 * <li>integer $paging['keywords'] 搜索关键字</li>
	 * <li>integer $paging['pid'] 上级分类id</li>
	 * </ul>
	 * @return array Paging 数组
	 * <ul> 
	 * <li> $array['total'] 总数 </li>
	 * <li> $array['data'] 分页数据 </li>
	 * </ul>
	 */
	function getPaging($paging = array()){
		$keywords = trim($paging['keywords']);
		if(!empty($keywords)){
			$where = " and (`name` like '%{$keywords}%' or `description` like '%{$keywords}%')";
		}
		if($paging['pid'] > 0){
			$where .= " and `pid`='{$paging['pid']}' ";
		}
		if(!isset($paging['total'])){
			$sql = "SELECT COUNT(*) as `total` FROM `{$this->table}` WHERE 1 {$where}";
			$GLOBALS['db']->query($sql);
			$rs = $GLOBALS['db']->fetch();
			$total = $rs['total'];
		}else{
			$total = (int)$paging['total'];
		}
		if($total <= 0){
			return array('total' => $total, 'data' => array());
		}
		if(empty($paging['sort'])) $paging['sort'] = 'cid';
		$dir = strtoupper($paging['dir']) == "DESC" ? "DESC" : "ASC";
		$sort = "`" . $paging['sort'] . "` {$dir}";
		$orderby = "ORDER BY {$sort}";
		$start = (int)$paging['start'];
		$limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
		$limit = "LIMIT {$start}, {$limit}";
		$sql = "SELECT * FROM `{$this->table}` WHERE 1 {$where} {$orderby} {$limit}";
		$GLOBALS['db']->query($sql);
		$rs = $GLOBALS['db']->fetchAll();
		if(count($rs) > 0){
			foreach ($rs as $k=>$v) {
				if(!isset($this->cache[$v['cid']])){
					$this->cache[$v['cid']] = $this->getNameById($v['pid']);
					empty($this->cache[$v['cid']]) && $this->cache[$v['cid']] = '<font color=green>顶级分类</font>';
				}
				$rs[$k]['pname'] = $this->cache[$v['cid']];
			}
		}
		return array('total' => $total, 'data' => $rs);
	}
	/**
	 * 获取当前问题分类下所有子栏目
	 *
	 * @param integer|string|array $cid	当前分类ID
	 * @return array
	 */
	public function getAskCategoryChilds($cid = 0){
		$category_array = $this->getCateCache($cid);
		$temp = array($cid);
		if(is_array($category_array['childids']) && count($category_array['childids']) > 0){
			foreach($category_array['childids'] as $value){
				if($this->hasChilds($value)){
					$temp = array_merge($temp, $this->getAskCategoryChilds($value));
				}else{
					$temp[] = $value;
				}
			}
		}
		return $temp;
	}
	/**
	 * 获取上级分类ID获取子分类
	 *
	 * @param integer $pid	上级分类ID
	 * 
	 * 
	 * @return array	子分类数组
	 */
	public function getAskCateByPid($pid){
		$sql = "SELECT * FROM `" . $this->table . "` WHERE `pid` = '" . $pid . "' ORDER BY `cid`";
		$GLOBALS['db']->query($sql);
		return $GLOBALS['db']->fetchAll();
	}
	/**
	 * 更新问题数量
	 *
	 * @param integer $cid	问题分类ID
	 * @param boolean $status	是否增加问题数量 true:问题数量加1,false问题数量减1
	 * 
	 * @return boolean
	 */
	public function updateQuestionNumber($cid, $status = true){
		$cid = EXCMS::convertToIntArray($cid);
		if($cid === false){
			throw_exception('ASK_CATEGORY_LACK_ID');
		}
		$num = count($cid);
		$where = $num > 1 ? "`cid` IN ('" . implode("', '", $cid) . "') LIMIT {$num}" : "`cid` = '" . $cid[0] . "'";
		$status = $status ? " asknumber+1 " : " asknumber-1 ";
		$sql = "UPDATE `{$this->table}` SET `asknumber` = {$status} WHERE {$where}";
		$GLOBALS['db']->query($sql);
		$cate_array = EXCMS::cacheRead(CACHE_CHANNEL_PATH . 'askcate.php');
		foreach ($cid as $value){
			$cate_array[$value]['asknumber'] =  $status ? $cate_array[$value]['asknumber'] + 1 : $cate_array[$value]['asknumber'] - 1;
		}
		EXCMS::cacheWrite(CACHE_CHANNEL_PATH . 'askcate.php', $cate_array);
		return true;
	}
	/**
	 * 获取导航条
	 *
	 * @param integer $cid	分类ID
	 * 
	 * @return string
	 */
	public function getNavigation($category = 0, $last = false){
		global $EXCMS_CONFIG, $EXCMS_MODULE;
		$split = ' ' . text2Html($EXCMS_CONFIG['list_symbol']) . ' ';
		if(is_array($category) && $category['cid']){
			$cid = $category['pid'];
			if($last === true){
				$nav = $category['url'];
			}elseif($last){
				$nav = $category['name'] . $split . $last;
			}else{
				$nav = $category['name'];
			}
			unset($last);
		}else{
			$cid = $category;
		}
		unset($category);
		
		while($cid > 0){
			$sql = "SELECT * FROM `" . $this->table . "` WHERE `cid` = '" . $cid . "' LIMIT 1";
			$GLOBALS['db']->query($sql);
			$rs = $GLOBALS['db']->fetch();
			if(isset($nav)){
				$nav = "<a href='" . EXCMS::url(array('name' => 'ask.list', 'cid' => $cid, 'type' => '', 'word' => '')) . "'>" . $rs['name'] . "</a>" . $split . $nav;
			}else{
				if($last === true){
					$nav = "<a href='" . EXCMS::url(array('name' => 'ask.list', 'cid' => $cid, 'type' => '', 'word' => '')) . "'>" . $rs['name'] . "</a>";
				}elseif($last){
					$nav = $rs['name'] . $split . $last;
				}else{
					$nav = $rs['name'];
				}
				unset($last);
			}
			$cid = $rs['pid'];
		}
		if($nav) $nav = $split . $nav;
		$nav = "<a href='" . EXCMS::url('ask.index') . "'>" . $EXCMS_MODULE['ask']['name'] . "首页</a>"  . $nav;
		if($last && is_string($last)) $nav .= $split . $last;
		return $nav;
	}
	/**
	 * 获取问题分类树
	 *
	 * @param integer $node	当前分类ID
	 * 
	 * @return array	问题分类树
	 */
	public function getAskCategoryTree($node){
		if(!($node >= 0)){
			throw_exception('ASK_CATEGORY_LACK_ID');
		}
		$sql = "SELECT * FROM `" . $this->table . "` WHERE `pid` = '" . $node . "' ORDER BY `sort`";
		$GLOBALS['db']->query($sql);
		$childs = $GLOBALS['db']->fetchAll();
		$nodes = array();
		if(is_array($childs) && count($childs) > 0){
			foreach($childs as $val){
				$node = array();
				$node['id'] = $val['cid'];
				$node['text'] = $val['name'];
				$node['leaf'] = $this->hasChilds($val['cid']) ? false : true;
				$node['questioncheck'] = $val['questioncheck'];
				$node['answercheck'] = $val['answercheck'];
				$node['asknumber'] = $val['asknumber'];
				$node['description'] = $val['description'];
				$node['sort'] = $val['sort'];
				$nodes[] = $node;
			}
		}
		return $nodes;
	}
	/**
	 * 判断分类是否有子分类
	 *
	 * @param integer $pid	上级分类ID
	 * @return array	
	 */
	public function hasChilds($pid){
		if(!($pid > 0)){
			throw_exception('ASK_CATEGORY_LACK_ID');
		}
		$sql = "SELECT `cid` FROM `" . $this->table . "` WHERE `pid` = '" . $pid . "' LIMIT 1";
		$GLOBALS['db']->query($sql);
		$rs = $GLOBALS['db']->fetch();
		return $rs['cid'] > 0 ? true : false;
	}
	/**
	 * 获取所有分类列表
	 *
	 * @param integer $cid	问题分类ID默认为0
	 * 
	 * @return array
	 */
	public function getAllCateList($cid = 0,$cate_cache=array()){
		if(!is_array($cate_cache) || count($cate_cache) < 1){
			$cate_cache = $this->getCateCache($cid);
		}
		$askcate_array = $cate_cache[$cid]['childids'];
		if(is_array($askcate_array) && count($askcate_array) > 0){
			foreach($askcate_array as $value){
				$temp = array();
				$temp[] = $cate_cache[$value]['cid'];
				$temp[] = $cate_cache[$value]["name"];
				if($this->hasChilds($value)){
					$temp[] = $this->getAllCateList($value,$cate_cache);
				}
				$msg[] = $temp;
			}
		}
		return $msg;
	}
	/**
	 * 获取所有分类数据
	 *
	 * @param integer $cid	分类ID
	 * @param array $cate_array	分类数组
	 * @return array
	 */
	public function getAllCate($cid = 0,$cate_array=array()){
		$askcate_array = $this->getAskCateByPid($cid);
		if(is_array($askcate_array) && count($askcate_array) > 0){
			foreach($askcate_array as $key => $value){
				$value['position'] = $this->getNavigation($value['cid']);
				$value['url'] = EXCMS::url(array('name' => 'ask.list', 'cid' => $value['cid'], 'type' => '', 'word' => ''));
				$cate_array[$value['cid']] = $value;
				if(!$value['pid']){ $cate_array[0]['childids'][] = $value['cid'];}
				if($cid > 0) $cate_array[$cid]['childids'][] =  $value['cid'];
				if($this->hasChilds($value['cid'])){
					$cate_array = $this->getAllCate($value['cid'],$cate_array);
				}
			}
		}
		return $cate_array;
	}
	/**
	 * 更新ASK缓存
	 *
	 * @param integer $cid
	 */
	public function updateCache($cid=0){
		 $category_array = $this->getAllCate($cid);
		 EXCMS::cacheWrite(CACHE_CHANNEL_PATH . 'askcate.php', $category_array);
		 return  $category_array;
	}
	/**
	 * 获取缓存文件
	 *
	 * @param integer $cid
	 * @return array
	 */
	public function getCateCache($cid=0){
		if(!is_array($GLOBALS['CACHE_CATEGORY']) || count($GLOBALS['CACHE_CATEGORY'] < 1)){
			$cache_file = CACHE_CHANNEL_PATH . 'askcate.php';
			if(!file_exists($cache_file)){
				$GLOBALS['CACHE_CATEGORY'] = $this->updateCache();
			}else{
				$GLOBALS['CACHE_CATEGORY'] = EXCMS::cacheRead($cache_file);
			}		
		}
		if(is_array($GLOBALS['CACHE_CATEGORY']) && $cid > 0){
			return $GLOBALS['CACHE_CATEGORY'][$cid]; 
		}else{
			return $GLOBALS['CACHE_CATEGORY'];
		}
	}
}


// excms file end