<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskExp.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 1839 $
 */
/* $Id: AskExp.class.php 1839 2010-06-29 11:09:57Z zhanghaisong $ */
/**
 * EXCMS 用户经验管理类
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 */
class AskExp{
	/**
	 * 会员经验值
	 *
	 * @access private
	 * @var string
	 */
	private $table = 'ask_exp';
	/**
	 * 构造函数
	 *
	 */
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
	}
	/**
	 * 兼容PHP4构造函数
	 *
	 */
	function AskExp(){
		$this->__construct();
	}
	/**
	 * 根据会员ID获取分员经验值
	 *
	 * @param integer $uid	会员ID
	 * @return array	用户经验值详细信息
	 */
	public function getByUid($uid){
		if(!($uid > 0)){
			throw_exception('LACK_PARAM_UID');
		}
		$sql = "SELECT * FROM `{$this->table}` WHERE `uid` = '{$uid}' LIMIT 1";
		$GLOBALS['db']->query($sql);
		return $GLOBALS['db']->fetch();
	}
	/**
	 * 添加会员经验数据 
	 *
	 * @param integer $uid	会员ID
	 * @return integer 会员ID
	 */
	function insert($uid){
		if((int)$uid < 1){
			throw_exception('LACK_PARAM_UID');
		}
		global $EXCMS_MODULE;
		$data = array(
			'uid' => $uid,
			'exp' => $EXCMS_MODULE['exp_first_login'],
			'exp_operate' => 0,
			'exp_question' => 0,
			'exp_answer' => 0,
			'exp_punish' => 0,
			'exp_other' => 0,
			'exp_week' => $EXCMS_MODULE['exp_first_login'],
			'exp_month' => $EXCMS_MODULE['exp_first_login'], 
			'exp_year' => $EXCMS_MODULE['exp_first_login'],
			'exp_updatetime' => time()
		);
		$sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
		$GLOBALS['db']->query($sql);
		return $uid;
	}
	/**
	 * 根据会员ID删除会员经验
	 *
	 * @param string|integer|array $uid 会员ID
	 * @return boolean
	 */
	public function delete($uid){
		$uid = EXCMS::convertToIntArray($uid);
		if($uid === false){
			throw_exception('ASK_SCORE_LACK_USER_ID');
		}
		$num = count($uid);
		$where = $num > 1 ? "`uid` IN ('" . implode("', '", $uid) . "') LIMIT {$num}" : "`uid` = '" . $uid[0] . "'";
		$sql = "DELETE FROM `{$this->table}` WHERE {$where}";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * 获取会员经验列表
	 *
	 * @param array $paging 分页数组
	 * <ul>
	 * <li>integer $paging['limit'] 分页大小 default 0</li>
	 * <li>integer $paging['start'] 分页起始大小 default 0</li>
	 * <li>integer $paging['total'] 总数 default 0</li>
	 * <li>integer $paging['sort'] 排序字段</li>
	 * <li>integer $paging['dir'] 排序方式 ASC or DESC, </li>
	 * </ul>
	 * @return array Paging 数组
	 * <ul> 
	 * <li> $array['total'] 总数 </li>
	 * <li> $array['data'] 分页数据 </li>
	 * </ul>
	 */
	public function getPaging($paging = array()){
		if(!isset($paging['total'])){
			$sql = "SELECT COUNT(*) as `total` FROM `{$this->table}` ";
			$GLOBALS['db']->query($sql);
			$rs = $GLOBALS['db']->fetch();
			$total = $rs['total'];
		}else{
			$total = (int)$paging['total'];
		}
		if(!in_array($paging['sort'], 'exp', 'exp_week', 'exp_month', 'exp_year', 'exp_updatetime')) $paging['sort'] = 'exp';
		$orderby = "ORDER BY {$paging['sort']}";
		$start = (int)$paging['start'];
		$limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
		$limit = "LIMIT {$start}, {$limit}";
		$sql = "SELECT * FROM `{$this->table}` {$orderby} {$limit}";
		$GLOBALS['db']->query($sql);
		$rs = $GLOBALS['db']->fetchAll();
		if(is_array($rs) && count($rs) > 0){
			include_once LIB_MODULES_PATH . 'account/Account.class.php';
			$account = new Account();
			include_once ASK_LIB_PATH.'Actor.class.php';
			$actor = new Actor();
			foreach($rs as $key => $value){
				$account_array = $account->getById($value['uid']);
				$rs[$key]['username'] = $account_array['username'];
				$actor_array = $actor->getActorByScore($value['total']);
				$rs[$key]['actorname'] = $actor_array['name'];
			}
		}
		return array('total' => $total, 'data' => $rs);
	}
	/**
	 * 经验排行设置
	 *
	 * @param integer $uid		用户ID
	 * @param integer $field	字段
	 * @param integer $value	经验值
	 * @param boolean $type	true增加,false减少
	 * @return integer
	 */
	public function update($uid, $field, $value, $type = true){
		$rs = $this->getByUid($uid);
		if(!($rs['uid'] > 0)){
			$this->insert($uid);
		}
		$value = (int)$value;
		$time = time();
		$data = array();
		if($type){
			$data['exp'] = $rs['exp'] + $value;
			if(in_array($field, array('exp_operate', 'exp_question', 'exp_answer', 'exp_punish', 'exp_other'))){
				$data[$field] = $rs[$field] + $value;
			}
			$data['exp_week'] = (date('YW', $rs['exp_updatetime']) == date('YW', $time)) ? ($rs['exp_week'] + $value) : $value;
			$data['exp_month'] = (date('Ym', $rs['exp_updatetime']) == date('Ym', $time)) ? ($rs['exp_month'] + $value) : $value;
			$data['exp_year'] = (date('Y', $rs['exp_updatetime']) == date('Y', $time)) ? ($rs['exp_year'] + $value) : $value;
		}else{
			$data['exp'] = $rs['exp'] - $value;
			if(in_array($field, array('exp_operate', 'exp_question', 'exp_answer', 'exp_punish', 'exp_other'))){
				$data[$field] = $rs[$field] - $value;
			}
			$data['exp_week'] = (date('YW', $rs['exp_updatetime']) == date('YW', $time)) ? ($rs['exp_week'] - $value) : 0;
			$data['exp_month'] = (date('Ym', $rs['exp_updatetime']) == date('Ym', $time)) ? ($rs['exp_month'] - $value) : 0;
			$data['exp_year'] = (date('Y', $rs['exp_updatetime']) == date('Y', $time)) ? ($rs['exp_year'] - $value) : 0;
		}
		$set = array();
		foreach($data as $k => $v){
			$set[] = "`{$k}` = '{$v}'";
		}
		$set = implode(",", $set);
		$sql = "UPDATE `{$this->table}` SET {$set} WHERE `uid` = '{$uid}' LIMIT 1";
		$GLOBALS['db']->query($sql);
		return $data['exp'];
	}
	/**
	 * 每日第一次登陆增加2点经验值
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function dayLogin($uid){
		global $EXCMS_MODULE;
		return $this->update($uid, 'exp_operate', $EXCMS_MODULE['ask']['exp_day_login'], true);
	}
	/**
	 * 提交回答增加经验值
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function answer($uid){
		global $EXCMS_MODULE;
		return $this->update($uid, 'exp_answer', $EXCMS_MODULE['ask']['exp_answer'], true);
	}
	/**
	 * 采纳最佳答案
	 *
	 * @param integer $uid	用户ID
	 * @param integer $score 经验
	 * @return boolean
	 */
	public function answerAdopt($uid, $score){
		global $EXCMS_MODULE;
		$score = (int)$EXCMS_MODULE['ask']['exp_answer_adopt'] + (int)$score;
		return $this->update($uid, 'exp_answer', $score, true);
	}
	/**
	 * 推荐答案增加经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function answerRecommend($uid){
		global $EXCMS_MODULE;
		return $this->update($uid, 'exp_answer', $EXCMS_MODULE['ask']['exp_answer_recommend'], true);
	}
	/**
	 * 精彩回答增加经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function answerElite($uid){
		global $EXCMS_MODULE;
		return $this->update($uid, 'exp_answer', $EXCMS_MODULE['ask']['exp_answer_elite'], true);
	}
	/**
	 * 处理过期问题增加经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expiredDeal($uid){
		global $EXCMS_MODULE;
		return $this->update($uid, 'exp', $EXCMS_MODULE['ask']['exp_question_expired_deal'], true);
	}
	/**
	 * 投票增加经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function vote($uid){
		global $EXCMS_MODULE;
		return $this->update($uid, 'exp_other', $EXCMS_MODULE['ask']['exp_vote'], true);
	}
	/**
	 * 匿名提问扣经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function anonymousQuestion($uid){
		global $EXCMS_MODULE;
		return $this->update($uid, 'exp_question', $EXCMS_MODULE['ask']['exp_question_anonymous'], false);
	}
	/**
	 * 处罚提问上线后被删除扣经验
	 *
	 * @param integer $uid 用户ID
	 * @return boolean
	 */
	public function deleteQuestion($uid){
		global $EXCMS_MODULE;
		return $this->update($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_question_delete'], false);
	}
	/**
	 * 处罚回答上线后被删除扣经验
	 *
	 * @param integer $uid 用户ID
	 * @return boolean
	 */
	public function deleteAnswer($uid){
		global $EXCMS_MODULE;
		return $this->update($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_answer_delete'], false);
	}
	/**
	 * 处罚问题15天内不处理
	 *
	 * @param integer $uid 用户ID
	 * @param boolean $expired	过期是否返回经验
	 * @return boolean
	 */
	public function expiredQuestion($uid, $expired = true){
		global $EXCMS_MODULE;
		$expired_score = $checked ? $EXCMS_MODULE['ask']['exp_question_expired'] : 0 - $EXCMS_MODULE['ask']['exp_question_expired'];
		return $this->update($uid, 'exp_punish', $expired_score, $expired);
	}
	/**
	 * 提问审核通过与不通过
	 *
	 * @param integer $uid	用户ID
	 * @param boolean $checked	是否增加经验
	 * @return boolean
	 */
	public function checkQuestion($uid, $checked = true){
		global $EXCMS_MODULE;
		$check_score = $checked ? $EXCMS_MODULE['ask']['exp_question_uncheck'] : 0 - $EXCMS_MODULE['ask']['exp_question_uncheck'];
		return $this->update($uid, 'exp_punish', $check_score, $checked);
	}
	/**
	 * 回答审核通过与不通过加
	 *
	 * @param integer $uid	用户ID
	 * @param boolean $checked	是否增加经验
	 * @return boolean
	 */
	public function checkAnswer($uid, $checked = true){
		global $EXCMS_MODULE;
		$check_score = $checked ? $EXCMS_MODULE['ask']['exp_answer_uncheck'] : 0 - $EXCMS_MODULE['ask']['exp_answer_uncheck'];
		return $this->update($uid, 'exp_punish', $check_score, $checked);
	}
	/**
	 * 删除最佳答案，回答者和提问者扣经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function deleteBestAnswer($uid){
		global $EXCMS_MODULE;
		return $this->update($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_answer_best_delete'], false);
	}
}

// excms file end