 <?php
	/**
	 * Project:		EXCMS: the PHP content management system.
	 * File:		AskQuestionList.class.php
	 *
	 * A product of PUTOYO Inc.
	 * 
	 * EXCMS is a ten million data-level,high speed,human-based content management system.
	 *
	 * EX is Excellence & Express & Exceed & Expert.
	 * 
	 * For questions, help, comments, discussion, please join the
	 * EXCMS mailing list. Send a blank e-mail to
	 * join@excms.cn
	 * or join the EXCMS forum
	 * www.excms.cn/forum
	 * 
	 * @link http://www.excms.cn/
	 * @copyright Copyright (c) 2010 PUTOYO Inc.
	 * @license http://www.excms.cn/licenses/LICENSE-1.0
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 * @version $Rev: 2220 $
	 */
	/* $Id: AskQuestionList.class.php 2220 2010-08-13 08:22:17Z zhanghaisong $ */
	/**
	 * EXCMS 问题列表标签类
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 */
	class AskQuestionList{
		/**
		 * 问题分类
		 *
		 * @var integer
		 */
		private $cid;
		/**
		 * 问题类型
		 *
		 * @var string
		 */
		private $type;
		/**
		 * 是否是精彩问题
		 *
		 * @var boolean
		 */
		private $elite;
		/**
		 * pending:待解决问题、solved:已解问题等expired:过期问题vote投票中问题close关闭offer高悬赏urgent:紧急hot热门问题elite精彩问题myhelp我的求助zero零回答
		 *
		 * @var integer
		 */
		private $status = array('pending', 'solved', 'offer', 'urgent', 'hot', 'elite', 'expired', 'vote', 'close', 'myhelp', 'zero');
		/**
		 * 关键字 多个关键字用","分
		 *
		 * @var string
		 */
		private $keyword;
		/**
		 * 是否为匿名提问
		 *
		 * @var boolean
		 */
		private $anonymous;
		/**
		 * 是否为紧急问题
		 *
		 * @var boolean
		 */
		private $urgent;
		/**
		 * 排序字段
		 *
		 * @var string
		 */
		private $orderby;
		/**
		 * 排序方式
		 *
		 * @var string
		 */
		private $orderway;
		/**
		 * 显示行数
		 *
		 * @var integer
		 */
		private $row;
		/**
		 * 分页
		 * 
		 * @var string
		 */
		private $limit;
		/**
		 * 分页大小
		 *
		 * @var integer
		 */
		private $pagesize;
		/**
		 * 当前页
		 *
		 * @var integer
		 */
		private $pageon = 1;
		/**
		 * 用户ID
		 *
		 * @var integer
		 */
		private $uid;
		/**
		 * 求助用户ID
		 *
		 * @var integer
		 */
		private $quid;
		/**
		 * 求助类型
		 *
		 * @var boolean
		 */
		private $qstatus;
		/**
		 * 审核状态
		 *
		 * @var 
		 */
		private $checked;
		/**
		 * 条件
		 *
		 * @var array
		 */
		private $where = array();
		public function setCid($cid){
			$this->cid = $cid;
		}
		public function setElite($elite){
			$this->elite = $elite ? true : false;
		}
		public function setKeyword($keyword){
			$this->keyword = $keyword;
		}
		public function setAnonymous($anonymous){
			$this->anonymous = $anonymous;
		}
		public function setUrgent($urgent){
			$this->urgent = $urgent;
		}
		public function setOrderby($orderby){
			$this->orderby = $orderby;
		}
		public function setOrderway($orderway){
			$this->orderway = $orderway;
		}
		public function setLimit($limit){
			$this->limit = $limit;
		}
		public function setRow($row){
			$this->row = $row;
		}
		public function setPagesize($pagesize){
			$this->pagesize = $pagesize;
		}
		public function setUid($uid){
			$this->uid = (int)$uid;
		}
		public function setType($type){
			$this->type = $type;
		}
		public function setChecked($checked){
			$this->checked = $checked;
		}
		public function setQuid($quid){
			$this->quid = $quid;
		}
		public function setQstatus($qstatus){
			$this->qstatus = $qstatus;
		}
		public function setWord($word = ''){
			$word = trim($word);
			$this->word = $word ? $word : false;
		}
		/**
		 * 获取分类ID
		 *
		 * @return integer
		 */
		public function getCid(){
			$cid = EXCMS::convertToIntArray($this->cid);
			if(is_array($cid)){
				$count = count($cid);
				if($count > 1){
					$cidstr = implode("','", $cid);
					$this->where['cid'] = "AND `cid` IN('{$cidstr}')";
				}elseif($count == 1){
					$this->where['cid'] = "AND `cid` = '{$cid[0]}'";
				}
			}
			return $this->cid;
		}
		/**
		 * 是否是精彩问题
		 *
		 * @return boolean
		 */
		public function getElite(){
			if($this->elite){
				$this->where['elite'] = "AND `elite` = '1' ";
			}
			return $this->elite;
		}
		/**
		 * 获取是否为匿名提问
		 *
		 * @return boolean
		 */
		public function getAnonymous(){
			if(isset($this->anonymous) && $this->anonymous !== ''){
				if(empty($this->anonymous)){
					$this->where['anonymous'] = "AND `anonymous` = '0' ";
				}else{
					$this->where['anonymous'] = "AND `anonymous` = '1' ";
				}
			}
			return $this->anonymous;
		}
		/**
		 * 获取是否为紧急问题
		 *
		 * @return boolean
		 */
		public function getUrgent(){
			if(isset($this->urgent) && $this->urgent !== ''){
				if(empty($this->urgent)){
					$this->where['urgent'] = "AND `urgent` = '0' ";
				}else{
					$this->where['urgent'] = "AND `urgent` = '1' ";
				}
			}
			return $this->urgent;
		}
		/**
		 * 获取关键字
		 *
		 * @return string
		 */
		public function getKeyword(){
			if($this->keyword){
				$this->where['keyword'] = " AND title like '%{$this->keyword}%' ";
			}
			return $this->keyword;
		}
		/**
		 * 获取分页
		 *
		 */
		public function getLimit(){
			if(isset($this->limit) && !empty($this->limit)){
				$this->limit = explode(',', trim($this->limit));
				$this->limit[0] = (int)$this->limit[0];
				$this->limit[1] = isset($this->limit[1]) && (int)$this->limit[1] ? (int)$this->limit[1] : $this->row;
				$this->limit = "limit " . $this->limit[0] . "," . $this->limit[1];
			}else if(isset($this->row) && !empty($this->row)){
				$this->limit = "limit " . $this->row;
			}else{
				$this->limit = "limit " . $this->getPagesize() * ($this->pageon - 1) . "," . $this->getPagesize();
			}
			return $this->limit;
		}
		/**
		 * 获取内容分页大小 默认为10
		 *
		 * @return integer
		 */
		public function getPagesize(){
			if($this->pagesize == "" || $this->pagesize <= 0 || $this->pagesize == null) return 10;
			return $this->pagesize;
		}
		public function getUid(){
			if($this->uid > 0){
				$this->where['uid'] = " AND `uid` = '{$this->uid}' ";
			}
			return $this->uid;
		}
		/**
		 * 获取类型
		 *
		 * @return string
		 */
		public function getType(){
			$types = explode(',', $this->type);
			foreach($types as $value){
				if(in_array($value, $this->status)){
					switch($value){
						//已解决
						case 'solved' :
							$this->where['status'] = "AND `status` =  '3' ";
							break;
						//高悬赏
						case 'offer' :
							$this->where['score'] = "AND `score` > '0' ";
							$this->setOrderby('score');
							$this->setOrderway('desc');
							break;
						//紧急
						case 'urgent' :
							$this->setUrgent(true);
							break;
						//热门
						case 'hot' :
							$this->setOrderby('hot');
							$this->setOrderway('desc');
							break;
						//精彩
						case 'elite' :
							$this->setElite(true);
							break;
						//已过期
						case 'expired' :
							$this->where['status'] = "AND `status` =  '4' ";
							break;
						//投票
						case 'vote' :
							$this->where['status'] = "AND `status` =  '5' ";
							break;
						//零回答
						case 'zero' :
							$this->where['zero'] = " AND `answernumber` = '0' ";
							break;
						//关闭
						case 'close' :
							$this->where['status'] = "AND `status` =  '6' ";
							break;
						case 'myhelp' :
							$this->where['myhelp'] = $this->getMyHelp($this->getUid());
							break;
						//待解决
						case 'pending' :
						default :
							$this->where['status'] = "AND `status` =  '2' ";
							break;
					}
				}
			}
		}
		/**
		 * 获取我的求助问题
		 *
		 * @param integer $uid	用户ID
		 * @return string
		 */
		private function getMyHelp($uid){
			$sql = "SELECT `qid` FROM `" . TABLE_PREFIX . "ask_from_uid` WHERE `uid` = '{$uid}' ";
			$GLOBALS['db']->query($sql);
			$quid_array = $GLOBALS['db']->fetchAll();
			if(is_array($quid_array) && count($quid_array) > 0){
				foreach($quid_array as $value){
					$qids .= $value['qid'] . ',';
				}
				return " AND `qid` IN('" . substr($qids, 0, strlen($qids) - 1) . "')";
			}else
				return " AND `qid` = '' ";
		}
		/**
		 * 获取我收到回答的问题状态
		 *
		 * @return string
		 */
		public function getQstatus(){
			$quid = $this->getQuid();
			if($quid > 0){
				$sql = "SELECT `qid` FROM `" . TABLE_PREFIX . "ask_from_uid` WHERE `fromuid` = '{$quid}' ";
			}
			if(in_array($this->qstatus, array('pending', 'solved', 'noanswer'))){
				switch($this->qstatus){
					case 'pending' :
						$status = 0;
						break;
					case 'solved' :
						$status = 1;
						break;
					case 'noanswer' :
						$status = 2;
						break;
				}
				$sql = "SELECT `qid` FROM `" . TABLE_PREFIX . "ask_from_uid` WHERE `fromuid` = '{$quid}' AND `status` = '{$status}' ";
			}
			if($sql != ''){
				$GLOBALS['db']->query($sql);
				$quid_array = $GLOBALS['db']->fetchAll();
				if(is_array($quid_array) && count($quid_array) > 0){
					foreach($quid_array as $value){
						$qids .= $value['qid'] . "','";
					}
					$this->where['qstatus'] = " AND `qid` IN('" . substr($qids, 0, strlen($qids) - 3) . "')";
				}else
					$this->where['qstatus'] = " AND `qid` = '' ";
			}
			return $this->qstatus;
		}
		/**
		 * 获取排序
		 *
		 * @return string
		 */
		public function getOrderBy(){
			$orderbyArr = explode(',', trim($this->orderby));
			$orderwayArr = explode(',', trim($this->orderway));
			$order = ' order by ';
			$seprator = ' ';
			foreach($orderbyArr as $k => $v){
				switch($v){
					//悬赏分 
					case 'score' :
						$order .= $seprator . ((isset($orderwayArr[$k]) && $orderwayArr[$k] == "asc") ? "score asc" : "score desc");
						break;
					//人气
					case 'hot' :
						$order .= $seprator . ((isset($orderwayArr[$k]) && $orderwayArr[$k] == "asc") ? "hot asc" : "hot desc");
						break;
					//创建时间
					case 'createdate' :
						$order .= $seprator . ((isset($orderwayArr[$k]) && $orderwayArr[$k] == "asc") ? "createdate asc" : "createdate desc");
						break;
					//回答数排序
					case 'answernumber' :
						$order .= $seprator . ((isset($orderwayArr[$k]) && $orderwayArr[$k] == "asc") ? "answernumber asc" : "answernumber desc");
						break;
					default :
						$order .= " createdate desc";
				}
				$seprator = ",";
			}
			return $order;
		}
		/**
		 * 获取审核状态
		 *
		 * @return string
		 */
		public function getChecked(){
			if(isset($this->checked) && $this->checked !== ''){
				if(empty($this->checked)){
					$this->where['checked'] = " AND `checked` = '0'";
				}else{
					$this->where['checked'] = " AND `checked` = '1'";
				}
			}else{
				$this->where['checked'] = " AND `checked` = '2'";
			}
			return $this->checked;
		}
		/**
		 * 获取求助ID
		 *
		 * @return integer
		 */
		public function getQuid(){
			return (int)$this->quid;
		}
		public function getWord(){
			if($this->word !== false) $this->where['word'] = " AND `title` LIKE '%" . $this->word . "%'";
		}
		/**
		 * 获取查询条件
		 *
		 * @return string
		 */
		private function getWhere(){
			$this->getQstatus();
			$this->getCid();
			$this->getKeyword();
			$this->getAnonymous();
			$this->getUid();
			$this->getType();
			$this->getUrgent();
			$this->getElite();
			$this->getChecked();
			$this->getWord();
			return join(' ', $this->where);
		}
		/**
		 * 获取问题列表
		 *
		 * @param array $array	字段属性
		 * <ul>
		 * <li>$array['cid'] 问题分类</li>
		 * <li>$array['keyword'] 关键字 多个关键字用","分</li>
		 * <li>$array['anonymous'] 是否为匿名提问</li>
		 * <li>$array['urgent'] 是否为紧急问题</li>
		 * <li>$array['elite'] 是否是精彩问题 </li>
		 * <li>$array['orderby'] 排序字段</li>
		 * <li>$array['orderway'] 排序方式</li>
		 * <li>$array['row'] 显示数量 </li>
		 * <li>$array['limit'] 获取范围内的记录 </li>
		 * <li>$array['pagesize'] 分页大小 </li>
		 * </ul> 
		 * @return array	问题列表数据
		 * <ul> 
		 * <li> $array['from'] 问题列表数据 </li>
		 * <li> $array['item'] 总数 </li>
		 * <li> $array['pager'] 分页数据 </li>
		 */
		public function getAskQuestionList($array){
			global $_PAGE, $_QUESTION_STATUS_TEXT;
			//设置参数
			$this->setCid($array['cid']);
			$this->setKeyword($array['keyword']);
			$this->setAnonymous($array['anonymous']);
			$this->setUrgent($array['urgent']);
			$this->setElite($array['elite']);
			$this->setUid($array['uid']);
			$this->setQuid($array['quid']);
			$this->setQstatus($array['qstatus']);
			$this->setType($array['type']);
			$this->setOrderby($array['orderby']);
			$this->setOrderway($array['orderway']);
			$this->setRow($array['row']);
			$this->setChecked($array['checked']);
			$this->setLimit($array['limit']);
			$this->setPagesize($array['pagesize']);
			$this->setWord($array['word']);
			$fields = explode(',', $array['fields']);
			$stat = empty($array['limit']) && empty($array['row']);
			unset($array);
			//初始化变量
			$this->pageon = max($_PAGE['page'], 1);
			//统计总数
			$wherestr = $this->getWhere();
			if($stat){
				$sql = "SELECT COUNT(*) as total FROM " . TABLE_PREFIX . "ask_questions WHERE 1 {$wherestr} ";
				$GLOBALS['db']->query($sql);
				$total = $GLOBALS['db']->fetch();
				$total = $total['total'];
			}
			//查询数据
			if($total > 0 || !$stat){
				$table = TABLE_PREFIX . 'ask_questions';
				$sql = "SELECT * FROM `{$table}` WHERE 1 {$wherestr} {$this->getOrderBy()} {$this->getLimit()}";
				$GLOBALS['db']->query($sql);
				$ask_array = $GLOBALS['db']->fetchAll();
			}else{
				return null;
			}
			if(is_array($ask_array) && count($ask_array) > 0){
				include_once LIB_PATH . 'update/ContentFunction.class.php';
				if(in_array('category', $fields)){
					include_once ASK_LIB_PATH . 'AskCategory.class.php';
					$ask_cate = new AskCategory();
					$category_array = $ask_cate->getCateCache();
					unset($ask_cate);
				}
				if(in_array('user', $fields)){
					include_once LIB_MODULES_PATH . 'account/Account.class.php';
					$account = new Account();
				}
				if(in_array('useraccount', $fields)){
					include_once ASK_LIB_PATH.'AskAccount.class.php';
					$askaccount = new AskAccount();
				}
				if(in_array('useractor', $fields) || in_array('userscore', $fields) || in_array('userexp', $fields)){
					include_once ASK_LIB_PATH.'AskScore.class.php';
					$score = new AskScore();
					if(in_array('useractor', $fields)){
						include_once ASK_LIB_PATH.'Actor.class.php';
						$actor = new Actor();
					}
				}
				foreach($ask_array as $key => $value){
					$ask_array[$key]['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $value['qid']));
					if(in_array('category', $fields) && $value['cid'] > 0){
						$ask_array[$key]['category'] = $category_array[$value['cid']];
					}
					$ask_array[$key]['statusname'] = $_QUESTION_STATUS_TEXT[$value['status']];
					$ask_array[$key]['asktime'] = timeformat($value['createdate'], 'n月j日 H:i');
					if($value['uid'] > 0){
						if(in_array('useractor', $fields) || in_array('userexp', $fields)){
							$ask_array[$key]['userexp'] = $score->getExpByUid($value['uid']);
							if(in_array('useractor', $fields)){
								$ask_array[$key]['useractor'] = $actor->getActorByScore($ask_array[$key]['userexp']['exp']);
							}
						}
						if(in_array('userscore', $fields)){
							$ask_array[$key]['userscore'] = $score->getScoreByUid($value['uid']);
						}
						if(in_array('useraccount', $fields)){
							$ask_array[$key]['useraccount'] = $askaccount->getByUid($value['uid']);
						}
					}
					if(in_array('user', $fields) && $value['uid'] > 0 && !$value['anonymous']){
						$ask_array[$key]['user'] = $account->getById($value['uid']);
					}else{
						$ask_array[$key]['user'] = array('username' => '匿名');
					}
				}
				$result = array('from' => &$ask_array, 'item' => array('total' => $total), 'pager' => array('total' => $total, 'pagesize' => $this->getPagesize(), 'dynamic' => true, 'pageon' => $_PAGE['page'], 'encodepage' => 'nocode'));
			}else{
				$result = null;
			}
			return $result;
		}
	}

// excms file end