<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskScore.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 * @version $Rev: 2201 $
 */
/* $Id: AskScore.class.php 2201 2010-08-11 15:09:16Z zhangxuelin $ */
/**
 * EXCMS 用户积分管理
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 */
class AskScore{
	/**
	 * 会员积分表
	 *
	 * @access private
	 * @var string
	 */
	private $table = 'ask_score';
	/**
	 * 会员经验值
	 *
	 * @access private
	 * @var string
	 */
	private $table_exp = 'ask_exp';
	/**
	 * 构造函数
	 *
	 */
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
		$this->table_exp = TABLE_PREFIX . $this->table_exp;
	}
	/**
	 * 兼容PHP4构造函数
	 *
	 */
	function AskScore(){
		$this->__construct();
	}
	/**
	 * 检查登陆
	 *
	 */
	public function checkLogin(){
		$score_array = $this->getScoreByUid(EXCMS_SESSION_UID);
		if(is_array($score_array) && count($score_array) > 0){
			if(date('Ymd', $score_array['score_updatetime']) != date('Ymd', time())){ //今日
				$this->scoreDayLogin(EXCMS_SESSION_UID); //每日第一次登陆
			}
		}else{
			$this->insertScore(EXCMS_SESSION_UID);
		}
		$exp_array = $this->getExpByUid(EXCMS_SESSION_UID);
		if(is_array($exp_array) && count($exp_array) > 0){
			if(date('Ymd', $exp_array['exp_updatetime']) != date('Ymd', time())){ //每日第一次登陆
				$this->expDayLogin(EXCMS_SESSION_UID);
			}
		}else{
			$this->insertExp(EXCMS_SESSION_UID);
		}
	}
	/**
	 * 根据会员ID获取分员积分
	 *
	 * @param integer $uid	会员ID
	 * @return array	积分详细信息
	 */
	public function getScoreByUid($uid){
		if(!($uid > 0)){
			throw_exception('LACK_PARAM_UID');
		}
		$sql = "SELECT * FROM `{$this->table}` WHERE `uid` = '{$uid}' LIMIT 1";
		$GLOBALS['db']->query($sql);
		return $GLOBALS['db']->fetch();
		//return count($rs) ? $rs : array('score' => 0, 'score_operate' => 0, 'score_answer' => 0, 'score_question' => 0, 'score_punish' => 0);
	}
	/**
	 * 添加会员积分数据 
	 *
	 * @param integer $uid	会员ID
	 * @return integer 会员ID
	 */
	public function insertScore($uid){
		if((int)$uid < 1){
			throw_exception('LACK_PARAM_UID');
		}
		global $EXCMS_MODULE;
		$data = array(
			'uid' => $uid,
			'score' => $EXCMS_MODULE['score_first_login'],
			'score_operate' => $EXCMS_MODULE['score_first_login'],
			'score_answer' => 0,
			'score_question' => 0,
			'score_punish' => 0,
			'score_other' => 0,
			'score_question_day' => 0,
			'score_answer_day' => 0, 
			'score_updatetime' => time()
		);
		$sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
		$GLOBALS['db']->query($sql);
		return $uid;
	}
	/**
	 * 更新指定字段数据
	 *
	 * @param integer $uid	会员ID
	 * @param string $field	字段名称
	 * @param string $value	字段值
	 * @param boolean $add	增加
	 * @return boolean
	 */
	private function updateScore($uid, $field, $value, $add = true){
		$score_array = $this->getScoreByUid($uid);
		if(!is_array($score_array) || count($score_array) < 1){
			$this->insertScore($uid);
			$this->insertExp($uid);
		}
		$data = array();
		$value = (int)$value;
		if(!($value > 0)) return true;
		if($field == 'score_answer_day'){
			if(date('Ymd', $score_array['score_updatetime']) == date('Ymd', time())){ //今日
				global $EXCMS_MODULE;
				//当今日所得积分大于最大今日积分数
				if((int)$score_array['score_answer_day'] >= (int)$EXCMS_MODULE['ask']['score_answer_day_max']){
					$value = 0;
				}else{
					$data['score_answer_day'] = (int)$score_array['score_answer_day'] + $value;
				}
			}else{ //昨日
				$data['score_answer_day'] = 0;
			}
			$field = 'score_answer';
		}else if($field == 'score_question_day'){
			if(date('Ymd', $score_array['score_updatetime']) == date('Ymd', time())){ //今日
				global $EXCMS_MODULE;
				//当今日所得积分大于最大今日积分数
				if((int)$score_array['score_question_day'] >= (int)$EXCMS_MODULE['ask']['score_question_day_max']){
					$value = 0;
				}else{
					$data['score_question_day'] = (int)$score_array['score_question_day'] + $value;
				}
			}else{ //昨日
				$data['score_question_day'] = 0;
			}
			$field = 'score_question';
		}else if($field == 'score_vote_day'){ //投票
			if(date('Ymd', $score_array['score_updatetime']) == date('Ymd', time())){ //今日
				global $EXCMS_MODULE;
				//当今日所得积分大于最大今日积分数
				if((int)$score_array['score_vote_day'] >= (int)$EXCMS_MODULE['ask']['score_vote_day_max']){
					$value = 0;
				}else{
					$data['score_vote_day'] = (int)$score_array['score_vote_day'] + $value;
				}
			}else{ //昨日
				$data['score_vote_day'] = 0;
			}
			$field = 'score_other';
		}
		if($add){
			if(in_array($field, array('score_operate', 'score_answer', 'score_other'))){
				$data[$field] = (int)$score_array[$field] + $value;
			}else if(in_array($field, array('score_question', 'score_punish'))){
				$data[$field] = (int)$score_array[$field] - $value;
			}
		}else{
			if(in_array($field, array('score_operate', 'score_answer', 'score_other'))){
				$data[$field] = (int)$score_array[$field] - $value;
			}else if(in_array($field, array('score_question', 'score_punish'))){
				$data[$field] = (int)$score_array[$field] + $value;
			}
		}
		if($add){
			$data['score'] = (int)$score_array['score'] + $value;
		}else{
			$data['score'] = (int)$score_array['score'] - $value;
		}
		$data['score_updatetime'] = time();
		$set = array();
		foreach($data as $k => $v){
			$set[] = "`{$k}` = '{$v}'";
		}
		$set = implode(",", $set);
		$sql = "UPDATE `{$this->table}` SET {$set} WHERE `uid` = '{$uid}' LIMIT 1";
		return $GLOBALS['db']->query($sql);
		return true;
	}
	/**
	 * 每日第一次登陆增加积分
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function scoreDayLogin($uid){
		global $EXCMS_MODULE;
		return $this->updateScore($uid, 'score_operate', $EXCMS_MODULE['ask']['score_day_login'], true);
	}
	/**
	 * 提交回答增加积分
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function scoreAnswer($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_answer_day', $EXCMS_MODULE['ask']['score_answer'], true);
		return $this->expAnswer($uid);
	}
	/**
	 * 采纳答案增加提问者积分
	 *
	 * @param integer $uid	用户ID
	 * @param integer $cent	积分
	 * @return boolean
	 */
	public function scoreAnswerAdopt($uid, $cent){
		global $EXCMS_MODULE;
		$score = (int)$EXCMS_MODULE['ask']['score_answer_adopt'] + (int)$cent;
		$this->updateScore($uid, 'score_answer', $score, true);
		return $this->expAnswerAdopt($uid, $cent);
	}
	/**
	 * 推荐答案增加积分
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function scoreAnswerRecommend($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_answer', $EXCMS_MODULE['ask']['score_answer_recommend'], true);
		return $this->expAnswerRecommend($uid);
	}
	/**
	 * 精彩回答
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function scoreAnswerElite($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_answer', $EXCMS_MODULE['ask']['score_answer_elite'], true);
		return $this->expAnswerElite($uid);
	}
	/**
	 * 精彩提问
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function scoreQuestionElite($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_answer', $EXCMS_MODULE['ask']['score_question_elite'], true);
		return $this->expQuestionElite($uid);
	}
	/**
	 * 处理过期问题
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function scoreExpiredDeal($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_punish', $EXCMS_MODULE['ask']['score_question_expired_deal'], true);
		return $this->expExpiredDeal($uid);
	}
	/**
	 * 过期问题转入投票
	 *
	 * @param integer $uid
	 * @return boolean
	 */
	public function scoreExpiredToVote($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_punish', $EXCMS_MODULE['ask']['score_expired_to_vote'], false);
		return $this->expExpiredToVote($uid);
	}
	/**
	 * 投票增加积分
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function scoreVote($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_vote_day', $EXCMS_MODULE['ask']['score_vote'], true);
		return $this->expVote($uid);
	}
	/**
	 * 悬赏付出
	 *
	 * @param integer $uid	用户ID
	 * @param integer $cent	悬赏分
	 */
	public function scoreCentQuestion($uid, $cent){
		global $EXCMS_MODULE;
		return $this->updateScore($uid, 'score_question', $cent, false);
	}
	/**
	 * 匿名提问扣积分
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function scoreAnonymousQuestion($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_question', $EXCMS_MODULE['ask']['score_question_anonymous'], false);
		return $this->expAnonymousQuestion($uid);
	}
	/**
	 * 直接向某人提问按人次扣积分
	 *
	 * @param integer $uid	用户ID
	 * @param integer	$number	人数
	 * @return boolean
	 */
	public function scoreQuestionDirect($uid, $number){
		global $EXCMS_MODULE;
		$score = (int)$EXCMS_MODULE['ask']['score_question_direct'] * (int)$number;
		$this->updateScore($uid, 'score_question', $score, false);
		return $this->expQuestionDirect($uid, $number);
	}
	/**
	 * 紧急问题扣提问者积分
	 *
	 * @param integer $uid
	 * @return boolean
	 */
	public function scoreQuestoinUgrent($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_question', $EXCMS_MODULE['ask']['score_questoin_ugrent'], false);
		return $this->expQuestoinUgrent($uid);
	}
	/**
	 * 提问获取积分
	 *
	 * @param integer $uid
	 * @return boolean
	 */
	public function scoreQuestoin($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_question_day', $EXCMS_MODULE['ask']['score_question'], true);
		return $this->expQuestoin($uid);
	}
	/**
	 * 处罚提问上线后被删除
	 *
	 * @param integer $uid 用户ID
	 * @return boolean
	 */
	public function scoreDeleteQuestion($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_punish', $EXCMS_MODULE['ask']['score_question_delete'], false);
		return $this->expDeleteQuestion($uid);
	}
	/**
	 * 处罚回答上线后被删除
	 *
	 * @param integer $uid 用户ID
	 * @return boolean
	 */
	public function scoreDeleteAnswer($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_punish', $EXCMS_MODULE['ask']['score_answer_delete'], false);
		return $this->expDeleteAnswer($uid);
	}
	/**
	 * 处罚问题15天内不处理
	 *
	 * @param integer $uid 用户ID
	 * @param boolean $expired	过期是否返回积分
	 * @return boolean
	 */
	public function scoreExpiredQuestion($uid, $expired = true){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_punish', $EXCMS_MODULE['ask']['score_question_expired'], $expired);
		return $this->expExpiredQuestion($uid, $expired);
	}
	/**
	 * 提问审核通过与不通过加
	 *
	 * @param integer $uid	用户ID
	 * @param boolean $checked	是否增加积分
	 * @return boolean
	 */
	public function scoreCheckQuestion($uid, $checked = true){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_punish', $EXCMS_MODULE['ask']['score_question_uncheck'], $checked);
		return $this->expCheckQuestion($uid, $checked);
	}
	/**
	 * 回答审核通过与不通过加
	 *
	 * @param integer $uid	用户ID
	 * @param boolean $checked	是否增加积分
	 * @return boolean
	 */
	public function scoreCheckAnswer($uid, $checked = true){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_punish', $EXCMS_MODULE['ask']['score_answer_uncheck'], $checked);
		return $this->expCheckAnswer($uid, $checked);
	}
	/**
	 * 删除最佳答案，回答者和提问者扣分
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function scoreDeleteBestAnswer($uid){
		global $EXCMS_MODULE;
		$this->updateScore($uid, 'score_punish', $EXCMS_MODULE['ask']['score_answer_best_delete'], false);
		return $this->expDeleteBestAnswer($uid);
	}
	/**
	 * 根据会员ID删除会员积分
	 *
	 * @param string|integer|array $uid 会员ID
	 * @return boolean
	 */
	public function deleteScore($uid){
		$uid = EXCMS::convertToIntArray($uid);
		if($uid === false){
			throw_exception('LACK_PARAM_UID');
		}
		$num = count($uid);
		$where = $num > 1 ? "`uid` IN ('" . implode("', '", $uid) . "') LIMIT {$num}" : "`uid` = '" . $uid[0] . "'";
		$sql = "DELETE FROM `{$this->table}` WHERE {$where}";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * 获取会员积分列表
	 *
	 * @param array $paging 分页数组
	 * <ul>
	 * <li>integer $paging['limit'] 分页大小 default 0</li>
	 * <li>integer $paging['start'] 分页起始大小 default 0</li>
	 * <li>integer $paging['total'] 总数 default 0</li>
	 * <li>integer $paging['sort'] 排序字段</li>
	 * <li>integer $paging['dir'] 排序方式 ASC or DESC, </li>
	 * </ul>
	 * @return array Paging 数组
	 * <ul> 
	 * <li> $array['total'] 总数 </li>
	 * <li> $array['data'] 分页数据 </li>
	 * </ul>
	 */
	public function getPagingScore($paging = array()){
		if($paging['keywords'] != ''){
			include_once LIB_MODULES_PATH . 'account/Account.class.php';
			$account = new Account();
			$account_array = $account->getByName($paging['keywords']);
			$where = " AND `uid`='{$account_array['uid']}' ";
		}
		if(!isset($paging['total'])){
			$sql = "SELECT COUNT(*) as `total` FROM `{$this->table}` WHERE 1 {$where} ";
			$GLOBALS['db']->query($sql);
			$rs = $GLOBALS['db']->fetch();
			$total = $rs['total'];
		}else{
			$total = (int)$paging['total'];
		}
		if(!in_array($paging['sort'], array('score', 'score_operate', 'score_answer', 'score_question', 'score_punish', 'score_other'))) $paging['sort'] = 'score';
		$dir = strtoupper($paging['dir']) == "DESC" ? "DESC" : "ASC";
		$orderby = "ORDER BY {$paging['sort']} {$dir}";
		$start = (int)$paging['start'];
		$limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
		$limit = "LIMIT {$start}, {$limit}";
		$sql = "SELECT * FROM `{$this->table}` WHERE 1 {$where} {$orderby} {$limit}";
		$GLOBALS['db']->query($sql);
		$rs = $GLOBALS['db']->fetchAll();
		if(is_array($rs) && count($rs) > 0){
			include_once LIB_MODULES_PATH . 'account/Account.class.php';
			$account = new Account();
			include_once ASK_LIB_PATH.'Actor.class.php';
			$actor = new Actor();
			include_once ASK_LIB_PATH.'AskAccount.class.php';
			$askaccount = new AskAccount();
			foreach($rs as $key => $value){
				$account_array = $account->getById($value['uid']);
				$rs[$key]['username'] = $account_array['username'];
				$account_array = $askaccount->getByUid($value['uid']);
				if(count($account_array) == 0){
					$account_array = array('question' => 0, 'question_elite' => 0, 'answer' => 0, 'answer_best' => 0, 'answer_elite' => 0, 'adopt' => 0, 'favorable' => 0);
				}
				$rs[$key] = array_merge($rs[$key], $account_array);
			}
		}
		return array('total' => $total, 'data' => $rs);
	}
	/**
	 * 根据会员ID获取分员经验值
	 *
	 * @param integer $uid	会员ID
	 * @return array	用户经验值详细信息
	 */
	public function getExpByUid($uid){
		if(!($uid > 0)){
			throw_exception('LACK_PARAM_UID');
		}
		$sql = "SELECT * FROM `{$this->table_exp}` WHERE `uid` = '{$uid}' LIMIT 1";
		$GLOBALS['db']->query($sql);
		return $GLOBALS['db']->fetch();
	}
	/**
	 * 添加会员经验数据 
	 *
	 * @param integer $uid	会员ID
	 * @return integer 会员ID
	 */
	function insertExp($uid){
		if((int)$uid < 1){
			throw_exception('LACK_PARAM_UID');
		}
		global $EXCMS_MODULE;
		$data = array(
			'uid' => $uid,
			'exp' => $EXCMS_MODULE['exp_first_login'],
			'exp_operate' => 0,
			'exp_question' => 0,
			'exp_answer' => 0,
			'exp_punish' => 0,
			'exp_other' => 0,
			'exp_week' => $EXCMS_MODULE['exp_first_login'],
			'exp_month' => $EXCMS_MODULE['exp_first_login'], 
			'exp_year' => $EXCMS_MODULE['exp_first_login'],
			'exp_updatetime' => time()
		);
		$sql = "INSERT INTO `{$this->table_exp}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
		$GLOBALS['db']->query($sql);
		return $uid;
	}
	/**
	 * 根据会员ID删除会员经验
	 *
	 * @param string|integer|array $uid 会员ID
	 * @return boolean
	 */
	public function deleteExp($uid){
		$uid = EXCMS::convertToIntArray($uid);
		if($uid === false){
			throw_exception('ASK_SCORE_LACK_USER_ID');
		}
		$num = count($uid);
		$where = $num > 1 ? "`uid` IN ('" . implode("', '", $uid) . "') LIMIT {$num}" : "`uid` = '" . $uid[0] . "'";
		$sql = "DELETE FROM `{$this->table_exp}` WHERE {$where}";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * 获取会员经验列表
	 *
	 * @param array $paging 分页数组
	 * <ul>
	 * <li>integer $paging['limit'] 分页大小 default 0</li>
	 * <li>integer $paging['start'] 分页起始大小 default 0</li>
	 * <li>integer $paging['total'] 总数 default 0</li>
	 * <li>integer $paging['sort'] 排序字段</li>
	 * <li>integer $paging['dir'] 排序方式 ASC or DESC, </li>
	 * </ul>
	 * @return array Paging 数组
	 * <ul> 
	 * <li> $array['total'] 总数 </li>
	 * <li> $array['data'] 分页数据 </li>
	 * </ul>
	 */
	public function getPagingExp($paging = array()){
		$where = '';
		if($paging['keywords'] != ''){
			include_once LIB_MODULES_PATH . 'account/Account.class.php';
			$account = new Account();
			$account_array = $account->getByName($paging['keywords']);
			$where = " AND `uid`='{$account_array['uid']}' ";
		}
		if(!isset($paging['total'])){
			$sql = "SELECT COUNT(*) as `total` FROM `{$this->table_exp}`  WHERE 1 {$where}";
			$GLOBALS['db']->query($sql);
			$rs = $GLOBALS['db']->fetch();
			$total = $rs['total'];
		}else{
			$total = (int)$paging['total'];
		}
		if(!in_array($paging['sort'], 'exp', 'exp_week', 'exp_month', 'exp_year', 'exp_updatetime')) $paging['sort'] = 'exp';
		$orderby = "ORDER BY {$paging['sort']}";
		$start = (int)$paging['start'];
		$limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
		$limit = "LIMIT {$start}, {$limit}";
		$sql = "SELECT * FROM `{$this->table_exp}`  WHERE  1 {$where} {$orderby} {$limit}";
		$GLOBALS['db']->query($sql);
		$rs = $GLOBALS['db']->fetchAll();
		if(is_array($rs) && count($rs) > 0){
			include_once LIB_MODULES_PATH . 'account/Account.class.php';
			$account = new Account();
			include_once ASK_LIB_PATH.'Actor.class.php';
			$actor = new Actor();
			foreach($rs as $key => $value){
				$account_array = $account->getById($value['uid']);
				$rs[$key]['username'] = $account_array['username'];
				$actor_array = $actor->getActorByScore($value['exp']);
				$rs[$key]['actorname'] = $actor_array['name'];
			}
		}
		return array('total' => $total, 'data' => $rs);
	}
	/**
	 * 经验排行设置
	 *
	 * @param integer $uid		用户ID
	 * @param integer $field	字段
	 * @param integer $value	经验值
	 * @param boolean $type	true增加,false减少
	 * @return integer
	 */
	public function updateExp($uid, $field, $value, $type = true){
		$rs = $this->getExpByUid($uid);
		if(!($rs['uid'] > 0)){
			$this->insertExp($uid);
		}
		$value = (int)$value;
		if(!($value > 0)) return true;
		$time = time();
		$data = array();
		if($field == 'exp_answer_day'){
			if(date('Ymd', $rs['exp_updatetime']) == date('Ymd', time())){ //今日
				global $EXCMS_MODULE;
				//当今日所得积分大于最大今日积分数
				if((int)$rs['exp_answer_day'] >= (int)$EXCMS_MODULE['ask']['exp_answer_day_max']){
					$value = 0;
				}else{
					$data['exp_answer_day'] = (int)$rs['exp_answer_day'] + $value;
				}
			}else{ //昨日
				$data['exp_answer_day'] = 0;
			}
			$field = 'exp_answer';
		}else if($field == 'exp_question_day'){
			if(date('Ymd', $rs['exp_updatetime']) == date('Ymd', time())){ //今日
				global $EXCMS_MODULE;
				//当今日所得积分大于最大今日积分数
				if((int)$rs['exp_question_day'] >= (int)$EXCMS_MODULE['ask']['exp_question_day_max']){
					$value = 0;
				}else{
					$data['exp_question_day'] = (int)$rs['exp_question_day'] + $value;
				}
			}else{ //昨日
				$data['exp_question_day'] = 0;
			}
			$field = 'exp_question';
		}else if($field == 'exp_vote_day'){
			if(date('Ymd', $rs['exp_updatetime']) == date('Ymd', time())){ //今日
				global $EXCMS_MODULE;
				//当今日所得积分大于最大今日积分数
				if((int)$rs['exp_vote_day'] >= (int)$EXCMS_MODULE['ask']['exp_vote_day_max']){
					$value = 0;
				}else{
					$data['exp_vote_day'] = (int)$rs['exp_vote_day'] + $value;
				}
			}else{ //昨日
				$data['exp_vote_day'] = 0;
			}
			$field = 'exp_other';
		}
		if($type){
			$data['exp'] = $rs['exp'] + $value;
			if(in_array($field, array('exp_operate', 'exp_answer', 'exp_other'))){
				$data[$field] = $rs[$field] + $value;
			}else if(in_array($field, array('exp_question', 'exp_punish'))){
				$data[$field] = $rs[$field] - $value;
			}
			$data['exp_week'] = (date('YW', $rs['exp_updatetime']) == date('YW', $time)) ? ($rs['exp_week'] + $value) : $value;
			$data['exp_month'] = (date('Ym', $rs['exp_updatetime']) == date('Ym', $time)) ? ($rs['exp_month'] + $value) : $value;
			$data['exp_year'] = (date('Y', $rs['exp_updatetime']) == date('Y', $time)) ? ($rs['exp_year'] + $value) : $value;
		}else{
			$data['exp'] = $rs['exp'] - $value;
			if(in_array($field, array('exp_operate', 'exp_answer', 'exp_other'))){
				$data[$field] = $rs[$field] - $value;
			}else if(in_array($field, array('exp_question', 'exp_punish'))){
				$data[$field] = $rs[$field] + $value;
			}
			$data['exp_week'] = (date('YW', $rs['exp_updatetime']) == date('YW', $time)) ? ($rs['exp_week'] - $value) : 0;
			$data['exp_month'] = (date('Ym', $rs['exp_updatetime']) == date('Ym', $time)) ? ($rs['exp_month'] - $value) : 0;
			$data['exp_year'] = (date('Y', $rs['exp_updatetime']) == date('Y', $time)) ? ($rs['exp_year'] - $value) : 0;
		}
		$data['exp_updatetime'] = time();
		$set = array();
		foreach($data as $k => $v){
			$set[] = "`{$k}` = '{$v}'";
		}
		$set = implode(",", $set);
		$sql = "UPDATE `{$this->table_exp}` SET {$set} WHERE `uid` = '{$uid}' LIMIT 1";
		$GLOBALS['db']->query($sql);
		//更新头街
		include_once ASK_LIB_PATH.'AskAccount.class.php';
		$account = new AskAccount();
		$account->updateLevel($uid, $data['exp']);
		return $data['exp'];
	}
	/**
	 * 每日第一次登陆增加2点经验值
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expDayLogin($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_operate', $EXCMS_MODULE['ask']['exp_day_login'], true);
	}
	/**
	 * 提交回答增加经验值
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expAnswer($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_answer_day', $EXCMS_MODULE['ask']['exp_answer'], true);
	}
	/**
	 * 采纳最佳答案
	 *
	 * @param integer $uid	用户ID
	 * @param integer $cent 经验
	 * @return boolean
	 */
	public function expAnswerAdopt($uid, $cent){
		global $EXCMS_MODULE;
		$score = (int)$EXCMS_MODULE['ask']['exp_answer_adopt'] + (int)$cent;
		return $this->updateExp($uid, 'exp_answer', $score, true);
	}
	/**
	 * 推荐答案增加经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expAnswerRecommend($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_answer', $EXCMS_MODULE['ask']['exp_answer_recommend'], true);
	}
	/**
	 * 精彩回答增加经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expAnswerElite($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_answer', $EXCMS_MODULE['ask']['exp_answer_elite'], true);
	}
	/**
	 * 精彩提问增加经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expQuestionElite($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_answer', $EXCMS_MODULE['ask']['exp_question_elite'], true);
	}
	/**
	 * 处理过期问题增加经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expExpiredDeal($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_question_expired_deal'], true);
	}
	/**
	 * 问题转入投票时会扣分
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expExpiredToVote($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_expired_to_vote'], false);
	}
	/**
	 * 投票增加经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expVote($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_vote_day', $EXCMS_MODULE['ask']['exp_vote'], true);
	}
	/**
	 * 匿名提问扣经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expAnonymousQuestion($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_question', $EXCMS_MODULE['ask']['exp_question_anonymous'], false);
	}
	/**
	 * 直接向某人提问按人次扣经验
	 *
	 * @param integer $uid	用户ID
	 * @param integer $number	人数
	 * @return boolean
	 */
	public function expQuestionDirect($uid, $number){
		global $EXCMS_MODULE;
		$exp = (int)$EXCMS_MODULE['ask']['exp_question_direct'] * (int)$number;
		return $this->updateExp($uid, 'exp_question', $exp, false);
	}
	/**
	 * 紧急问题扣经验值
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expQuestoinUgrent($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_question', $EXCMS_MODULE['ask']['exp_questoin_ugrent'], false);
	}
	/**
	 * 提问获得经验值
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expQuestoin($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_question_day', $EXCMS_MODULE['ask']['exp_question'], true);
	}
	/**
	 * 处罚提问上线后被删除扣经验
	 *
	 * @param integer $uid 用户ID
	 * @return boolean
	 */
	public function expDeleteQuestion($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_question_delete'], false);
	}
	/**
	 * 处罚回答上线后被删除扣经验
	 *
	 * @param integer $uid 用户ID
	 * @return boolean
	 */
	public function expDeleteAnswer($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_answer_delete'], false);
	}
	/**
	 * 处罚问题15天内不处理
	 *
	 * @param integer $uid 用户ID
	 * @param boolean $expired	过期是否返回经验
	 * @return boolean
	 */
	public function expExpiredQuestion($uid, $expired = true){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_question_expired'], $expired);
	}
	/**
	 * 提问审核通过与不通过
	 *
	 * @param integer $uid	用户ID
	 * @param boolean $checked	是否增加经验
	 * @return boolean
	 */
	public function expCheckQuestion($uid, $checked = true){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_question_uncheck'], $checked);
	}
	/**
	 * 回答审核通过与不通过加
	 *
	 * @param integer $uid	用户ID
	 * @param boolean $checked	是否增加经验
	 * @return boolean
	 */
	public function expCheckAnswer($uid, $checked = true){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_answer_uncheck'], $checked);
	}
	/**
	 * 删除最佳答案，回答者和提问者扣经验
	 *
	 * @param integer $uid	用户ID
	 * @return boolean
	 */
	public function expDeleteBestAnswer($uid){
		global $EXCMS_MODULE;
		return $this->updateExp($uid, 'exp_punish', $EXCMS_MODULE['ask']['exp_answer_best_delete'], false);
	}
}
// excms file end