 <?php
	/**
	 * Project:		EXCMS: the PHP content management system.
	 * File:		AskSearch.class.php
	 *
	 * A product of PUTOYO Inc.
	 * 
	 * EXCMS is a ten million data-level,high speed,human-based content management system.
	 *
	 * EX is Excellence & Express & Exceed & Expert.
	 * 
	 * For questions, help, comments, discussion, please join the
	 * EXCMS mailing list. Send a blank e-mail to
	 * join@excms.cn
	 * or join the EXCMS forum
	 * www.excms.cn/forum
	 * 
	 * @link http://www.excms.cn/
	 * @copyright Copyright (c) 2010 PUTOYO Inc.
	 * @license http://www.excms.cn/licenses/LICENSE-1.0
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 * @version $Rev: 2220 $
	 */
	/* $Id: AskSearch.class.php 2220 2010-08-13 08:22:17Z zhanghaisong $ */
	/**
	 * EXCMS 问题搜索列表
	 * @category EXCMS
	 * @package ask
	 * @author $Author: zhanghaisong $
	 */
	class AskSearch{
		/**
		 * 问题分类
		 *
		 * @var integer
		 */
		private $cid;
		/**
		 * 分页大小
		 *
		 * @var integer
		 */
		private $pagesize;
		/**
		 * 当前页
		 *
		 * @var integer
		 */
		private $pageon;
		/**
		 * pending:待解决问题、solved:已解问题等expired:过期问题vote投票中问题close关闭offer高悬赏urgent:紧急hot热门问题elite精彩问题
		 *
		 * @var integer
		 */
		private $status = array('pending', 'solved', 'offer', 'urgent', 'hot', 'elite', 'expired', 'vote', 'close');
		/**
		 * 搜索关键字
		 *
		 * @var string
		 */
		private $keywords;
		/**
		 * 搜索类型 solved:已解决、pending:待解决问题、offer:高分
		 *
		 * @var string
		 */
		private $type;
		/**
		 * 提问时间
		 *
		 * @var string
		 */
		private $date;
		/**
		 * 是否是精彩问题
		 *
		 * @var boolean
		 */
		private $elite;
		/**
		 * 是否为紧急问题
		 *
		 * @var boolean
		 */
		private $urgent;
		/**
		 * 特色内容
		 *
		 * @var string
		 */
		private $special;
		/**
		 * 排序字段
		 *
		 * @var string
		 */
		private $orderby;
		/**
		 * 排序方式
		 *
		 * @var string
		 */
		private $orderway;
		/**
		 * 分词
		 *
		 * @var string
		 */
		private $words;
		/**
		 * 条件
		 *
		 * @var array
		 */
		private $where = array();
		public function setCid($cid){
			$this->cid = $cid;
		}
		public function setType($type){
			$this->type = $type;
		}
		public function setKeywords($keywords){
			$this->keywords = $keywords;
		}
		public function setPageon($pageon){
			$this->pageon = max($pageon, 1);
		}
		public function setPagesize($pagesize){
			$this->pagesize = $pagesize;
		}
		public function setOrderby($orderby){
			$this->orderby = $orderby;
		}
		public function setOrderway($orderway){
			$this->orderway = $orderway;
		}
		public function setDate($date){
			$this->date = $date;
		}
		public function setSpecial($special){
			$this->special = $special;
		}
		public function setUrgent($urgent){
			$this->urgent = $urgent;
		}
		public function setElite($elite){
			$this->elite = $elite ? true : false;
		}
		/**
		 * 获取分类ID
		 *
		 * @return integer
		 */
		public function getCid(){
			$this->cid = (int)$this->cid;
			if($this->cid){
				global $EXCMS_MODULE;
				if($EXCMS_MODULE['ask']['search_son']){
					include_once ASK_LIB_PATH . 'AskCategory.class.php';
					$ask_cate = new AskCategory();
					$cate_id_array = $ask_cate->getAskCategoryChilds($this->cid);
					$this->cid = implode(',', $cate_id_array);
					unset($ask_cate);
				}
				$this->where['cid'] = "AND `cid` in(" . $this->cid . ") ";
			}
			return $this->cid;
		}
		/**
		 * 获取类型
		 *
		 * @return string
		 */
		public function getType(){
			$types = explode(',', $this->type);
			foreach($types as $value){
				if(in_array($value, $this->status)){
					switch($value){
						//已解决
						case 'solved' :
							$this->where['status'] = "AND `status` =  '3' ";
							break;
						//高悬赏
						case 'offer' :
							$this->where['score'] = "AND `score` > '0' ";
							$this->setOrderby('score');
							$this->setOrderway('desc');
							break;
						//紧急
						case 'urgent' :
							$this->setUrgent(true);
							break;
						//热门
						case 'hot' :
							$this->setOrderby('hot');
							$this->setOrderway('desc');
							break;
						//精彩
						case 'elite' :
							$this->setElite(true);
							break;
						//已过期
						case 'expired' :
							$this->where['status'] = "AND `status` =  '4' ";
							break;
						//投票
						case 'vote' :
							$this->where['status'] = "AND `status` =  '5' ";
							break;
						//关闭
						case 'close' :
							$this->where['status'] = "AND `status` =  '6' ";
							break;
						//待解决
						case 'pending' :
						default :
							$this->where['status'] = "AND `status` =  '2' ";
							break;
					}
				}else{ //默认为已解决
					$this->where['status'] = "AND `status` =  '3' ";
				}
			}
			return $this->type;
		}
		/**
		 * 根据时间查询提问
		 *
		 */
		public function getDate(){
			if(in_array($this->date, array('day', 'week', 'month'))){
				$now = time();
				$day_seconds = 24 * 60 *60; 
				switch($this->date){
					case 'day' :
						$day = $now - (1 * $day_seconds);
						$this->where['createdate'] = " AND `createdate` > '{$day}' ";
						break;
					case 'week' :
						$week = $now - (7 * $day_seconds);
						$this->where['createdate'] = " AND `createdate` > '{$week}' ";
						break;
					case 'month' :
						$month = $now - (date('t') * $day_seconds);
						$this->where['createdate'] = " AND `createdate` > '{$month}' ";
						break;
				}
			}
			return $this->date;
		}
		/**
		 * 获取特色内容
		 *
		 * @return string
		 */
		public function getSpecial(){
			if(in_array($this->special, array('elite'))){
				switch($this->special){
					case 'elite' :
						$this->setElite(true);
						break;
				}
			}
			return $this->special;
		}
		/**
		 * 获取是否为紧急问题
		 *
		 * @return boolean
		 */
		public function getUrgent(){
			if(isset($this->urgent) && $this->urgent !== ''){
				$urgent = empty($this->urgent) ? 0 : 1;
				$this->where['urgent'] = "AND `urgent` = '{$urgent}' ";
			}
			return $this->urgent;
		}
		/**
		 * 是否是精彩问题
		 *
		 * @return boolean
		 */
		public function getElite(){
			if($this->elite){
				$this->where['elite'] = "AND `elite` = '1' ";
			}
			return $this->elite;
		}
		/**
		 * 搜索关键字条件
		 *
		 * @return string
		 */
		public function getKeywords(){
			if($this->keywords != ''){
				include_once LIB_PATH . 'split/SplitWord.class.php';
				$obj_sp = new SplitWord();
				$obj_sp->split($this->keywords);
				return $obj_sp->getSplitWords();
			}
			return $this->keywords;
		}
		/**
		 * 获取内容分页大小 默认为10
		 *
		 * @return integer
		 */
		public function getPagesize(){
			if(empty($this->pagesize)) return 10;
			else return $this->pagesize;
		}
		/**
		 * 获取排序
		 *
		 * @return string
		 */
		public function getOrderBy(){
			$by = explode(',', trim($this->orderby));
			$way = explode(',', trim($this->orderway));
			$order = ' ORDER BY ';
			$seprator = ' ';
			foreach($by as $k => $v){
				switch($v){
					//悬赏分 
					case 'score' :
					//人气
					case 'hot' :
					//创建时间
					case 'createdate' :
					//回答数排序
					case 'answernumber' :
						$order .= $seprator . $v . ((isset($way[$k]) && strtolower($way[$k]) == 'asc') ? ' ASC' : ' DESC');
						break;
					default :
						$order .= 'createdate DESC';
				}
				$seprator = ',';
			}
			return $order;
		}
		/**
		 * 获取查询条件
		 *
		 * @return string
		 */
		private function getWhere(){
			$this->getCid();
			$this->getType();
			$this->getDate();
			$this->getSpecial();
			$this->getUrgent();
			$this->getElite();
			$where = join(' ', $this->where);
			$this->words = $this->getKeywords();
			$words_array = explode(' ', $this->words);
			if(is_array($words_array) && count($words_array) > 0){
				foreach($words_array as $value){
					// $like[] = " `title` LIKE '%{$value}%' OR `content` LIKE '%{$value}%'";
					$like[] = " `title` LIKE '%{$value}%'";
				}
				$where .= " AND (" . implode(' OR ', $like) . " )";
			}
			$where .= " AND `checked` = 2 ";
			return $where;
		}
		/**
		 * 获取搜索问题列表
		 *
		 * @return array
		 * <ul>
		 * <li>string $array['data'] 问题列表数据 </li>
		 * <li>integer $array['total'] 总数 </li>
		 * </ul>
		 */
		public function getAskSearch($array){
			global $_PAGE;
			$this->setCid($array['cid']);
			$this->setDate($array['date']);
			$this->setType($array['type']);
			$this->setKeywords($array['word']);
			$this->setOrderby($array['orderby']);
			$this->setOrderway($array['orderway']);
			$this->setPagesize($array['pagesize']);
			$this->setSpecial($array['special']);
			$this->setPageon($_PAGE['pageon']);
			//统计搜索时间
			$startTime = microtime_float();
			$where = $this->getWhere();
			$sql = "SELECT COUNT(*) as total FROM " . TABLE_PREFIX . "ask_questions WHERE 1 {$where} ";
			$GLOBALS['db']->query($sql);
			$total = $GLOBALS['db']->fetch();
			$total = $total['total'];
			if($total > 0){
				//当前页大于总数页,当前页为总数页
				$pages = ceil($total / $this->getPagesize());
				if($this->pageon > 0 && $this->pageon > $pages){
					$this->pageon = $pages;
				}
				//根据条件查询问题
				$limit = "limit " . $this->getPagesize() * ($this->pageon - 1) . "," . $this->getPagesize();
				$sql = "SELECT * FROM " . TABLE_PREFIX . "ask_questions WHERE 1 {$where} {$this->getOrderBy()} {$limit} ";
				$GLOBALS['db']->query($sql);
				$ask_array = $GLOBALS['db']->fetchAll();
				$field_array = explode(',', $array['fields']);
				if(in_array('category', $field_array) || in_array('position', $field_array)){
					include_once ASK_LIB_PATH . 'AskCategory.class.php';
					$ask_cate = new AskCategory();
					$category_array = $ask_cate->getCateCache();
					unset($ask_cate);
				}
				if(in_array('answer', $field_array)){
					include_once ASK_LIB_PATH.'Answer.class.php';
					$ask_answer = new Answer();
				}
				if(in_array('user', $field_array)){
					include_once LIB_MODULES_PATH . 'account/Account.class.php';
					$account = new Account();
				}
				$askquestionlist = array();
				foreach($ask_array as $value){
					//显示自定义属性
					foreach($field_array as $v){
						switch($v){
							case 'url' :
								$data_array['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $value['qid']));
								break; //链接地址
							case 'title' :
								$data_array['title'] = highLightWords($value['title'], $this->words, 64);
								break; //标题
							case 'content' :
								$data_array['content'] = highLightWords($value['content'], $this->words, 220);
								break;
							case 'category' :
								$data_array['category'] = $category_array[$value['cid']];
								break; //问题分类
							case 'createdate' :
								$data_array['createdate'] = $value['createdate'];
								break; //提问时间
							case 'asktime' :
								$data_array['asktime'] = timeformat($value['createdate']);
								break; //处理后提问时间
							case 'score' :
								$data_array['score'] = $value['score'];
								break; //悬赏分
							case 'user' :
								if($value['uid'] > 0) $account->getById($value['uid']);
								break; //提问人名称
							case 'answer' :
								$data_array['answer'] = $ask_answer->getBestAnswer($value['qid']);
								break; //最佳回答信息
							case 'answernumber' : // 回答数
								$data_array['answernumber'] = $value['answernumber'];
								break;
							case 'position' : // 导航地址
								$data_array['position'] = $category_array[$value['cid']]['position'];
								break;
						}
					}
					$data_array['urgent'] = $value['urgent'];
					$data_array['elite'] = $value['elite'];
					$askquestionlist[] = $data_array;
				}
			}
			//计算搜索用时
			$processedtime = round((microtime_float() - $startTime), 3);
			return $total > 0 ? array('from' => $askquestionlist, 'item' => array('keywords' => $this->keywords, 'total' => $total, 'processedtime' => $processedtime, 'words' => $this->words), 
					'pager' => array('total' => $total, 'pagesize' => $this->getPagesize(), 'dynamic' => true, 'pageon' => $this->pageon, 'encodepage' => 'nocode')) : null;
		}
	}

 // excms file end