<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskSetting.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package Hit
 * @author $Author: hukuizhi $
 * @version $Rev: 1700 $
 */
/* $Id: AskSetting.class.php 1700 2010-06-08 02:44:30Z hukuizhi $ */
/**
 * EXCMS 我的设置
 * @category EXCMS
 * @package AskSetting
 * @author $Author: hukuizhi $
 */
include_once LIB_PATH . 'util/Message.class.php';
class AskSetting{
	/**
	 * 我的设置表
	 *
	 * @access private
	 * @var string
	 */
	private $table = "ask_setting";
	/**
	 * 构造函数
	 * 
	 */
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
	}
	/**
	 * 兼容PHP4构造函数
	 * 
	 */
	function AskSetting(){
		$this->__construct();
	}
	/**
	 * 根据用户ID获取我的设置信息
	 *
	 * @param integer $uid	用户ID
	 * @return array
	 */
	public function getByUid($uid){
		if($uid > 0){
			$sql = "SELECT * FROM {$this->table} WHERE `uid`='{$uid}'";
			$GLOBALS['db']->query($sql);
			return $GLOBALS['db']->fetch();
		}else{
			Message::put('LACK_PARAM_UID');
		}
	}
	/**
	 * 增加用户设置
	 *
	 * @param array $data	数据
	 * 
	 * @return integer
	 */
	public function insert($data){
		if($data['uid'] > 0){
			$data = array(
				'uid' => $data['uid'],
				'question' => $data['question'] ? 1 : 0,
				'maxrecord' => (int)$data['maxrecord'],
				'cid'	=> $data['cid'],
				'keywords' => $data['keywords']
			);
			$sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
	        	        $GLOBALS['db']->query($sql);
		    return $GLOBALS['db']->insert_id();
		}else{
			Message::put('LACK_PARAM_UID');
			return false;
		}
	}
	/**
	 * 更新我的设置
	 *
	 * @param integer $uid	用户ID
	 * @param arrat $data	数据
	 * 
	 * @return boolean
	 */
	public function update($uid,$data){
		if($uid > 0){
			$data = array(
				'question' => $data['question'] ? 1 : 0,
				'maxrecord' => (int)$data['maxrecord'],
				'cid'	=> $data['cid'],
				'keywords' => $data['keywords']
			);
			$set = array();
	        foreach ($data as $k => $v) {
	            $set[] = "`{$k}` = '{$v}'";
	        }
	        $set = implode(", ", $set);
	        	        $sql = "UPDATE `{$this->table}` SET {$set} WHERE `uid` = '{$uid}' LIMIT 1";
	        return $GLOBALS['db']->query($sql);
		}else{
			Message::put('LACK_PARAM_UID');
			return false;
		}
	}
	/**
	 * 更新ASK分类
	 *
	 * @param integer $uid	用户ID
	 * @param string $cids	问题分类
	 * @return boolean
	 */
	public function updateAskCategory($uid,$cids){
		if($uid > 0){
			Message::put('LACK_PARAM_UID');
			return false;
		}
		$cids = EXCMS::convertToIntArray($cids);
		if($cids===false){
			Message::put('LACK_PARAM_UID');
			return false;
		}
		$cids = implode(',',$cids);
		$sql = "UPDATE `{$this->table}` SET `cid` = '{$cids}' WHERE `uid` = '{$uid}'";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * 保存用户设置
	 *
	 * @param array $data	我的设置信息
	 * @return boolean
	 */
	public function commit($data){
		$setting = $this->getByUid($data['uid']);
		if(is_array($setting) && count($setting) > 0){
			return $this->update($data['uid'],$data);
		}else{
			return $this->insert($data);
		}
	}
	/**
	 * 更新关键字
	 *
	 * @param integer $uid	用户ID
	 * @param string $keywords	关键字
	 * @return boolean
	 */
	public function updateAskKeywords($uid,$keywords){
		if($uid > 0){
			Message::put('LACK_PARAM_UID');
			return false;
		}
		$sql = "UPDATE `{$this->table}` SET `keywords` = '{$keywords}' WHERE `uid` = '{$uid}'";
		return $GLOBALS['db']->query($sql);
	}
}


// excms file end