<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AskVote.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package Hit
 * @author $Author: hukuizhi $
 * @version $Rev: 1700 $
 */
/* $Id: AskVote.class.php 1700 2010-06-08 02:44:30Z hukuizhi $ */
/**
 * EXCMS 用户投票表
 * @category EXCMS
 * @package AskVote
 * @author $Author: hukuizhi $
 */
class AskVote{
	/**
	 * 问答统计表
	 *
	 * @access private
	 * @var string
	 */
	private $table = 'ask_vote';
	/**
	 * 构造函数
	 * 
	 */
	function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
	}
	/**
	 * 兼容PHP4构造函数
	 * 
	 */
	function AskVote(){
		$this->__construct();
	}
	/**
	 * 保存投票数据
	 *
	 * @param array $data
	 * @return boolean
	 */
	public function insert($data){
		if((int)$data['uid'] < 1){
			throw_exception('LACK_PARAM_UID');
		}
		$data = array(
			'qid' => (int)$data['qid'],
			'aid' => (int)$data['aid'],
			'uid' => (int)$data['uid'],
			'votetime' => time()
		);
		$sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
		return $GLOBALS['db']->query($sql);
	}
	/**
	 * 验证是否已经投票
	 *
	 * @param integer $uid	用户ID
	 * @param  integer	$qid	问题ID
	 * @return boolean
	 */
	public function isVote($uid, $qid){
		if($uid > 0){
			$sql = "SELECT count(*) as total FROM {$this->table} WHERE `uid` = {$uid} AND `qid` = '{$qid}'";
			$GLOBALS['db']->query($sql);
			$rs = $GLOBALS['db']->fetch();
			return $rs['total'] > 0 ? true : false;
		}
		return false;
	}
	/**
	 * 统计投票数
	 *
	 * @param integer $qid	问题ID
	 * @return integer
	 */
	public function statVoteByQid($qid){
		if(!($qid > 0)){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$sql = "SELECT count(*) as total FROM {$this->table} WHERE `qid` = '{$qid}' LIMIT 1";
		$GLOBALS['db']->query($sql);
		$rs = $GLOBALS['db']->fetch();
		return $rs['total'];
	}
	/**
	 * 根据回答ID分组统计投票数
	 *
	 * @param integer $qid
	 * @return array
	 */
	public function groupStatVoteByQid($qid){
		if(!($qid > 0)){
			throw_exception('ASK_QUESTIONS_LACK_ID');
		}
		$sql = "SELECT `aid`,COUNT(*) as total FROM {$this->table} WHERE `qid` = '{$qid}' GROUP BY `aid`";
		$GLOBALS['db']->query($sql);
		return $GLOBALS['db']->fetchAll();
	}
}

// excms file end