DROP TABLE IF EXISTS `excms_ask_account`;
CREATE TABLE `excms_ask_account` (
  `uid` INT(11) UNSIGNED NOT NULL,
  `level` CHAR(20) DEFAULT NULL,
  `question` INT(11) DEFAULT NULL,
  `question_elite` INT(11) DEFAULT NULL,
  `answer` INT(11) DEFAULT NULL,
  `answer_best` INT(11) DEFAULT NULL,
  `answer_elite` INT(11) DEFAULT NULL,
  `adopt` FLOAT DEFAULT NULL,
  `favorable` INT(11) DEFAULT NULL
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `excms_ask_actor`;
CREATE TABLE `excms_ask_actor` (
  `id` SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `catename` CHAR(50) DEFAULT NULL,
  `grade` CHAR(20) DEFAULT NULL,
  `name` CHAR(40) DEFAULT NULL,
  `min` INT(11) DEFAULT '0',
  `max` INT(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MYISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO `excms_ask_actor` VALUES ('1','科举系列','1','书童','0','80');
INSERT INTO `excms_ask_actor` VALUES ('2','新系列','2','书生','81','400');
INSERT INTO `excms_ask_actor` VALUES ('3','科举系列','3','秀才','401','800');
INSERT INTO `excms_ask_actor` VALUES ('4','科举系列','4','举人','801','2000');
INSERT INTO `excms_ask_actor` VALUES ('5','科举系列','5','解元','2001','4000');
INSERT INTO `excms_ask_actor` VALUES ('6','科举系列','6','贡士','4001','7000');
INSERT INTO `excms_ask_actor` VALUES ('7','科举系列','7','会元','7001','10000');
INSERT INTO `excms_ask_actor` VALUES ('8','科举系列','8','同进士出身','10001','14000');
INSERT INTO `excms_ask_actor` VALUES ('9','科举系列','9','进士出身','14001','18000');
INSERT INTO `excms_ask_actor` VALUES ('10','科举系列','10','探花','18001','22000');
INSERT INTO `excms_ask_actor` VALUES ('11','科举系列','11','榜眼','22001','32000');
INSERT INTO `excms_ask_actor` VALUES ('12','科举系列','12','状元','32001','45000');
INSERT INTO `excms_ask_actor` VALUES ('13','科举系列','13','编修','45001','60000');
INSERT INTO `excms_ask_actor` VALUES ('14','科举系列','14','府丞','60001','100000');
INSERT INTO `excms_ask_actor` VALUES ('15','科举系列','15','翰林学士','100001','150000');
INSERT INTO `excms_ask_actor` VALUES ('16','科举系列','16','御史中丞','150001','250000');
INSERT INTO `excms_ask_actor` VALUES ('17','科举系列','17','詹士','250001','400000');
INSERT INTO `excms_ask_actor` VALUES ('18','科举系列','18','侍郎','400001','700000');
INSERT INTO `excms_ask_actor` VALUES ('19','科举系列','19','大学士','700001','1000000');
INSERT INTO `excms_ask_actor` VALUES ('20','科举系列','20','文曲星','1000001','0');

DROP TABLE IF EXISTS `excms_ask_answers`;
CREATE TABLE `excms_ask_answers` (
  `aid` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `qid` INT(11) NOT NULL,
  `cid` MEDIUMINT(5) NOT NULL,
  `checked` TINYINT(1) NOT NULL DEFAULT '0',
  `ishidden` TINYINT(1) NOT NULL DEFAULT '0',
  `isbest` TINYINT(1) NOT NULL DEFAULT '0',
  `content` TEXT,
  `anonymous` TINYINT(1) NOT NULL DEFAULT '0',
  `vote` TINYINT(1) DEFAULT '0',
  `votecount` INT(11) NOT NULL DEFAULT '0',
  `uid` INT(11) DEFAULT NULL,
  `append` TINYINT(1) UNSIGNED DEFAULT '0',
  `ip` CHAR(15) DEFAULT NULL,
  `createdate` INT(11) DEFAULT NULL,
  `modifieddate` INT(11) DEFAULT NULL,
  PRIMARY KEY (`aid`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_answers_append`;
CREATE TABLE `excms_ask_answers_append` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `aid` INT(11) DEFAULT NULL,
  `type` TINYINT(1) DEFAULT '0',
  `content` TEXT,
  `date` INT(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_answers_comment`;
CREATE TABLE `excms_ask_answers_comment` (
  `qid` INT(11) DEFAULT NULL,
  `aid` INT(11) DEFAULT NULL,
  `solveoption` TINYINT(1) DEFAULT NULL,
  `yuanchuang` TINYINT(1) DEFAULT NULL,
  `sudu` TINYINT(1) DEFAULT NULL,
  `taidu` TINYINT(1) DEFAULT NULL,
  `comment` VARCHAR(100) DEFAULT NULL
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_category`;
CREATE TABLE `excms_ask_category` (
  `cid` MEDIUMINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` MEDIUMINT(5) UNSIGNED NOT NULL DEFAULT '0',
  `name` CHAR(40) NOT NULL,
  `type` TINYINT(1) UNSIGNED DEFAULT '0',
  `childnum` SMALLINT(2) DEFAULT '0',
  `wordgroupnum` TINYINT(1) DEFAULT '0',
  `description` VARCHAR(250) DEFAULT NULL,
  `asknumber` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  `questioncheck` TINYINT(1) UNSIGNED NOT NULL DEFAULT '2',
  `answercheck` TINYINT(1) DEFAULT '0',
  `sort` INT(11) DEFAULT '50',
  PRIMARY KEY (`cid`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_exp`;
CREATE TABLE `excms_ask_exp` (
  `uid` INT(11) UNSIGNED NOT NULL,
  `exp` INT(11) DEFAULT '0',
  `exp_operate` INT(11) DEFAULT '0',
  `exp_question` INT(11) DEFAULT '0',
  `exp_answer` INT(11) DEFAULT '0',
  `exp_punish` INT(11) DEFAULT '0',
  `exp_other` INT(11) DEFAULT '0',
  `exp_week` INT(11) DEFAULT '0',
  `exp_month` INT(11) DEFAULT '0',
  `exp_year` INT(11) DEFAULT '0',
  `exp_updatetime` INT(11) DEFAULT NULL,
  `exp_question_day` INT(11) DEFAULT '0',
  `exp_answer_day` INT(11) DEFAULT '0',
  `exp_vote_day` INT(11) DEFAULT '0'
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_from_uid`;
CREATE TABLE `excms_ask_from_uid` (
  `uid` INT(11) DEFAULT NULL,
  `fromuid` INT(11) DEFAULT NULL,
  `qid` INT(11) DEFAULT NULL,
  `status` TINYINT(1) DEFAULT '0'
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_questions`;
CREATE TABLE `excms_ask_questions` (
  `qid` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cid` MEDIUMINT(5) UNSIGNED DEFAULT NULL,
  `title` CHAR(100) NOT NULL,
  `content` TEXT,
  `score` TINYINT(2) UNSIGNED DEFAULT '0',
  `hot` INT(11) UNSIGNED DEFAULT '0',
  `checked` TINYINT(1) UNSIGNED DEFAULT '0',
  `elite` TINYINT(1) UNSIGNED DEFAULT '0',
  `status` TINYINT(1) UNSIGNED DEFAULT '2',
  `urgent` TINYINT(1) UNSIGNED DEFAULT '0',
  `anonymous` TINYINT(1) UNSIGNED DEFAULT '0',
  `answernumber` INT(11) UNSIGNED DEFAULT '0',
  `newanswer` TINYINT(1) UNSIGNED DEFAULT '0',
  `uid` INT(11) DEFAULT NULL,
  `ip` CHAR(15) DEFAULT NULL,
  `createdate` INT(11) UNSIGNED DEFAULT NULL,
  `modifieddate` INT(11) UNSIGNED DEFAULT NULL,
  `solveddate` INT(11) UNSIGNED DEFAULT NULL,
  `append` TINYINT(1) UNSIGNED DEFAULT '0',
  `votedate` INT(11) DEFAULT NULL,
  PRIMARY KEY (`qid`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_questions_append`;
CREATE TABLE `excms_ask_questions_append` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `qid` INT(11) DEFAULT NULL,
  `content` TEXT,
  `date` INT(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_score`;
CREATE TABLE `excms_ask_score` (
  `uid` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `score` INT(11) DEFAULT '20',
  `score_operate` INT(11) DEFAULT '0',
  `score_answer` INT(11) DEFAULT '0',
  `score_question` INT(11) DEFAULT '0',
  `score_punish` INT(11) DEFAULT '0',
  `score_other` INT(11) DEFAULT '0',
  `score_question_day` INT(5) DEFAULT '0',
  `score_answer_day` INT(5) DEFAULT '0',
  `score_updatetime` INT(11) DEFAULT NULL,
  `score_vote_day` INT(11) DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_score_log`;
CREATE TABLE `excms_ask_score_log` (
  `lid` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` INT(11) DEFAULT NULL,
  `type` TINYINT(1) DEFAULT NULL,
  `score` INT(5) DEFAULT NULL,
  `log` VARCHAR(100) DEFAULT NULL,
  `createdate` INT(11) DEFAULT NULL,
  PRIMARY KEY (`lid`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_setting`;
CREATE TABLE `excms_ask_setting` (
  `uid` INT(11) NOT NULL,
  `question` TINYINT(1) DEFAULT NULL,
  `maxrecord` INT(5) DEFAULT NULL,
  `cid` CHAR(100) DEFAULT NULL,
  `keywords` VARCHAR(500) DEFAULT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `excms_ask_vote`;
CREATE TABLE `excms_ask_vote` (
  `vid` INT(11) NOT NULL AUTO_INCREMENT,
  `qid` INT(11) DEFAULT NULL,
  `aid` INT(11) DEFAULT NULL,
  `uid` INT(11) DEFAULT NULL,
  `votetime` INT(11) DEFAULT NULL,
  PRIMARY KEY (`vid`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DELETE FROM `excms_url` WHERE `moduleid` = 'ask';
INSERT INTO `excms_url` (`moduleid`,`name`,`url`,`enablerewrite`,`rewrite`,`description`,`issystem`,`sort`) VALUES ('ask','index','/ask/index.php','0','/ask/index.html','问吧主页重写','1','50'),('ask','list','ask/list.php?cid={cid}&type={type}&word={word}&page={page}','0','/ask-list-{cid}-{type}-{word}-{page}.html','分类问题列表(待解决,高悬赏,已解决,紧急,热点,精彩)','1','50'),('ask','question','/ask/question.php?id={id}','0','/ask/question-{id}.html','问题详细信息','1','50'),('ask','myask','/ask/myask.php?action={action}&status={status}','0','/ask/myask/{action}/{status}','我的问吧','1','50'),('ask','wen','/ask/wen.php?action={action}','0','/ask/wen-action.html','提问页面','1','50'),('ask','action','/ask/action.php?action={action}','0','/ask/action-{action}.html','ASK用户中心动作处理','1','50'),('ask','search','/ask/search.php?word={word}&type={type}&cid={cid}&date={date}&special={special}','0','','搜索','1','50'),('ask','user','/ask/user.php?unumber={unumber}&action={action}&status={status}','0','/ask/user-{unumber}-{action}-{status}.html','用户问答信息','1','50');
DELETE FROM `excms_system_config` WHERE `moduleid` = 'ask';
INSERT INTO `excms_system_config` (`moduleid`,`name`,`value`,`description`,`group`,`type`,`issystem`,`sort`) VALUES ('ask','name','问答','问答名称','模块设置','3','1','100'),('ask','question_check','0','提问是否需要审核','模块设置','1','1','100'),('ask','answer_check','0','回答是否需要审核','模块设置','1','1','100'),('ask','search_son','1','按分类搜索是否包含子分类','模块设置','1','1','100'),('ask','question_expired_time','15','问题过期时间,单位:天','模块设置','2','1','100'),('ask','vote_time','5','投票时间天数','模块设置','2','1','100'),('ask','question_verifycode','1','提问是否需要验证码','模块设置','1','1','100'),('ask','answer_verifycode','1','回答问题验证码','模块设置','1','1','100'),('ask','question_anonymous_allow','1','是否允许匿名提问','模块设置','1','1','100'),('ask','answer_anonymous_allow','0','是否允许匿名回答问题','模块设置','1','1','100'),('ask','answer_best_allow','2','满意答案最多允许数目','模块设置','2','1','100'),('ask','score_question_anonymous','10','匿名提问扣积分','模块设置','2','1','100'),('ask','score_answer_adopt','20','答案被采纳加积分及相应的悬赏分','模块设置','2','1','100'),('ask','score_question_expired','20','提问过期扣积分','模块设置','2','1','100'),('ask','score_answer_delete','10','回答被删除回答者减10分','模块设置','2','1','100'),('ask','score_answer_uncheck','10','回答未通过审核扣分（补充修改通过审核后将返还）','模块设置','2','1','100'),('ask','score_question_delete','20','提问被删除扣积分','模块设置','2','1','100'),('ask','score_question_uncheck','20','提问未通过审核所扣积分及相应悬赏分 (补充修改通过审核后将返还)','模块设置','2','1','100'),('ask','score_answer_best_delete','20','满意答案被删除提问者和满意答案提供者扣积分','模块设置','2','1','100'),('ask','score_question_expired_deal','0','处理过期问题加积分','模块设置','2','1','100'),('ask','score_first_login','20','新用户首次登陆加积分','模块设置','2','1','100'),('ask','score_answer','0','回答问题加积分','模块设置','2','1','100'),('ask','score_day_login','0','每日第一次登陆加积分','模块设置','2','1','100'),('ask','score_question','2','提问获取积分','模块设置','2','1','100'),('ask','score_answer_elite','10','回答被选为精彩答案加积分','模块设置','2','1','100'),('ask','score_answer_recommend','10','回答被选为网友推荐答案加积分','模块设置','2','1','100'),('ask','score_vote','0','投票加积分','模块设置','2','1','100'),('ask','score_question_day_max','20','提问每日最多可获积分','模块设置','2','1','100'),('ask','score_answer_day_max','20','回答每日最多可获得积分','模块设置','2','1','100'),('ask','score_question_elite','0','提问被选择精彩加积分','模块设置','2','1','100'),('ask','score_expired_to_vote','20','过期问题转入投票扣积分','模块设置','2','1','100'),('ask','score_questoin_ugrent','20','紧急问题扣积分','模块设置','2','1','100'),('ask','score_question_direct','2','直接向某人提问按人次扣积分','模块设置','2','1','100'),('ask','score_vote_day_max','0','每日投票最多可获积分','模块设置','2','1','100'),('ask','exp_day_login','2','每日第一次登陆加经验值','模块设置','2','1','100'),('ask','exp_first_login','20','新用户首次登陆增加经验值','模块设置','2','1','100'),('ask','exp_question','0','提问获得经验值','模块设置','2','1','100'),('ask','exp_answer','2','回答问题奖励经验值','模块设置','2','1','100'),('ask','exp_answer_day_max','10','回答问题每日最多可获经验值','模块设置','2','1','100'),('ask','exp_question_anonymous','0','匿名提问扣经验值','模块设置','2','1','100'),('ask','exp_question_delete','10','提问被删除扣经验值','模块设置','2','1','100'),('ask','exp_question_expired','0','提问过期扣经验','模块设置','2','1','100'),('ask','exp_question_uncheck','20','提问未审核扣经验值','模块设置','2','1','100'),('ask','exp_question_day_max','20','提问每日最多可获经验值','模块设置','2','1','100'),('ask','exp_answer_delete','20','回答被删除扣经验值','模块设置','2','1','100'),('ask','exp_answer_uncheck','20','回答未通过审核扣经验值','模块设置','2','1','100'),('ask','exp_answer_adopt','20','回答被采纳加经验值','模块设置','2','1','100'),('ask','exp_answer_best_delete','20','满意答案被删除提问者和满意答案提供者扣经验值','模块设置','2','1','100'),('ask','exp_answer_elite','10','回答被选为精彩答案加经验值','模块设置','2','1','100'),('ask','exp_answer_recommend','10','回答被网友推荐回答加经验值','模块设置','2','1','100'),('ask','exp_question_expired_deal','10','处理过期提问加经验值','模块设置','2','1','100'),('ask','exp_expired_to_vote','0','过期问题转入投票扣经验值','模块设置','2','1','100'),('ask','exp_questoin_ugrent','0','紧急问题扣经验值','模块设置','2','1','100'),('ask','exp_question_direct','0','直接向某人提问按人次扣经验值','模块设置','2','1','100'),('ask','exp_vote','2','投票增加经验值','模块设置','2','1','100'),('ask','exp_question_elite','10','精华提问加经验值','模块设置','2','1','100'),('ask','exp_vote_day_max','20','每日投票最多可获经验','模块设置','2','1','100');
DELETE FROM `excms_modules_action` WHERE `module` = 'ask';
INSERT INTO `excms_modules_action` (`actionname`,`module`,`class`,`action`,`params`) VALUES ('ask.questionlist','ask','AskQuestionList','getAskQuestionList','tagparam'),('ask.answerlist','ask','AskAnswerList','getAskAnswerList','tagparam'),('ask.catelist','ask','AskCateList','getAskCateList','tagparam'),('ask.cate','ask','AskCateList','getAskCate','tagparam'),('ask.searchpagelist','ask','AskSearch','getAskSearch','tagparam'),('ask.search','ask','AskQuestion','getByQid','qid'),('ask.askscorelist','ask','AskScoreList','getAskScoreList','tagparam'),('ask.appendlist','ask','AskAppendList','getAskAppendList','tagparam');