<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		list.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 2220 $
 */
/* $Id: list.php 2220 2010-08-13 08:22:17Z zhanghaisong $ */

/**
 * 分类问题列表
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 */ 

// 加载ASK系统配置文件，移动本程序时，请修改配置文件路径
require_once ('configuration/inc/common.inc.php');

// set page params
$_PAGE['word'] = trim($_GET['word']);
$_PAGE['page'] = $_GET['page'];
$_PAGE['type'] = $_GET['type'];
$_CATEGORY = array();

// 加载问题分类,创建问题分类AskCategory对像
include_once ASK_LIB_PATH . 'AskCategory.class.php';
$ac = new AskCategory();
$cid = is_numeric($_GET['cid']) && $_GET['cid'] ? (int)$_GET['cid'] : 0;
if($cid > 0){	// 当前分类不为空时
	$_CATEGORY = $ac->getCateCache($_GET['cid']);
	if(!is_array($_CATEGORY['childids']) || count($_CATEGORY['childids']) < 1){	
		// 判断当前分类是否有子分类
		if($_CATEGORY['pid']){	
			// 获取上级分类名称
			$cate_array = $ac->getCateCache($_CATEGORY['pid']);
			$_CATEGORY['categoryname'] = $cate_array['name'];
		}else{		
			// 获取模块名称
			$_CATEGORY['categoryname'] = $EXCMS_MODULE['ask']['name'];
		}
	}else{
		$_CATEGORY['categoryname'] = $_CATEGORY['name'];
	}
}else{
	$_CATEGORY['name'] = '问题库';
	$_CATEGORY['categoryname'] = '<a href="allcategory.html">全部分类</a>';
}

// 当前位置
$_PAGE['position'] = $ac->getNavigation($_CATEGORY['cid'], $_CATEGORY['cid'] ? $_PAGE['word'] : $_CATEGORY['name']);
unset($ac);
// set page category
$_PAGE['CATEGORY'] = &$_CATEGORY;

//set asktype
switch ($_PAGE['type']){
	// 高悬赏
	case 'offer' :
		$_PAGE['asktype'] = 'offer,pending';
		break;
	// 紧急问题
	case 'urgent' :
		$_PAGE['asktype'] = 'urgent,pending';
		break;
	// 热点问题
	case 'hot' :
		$_PAGE['asktype'] = 'hot,pending';
		break;
	// 精彩问题
	case 'elite' :
		$_PAGE['asktype'] = 'elite';
		break;
	// 已解决
	case 'solved' :
		$_PAGE['asktype'] = 'solved';
		break;
	// 投票
	case 'vote' :
		$_PAGE['asktype'] = 'vote';
		break;
	// 零回答
	case 'zero' :
		$_PAGE['asktype'] = 'zero,pending';
		break;
	// 待解决
	case 'pending' :
	default:
		$_PAGE['type'] = $_PAGE['asktype'] = 'pending';
		break;
}
// 输出模板
EXCMS::display('ask/list.html');

// excms file end