<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		question.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 * @version $Rev: 2153 $
 */
/* $Id: question.php 2153 2010-08-10 09:15:01Z zhangxuelin $ */
/**
 * EXCMS 问题详细列表
 * @category EXCMS
 * @package ask
 * @author $Author: zhangxuelin $
 */

require_once ('configuration/inc/common.inc.php');

// 获取页面参数
$id = $_GET['id'];
$_PAGE['bc'] = $_GET['bc'];

// 加载问题类,创建问题AskQuestion对像
include_once ASK_LIB_PATH . 'AskQuestion.class.php';
$question = new AskQuestion();
$question_array = $question->getById($id);
if($question_array['qid'] > 0){ // 问题存在
	$tpl = 'question.html';
	// 处理问题
	$question->dealQuestion($question_array);
	$question_array = $question->getById($id);
	// 更新问题点击数
	$question->updateHot($id);
	// 设置页面数据
	$question->format($question_array);
	$_PAGE['QUESTION'] = &$question_array;
	// 加载问题分类类，创建分类对象
	include_once ASK_LIB_PATH . 'AskCategory.class.php';
	$askcate = new AskCategory();
	// 设置页面当前所在位置
	$_PAGE['position'] = $askcate->getNavigation($question_array['cid'], true);
	$_PAGE['page'] = $_GET['page'];
	unset($askcate);
}else{ // 问题不存在
	$_PAGE['message'] = '问题已失效或不存在';
	$tpl = 'message.html';
}

// 输出模板
EXCMS::display("ask/{$tpl}");

// end excms file