<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		user.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author luofen@excms.cn
 * @version $Rev: 1896 $
 */
/* $Id: index.php 1896 2010-07-18 02:02:46Z zhanghaisong $ */
/**
 * 用户问答
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 */
// 加载ASK系统配置文件，移动本程序时，请修改配置文件路径
require_once ('configuration/inc/common.inc.php');
$unumber = $_GET['unumber'];
$_PAGE_USER['user'] = $_USER->getByUnumber($unumber);
if(EXCMS_SESSION_UID == $_PAGE_USER['user']['uid']){
	header('Location: ' . EXCMS::url(array('name' => 'ask.myask')), true);
	exit();
}
$uid = $_PAGE_USER['user']['uid'];
include_once ASK_LIB_PATH.'AskScore.class.php';
$score = new AskScore();
$_PAGE_USER['score']  = $score->getScoreByUid($uid);
if(!is_array($_PAGE_USER['score']) || count($_PAGE_USER['score']) < 1){
	$_PAGE_USER['score'] = array('score'=>0,'score_operate'=>0,'score_answer'=>0,'score_question'=>0,'score_punish'=>0,'score_other'=>0,'score_question_day'=>0,'score_answer_day'=>0,'score_vote_day'=>0);
}
include_once ASK_LIB_PATH.'Actor.class.php';
$actor = new Actor();
$_PAGE_USER['actor'] = $actor->getActorByScore($_PAGE_USER['score'] ['score']);

include_once ASK_LIB_PATH.'AskAccount.class.php';
$account = new AskAccount();
$_PAGE_USER['account'] = $account->getByUid($uid);
if(!is_array($_PAGE_USER['account']) || count($_PAGE_USER['account']) < 1){
	$_PAGE_USER['account'] = array('question'=>0,'question_elite'=>0,'answer'=>0,'answer_best'=>0,'answer_elite'=>0,'adopt'=>0,'favorable'=>0);
}
// get page action
$_PAGE['action'] = $_GET['action'];
$_PAGE['status'] = $_GET['status'];	//状态
switch($_PAGE['action']){
	// 提问记录
	case 'question' :
		$_PAGE['title'] = '提问记录';
		$tpl = 'user_question.html';
		if($_PAGE['status']=='failed')	$_PAGE['checked'] = true;
		break;
	// 回答记录
	case 'answer' :
		$_PAGE['title'] = '回答记录';
		$tpl = 'user_answer.html';
		$_PAGE['status'] = $_GET['status']; //状态
		switch ($_PAGE['status']){
			case 'best' :$_PAGE['listtype'] = 'best';
				break;
			case 'hidden' :$_PAGE['hidden'] = true;
				break;
			case 'anonymous' :$_PAGE['anonymous'] = true;
				break;
			case 'failed' :	$_PAGE['checked'] = true;
				break;
			default:$_PAGE['hidden'] = false;
				break;
		}
		break;
	// 好友动态
	case 'message' :
		$_PAGE['title'] = '好友动态';
		$tpl = 'user_message.html';
		break;
	// 积分明细
	case 'score' :
		$_PAGE['title'] = '积分明细';
		$tpl = 'user_score.html';
		$_PAGE_USER['exp'] = $score->getExpByUid($uid);
		if(!is_array($_PAGE_USER['exp']) || count($_PAGE_USER['exp']) < 1){
			$_PAGE_USER['exp'] = array('exp'=>0,'exp_operate'=>0,'exp_question'=>0,'exp_answer'=>0,'exp_punish'=>0,'exp_other'=>0,'exp_week'=>0,'exp_month'=>0,'exp_year'=>0,'exp_question_day'=>0,'exp_answer_day'=>0,'exp_vote_day'=>0);
		}
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$question = new AskQuestion();
		$_PAGE_USER['account']['questions_solved'] = $question->countSolution($uid);
		$_PAGE_USER['account']['questions_pending'] = $question->countPendingNumbere($uid);
		$_PAGE_USER['account']['questions_close'] = $question->countClose($uid);
		break;
		break;
	// 用户问答默认页
	default :
		$_PAGE['title'] = '用户信息';
		$tpl = 'user_ask.html';
		$_PAGE['action'] = '';
		$_PAGE_USER['exp'] = $score->getExpByUid($uid);
		if(!is_array($_PAGE_USER['exp']) || count($_PAGE_USER['exp']) < 1){
			$_PAGE_USER['exp'] = array('exp'=>0,'exp_operate'=>0,'exp_question'=>0,'exp_answer'=>0,'exp_punish'=>0,'exp_other'=>0,'exp_week'=>0,'exp_month'=>0,'exp_year'=>0,'exp_question_day'=>0,'exp_answer_day'=>0,'exp_vote_day'=>0);
		}
		include_once ASK_LIB_PATH.'AskSetting.class.php';
		$setting = new AskSetting();
		$setting_array =  $setting->getByUid($uid);
		$_PAGE['cid'] = $setting_array['cid'];
		break;
}
$_PAGE['page'] = &$_GET['page'];
// 输出模板
EXCMS::display("ask/{$tpl}");

// excms file end