<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		questions.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 2234 $
 */
/* $Id: wen.php 2234 2010-08-16 07:41:02Z zhanghaisong $ */

/**
 * EXCMS 我要提问
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 */ 

//加载ASK系统配置文件，移动本程序时，请修改配置文件路径
require_once ('configuration/inc/common.inc.php');
// 动作检查
switch($method){
	// 问题分类数据
	case 'categorydata' : 
		// 加载问题分类,创建问题分类AskCategory对像
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		$askcate = $askcate->getAllCateList();
		exit(EXCMS::json_print($askcate));
		break;
	default :
		// 加载问题分类,创建问题分类AskCategory对像
		include_once ASK_LIB_PATH . 'AskCategory.class.php';
		$askcate = new AskCategory();
		//导航条
		$_PAGE['position'] =  $askcate->getNavigation();	
		$_PAGE['title'] = $_GET['wd']=='' ? $_POST['wd'] : $_GET['wd'];
		include_once LIB_MODULES_PATH . 'account/User.class.php';
		$userObj = new User();
		$_PAGE['user'] = $userObj->getSession();
		if($_PAGE['user']['uid'] > 0){
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			$score_array = $score->getScoreByUid($_PAGE['user']['uid']);
			$_PAGE['user'] = array_merge($_PAGE['user'],$score_array);
		}
		unset($userObj,$askcate);
		//输出模板
		EXCMS::display('ask/wen.html');
		break;
}

// excms file end