<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		channel.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hkz@putoyo.com
 * @version $Rev: 3327 $
 */
 
 /* $Id: channel.php 3327 2010-12-30 08:57:25Z zhangxuelin $ */ 
 
 /**
  * 栏目页面显示程序
  */

// 加载系统配置文件
require_once ('configuration/inc/common.inc.php');

// 获取栏目ID
if(isset($_GET['channelid'])){
	$channelid = $_GET['channelid'];
}elseif(isset($_GET['id'])){
	$channelid = $_GET['id'];
}

// 如果启用栏目ID编码，解码栏目ID
$EXCMS_CONFIG['code_channelid'] && $channelid = EXCMS::channel_id_decode($channelid);

// 判断栏目ID是法为数字
if(!is_numeric($channelid) || !($channelid > 0)){
	EXCMS::page404('不存在的栏目');
}

// 获取交叉栏目ID
if(isset($_GET['crossid'])){
	$_PAGE['crossid'] = $EXCMS_CONFIG['code_channelid'] ? $_GET['crossid'] : EXCMS::channel_id_decode($_GET['crossid']);
}

// 获取栏目
$_PAGE_CHANNEL = EXCMS::getChannelCacheById($channelid);
!$_PAGE_CHANNEL['channelid'] && EXCMS::page404('不存在的栏目');

// 加载栏目类，获取栏目介绍
include_once LIB_PATH . 'channel/Channel.class.php';
$ch = new Channel();
$ch = $ch->getById($_PAGE_CHANNEL['_channelid'], 'body');
$_PAGE_CHANNEL['body'] = $ch['body'];
unset($ch);

// 分页（必须）
if(isset($_GET['page'])){
	$_PAGE['pageon'] = $EXCMS_CONFIG['code_page'] ? EXCMS::page_decode($_GET['page']) : $_GET['page'];
}

// 当前使用URL规则
$_PAGE['urlrule'] = array('name' => 'channel', 'usepagechannel' => 1);

// 下载模型设置
if($_PAGE_CHANNEL['modelid'] == 3){
    if(isset($_GET['orderby']) && in_array($_GET['orderby'], array('time','hot','digg','free'))){
    	$_PAGE['orderby'] = $_GET['orderby'];
    	$_PAGE['urlrule'] = array('name' => 'download.orderby','usepagechannel'=>1);
    }else if(isset($_GET['type'])){
    	$_PAGE['type'] = $_GET['type'];
    	$_PAGE['urlrule'] = array('name' => 'download.type','usepagechannel'=>1);
    }else{
    	$_PAGE['orderby'] = 'time';
    	$_PAGE['urlrule'] = array('name' => 'download.orderby','usepagechannel'=>1);
    }
}

// 检查栏目类型
switch($_PAGE_CHANNEL['type']){
    case 3 : // 目录
        header('Location: ' . $_PAGE_CHANNEL['url']);
        exit;
        break;
    case 4 : // 跳转
        header('Location:' . $_PAGE_CHANNEL['forward']);
        exit;
        break;
    case 1 : // 封面
    case 2 : // 单独页
    default : // 列表
        $tpl = $_PAGE_CHANNEL['template'];
        break;
}
// 当前位置
$_PAGE['position'] = &$_PAGE_CHANNEL['position'];

// 动态浏览标识
$_PAGE['dynamic'] = 1;

// 设置页面名称
$_PAGE['name'] = 'channel';

// 页面标签
$_PAGE['title'] = &$_PAGE_CHANNEL['title'];
$_PAGE['keywords'] = &$_PAGE_CHANNEL['keywords'];
$_PAGE['description'] = &$_PAGE_CHANNEL['description'];

// 输出页面
EXCMS::display($tpl);

// excms file's end