<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		comment.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author blaster@putoyo.com
 * @version $Rev: 146 $
 */
 
 /* $Id: comment.php 146 2009-11-10 07:58:36Z zhangxuelin $ */ 
 
 /**
  * EXCMS评论程序
  */

// 加载系统配置文件
include_once ('configuration/inc/common.inc.php');
//加载模块配置
loadModuleConfig('comment',true);
// 检查评论模块是否启用
if($EXCMS_MODULE['comment'] === false){
	EXCMS::showMessage('评论模块已禁用');
}
$params = array_merge($_GET, $_POST);

//加载评论类，创建对象
include_once LIB_MODULES_PATH . 'comment/Comment.class.php';
include_once LIB_MODULES_PATH . 'comment/CommentStat.class.php';
$commentstat = new CommentStat();
$comment = new Comment();

/**
 * 获取页面参数
 */
 
// 获取页面运作
$action = $params['act'];

// 获取内容ID
$contentid = $params['contentid'] ? $params['contentid'] : $params['id'];

// 如启用内容ID编码时，解码 
$_contentid = $EXCMS_CONFIG['code_contentid'] ? EXCMS::id_decode($contentid) : $contentid;

//获取评论ID
$commentid = $params['commentid'];

// 获取评论分页参数

if(isset($_GET['page'])){
	$_PAGE['pageon'] = $_GET['page'];
}

// 是否跨域回调
if(isset($_GET['crossDomainCallback']) && $_GET['crossDomainCallback'] != ''){
	$crossDomainCallback = trim($_GET['crossDomainCallback']);
}
switch($action){
	/**
	 * 引用评论
	 */
	case 'getquote' :
		//根据评论ID查询评论详细信息
		$rs = $comment->getById($params['id']);
		$rs['createddate'] = formatDate('Y-m-d H:i:s',$rs['createddate']);
		echo "[quote]原文由EXCMS{$rs['area']}网友[{$rs['username']}]于{$rs['createddate']}发表".chr(13)."{$rs['content']}[/quote]";
		break;
	
	/**
	 * 支持数
	 */
	case 'support' :
		$_PAGE["comment"] = $comment->getDetailById($params['id']);
		$support = $commentstat->support($_PAGE["comment"]['itemid'],'content');
		$support = $comment->support($params['id']);
		if($crossDomainCallback){
		  echo $crossDomainCallback . "(\"{$support}\")";
		}else{
		  echo $support;
		}
		break;
	
	/**
	 * 反对数
	 */
	case 'against' :
		$_PAGE["comment"] = $comment->getDetailById($params['id']);
		$against = $commentstat->against($_PAGE["comment"]['itemid'],'content');
		$against = $comment->against($params['id']);
		if($crossDomainCallback){
		  echo $crossDomainCallback . "(\"{$against}\")";
		}else{
		  echo $against;
		}
		break;
	
	/**
	 * 内容评论列表
	 */
	case 'commentlist' :
		$_PAGE_CONTENT['_contentid'] = $_contentid;
		$_PAGE_CONTENT['contentid'] = $contentid;
		if($_contentid>0){
			if($crossDomainCallback){
				ob_start();
				EXCMS::display('comment/comment_list.html');
				$comment_list = ob_get_contents();
				ob_clean();
				echo $crossDomainCallback . "(\"" . addslashes(str_replace(array(chr(13), chr(10)), '', $comment_list)) . "\")";
			}else{
				EXCMS::display('comment/comment_list.html');
			}
			
		}
		break;
	// 内容评论
	case 'contentcomment' :
		$_PAGE_CONTENT['contentid'] = $contentid;
		$_PAGE_CONTENT['_contentid'] = $_contentid;
		if($_contentid > 0){
			if($crossDomainCallback){
				ob_start();
				EXCMS::display('comment/comment_block.html');
				$comment_list = ob_get_contents();
				ob_clean();
				echo $crossDomainCallback . "(\"" . addslashes(str_replace(array(chr(13), chr(10)), '', $comment_list)) . "\")";
			}else{
				EXCMS::display('comment/comment_block.html');
			}
		}
		break;
	
	/**
	 * 加载评论配置信息
	 */
	case 'loadcommentconfig' :
		EXCMS::json_print($EXCMS_MODULE['comment']);
		break;
	/**
	 * 发表评论
	 */
	case 'submit' :
		session_start();
		//验证码
		if ($EXCMS_MODULE['comment']['verifycode'] && !EXCMS::verifycode_check($params['verifycode'])) {
			EXCMS::showMessage('验证码不正确，请重试');
		}
		// 检查内容ID
		checkContentComment($_contentid);
		
		if(trim($params['commenttext']) == ''){
			EXCMS::showMessage('评论内容不能为空');
		}
		// 获取评论数据
		$data = array();
		
		// 登录评论,禁止游客评论
		if (!$EXCMS_MODULE['comment'] ['allow_guest']) {
			// load User class and creat user object
			include_once LIB_MODULES_PATH . 'account/User.class.php';
			$userObj = new User();
			// check user logined
			if(!$userObj->isLogin()){
				EXCMS::showMessage('请登录后再评论');
				$forward = $action == 'logout' ? '' : urlencode("http://".$_SERVER['SERVER_NAME'].($_SERVER['SERVER_PORT']==80 ? '' : (':'.$_SERVER['SERVER_PORT'])).$_SERVER['REQUEST_URI']);
				header('location:' . EXCMS::url(array('name' => 'account.login','forward'=>$forward)));	
				exit;
			}else{
				$userinfo = $userObj->getSession();
				$data['uid'] = $userinfo['uid'];
				$data['username'] = $userinfo['nickname'];
			}
		}
		$data['itemid'] = $_contentid;
		$data['content'] = htmlspecialchars($params['commenttext']);
		$data['ip'] = $_SERVER['REMOTE_ADDR'];
		$data['createddate'] = time();
		// 匿名评论
		if ($EXCMS_MODULE['comment']['anonymous'] && $params['anonymous']) {
			$data['anonymous'] = 1;
		}
		
		// 隐藏IP
		if($EXCMS_MODULE['comment']['allow_hide_ip'] && $params['hideip'] == 1){
			$data['hideip'] = 1;
		}
		
		include_once LIB_PATH . 'plugins/ipquery/IpLocation.class.php';
		//所在地区
		$area = new IpLocation();
		$area = $area->getlocation($data['ip']);
		if($area['country']){
			$data['area'] = str_replace(array('省','市','区'), '', $area['country']);
			if(stripos($data['area'], '本机') === 0 || stripos($data['area'], '局域') === 0) unset($data['area']);
		}
		//隐藏所在位置
		if($EXCMS_MODULE['comment']['allow_hide_position'] && $params['hideposition'] == 1){
			$data['hideposition'] = 1;
		}
		//判断回复评论是否存在
		$replyid = (int)$params['reply'];
		if($replyid > 0){
			$replyInfo = $comment->getById($replyid);
			if(!$replyInfo){
				$replyid = 0;
			}
		}
		
		// 基于回复评论
		if($replyid > 0){
			$data['replyid'] = $replyid;
			$data['floor'] = $replyInfo['floor'] + 1;
			$lastFloor = $replyInfo['floor'] > 1 ? $replyInfo['lastfloor'] : '';
			// 检查是否隐藏IP
			$replyInfo['ip'] = $replyInfo['hideip'] ? '' : "(" . ipformat($replyInfo['ip']) . ")";
			// 检查是否匿名
			if($replyInfo['anonymous']){
				$replyInfo['username'] = '匿名网友';
			}elseif($replyInfo['uid'] > 0 || $replyInfo['username']){
				$replyInfo['username'] = '网友 [' . $replyInfo['username'] . '] ';
				unset($replyInfo['ip']);
			}else{
				$replyInfo['username'] = '网友';
			}
			// 检查是否隐藏所有位置
			if($replyInfo['hideposition']){
				$replyInfo['area'] = '';
			}
			//生成回复数据
			$data['lastfloor'] = "<div class=\"cmt_old\">" . $lastFloor . 
				"<dl class=\"cmt_old_head\">" . 
				"<dt>%%EXCMS_SITENAME%%" . $replyInfo['area'] . $replyInfo['username'] . $replyInfo['ip'] . "的原贴：</dd>" . 
				"<dd>" . $replyInfo['floor'] . "</dd></dl>" . 
				"<div class=\"cmt_old_message\">" . $replyInfo['content'] . "</div></div>";
		}
		$comment->insert($data, 'content');
		checkContentComment($_contentid);
		$data['modelid'] = $_PAGE_CONTENT['modelid'];
		$data['channelid'] = $_PAGE_CONTENT['channelid'];
		$commentstat->insert($data, 'content');
		header("Location:" . EXCMS::url(array('name' => 'comment.content', 'contentid' => $contentid)), true);
		exit;
	/**
	 * 评论封面、评论排行、精彩评论、推荐评论、内容评论
	 */
	default :
		// 内容评论
		if((is_numeric($_contentid) && $_contentid > 0) || (is_numeric($commentid) && $commentid > 0)){
			
			// 单个评论全文
			if($commentid){
				$_PAGE['comment'] = $comment->getDetailById($commentid);
				$_contentid = $_PAGE['comment']['itemid'];
			}
			// 检查
			checkContentComment($_contentid);
				// 获取评论分类参数
			$_PAGE['type'] = $params['type'];
			if(in_array($_PAGE['type'], array('hot', 'support', 'against'))){
				$_PAGE['urlrule'] = array('name' => "comment.content_{$_PAGE['type']}");
			}else{
				$_PAGE['type'] = 'all';
				$_PAGE['urlrule'] = array('name' => 'comment.content');
			}
			
			// 加载内容方法
			include_once LIB_PATH . 'update/ContentFunction.class.php';
			$_PAGE_CONTENT['url'] = ContentFunction::getContentUrl($_PAGE_CONTENT);
			$_PAGE_CONTENT['href'] = &$_PAGE_CONTENT['url'];
			$_PAGE['comment']['total'] = $comment->getCountByItemId($_contentid);;
			$_PAGE['comment']['shownum'] = $_PAGE['comment']['total'];
			EXCMS::display($commentid ? 'comment/comment_single.html' : 'comment/comment_content.html');
		}else{ // 评论封面、评论排行、精彩评论、推荐评论
			$type = $_GET['type'];
			$tpl = 'comment.html';
			if($type == 'rank'){ // 评论排行
				$_PAGE['title'] = '评论排行榜';
				$tpl = 'comment_rank.html';
				$_PAGE['rank'] = isset($_GET['rank']) && in_array($_GET['rank'], array('day', 'week', 'month', 'year', 'all')) ? $_GET['rank'] : 'week';
			}elseif($type == 'wonderful'){ // 精彩评论头条
				$_PAGE['title'] = '精彩评论头条';
				$_PAGE['recommend'] = 1;
				$tpl = 'comment_recommend.html';
				$_PAGE['urlrule'] = array('name' => 'comment.wonderful');
			}elseif($type == 'recommend'){ // 推荐评论
				$_PAGE['title'] = '推荐评论';
				$_PAGE['recommend'] = 2;
				$tpl = 'comment_recommend.html';
				$_PAGE['urlrule'] = array('name' => 'comment.recommend');
			}else{ // 评论首页
				$_PAGE['title'] = '评论';
			}
			EXCMS::display("comment/{$tpl}");
		}
		break;
}

//检查内容是否允许评论
function checkContentComment($_contentid){
	global $_PAGE_CONTENT, $_PAGE_CHANNEL, $EXCMS_CONFIG; 
	//获取内容信息
	include_once LIB_PATH . 'content/Content.class.php';
	$content = new Content();
	$_PAGE_CONTENT = $content->getById($_contentid);
	$_PAGE_CONTENT['_contentid'] = $_contentid;
	if($EXCMS_CONFIG['code_contentid']){
		$_PAGE_CONTENT['contentid'] = EXCMS::id_encode($_PAGE_CONTENT['contentid']);
	}
	unset($content);
	
	if(!$_PAGE_CONTENT){
		EXCMS::page404('内容不存在');
	}elseif (!$_PAGE_CONTENT['comment']) {
		EXCMS::page404('内容不允许评论');
	}
	
	//获取栏目信息
	//include_once LIB_PATH . 'channel/Channel.class.php';
	//$_PAGE_CHANNEL = new Channel();
	//$_PAGE_CHANNEL = $_PAGE_CHANNEL->getById($_PAGE_CONTENT['channelid']);

	if (!($_PAGE_CHANNEL['comment'] > 0)){
		//exit('内容所有栏目不允许评论');
	}
	
	/*
	//检查是否需要登录才能评论
	if (! ($EXCMS_MODULE['comment']['allow_guest'] > 0) && ! ($_SESSION['uid'] > 0)) {
		EXCMS::showMessage('请登录后再评论');
	}
	*/
}

// excms file's end