<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		global.inc.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author $Author: zhanghaisong $
 * @version $Rev: 3557 $
 */
/* $Id: global.func.php 3557 2011-01-11 03:12:55Z zhanghaisong $ */
/**
 * EXCMS 通用函数
 */
/**
 * EXCMS debug类，记录测试时间和sql查询
 * @author hukuizhi
 *
 */
class Debug{
	static $debug_time = 0;
	static $debug_memory = 0;
	static $debug_queries = 0;
	static $debug_query_time = 0;
	static $time = 0;
	static $debug_fetch_time = 0;
}
/**
 * 调试方法，记录测试时间和sql查询
 * @return true
 */
function debug(){
	Debug::$debug_time = processedIn();
	Debug::$debug_memory = processedMemory();
	Debug::$debug_queries = $GLOBALS['db']->querynum;
	Debug::$debug_query_time = number_format($GLOBALS['db']->querytime, 8);
	Debug::$debug_fetch_time = number_format($GLOBALS['db']->fetchtime, 8);
	return true;
}
/**
 * 获取(调试)程序处理时间
 * @return float
 */
function processedIn(){
	$startTime = explode(' ', EXCMS_TIME_START);
	$endTime = explode(' ', microtime());
	return number_format(($endTime[1] + $endTime[0] - $startTime[1] - $startTime[0]), 6);
}
/**
 * 获取(调试)程序处理时间
 * @return float
 */
function processedMemory(){
	return round((memory_get_peak_usage() - EXCMS_MEMORY_START) / 1024, 1);
}
/**
 * 显示调试信息(程序执行时间各sql执行时间)
 * @param bool $return true直接输出，false返回调试信息字符串(default) 
 * @return string
 */
function displayDebugInfo($return = false){
	global $EXCMS_CONFIG;
	if(!$EXCMS_CONFIG['debug_mode']) return;
	debug();
	//	$re = "Processed in ".Debug::$debug_time." second(s), ".Debug::$debug_queries." queries takes ".Debug::$debug_query_time." second(s).";//.Debug::$debug_fetch_time;
	
	$re = "<font style=\"font-size:11px\">Processed in " . round(Debug::$debug_time, 6) . " second(s), " . Debug::$debug_queries . " queries takes " . round(Debug::$debug_query_time, 6) . " second(s), memory:" . Debug::$debug_memory . 'KB.</font>'; //.Debug::$debug_fetch_time;
	if($return){
		return $re;
	}
	echo "<div style=\"text-align:center;color:#999;font-size:11px;font-family:Arial;\">{$re}</div><pre>";
}
/**
 * 获取精确时间
 * @return string
 */
function microtime_float(){
	list($u, $s) = explode(" ", microtime());
	return ((float)$u + (float)$s);
}
/**
 * 使用反斜线引用字符串
 * @param array | string $v
 * @return array | string
 */
function addslashes_deep($v){
	return is_array($v) ? array_map('addslashes_deep', $v) : addslashes($v);
}
/**
 * 将中文转化为区位码
 *
 * @param string $str 
 * @return string
 */
function convertToAscii($str){
	$s = trim($str);
	if($str != ''){
		$leng = strlen($s);
		$str = "";
		$reg = "/^[" . chr(0xa1) . "-" . chr(0xff) . "]+$/";
		if(CHARSET == JSON_CHARSET){
			$s = EXCMS::iconv_all('UTF-8', 'GBK', $s);
		}
		for($i = 0; $i < $leng; $i++){
			if(preg_match($reg, $s[$i])){
				$str .= sprintf("%02d%02d", ord($s[$i]) - 160, ord($s[++$i]) - 160);
			}else{
				$str .= $s[$i];
			}
		}
		if(CHARSET == JSON_CHARSET){
			$s = EXCMS::iconv_all('GBK', 'UTF-8', $str);
		}
	}
	return $str;
}
/**
 * 跳转链接方法
 * @param string $url
 */
function goUrl($url){
	echo "<script language=javascript>location.href=\"" . $url . "\"</script>";
}
/**
 * file_put_contents
 */
if(!function_exists('file_put_contents')){
	define('FILE_APPEND', 8);
	/**
	 * 写文件
	 *
	 * @param string $file 待写入的文件
	 * @param string $data 待写入的数据
	 * @param string $append 写入方式 默认wb否则ab
	 * @return int 文件大小
	 */
	function file_put_contents($file, $data, $append = ''){
		$mode = $append == '' ? 'wb' : 'ab';
		$fp = @fopen($file, 'wb') or exit("不能打开文件 $file !");
		flock($fp, LOCK_EX);
		$len = @fwrite($fp, $data);
		flock($fp, LOCK_UN);
		@fclose($fp);
		return $len;
	}
}
if(!function_exists('mb_strpos')){
	function mb_strpos($str, $needle, $offset = 0, $charset = ''){
		$arr = preg_split("/$needle/", $str);
		if(1 == sizeof($arr)) $pos = false;
		else{
			if(0 == $offset) $pos = mb_strlen($arr[0]);
			elseif($offset >= mb_strlen($str)) $pos = false;
			else{
				$sstr = mb_substr($str, $offset);
				if(mb_strpos($sstr, $needle) === false) $pos = false;
				else $pos = $offset + mb_strpos($sstr, $needle);
			}
		}
		return $pos;
	}
	function mb_strlen($str){
		preg_match_all("/[\\x80-\\xff]?./", $str, $arr);
		return sizeof($arr[0]);
	}
	function mb_substr($str, $start, $len = -1){
		preg_match_all("/[\\x80-\\xff]?./", $str, $arr);
		$len == -1 && $len = sizeof($arr[0]) - $start;
		return @implode(array_slice($arr[0], $start, $len), '');
	}
}
/**
 * 重定向
 *
 * @param string $url 重定向URL
 * @param int $time 暂停时间
 * @param null|string $msg 显示的消息
 */
function redirect($url, $time = 0, $msg = ''){
	//多行URL地址支持
	$url = str_replace(array("\n", "\r"), '', $url);
	if(empty($msg)){
		$msg = "系统将在{$time}秒之后自动跳转到{$url}！";
	}
	if(!headers_sent()){
		// redirect
		if(0 === $time){
			header("Location: " . $url);
		}else{
			header("refresh:{$time};url={$url}");
			EXCMS::showMessage($msg);
		}
		exit();
	}else{
		$str = "<meta http-equiv='Refresh' content='{$time};URL={$url}'>";
		if($time != 0){
			$str .= $msg;
		}
		exit($str);
	}
}
/**
 * 格式化文本域内容，替换空格和换行
 *
 * @param string $string
 * @return string
 */
function format_textarea($string){
	return nl2br(str_replace(' ', '&nbsp;', htmlspecialchars($string)));
}
/**
 * 将整数转化成存储大小Bytes,KB,MB,GB
 *
 * @param int $filesize 文件大小
 * @return string
 */
function sizecount($filesize, $type = ''){
	if($type == 'MB'){
		$filesize = $filesize * 1048576;
	}else if($type == 'KB'){
		$filesize = $filesize * 1024;
	}
	if($filesize > 0){
		if($filesize >= 1073741824){
			$filesize = round($filesize / 1073741824 * 100) / 100 . 'GB';
		}elseif($filesize >= 1048576){
			$filesize = round($filesize / 1048576 * 100) / 100 . 'MB';
		}elseif($filesize >= 1024){
			$filesize = round($filesize / 1024 * 100) / 100 . 'KB';
		}else{
			$filesize = $filesize . 'B';
		}
	}else
		$filesize = '未知';
	return $filesize;
}
/**
 * 将事件格式化成'天前'，'小时前'，'分钟前'，'秒前'或指定格式时间
 *
 * @param int $time 时间，秒
 * @param string $dateformat='Y-m-d H:i:s'
 * @return string
 */
function timeformat($time, $dateformat = 'Y-m-d H:i:s'){
	$now = time();
	$t = $now - $time;
	$t = $t == 0 ? 1 : $t;
	if(formatDate('Y', $now) != formatDate('Y', $time)){
		$time = formatDate('Y年m月d日', $time);
	}elseif($t >= 60 * 60 * 24 * 3){
		$time = formatDate($dateformat, $time);
	}elseif($t >= 60 * 60 * 24){
		$time = floor($t / (60 * 60 * 24)) . '天前';
	}elseif($t >= 60 * 60){
		$time = floor($t / (60 * 60)) . '小时前';
	}elseif($t >= 60){
		$time = round($t / 60) . '分钟前';
	}else{
		$time = $t . '秒前';
	}
	return $time;
}
/**
 * 将给定时间戳转换成日期格式
 *
 * @param int $mktime 时间戳
 * @return string 
 */
function GetDateMk($mktime){
	global $EXCMS_CONFIG;
	$cli_time = $EXCMS_CONFIG["cli_time"];
	if($mktime == "" || ereg("[^0-9]", $mktime)) return "";
	return gmdate("Y-m-d", $mktime + 3600 * (int)$cli_time);
}
/**
 * 获取中文字符串的拼音
 *
 * @param string $str 中文字符串
 * @param int $type 0全拼，1简拼，2首字全拼其余简拼 ，3仅取拼音首字母
 * 
 * @return string
 */
function pinyin($str, $type = 0){
	include_once LIB_PATH . 'util/Pinyin.class.php';
	$pinyin = new Pinyin();
	return $pinyin->getPinyin($str, $type);
}
/**
 * 格式化时间
 *
 * @param string $format 时间格式
 * @param int $timest 时间戳
 * @return string
 */
function formatDate($format = 'Y-m-d H:i:s', $timest = 0){
	global $EXCMS_CONFIG;
	$cli_time = $EXCMS_CONFIG['cli_time'];
	$addtime = $cli_time * 3600;
	if(empty($format)) $format = 'Y-m-d H:i:s';
	$timest = $timest > 0 ? $timest : time();
	return gmdate($format, $timest + $addtime);
}
function get_formatted_timediff($then, $now = false){
	define('INT_SECOND',	1);
	define('INT_MINUTE',	60);
	define('INT_HOUR',		3600);
	define('INT_DAY',		86400);
	define('INT_WEEK',		604800);
	!$now && $now = time();
	$timediff = ($then - $now);
	$days = intval($timediff / INT_DAY);
	$timediff = intval($timediff - (INT_DAY * $days));
	$hours = intval($timediff / INT_HOUR);
	$timediff = intval($timediff - (INT_HOUR * $hours));
	$mins = intval($timediff / INT_MINUTE);
	$timediff = intval($timediff - (INT_MINUTE * $mins));
	$sec = intval($timediff / INT_SECOND);
	$timediff = intval($timediff - ($sec * INT_SECOND));
	$str = '';
	$days > 0 && $str .= intval($days) . '天';
	$hours > 0 && $str .= intval($hours) . '小时';
	$mins > 0 && $str .= intval($mins) . '分钟';
	$sec > 0 && $str .= intval($sec) . '秒';
	/*if ( !$weeks && !$days && !$hours && !$mins && !$sec )
    {
        $str .= '已到时';
    }
    else
    {
        $str .= '以前';
    }*/
	return $str;
}
/**
 * 中文字符串截取函数，支持 GBK, GB2312, UTF8
 * 一个中文汉字代表2个字符
 * @param string $str 源字符串
 * @param int $length 截取长度
 * @param int $start 其实位置
 * @return string
 */
function csubstr($str, $length, $start = 0, $suffix = true){
	if($length < 1) return '';
	if($start < 0) $start = 0;
	$str_len = strlen($str);
	if($str_len <= $start) return '';
	$slice = '';
	if($str_len < $start + $length || $length == 0) $length = $str_len - $start;
	$i = $k = 0;
	$add = CHARSET == JSON_CHARSET ? 2 : 1;
	while($length > 0 && $i <= $str_len){
		if(ord($str[$i]) > 127){
			if($k >= $start){
				if($str_len > $i + $add && $length > $add){
					$slice .= $add > 1 ? $str[$i] . $str[$i + 1] . $str[$i + 2] : $str[$i] . $str[$i + 1];
					$length -= 2;
				}else{
					break;
				}
			}
			$k += 2;
			$i += $add + 1;
		}else{
			if($k >= $start){
				$slice .= $str[$i];
				$length--;
			}
			$i++;
			$k++;
		}
	}
	$suffix_str = '<font style="font-family:Tahoma">…</font>';
	if($suffix === false || $suffix == 'false' || $suffix == '' || $suffix == 0){
		$suffix = false;
	}elseif($suffix === true || $suffix == 'true' || $suffix == 1){
		$suffix = true;
	}else{
		$suffix_str = $suffix;
	}
	return $suffix && $i < ($str_len - 1) ? $slice . $suffix_str : $slice;
}
/**
 * high light words
 * @param string $str 字符串
 * @param string $word 关键字
 * @param int $length 是否需要截取长度
 * @return string
 */
function highLightWords($str, $word, $length = 0){
	if($length > 0) $str = csubstr($str, $length);
	if(!$word) return $str;
	$words = explode(' ', trim($word));
	$i = 0;
	foreach($words as $k => $v){
		if($word == '') unset($words[$k]);
		$i++;
	}
	if($i == 0) return $str;
	$pattern = "/(" . implode('|', $words) . ")/i";
	return preg_replace($pattern, "<font color=\"red\">\\1</font>", $str);
}
/**
 * URL格式标准化
 * @param $url
 * @return string
 */
function urlFormat($url){
	$url = preg_replace("/(\\/+\\.\\/+)|(\\/+)|(\\\\+)/", "/", $url);
	return str_replace('http:/', 'http://', $url);
}
/**
 * 文本转HTML
 * @param string $txt
 * @return string
 */
function text2Html($txt){
	$txt = str_replace("  ", "　", $txt);
	$txt = str_replace("<", "&lt;", $txt);
	$txt = str_replace(">", "&gt;", $txt);
	$txt = preg_replace("/[\r\n]{1,}/isU", "<br/>\r\n", $txt);
	return $txt;
}
/**
 * 获得HTML里的文本
 * @param string $str
 * @return string
 */
function html2Text($str){
	$str = preg_replace("/<sty(.*)\\/style>|<scr(.*)\\/script>|<!--(.*)-->/isU", '', $str);
	$str = str_replace(array('<br />', '<br>', '<br/>'), "\n", $str);
	$str = strip_tags($str);
	return $str;
}
/**
 * 清除HTML标记
 * @param string $str
 * @return string
 */
function clearHtml($str){
	$str = html2Text($str);
	$str = str_replace('<', '&lt;', $str);
	$str = str_replace('>', '&gt;', $str);
	return $str;
}
/**
 * 字段内容不为空是连接组合
 *
 *@param string $start 前缀
 *@param string $field 字段值
 *@param string $end 后缀
 *@return string
 */
function notEmptyJoin($start = '', $field = '', $end = ''){
	if(empty($field)) return '';
	return $start . $field . $end;
}
/**
 * 格式化逗号字符串
 *
 * @param string $str
 * @param bool $space 是否将空格转换成逗号
 * @return string
 */
function formatCommaStr($str, $space = true){
	if($space){
		$str = str_replace(array('，', '　'), ',', trim($str));
		$str = preg_replace("/[, \040]{1,}/", ',', $str);
	}else{
		$str = str_replace('，', ',', trim($str));
		$str = preg_replace("/[,]{1,}/", ',', $str);
	}
	substr($str, 0, 1) == ',' && $str = substr($str, 1);
	substr($str, -1, 1) == ',' && $str = substr($str, 0, -1);
	return trim($str);
}
function mysql_filter_string($str){
	return mysql_escape_string($str);
}
/**
 * 格式化空格隔开字符串
 *
 * @param string $str
 * @return string
 */
function formatSpaceSplitStr($str){
	return trim(preg_replace("/[\040]{2,}/", " ", str_replace(array(',', '，', '　'), ' ', trim($str))));
}
/**
 * 将逗号隔开字符串转化成数组，并按需求去除重复
 *
 * @param string $str
 * @param boolean $unique 是否去除重复值
 * @return array
 */
function convertCommaStrToArray($str, $unique = false){
	$str = formatCommaStr($str);
	if(empty($str)) return array();
	$str = explode(',', $str);
	return $unique ? array_unique($str) : $str;
}
/**
 * 从链接中获取文本
 *
 * @param string $str 链接
 * @return array
 */
function clearLink($str){
	preg_match_all('/<a\s*[^>]*href=["|\']?([^>"\' ]+)["|\']?\s*[^>]*>([^>]+)<\/a>/i', $str, $v);
	return $v[2][0];
}
/**
 * 从html文本中提取所有非空(链接url和文本都不能为空)超链接url
 *
 * @param string $html html文本
 * @return array
 */
function getAllLinks($html){
	preg_match_all("'<\s*a\s.*?href\s*=\s*([\"\'])?(?(1)(.*?)\\1|([^\s\>]+))[^>]*>?(.*?)</a>'isx", stripslashes($html), $match);
	$links = array();
	while(list($k, $v) = each($match[4])){
		$v = trim($v);
		if(!empty($v)){
			$url = trim($match[2][$k]);
			empty($url) && $url = trim($match[3][$k]);
			!empty($url) && $links[] = array('txt' => $v, 'url' => $url);
		}
	}
	return $links;
}
/**
 * 格式化ip字符串
 * @param string $ip
 * @return string
 */
function ipformat($ip){
	return preg_replace("/\d+\.\d+$/i", '*.*', $ip);
}
/**
 * 将相对地址处理成全地址)
 * @param $url
 */
function full_url($url){
	strpos($url, "http://") === false && $url = urlFormat($GLOBALS['EXCMS_CONFIG']['domain'] . $url);
	return $url;
}
/**
 * 相对路径
 */
function getRelativePath($path, $basedir = SITE_PATH){
	$p = urlFormat($path);
	$d = urlFormat($basedir);
	return stripos($p, $d) === 0 ? substr($p, strlen($d)) : (stripos($d, $p) === 0 ? '' : $p);
}
/**
 * 检查目录是否可写
 *
 * @param string $file 文件名
 * @param string $postfix 后缀
 * @return string
 */
function writeable($d){
	$w = 0;
	!is_dir($d) && mkdir($d, 0777);
	if(is_dir($d)){
		$f = "{$d}/excms.txt";
		if($fp = fopen($f, 'w')){
			fclose($fp);
			unlink($f);
			$w = 1;
		}
	}
	return $w;
}
/**
 * 添加后缀
 *
 * @param string $file 文件名
 * @param string $postfix 后缀
 * @return string
 */
function addFilePostfix($file, $postfix, $con = '_'){
	if(empty($postfix)) return $file;
	$pos = strrpos($file, '.');
	$postfix = $con . $postfix;
	if($pos){
		$file = substr($file, 0, $pos) . $postfix . substr($file, $pos);
	}else{
		$file .= $postfix;
	}
	return $file;
}
/**
 * 添加前缀
 *
 * @param string $file 文件名
 * @param string $prefix 前缀
 * @return string
 */
function addFilePrefix($file, $prefix){
	if($prefix == '') return $file;
	$file = str_replace('\\', '/', $file);
	$pos = strrpos($file, '/');
	if($pos !== false){
		$file = substr($file, 0, $pos + 1) . $prefix . '_' . substr($file, $pos + 1);
	}else{
		$file = $prefix . '_' . $file;
	}
	return $file;
}
if(file_exists(INC_PATH . 'debug.func.php')){
	include_once INC_PATH . 'debug.func.php';
}

// excms file's end