<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		Contentid.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package update
 * @author $Author: zhanghaisong $
 * @version $Rev: 404 $
 */
/* $Id: ListBase.class.php 404 2009-12-22 10:12:08Z zhanghaisong $ */
/**
 * EXCMS 内容ID处理类
 * 
 * @category EXCMS
 * @package template
 * @author $Author: zhanghaisong $
 */
class Contentid{
	/**
	 * 内容数据主表
	 *
	 * @access private
	 * @var string
	 */
	protected $table = 'contents';
	/**
	 * 提取特定文档列表（文档ID）
	 *
	 * @var string
	 */
	var $id;
	/**
	 * 当前处理的字段
	 *
	 * @var string
	 */
	var $item;
	var $type;
	/**
	 * 需要格式化的字段，包含数据表字段和非数据表字段
	 * @var array
	 */
	var $toFormate = array('channel', 'href', 'url', 'arctitle', 'thumb');
	/**
	 * 当前Contentid对像
	 *
	 * @var ContentList
	 */
	private static $instance;
	/**
	 * 构造函数
	 *
	 */
	public function __construct(){
		$this->table = TABLE_PREFIX . $this->table;
	}
	/**
	 * 兼容PHP4构造函数
	 *
	 */
	public function Contentid(){
		$this->__construct();
	}
	/**
	 * 创建Contentid对像
	 *
	 * @return Contentid
	 */
	public static function create(){
		if(self::$instance == null){
			self::$instance = new Contentid();
		}
		return self::$instance;
	}
	/**
	 * 根据内容ID获取内容数据
	 *
	 * @param $contentid 内容ID
	 * @param $channelid 栏目ID
	 * @param $model 模型ID
	 * @param $type 类型  
	 * @return array
	 */
	public function getContent($contentid, $type = null, $channelid = null, $model = null, $image = null){
		if($type == 'pre' || $type == 'prev' || $type == 'next'){
			$where = '';
			$contentid = (int)$contentid;
			$contentid < 1 && throw_exception('LACK_CONTENT_ID');
			$channelid = (int)$channelid;
			$channelid > 0 && $where = "`channelid` = '{$channelid}' AND ";
			if($model){
				switch($model){
					case 'article' :
						$model = 1;
						break;
					case 'image' :
						$model = 2;
						break;
					case 'download' :
						$model = 3;
						break;
					case 'video' :
						$model = 4;
						break;
					default :
						$model = (int)$model;
						break;
				}
				$model > 0 && $where .= "`modelid` = '{$model}' AND ";
			}
			$image && $where .= "`isthumb` = '1' AND ";
			$type = $type == 'next' ? "> '{$contentid}'" : "< '{$contentid}' ORDER BY `contentid` DESC";
			$sql = "SELECT * FROM `{$this->table}` WHERE {$where}`checked` = '1' AND `contentid` {$type} LIMIT 1";
		}else{
			$ids = EXCMS::array_trim_rmnull_unique(explode(',', $contentid));
			$t = count($ids);
			if($t){
				$ids = $t > 1 ? "IN ('" . implode("','", $ids) . "')" : "= '{$ids[0]}'";
			}else{
				if($GLOBALS['_PAGE_CONTENT']['_contentid']){
					$t = 1;
					$ids = "= '{$GLOBALS['_PAGE_CONTENT']['_contentid']}'";
				}else
					return null;
			}
			$sql = "SELECT * FROM `{$this->table}` WHERE `contentid` {$ids} LIMIT {$t}";
		}
		$GLOBALS['db']->query($sql);
		$data = $GLOBALS['db']->fetchAll();
		if(is_array($data) && count($data)){
			// 格式化内容
			$data = ContentFunction::formate($data, $this->toFormate);
			return array('from' => $data);
		}else
			return null;
	}
}