<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		digg.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author $Author: zhangxuelin $
 * @version $Rev: 3408 $
 */
/* $Id: digg.php 3408 2011-01-07 04:42:32Z zhangxuelin $ */
/**
 * Digg 关注排行
 */
//加载系统配置文件，移动本程序时，请修改配置文件路径
require_once 'configuration/inc/common.inc.php';

// 关注列表类型
$digg_type = array('day' => '21小时关注排行', 'week' => '本周关注排行', 'month' => '本月关注排行', 'year' => '本年关注排行', 'all' => '关注总排行');

// 获取当前类型
$_PAGE['type'] = $_GET['type'];
if(!isset($_PAGE['type']) || !in_array($_PAGE['type'], array_keys($digg_type))){
	$_PAGE['type'] = '';
}
// 是否AJAX请求

$IS_AJAX_REQUEST = false;
// 分页（必须）
isset($_GET['page']) && $_PAGE['pageon'] = $EXCMS_CONFIG['code_page'] ? EXCMS::page_decode($_GET['page']) : $_GET['page'];

// 获取栏目ID
$channelid = $EXCMS_CONFIG['code_channelid'] ? EXCMS::channel_id_decode($_GET['channelid']) : $_GET['channelid'];

// 当前栏目
if(is_numeric($channelid) && $channelid > 0){
	$_PAGE_CHANNEL = EXCMS::getChannelCacheById($channelid);
	if($_PAGE_CHANNEL['_channelid']){
		$_PAGE['title'] = $_PAGE_CHANNEL['name'];
		include_once LIB_PATH . 'update/ChannelFunction.class.php';
		$position = ChannelFunction::getNavigation($_PAGE_CHANNEL['_channelid']);
		if($_PAGE_CHANNEL['modelid'] == 2){
			$_PAGE['model'] = 'image';
		}elseif($_PAGE_CHANNEL['modelid'] == 4){
			$_PAGE['model'] = 'video';
		}
	}
}else{ // 设置页面模型
	isset($_GET['model']) && $_PAGE['model'] = $_GET['model'];
	if($_PAGE['model']){
		$_PAGE['title'] = '';
		switch($_PAGE['model']){
			case 'image' :
				$_PAGE['title'] = '图片';
				break;
			case 'download' :
				$_PAGE['title'] = '下载';
				break;
			case 'video' :
				$_PAGE['title'] = '视频';
				break;
			default :
				$_PAGE['model'] = '';
				break;
		}
	}
}

// 当前使用URL规则
$_PAGE['urlrule'] = array('name' => 'digg', 'type' => $_PAGE['type']);
$_PAGE_CHANNEL['_channelid'] && $_PAGE['urlrule']['channelid'] = $_PAGE_CHANNEL['_channelid'];

// 页面字段
$_PAGE['name'] = 'digg';
$_PAGE['title'] .= $_PAGE['type'] ? $digg_type[$_PAGE['type']] : '最新关注';
$_PAGE['keywords'] = $digg_type[$_PAGE['type']] . ',' . $_PAGE_CHANNEL['keywords'];
$_PAGE['description'] = $digg_type[$_PAGE['type']] . ' ' . $_PAGE_CHANNEL['description'];

// 当前位置
$_PAGE['position'] = EXCMS::position_join($position, '关注');

// 输出
EXCMS::display('digg.html');

// excms file's end