<?php

/**
 * Project:		EXCMS: the PHP content management system.
 * File:		index.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author zhangxuelin@putoyo.com
 * @version $Rev: 3668 $
 */
/* $Id: index.php 3668 2011-01-22 08:51:06Z zhanghaisong $ */

/**
 * EXCMS 安装程序
 */

// 变更环境变量
error_reporting(E_ALL || ~E_NOTICE);

//版本号
define('EXCMS_VERSION', '2011');
define('CHARSET', 'UTF-8');
define('SQL_CHARSET', 'utf8');
define('EXCMS_ROOT', dirname(dirname(__FILE__)).'/');
header("Content-Type: text/html; charset=" . CHARSET);

$step = isset($_GET['step']) ? (int)$_GET['step'] : 0;
$step = $step > 0 && $step < 8 ? $step : 0;

//安装步骤
$step_params = array(
	0=>array('title'=>"安装"),
	1=>array('title'=>"欢迎",'preText'=>'不同意','nextText'=>'同意'),
	2=>array('title'=>"安装检查"),
	3=>array('title'=>"系统配置"),
	4=>array('title'=>"创建配置文件"),
	5=>array('title'=>"安装选项"),
	6=>array('title'=>"数据库生成"),
	7=>array('title'=>"安装成功 ",'nextText'=>'完成')
);

$system_module = array(
	'account' => array('name'=>'账户中心','path'=>'account','version'=>'1.0'),
	'search' => array('name'=>'搜索','path'=>'search','version'=>'1.0'),
	'comment' => array('name'=>'评论','path'=>'comment','version'=>'1.0'),
	'digg' => array('name'=>'顶踩','path'=>'digg','version'=>'1.0'),
	'click' => array('name'=>'点击','path'=>'click','version'=>'1.0'),
	'mood' => array('name'=>'心情','path'=>'mood','version'=>'1.0'),
	'download' => array('name'=>'下载','path'=>'download','version'=>'1.0'),
	'link' => array('name'=>'友情链接','path'=>'link','version'=>'1.0')
);
$other_module = array(
	'ask' => array('name'=>'问答','path'=>'./ask','extend'=>'ask/install/extaction.inc.php','sql'=>'ask/install/mysql.sql','version'=>'1.0'),
	'ads' => array('name'=>'广告','path'=>'./apps/ads','extend'=>'apps/ads/install/extaction.inc.php','sql'=>'apps/ads/install/mysql.sql','version'=>'1.0'),
	'ucenter' => array('name'=>'Ucenter','path'=>'./apps/ucenter','extend'=>'apps/ucenter/install/extaction.inc.php','sql'=>'','version'=>'1.0'),
	'rating' => array('name'=>'评分','path'=>'./apps/rating','extend'=>'apps/rating/install/extaction.inc.php','sql'=>'apps/rating/install/mysql.sql','version'=>'1.0')
);
//演示数据
$demo_data = 'EXCMS_DEMO.sql';
//文件或文件夹变量
$dirfile_params = array(
	'cache' => array('type' => 'dir', 'path' => './sitedata'),
	'config' => array('type' => 'file', 'path' => './sitedata/config.inc.php'),
); 

if(file_exists(EXCMS_ROOT . $dirfile_params['config']['path']) && $step < 4){
	exit("<title>EXCMS 警告</title>
		 <div style='font-size:12px;line-height:150%;'><font color='red' style='font-size:14px'>警告，您已经安装过EXCMS。</font><br/>
		为了保证您网站的数据安全，请立即手动删除 install/index.php 文件。<br/>
		如果您想重新安装 EXCMS，请先删除 {$dirfile_params['config']['path']} 文件，再次运行本安装文件。</font>");
}

//检测目录是否可写
function writeable($d){
	$writeable = 0;
	if(!is_dir($d)) {
		mkdir($d, 0777);
	}
	if(is_dir($d)) {
		if($fp = fopen("$d/excmstest.txt", 'w')) {
			fclose($fp);
			unlink("$d/excmstest.txt");
			$writeable = 1;
		}
	}
	return $writeable;
}

//创建配置文件
function writeConfig ($data,$flag=true,$file = ""){
	if($file == "") {
		global $dirfile_params;
		$file = EXCMS_ROOT.$dirfile_params['config']['path'];
	}
	$rs = "<?php \n";
	if($flag){
		if (is_array($data)) {
			foreach ($data as $k=>$v) {
				$rs .= "\$$k='$v';\n";
			}
		}
	}else{
		$rs .= "return ";
		$rs .= var_export($data, true).";";
	}
	$rs .= "?>";
	$fp = fopen($file,'w') or exit("不能打开文件". $file." !");
	flock($fp, LOCK_EX);
	fwrite($fp, $rs);
	flock($fp, LOCK_UN);
	fclose($fp);
}

//数据库服务器访问检查及创建数据库
function checkDatabase(&$config) {
	//连接数据库服务器
	$conn = @mysql_connect($config['db_host'], $config['db_username'], $config['db_password']);
	
	//连接数据库服务器失败
	if($conn){
		//选择数据库
		if(!mysql_select_db ($config['db_name'], $conn)){
			if($config['createdb']) { //连接数据库服务器并创建数据库
				//用root用户连接数据库
				$root = false;
				if(!empty($config['db_root'])){
					$root = true;
					mysql_close($conn);
					$conn = mysql_connect($config['db_host'], $config['db_root'], $config['db_rootpwd']);
				}
				
				if($conn){
					//创建数据库SQL
					$sql = "CREATE DATABASE IF NOT EXISTS `{$config['db_name']}`";
					
					if (mysql_get_server_info() > '4.1') {
						$serverset = '';
						if($config['db_charset']){
							$serverset = "character_set_connection='{$config['db_charset']}',character_set_results='{$config['db_charset']}',character_set_client=binary";
						}
						$serverset .= mysql_get_server_info() > '5.0.1' ? ((empty($serverset) ? '' : ',') . " sql_mode='' ") : '';
						$serverset && mysql_query("SET {$serverset}", $conn);

						$sql .= " DEFAULT CHARACTER SET {$config['db_charset']}";
					}
					//创建数据库
					if(!mysql_query($sql, $conn)){
						$r = $root ? "Root" : "";
						$u = $root ? $config['db_root'] : $config['db_username'];
						$msg = "创建数据库失败！<br>{$r}用户“{$u}”没有权限创建数据库。";
					}	
				}else{
					switch(mysql_errno()){
						case 1044 : $msg = "用户“{$config['db_root']}”没有访问数据库的权限！";break;
						case 1045 : $msg = "不能连接数据库，Root用户名或密码错误！";break;
						default : $msg = "连接数据库服务器 {$config['db_host']} 失败！";break;
					}
				}
			}else{
				$msg = "选择数据库“{$config['db_name']}”失败！<br>用户“{$config['db_username']}”没有权限读取该数据库。";
			}
		}
	}else{
		switch(mysql_errno()){
			case 1044 : $msg = "用户“{$config['db_username']}”没有访问数据库的权限！";break;
			case 1045 : $msg = "不能连接数据库，用户名或密码错误！";break;
			default : $msg = "连接数据库服务器 {$config['db_host']} 失败！";break;
		}
	}
	return $msg ? "<font color=\"red\">{$msg}</font>" : FALSE;
}

//创建EXCMS数据库
function runquery(&$config) {
	//连接数据库服务器
	$conn = mysql_connect($config['db_host'], $config['db_username'], $config['db_password']) or die("Could not connect: " . mysql_error());
	
	//选择数据库
	if(!mysql_select_db($config['db_name'], $conn)){
		echo "不存在的数据库，请退出安装程序并删除 configuration/inc/config.inc.php 文件重新安装本系统！";
	}
	
	mysql_query("SET NAMES '".SQL_CHARSET."'");
	
	$return = array();
	
	$excms_database_struct = 'EXCMS.sql';
	//读取EXCMS数据库结构
	if(!file_exists($excms_database_struct)){
		echo '<script language="javascript">showSqlMsg(\'读取 EXCMS 数据库结构文件“EXCMS.sql”失败，请检查 install 文件夹中是否存在该文件！<br>提示：如果该文件不存在请从安装包中文件夹 upload/install 下复制该文件到 intall 文件夹中。\');</script>';
		return ;
	}
	
	$sql = file_get_contents("EXCMS.sql");
	if(!isset($sql) || empty($sql)) return;
	//更新站点配置信息
	$sql = trim($sql);
	$sql .= "\n\nINSERT INTO `{$config['db_prefix']}admin`(`adminname`,`password`,`fullname`,`status`,`createddate`) VALUES('{$config['adminuser']}','".md5($config['adminpwd'])."','超级管理员','1',".time().");";
	$sql .= "\n\nINSERT INTO `{$config['db_prefix']}admin_relate`(`adminid`,`groupid`) VALUES('".mysql_insert_id()."','1');";
	$sql .= "\n\nUPDATE `{$config['db_prefix']}system_config` SET `value`='{$config['sitename']}' WHERE `name`='sitename';";
	$sql .= "\n\nUPDATE `{$config['db_prefix']}system_config` SET `value`='{$config['domain']}' WHERE `name`='domain';";
	$sql .= "\n\nUPDATE `{$config['db_prefix']}system_config` SET `value`='{$config['title']}' WHERE `name`='title';";
	$sql .= "\n\nUPDATE `{$config['db_prefix']}publishing_point` SET `url`='{$config['domain']}' WHERE `id`='1';";
	$sql .= "\n\nUPDATE `{$config['db_prefix']}publishing_point` SET `url`='{$config['domain']}/html' WHERE `id`='2';";
	
	if($config['enableidencryptcode'] == 1){
		$sql .= "\n\nUPDATE `{$config['db_prefix']}system_config` SET `value`='{$config['idencryptcode']}' WHERE `name`='id_code_key';";
		if($config['idencrypt_channel'] == 1){
			$sql .= "\n\nUPDATE `{$config['db_prefix']}system_config` SET `value`='1' WHERE `name`='code_channelid';";
		}
		if($config['idencrypt_content'] == 2){
			$sql .= "\n\nUPDATE `{$config['db_prefix']}system_config` SET `value`='1' WHERE `name`='code_contentid';";
		}
		if($config['idencrypt_page'] == 3){
			$sql .= "\n\nUPDATE `{$config['db_prefix']}system_config` SET `value`='1' WHERE `name`='code_page';";
		}
	}
	//安装模块
	$modules = $_POST['modules'];
	global $other_module;
	if(is_array($modules) && count($modules) > 0){
		foreach ($other_module as $key=>$value){
			if(in_array($key,$modules)){
				if($value['sql']!='' && file_exists(EXCMS_ROOT.$value['sql'])){
					$modules_sql = file_get_contents(EXCMS_ROOT.$value['sql']);
					if(!isset($modules_sql) || empty($modules_sql)) continue;
					$sql .= "\n\n".$modules_sql;
				}
				$data = array('moduleid' => $key, 'name' => $value['name'], 'path' => trim($value['path']), 'url' => trim($value['path']), 'version' => $value['version'], 'author' => 'EXCMS 团队', 'site' => 'www.excms.cn', 'email' => 'service@excms.cn', 'description' => $value['name'].'模块', 
				'license' => '', 'help' => '/help/help.html',  'disabled' => 1, 'isdisplaytop' => 1, 'publishdate' => strtotime(trim('2011-01-11'), time()), 
				'installdate' => time(), 'updatedate' => time(), 'sort' => 0);
				$sql .= "\n\nINSERT INTO `".$config['db_prefix']."modules` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "');";
				if($value['extend'] && file_exists(EXCMS_ROOT.$value['extend'])){	//执行扩展动作
		    		require_once(EXCMS_ROOT.$value['extend']);
		    	}
			}
		}
	}
	global $demo_data;
	//安装演示数据
	if($_POST['demodata'] && file_exists($demo_data)){
		$sql .= file_get_contents($demo_data);
	}
	$sql = str_replace("\r", "\n", str_replace('excms_', $config['db_prefix'], $sql));
	
	$ret = array();
	$num = 0;
	foreach(explode(";\n", trim($sql)) as $query) {
		$ret[$num] = '';
		$queries = explode("\n", trim($query));
		foreach($queries as $query) {
			$ret[$num] .= (isset($query[0]) && $query[0] == '#') || (isset($query[1]) && isset($query[1]) && $query[0].$query[1] == '--') ? '' : $query;
		}
		$num++;
	}
	unset($sql);
	foreach($ret as $query) {
		$query = trim($query);
		if($query) {
            ob_flush();
            flush();
			if(substr($query, 0, 12) == 'CREATE TABLE') {
				$name = preg_replace("/CREATE TABLE `?([a-z0-9_]+)`? .*/is", "\\1", $query);
				 echo "<script language=\"javascript\">showSqlMsg('<font color=green>成功创建数据表</font> {$name}');</script>\n";
				mysql_query(createtable($query, $config['db_charset']), $conn);
			} else {
				mysql_query($query, $conn);
			}
		}
	}
	echo "<script language=\"javascript\">$(\"nextBtn\").style.display=\"\";showSqlMsg('<font color=red>数据库创建完成，请点击下一步</font>');</script>\n";
	//return implode("<br>",$return);
}
function createtable($sql,$charset) {
	$type = strtoupper(preg_replace("/^\s*CREATE TABLE\s+.+\s+\(.+?\).*(ENGINE|TYPE)\s*=\s*([a-z]+?).*$/isU", "\\2", $sql));
	$type = in_array($type, array('MYISAM', 'HEAP')) ? $type : 'MYISAM';
	return preg_replace("/^\s*(CREATE TABLE\s+.+\s+\(.+?\)).*$/isU", "\\1", $sql).
	(mysql_get_server_info() > '4.1' ? " ENGINE=$type DEFAULT CHARSET=".$charset : " TYPE=$type");
}


if($step == 4 && $rs['db_host'] == ''){
	$step = 3;
}
if($step == 3){//系统配置
	$act = $_POST['act'];
	$id_encrypt_display = 'none';
	if($act == "submit"){
		$flag = false;
		$msg = array();
		
		$rs['db_type'] 		= 'mysql';
		$rs['db_persist'] 	= false;
		$rs['db_charset'] 	= SQL_CHARSET;
		$rs['db_host']	 	= trim($_POST['dbhost']);
		if($rs['db_host'] == ''){
			$flag = true;
			$msg[] = "数据库主机为空";
		}
		$rs['db_username'] 	= trim($_POST['dbuser']);
		if($rs['db_username'] == ''){
			$flag = true;
			$msg[] = "数据库访问用户名为空";
		}
		$rs['db_password'] 	= trim($_POST['dbpwd']);
		$rs['db_name'] 		= trim($_POST['dbname']);
		if($rs['db_name'] == ''){
			$flag = true;
			$msg[] = "数据库名称为空";
		}
		$rs['db_prefix'] 	= trim($_POST['dbprefix']);
		
		$createdb 			= (int)$_POST['createdb'];
		$rs['createdb'] = $createdb;
		if($createdb == 1){
			$createdb = 'checked="checked"';
			$createdb_display = '';
			$rs['db_root']		= trim($_POST['root']);
			$rs['db_rootpwd'] 	= $_POST['rootpwd'];
		}else{
			$createdb = '';
			$createdb_display = 'none';
		}
		
		$rs['sitename']		= trim($_POST['sitename']);
		if($rs['sitename'] == ''){
			$flag = true;
			$msg[] = "网站名称不能为空";
		}
		$rs['domain']		= trim($_POST['domain']);
		$rs['idencryptcode']= trim($_POST['idencryptcode']);
		$rs['adminuser'] 	= trim($_POST['adminuser']);
		if($rs['adminuser'] == ''){
			$flag = true;
			$msg[] = "系统管理员用户名不能为空";
		}
		$rs['adminpwd'] 	= $_POST['adminpwd'];
		if($rs['adminpwd'] == ''){
			$flag = true;
			$msg[] = "系统管理员密码不能为空";
		}
		$rs['adminrepwd'] 	= $_POST['adminrepwd'];
		if($rs['adminrepwd'] == ''){
			$flag = true;
			$msg[] = "确认密码不能为空";
		}
		if($rs['adminpwd'] != $rs['adminrepwd']){
			$flag = true;
			$msg[] = "系统管理员密码不统一";
		}
		//$rs['modules'] = $_POST['modules'];
		
		$checkMsg = checkDatabase($rs);
		if($checkMsg !== FALSE){
			$flag = true;
			$msg[] = $checkMsg;
		}
		$rs['title'] = $_POST['title'];
		
		$rs['enableidencryptcode'] = $_POST['enableidencryptcode'];
		$rs['idencrypt_channel'] = $_POST['idencrypt_channel'];
		$rs['idencrypt_content'] = $_POST['idencrypt_content'];
		$rs['idencrypt_page'] = $_POST['idencrypt_page'];
		$id_encrypt_display = $rs['enableidencryptcode'] == 1 ? 'block' : 'none';
		if($flag === false){
			writeConfig($rs, false);
			$step = 4;
			$msg = "成功创建 EXCMS 配置文件: ".$dirfile_params['config']['path'];
		}
	}else{
		$rs['db_host']	 	= 'localhost';
		$rs['db_username'] 	= 'root';
		$rs['db_name'] 		= 'excms';
		$rs['db_prefix'] 	= 'excms_';
		$createdb = '';
		$createdb_display = 'none';
		$rs['domain']		= 'http://'.$_SERVER['SERVER_NAME'].substr($_SERVER['PHP_SELF'],0,-18);
		$rs['adminuser'] 	= 'administrator';
	}
}else if($step == 6){//数据库生成
	error_reporting(E_ALL || ~E_NOTICE);
	$config = EXCMS_ROOT.$dirfile_params['config']['path'];
}else if($step == 7){//完成
	if(file_exists(EXCMS_ROOT.$dirfile_params['config']['path'])){
		$msg = "您可以访问以下链接来使用 EXCMS，祝您使用 EXCMS 愉快! <br><br><a href='../' target='_blank' class='btnlink'>访问网站首页</a><a href='../admin' target=_blank class='btnlink'>EXCMS 后台管理</a>";
	}else{
		$step = -1;

		$msg = "配置文件不存在或者丢失，请“<a href=\"index.php\">重新安装</a>”。";
	}
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" />
<title><?php echo $step_params[$step]['title']; ?> EXCMS 卓越内容管理系统</title>
<link rel="stylesheet" type="text/css" href="theme/install.css" />
<script language="javascript" src="install.js"></script>
</head>
<body scroll=no>
<?php /**
 Install ************************************************************************************************ Step 0
*/
if($step == 0){ ?>
<div class="mtop"></div>
<div class="welcome">
<div class="version"><?php echo EXCMS_VERSION; ?></div>
<a href="index.php?step=1" class="start">开始安装</a>
<div class="help"><a href="http://www.excms.cn/help/install/" target="_blank">如何安装 EXCMS
卓越内容管理系统?</a><br />
Copyright (C) 2010 葡萄柚软件. All Right Reserved.</div>
</div>
<?php } else { ?>
<div class="leftside">
<div class="logo"></div>
<ul>
<?php 
foreach ($step_params as $k=>$v) {
	if($k < 1 )continue;
	if($k < $step){
		echo "<li class='finished'>{$v['title']}</li>";
	}elseif($k==$step){
		echo "<li class='on'>{$v['title']}</li>";
	}else{
		echo "<li>{$v['title']}</li>";
	}
}
?>
</ul>
</div>
<div class="main">
<div id="opacity"></div>
<div id="contentct">
<div class="content">
<div class="txt-step<?php echo $step ?>"></div>
<?php
/**
 Install ************************************************************************************************ error
*/
if($step == -1){
?>
<h1 style="color:red">错误</h1>
<p><?php echo "<div class='error'>" . $msg . "</div>";?></p>
<?php }
/**
 Install ************************************************************************************************ Step 1
*/
elseif($step == 1){?>
<div class="txt">您正在安装 <strong>EXCMS <?php echo EXCMS_VERSION; ?> </strong><br />EXCMS 是千万数据级人性化内容管理系统。<br /></div>
<div class="stitle">葡萄柚软件许可协议</div>
<div class="license">版权所有 (c)2007-2009，葡萄柚（北京）软件有限公司保留所有权利。 <br />感谢您选择卓越内容管理系统（以下简称EXCMS），EXCMS是千万数据级、高速、稳定、人性化内容管理的大型门户网站建设解决方案之一，目前只开放部分源代码，EXCMS将在3.0版本时开放全部源码。希望我们的努力能为您提供一个具备高效、高速、安全稳定的网站解决方案。<br /><br />EXCMS 的官方网址是： <a href="http://www.excms.cn" target="_blank">www.excms.cn</a>EXCMS 技术交流论坛： <a href="http://www.excms.cn/forum"	target="_blank">www.excms.cn/forum</a><br /><br /><strong>为了使你正确并合法的使用本软件，请你在使用前务必阅读清楚下面的协议条款：</strong><br /><br /><strong>一、授权协议范围</strong><br />本授权协议适用且仅适用于 EXCMS 1.x.x 版本，EXCMS官方对本授权协议的最终解释权。<br /><br /><strong>二、协议许可的权利 </strong><br />1、您可以在完全遵守本最终用户授权协议的基础上，将本软件应用于非商业用途，而不必支付软件版权授权费用。 <br />2、您可以在协议规定的约束和限制范围内修改 EXCMS 源代码或界面风格以适应您的网站要求。<br />3、您拥有使用本软件构建的网站全部内容所有权，并独立承担与这些内容的相关法律义务。<br />4、获得商业授权之后，您可以将本软件应用于商业用途，同时依据所购买的授权类型中确定的技术支持内容，自购买时刻起，在技术支持期限内拥有通过指定的方式获得指定范围内的技术支持服务。商业授权用户享有反映和提出意见的权力，相关意见将被作为首要考虑，但没有一定被采纳的承诺或保证。<br /><br /><strong>三、协议规定的约束和限制 </strong><br />1、未获商业授权之前，不得将本软件用于商业用途（包括但不限于企业网站、经营性网站、以营利为目的或实现盈利的网站）。购买商业授权请登陆 www.excms.cn 了解最新说明。<br />2、未经官方许可，不得对本软件或与之关联的商业授权进行出租、出售、抵押或发放子许可证。<br />3、不管你的网站是否整体使用 EXCMS ，还是部份栏目使用 EXCMS，在你使用了 EXCMS 的网站主页上必须加上EXCMS 官方网址(www.excms.cn)的链接。<br />4、未经官方许可，禁止在 EXCMS 的整体或任何部分基础上以发展任何派生版本、修改版本或第三方版本用于重新分发。<br />5、如果您未能遵守本协议的条款，您的授权将被终止，所被许可的权利将被收回，并承担相应法律责任。 <br /><br /><strong>四、有限担保和免责声明 </strong><br />1、本软件及所附带的文件是作为不提供任何明确的或隐含的赔偿或担保的形式提供的。 <br />2、用户出于自愿而使用本软件，您必须了解使用本软件的风险，在尚未购买产品技术服务之前，我们不承诺对免费用户提供任何形式的技术支持、使用担保，也不承担任何因使用本软件而产生问题的相关责任。<br />3、如果本软件带有其它软件的整合API示范例子包，这些文件版权不属于本软件官方，并且这些文件是没经过授权发布的，请参考相关软件的使用许可合法的使用。<br /><br />电子文本形式的授权协议如同双方书面签署的协议一样，具有完全的和等同的法律效力。您一旦开始安装 EXCMS，即被视为完全理解并接受本协议的各项条款，在享有上述条款授予的权力的同时，受到相关的约束和限制。协议许可范围以外的行为，将直接违反本授权协议并构成侵权，我们有权随时终止授权，责令停止损害，并保留追究相关责任的权力。<br /><br /></div>
<?php }
/**
 Install ************************************************************************************************ Step 2
*/
elseif ($step == 2){ 
?>
<div class="stitle">服务器信息</div>
<table border="0" cellpadding="0" cellspacing="0" class="withbd">
<tr><th>参数</th><th>EXCMS基本配置</th><th>EXCMS推荐配置</th><th>当前服务器配置</th></tr>
<?php 
	//环境变量
	$env_params = array
	(
		'os' => array('name'=>'操作系统','c' => 'PHP_OS', 'r' => '不限制', 'b' => 'FreeBSD'),
		'engine' => array('name'=>'Httpd','r' => '不限制', 'b' => 'Nginx'),
		'php' => array('name'=>'PHP版本','c' => 'PHP_VERSION', 'r' => '5.0', 'b' => '5.2.4'),
		'attachmentupload' => array('name'=>'附件上传','r' => '不限制', 'b' => '2M'),
		'gdversion' => array('name'=>'GD 库','r' => '2.0', 'b' => '2.0'),
		'diskspace' => array('name'=>'磁盘空间','r' => '10M', 'b' => '100M')
	);
	
	//检测环境变量
	foreach($env_params as $key => $item) {
		if($key == 'php') {
			$env_params[$key]['current'] = phpversion();
		} elseif($key == 'attachmentupload') {
			$env_params[$key]['current'] = @ini_get('file_uploads') ? ini_get('upload_max_filesize') : 'unknow';
		} elseif ($key == 'engine'){
			$env_params[$key]['current'] = $_SERVER['SERVER_SOFTWARE'];
		}elseif($key == 'gdversion') {
			$tmp = function_exists('gd_info') ? gd_info() : array();
			$env_params[$key]['current'] = empty($tmp['GD Version']) ? 'noext' : $tmp['GD Version'];
			unset($tmp);
		} elseif($key == 'diskspace') {
			if(function_exists('disk_free_space')) {
				$env_params[$key]['current'] = floor(disk_free_space(EXCMS_ROOT) / (1024*1024)).'M';
			} else {
				$env_params[$key]['current'] = 'unknow';
			}
		} elseif(isset($item['c'])) {
			$env_params[$key]['current'] = constant($item['c']);
		}

		$env_params[$key]['status'] = 1;
		if($item['r'] != 'notset' && strcmp($env_params[$key]['current'], $item['r']) < 0) {
			$env_params[$key]['status'] = 0;
		}
	}

	$sp_safe_mode = (ini_get('safe_mode') ? '<font color=red><b>On</b></font>' : '<font color=green><b>Off</b></font>');
	$sp_mysql = (function_exists('mysql_connect') ? '<font color=green><b>On</b></font>' : '<font color=red><b>Off</b></font>');
	if($sp_mysql=='<font color=red><b>Off</b></font>'){$sp_mysql_err = true;}else{$sp_mysql_err = false;}
	foreach($env_params as $v){ 
?>
<tr><td><?php echo $v['name'] ?></td><td><?php echo $v['r'] ?></td><td><?php echo $v['b'] ?></td><td><?php echo $v['current'] ?></td></tr>
<?php } ?>
</table>
<div class="stitle">系统环境检测</div>
<div class="tip">系统环境要求必须满足下列所有条件，否则系统或系统部份功能将无法使用。</div>
<table border="0" cellpadding="0" cellspacing="0" class="withbd">
<tr>
<th>需开启的变量或函数</th>
<th>要求</th>
<th>实际状态及建议</th>
</tr>
<tr>
<td>safe_mode</td>
<td>Off</td>
<td><?php echo $sp_safe_mode; ?> (本系统不支持在非win主机的安全模式下运行)</td>
</tr>
<tr>
<td>MySQL 支持</td>
<td>On</td>
<td><?php echo $sp_mysql; ?> (不支持无法使用本系统)</td>
</tr>
</table>
<div class="stitle">目录权限检测</div>
<div class="tip">系统要求必须满足下列所有的目录权限全部可读写的需求才能使用，其它应用目录可安装后在管理后台检测。</div>
<table border="0" cellpadding="0" cellspacing="0" class="withbd">
<tr><th>目录名</th><th>读取权限</th><th>写入权限</th></tr>
<?php 
	$rwable_true	= 'g';
	$rwable_false	= 'x';
	foreach($dirfile_params as $k => &$d){
		if($k == 'config') continue; 
		echo "<tr><td>".$d['path']."</td>";
		$dir = str_replace('/./', '/', EXCMS_ROOT . $d['path']);
		if($d['type'] == 'dir'){
			$readable = is_readable($dir) ? $rwable_true : $rwable_false;
			$writeable = writeable($dir) ? $rwable_true : $rwable_false;
		}else{
			if(file_exists($dir)){
				$readable = is_readable($dir) ? $rwable_true : $rwable_false;
				$writeable = is_writable($dir) ? $rwable_true : $rwable_false;
			}else{
				$dir = dirname($dir);
				$writeable = writeable($dir) ? $rwable_true : $rwable_false;
				$readable = is_readable($dir) ? $rwable_true : $rwable_false;
			}
		}
		echo "<td class='$readable'>&nbsp;</td><td class='$writeable'>&nbsp;</td></tr>";
	}
?>
</table>
<?php
}
/**
 Install ************************************************************************************************ Step 3
*/
elseif ($step == 3){
?>
<div class="txt">配置数据库及网站信息，请填写 EXCMS 数据库服务器连接及数据库信息，网站的名称及域名。</div>
<?php if(is_array($msg) && count($msg) > 0 ){
	  echo "<div class='error'>".implode('<br>', $msg)."</div>";
  }
?>
<form name="step3form" id="step3form" action="index.php?step=3"	method="post" act='submit'>
<input type="hidden" value="submit" id="act" name="act" /> 
<input type="hidden" id="checkrs" name="checkrs" />
<div class="stitle">数据库信息</div>
<table border="0" cellpadding="0" cellspacing="0">
<tr>
<td width="80">数据库主机：</td>
<td><input name="dbhost" id="dbhost" type="text" value="<?php echo $rs['db_host']; ?>" class="ipt" /> 一般为localhost</td>
</tr>
<tr>
<td>数据库用户：</td>
<td><input name="dbuser" id="dbuser" type="text" value="<?php echo $rs['db_username']; ?>" class="ipt" /></td>
</tr>
<tr>
<td>数据库密码：</td>
<td><input name="dbpwd" id="dbpwd" type="password" class="ipt" value="<?php echo $rs['db_password']; ?>" /></td>
</tr>
<tr>
<td>数据库名称：</td>
<td><input name="dbname" id="dbname" type="text" value="<?php echo $rs['db_name']; ?>" class="ipt" />
<label for="createdb" onclick="doCheckRoot();">
<input id="createdb" name="createdb" type="checkbox" value="1" <?php echo $createdb; ?> /> 创建数据库</label></td>
</tr>
<tr id="roottr1" style="display:<?php echo $createdb_display; ?>">
<td><br />Root 用户名：</td>
<td><div style="padding-bottom:4px">如上面的数据库用户有权限创建数据库，Root用户名及Root密码无需填写</div><input name="root" id="root" type="text" value="<?php echo $rs['db_root']; ?>" class="ipt" /></td>
</tr>
<tr id="roottr2" style="display:<?php echo $createdb_display; ?>">
<td>Root 密码：</td>
<td><input name="rootpwd" id="rootpwd" type="password" class="ipt" value="<?php echo $rs['db_rootpwd']; ?>" /></td>
</tr>
<tr>
<td>数据表前缀：</td>
<td><input name="dbprefix" type="text" value="<?php echo $rs['db_prefix']; ?>" class="ipt" />
如无特殊需要,请不要修改</td>
</tr>
</table>
<div class="stitle">网站基本信息</div>
<table border="0" cellpadding="0" cellspacing="0">
<tr>
<td width="80">网站名称：</td>
<td><input name="sitename" type="text" value="<?php echo $rs['sitename']; ?>" class="ipt" size="40" /></td>
</tr>
<tr>
<td width="80">网站标题：</td>
<td><input name="title" type="text" value="<?php echo $rs['title']; ?>" class="ipt" size="40" /></td>
</tr>
<tr>
<td>网站域名：</td>
<td><input name="domain" type="text" value="<?php echo $rs['domain']; ?>" class="ipt" size="40" /></td>
</tr>
</table>
<div class="stitle">ID编码</div>
<table border="0" cellpadding="0" cellspacing="0">
<tr>
<td width="80">是否启用：</td>
<td><label for="enableidencryptcode" onclick="setEncryptTableDisplay()"><input name="enableidencryptcode" type="checkbox" id="enableidencryptcode" value="1" <?php echo $rs['enableidencryptcode'] == 1 ? 'checked="checked"' : ''; ?> />适用于内容ID、栏目ID、分页混编码(防采集)</label></td>
</tr>
</table>
<table border="0" cellpadding="0" cellspacing="0" id="id_encrypt_table" style="display:<?php echo $id_encrypt_display; ?>">
<tr>
<td>编码扰码：</td>
<td><input name="idencryptcode" type="text" value="<?php echo $rs['idencryptcode']; ?>" class="ipt" /></td>
</tr>
<tr>
<td>&nbsp;</td>
<td><font color="red">请务必记住本编码扰码，不同的编码扰码，生成混编码不一样</font></td>
</tr>
<tr>
<td width="80"><label for="idencrypt_channel">栏目ID：</label></td>
<td><label for="idencrypt_channel"><input name="idencrypt_channel" id="idencrypt_channel" type="checkbox" <?php echo $rs['idencrypt_channel'] == 1 ? 'checked="checked"' : ''; ?> value="1" /> 启用</label> 示例：栏目ID：X6X5556F，8位数字字符串混编码</td>
</tr>
<tr>
<td width="80"><label for="idencrypt_content">内容ID：</label></td>
<td><label for="idencrypt_content"><input name="idencrypt_content" id="idencrypt_content" type="checkbox" <?php echo $rs['idencrypt_content'] == 2 ? 'checked="checked"' : ''; ?> value="2" /> 启用</label> 示例：内容ID：X03APP583A，10位数字字符串混编码</td>
</tr>
<tr>
<td width="80"><label for="idencrypt_page">分页：</label></td>
<td><label for="idencrypt_page"><input name="idencrypt_page" id="idencrypt_page" type="checkbox" <?php echo $rs['idencrypt_page'] == 3 ? 'checked="checked"' : ''; ?> value="3" /> 启用</label> 示例：分页：X0X68A，6位数字字符串混编码</td>
</tr>
</table>
<div class="stitle">管理员信息</div>
<table border="0" cellpadding="0" cellspacing="0">
<tr>
<td width="80">用户名：</td>
<td><input name="adminuser" type="text" value="<?php echo $rs['adminuser']; ?>" class="ipt" /></td>
</tr>
<tr>
<td>密码：</td>
<td><input name="adminpwd" type="password" value="<?php echo $rs['adminpwd']; ?>" class="ipt" /></td>
</tr>
<tr>
<td>确认密码：</td>
<td><input name="adminrepwd" type="password" value="<?php echo $rs['adminrepwd']; ?>" class="ipt" /></td>
</tr>
</table>
</form>
<?php 
}elseif($step==5){
	?>
<br />
<form name="step5form"  id="step5form" action="index.php?step=6" method="post" act='submit'>
<table border="0" cellpadding="0" cellspacing="0" class="withbd">
<tr>
<th class="thbig">系统模块</th>
</tr>
<tr>
<td>
<ul class="modulelist clearfix">
<?php 
	foreach($system_module as $key => $value){
		echo "<li><input type=\"checkbox\" checked=\"checked\" disabled=\"disabled\" />{$value['name']}({$key})</li>\n";
	}
?>
</ul>
</td>
</tr>
</table>
<br />
<table border="0" cellpadding="0" cellspacing="0" class="withbd">
<tr>
<th class="thbig"><font class="thtip">可选模块能够自由卸载，您可以根据自己需要选择性安装</font>可选模块</th>
</tr>
<tr>
<td>
<ul class="modulelist clearfix">
<?php 
	foreach($other_module as $key => $value){
		echo "<li><input name='modules[]' type=\"checkbox\" checked=\"checked\" value=\"{$key}\" id=\"module-{$key}\"  /><label for=\"module-{$key}\">{$value['name']}({$key})</label></li>\n";
	}
?>
</ul>
</td>
</tr>
</table>
<br />
<table border="0" cellpadding="0" cellspacing="0" class="withbd">
<tr>
<th class="thbig">数据安装</th>
</tr>
<tr>
<td>
<ul class="modulelist clearfix">
<li class="fulli"><input name='demodata' type="checkbox" checked="checked" value="1" id="demoData"  /><label for="demoData">安装演示数据(用于新手和调试用户)</label></li>
</ul>
</td>
</tr>
</table>
</form>
<?php 
}
/**
 Install ************************************************************************************************ Step 5,6,7
*/
elseif ($step == 4 || $step == 5 || $step == 7){
	echo "<div class='txt'>$msg</div>";
	
}elseif($step == 6){
    echo "<div class='txt'>";
    if(file_exists(EXCMS_ROOT.$dirfile_params['config']['path'])){
		echo "<div class='sql' id='toresize'></div>";
	}else{
		$step = -1;
		echo "配置文件不存在或者丢失，请“<a href=\"index.php?step=3\">返回系统配置重新配置数据库及网站信息</a>”。";
	}
	echo "</div>";
	
}
?>
</div>
</div>
<div id="controlbar">
<?php 
if($step<7 && $step>0){
	if($step > 1){
		echo "<input type=\"button\"  value=\"".(isset($step_params[$step]['preText']) ? $step_params[$step]['preText'] : '上一步')."\" onclick=\"window.location.href='index.php?step=".($step-1)."'\"; />";
	}
	echo  "<input type=\"button\" id=\"nextBtn\" value=\"" . (isset($step_params[$step]['nextText']) ? $step_params[$step]['nextText'] : '下一步')."\" onclick=\"". ($step == 3 ? "EXCMS.install.submit('step3form')" : ($step == 5 ? "EXCMS.install.submit('step5form')" : ("window.location.href='index.php?step=".($step_params[$step]['nextStep']>0 ? $step_params[$step]['nextStep'] : ($step+1))."'"))) . "\" />"; 
}
?>
</div>
</div>
<?php } ?>
</body>

<?php
if($step == 6){
    echo '<script language="javascript">EXCMS.install.init();$("nextBtn").style.display="none";</script>';
    $config = include $config;
    runquery($config);
    unset($config['createdb'], $config['db_root'], $config['db_rootpwd'], $config['db_persist'], $config['sitename'], $config['domain'], $config['idencryptcode'], $config['adminuser'], $config['adminpwd'], $config['adminrepwd'], $config['title'], $config['enableidencryptcode'], $config['idencrypt_channel'], $config['idencrypt_content'], $config['idencrypt_page'],$config['subdir']);
    writeConfig($config);
}
?>
</html>