<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		list.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author $Author: zhanghaisong $
 * @version $Rev: 3528 $
 */
 
 /* $Id: list.php 3528 2011-01-10 12:13:44Z zhanghaisong $ */ 
 
 /**
  * 内容列表
  * 
  * 类型：最新，焦点，头条，推荐，滚动，图片
  */

// 加载系统配置文件
require_once ('configuration/inc/common.inc.php');

// 列表类型
$type_array = array(
	'newest'	=>  '最新',
	'head'		=> '头条',
	'focus'		=> '焦点',
	'recommend'	=> '推荐',
	'scroll'	=> '滚动',
	'txpic'		=> '图文',
	'flash'		=> '幻灯',
	'image'		=> '图片',
	'download'	=> '下载'
);
$type_array['roll'] = &$type_array['scroll'];

// 获取当前列表类型
if(!isset($_GET['type'])){
	$_PAGE['type'] = 'newest';
}elseif(!empty($_GET['type']) && array_key_exists($_GET['type'], $type_array)){
	$_PAGE['type'] = $_GET['type'];
}else{
	$_PAGE['type'] = 'newest';
	//EXCMS::showMessage('不存在的列表分类');
}

// 动态访问用于动态分页
$_PAGE['dynamic'] = true;

// 当前使用URL规则
$_PAGE['urlrule'] = array('name' => 'list', 'type' => $_PAGE['type'], 'usepagechannel' => 1);

// 分页（必须）
isset($_GET['page']) && $_PAGE['pageon'] = $EXCMS_CONFIG['code_page'] ? EXCMS::page_decode($_GET['page']) : $_GET['page'];

// 获取栏目ID
unset($chanelid);
if(isset($_GET['channelid'])){
	$channelid = $_GET['channelid'];
}elseif(isset($_GET['id'])){
	$channelid = $_GET['id'];
}

// 检查栏目ID 编码设置，解码
$EXCMS_CONFIG['code_channelid'] && $channelid = EXCMS::channel_id_decode($channelid);

// 获取栏目
is_numeric($channelid) && $channelid > 0 && $_PAGE_CHANNEL = EXCMS::getChannelCacheById($channelid);

// 获取交叉栏目ID
unset($crossid);
isset($_GET['crossid']) && $_PAGE['crossid'] = $EXCMS_CONFIG['code_channelid'] ? $_GET['crossid'] : EXCMS::channel_id_decode($_GET['crossid']);

// 加载栏目更新方法成员类
include_once LIB_PATH . 'update/ChannelFunction.class.php';

// 获取交叉栏目
if(is_numeric($_PAGE['crossid']) && $_PAGE['crossid'] > 0){
	$_PAGE_CHANNEL['crosschannel'] = EXCMS::getChannelCacheById($_PAGE['crossid']);
	if($_PAGE_CHANNEL['crosschannel']['channelid']){
		$_PAGE_CHANNEL['href'] = ChannelFunction::listName($_PAGE_CHANNEL, 1, $_PAGE_CHANNEL['crosschannel']['channelid']);
		$_PAGE['title'] = $_PAGE_CHANNEL['crosschannel']['name'];
	}
}else{
	$_PAGE_CHANNEL['crosschannel'] = null;
	$_PAGE['title'] = $_PAGE_CHANNEL['name'];
}

// 页面模型类型
$_PAGE['model'] = isset($_GET['model']) ? $_GET['model'] : '';
//echo $_SERVER['QUERY_STRING'];

// 获取内容模型
if($_PAGE_CHANNEL && $_PAGE_CHANNEL['modelid'] > 0){
	include_once LIB_PATH . 'model/Model.class.php';
	$model = new Model();
	$model = $model->getById($_PAGE_CHANNEL['modelid']);
	$model['ename'] && $_PAGE['model'] = $model['ename'];
}

switch($_PAGE['model']){
	// 图片
	case 'image' :
		$page_title_addon = '图片';
		$tpl = 'list_type_image.html';
		break;
	// 视频
	case 'video' :
		$page_title_addon = '视频';
		$tpl = 'list_type_video.html';
		break;
	// 下载
	case 'download':
		$page_title_addon = '下载';
		$tpl = 'list_type_download.html';
		break;
	// 默认文章
	default :
		$_PAGE['model'] = '';
		$tpl = 'list_type.html';
		break;
}
$_PAGE['model'] && $_PAGE['urlrule'] = array('name' => 'list', 'model' => $_PAGE['model'], 'type' => $_PAGE['type']);

// 指定推荐类型
$recommend_type = array('head', 'focus', 'recommend', 'flash', 'scroll', 'indexhead', 'indexfocus', 'indexrmd');
in_array($_PAGE['type'], $recommend_type) && $_PAGE['listtype'] = 'recommend';

// 页面字段
$_PAGE['name'] = $type_array[$_PAGE['type']];
$_page_type = $_PAGE['name'] . $page_title_addon;
$_PAGE['title'] .= "{$_page_type}";
$_PAGE['keywords'] = "{$_PAGE['title']} {$_PAGE_CHANNEL['keywords']}";
$_PAGE['description'] = "{$_PAGE['title']} {$_PAGE_CHANNEL['description']}";

// 当前位置
$_PAGE['position'] = EXCMS::position_join(ChannelFunction::getNavigation($_PAGE_CHANNEL['_channelid'], $_PAGE['crossid']), $_page_type);
// 输出模板
EXCMS::display($tpl);

// excms file's end