<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		action.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author alisa@excms.cn
 * @version $Rev: 146 $
 */
 
 /* $Id: index.php 146 2009-11-10 07:58:36Z zhangxuelin $ */ 
 
 /**
  * 心情动作程序
  */
  
// 加载系统配置文件
require_once('../configuration/inc/common.inc.php');

// cross domain clallback
if(isset($_GET['crossDomainCallback']) && $_GET['crossDomainCallback'] != ''){
	$crossDomainCallback = trim($_GET['crossDomainCallback']);
}

// get action params
if($crossDomainCallback){
	$params = &$_GET; 
}else{
	$params = &$_POST; 
}

switch($params['method']){
	// render vote panel
	case 'votepanel' :
		$_PAGE['contentid'] = $params['contentid'];
		if($EXCMS_CONFIG['code_contentid']){
		    $_PAGE['contentid'] = EXCMS::id_decode($_PAGE['contentid']);
		}
		if($crossDomainCallback){
			ob_start();
			EXCMS::display('mood/panel.html');
			$mood_panel = ob_get_contents();
			ob_clean();
			echo $crossDomainCallback . "(\"" . addslashes(str_replace(array(chr(13), chr(10)), '', $mood_panel)) . "\")";
		}else{
			EXCMS::display('mood/panel.html');
		}
		break;
		
	// vote
	case 'vote' :
		$_PAGE['contentid'] = $params['contentid'];
		if($EXCMS_CONFIG['code_contentid']){
		    $_PAGE['contentid'] = EXCMS::id_decode($_PAGE['contentid']);
		}
		if(!is_numeric($_PAGE['contentid']) || !($_PAGE['contentid']  > 0)){
		    unset($_PAGE['contentid']);
		}
		
		include_once LIB_MODULES_PATH .'mood/MoodClick.class.php';
		$mood = new MoodClick();
		$message['total'] = $mood->vote($_PAGE['contentid'], 1, $params['value']);
		$message['success'] = 1;
		$message = EXCMS::jsonencode($message);
		if($crossDomainCallback){
			echo $crossDomainCallback . "({$message})";
		}else{
			echo $message;
		}
		break;
}

// excms file's end