<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		search.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http:// www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http:// www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author zhanghaisong@putoyo.com
 * @version $Rev: 3327 $
 */
/* $Id: search.php 3327 2010-12-30 08:57:25Z zhangxuelin $ */
/**
 * 站内搜索
 */
session_start();

// 加载系统配置文件，移动本程序时，请修改配置文件路径
require_once ('configuration/inc/common.inc.php');

$_PAGE = array('search' => array());
$so = &$_PAGE['search'];
$mso = loadModuleConfig('search', true);
$so = $_GET;
// 获取关键字
$so['keywords'] = str_replace('\\', '', trim($_GET[$mso['q_keywords']]));
$so['category'] = trim($_GET[$mso['q_category']]);
$so['advanced'] = trim($_GET['adv']) == 1;
$so['pageon'] = $_GET[$mso['q_pageon']];
// 分页（必须）
if(isset($so['pageon'])){
	$_PAGE['pageon'] = $so['pageon'] = $EXCMS_CONFIG['code_page'] ? EXCMS::page_decode($so['pageon']) : $so['pageon'];
}
$so['pagesize'] = $_GET[$mso['q_pagesize']];
$so['orderby'] = $_GET[$mso['q_orderby']];
if($so['advanced'])// 高级搜索
{
	// 加载搜索类，创建搜索对象
	include_once LIB_MODULES_PATH . 'search/AdvSearchPageList.class.php';
	$so['class'] = new AdvSearchPageList();
	$search = &$so['class'];
	$so['keywordslocation'] = $_GET[$mso['q_keywordslocation']];
	$so['date'] = $_GET[$mso['q_date']];
	/**
	 * 高级搜索相关参数
	 */
	// 包含以下全部的关键词
	$search->setAllKeywords(trim($_GET[$mso['q_allkeywords']]));
	// 包含以下的完整关键词
	$search->setCompleteKeywords(trim($_GET[$mso['q_completekeywords']]));
	// 包含以下任意一个关键词
	$search->setArbitraryKeywords(trim($_GET[$mso['q_anykeywords']]));
	// 不包括以下关键词
	$search->setNotIn(trim($_GET[$mso['q_notin']]));
	// 限定要搜索的网页的时间是
	$search->setDate($so['date']);
	// 查询关键词位于
	$search->setKeywordsLocation($so['keywordslocation']);
	// 设置搜索关键字
	$search->setKeywords($so['keywords']);
	$so['keywords'] = $search->getWords();
}else{
	// 加载搜索类，创建搜索对象
	include_once LIB_MODULES_PATH . 'search/SearchPageList.class.php';
	$so['class'] = new SearchPageList();
	$search = &$so['class'];
	// 设置搜索关键字
	$search->setKeywords($so['keywords']);
}

// 设置搜索分类
$search->setCategory($so['category']);

// 获取搜索分类
$so['category'] = $search->getCategory();
$_PAGE['category'] = &$so['category'];

// 检查搜索关键字是否为空
if($so['keywords'] != '' || $allkeywords != '' || $completekeywords != '' || $arbitrarykeywords != '' || $notin != ''){
	// 按搜索分类设定模板
	$tpl = $so['category']['template'];
	!$tpl && $tpl = 'search.html';
}else{
	// 空搜索模板
	$tpl = $so['advanced'] ? 'search_advanced.html' : 'search_blank.html';
}

// 输出模板
EXCMS::display($tpl);

// excms file's end