<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		tag.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hukuizhi
 * @version $Rev: 3473 $
 */
 
 /* $Id: tag.php 3473 2011-01-08 17:44:10Z zhangxuelin $ */ 
 
 /**
  * TAG标签封面及列表程序
  */

//加载系统配置文件，移动本程序时，请修改配置文件路径
require_once ('configuration/inc/common.inc.php');

//获取页面参数
$_PAGE['type']		= $_GET['type'];		// 列表类型
$_PAGE['initial']	= $_GET['initial'];		// 首字母

// 分页（必须）
if(isset($_GET['page'])){
	$_PAGE['pageon'] = $EXCMS_CONFIG['code_page'] ? EXCMS::page_decode($_GET['page']) : $_GET['page'];
}

// 栏目信息
$channelid = $_GET['channelid'] && $EXCMS_CONFIG['code_channelid'] ? EXCMS::channel_id_decode($_GET['channelid']) : $_GET['channelid'];
if(is_numeric($channelid)){
	$_PAGE_CHANNEL = EXCMS::getChannelCacheById($channelid);
	// 当前使用URL规则
	$_PAGE['urlrule'] = array('name'=>'tag');
}

// 页面字段
$_PAGE['name'] = 'tag';
$_PAGE['title'] = '标签';

// 定义页面模板
$tpl = 'tag.html';
if(isset($_GET['name']) && !empty($_GET['name'])) { //显示tag列表
	$_PAGE['tagname'] = trim($_GET['name']);
    include_once LIB_PATH . 'content/Tag.class.php';
    $tag = new Tag();
    $_PAGE['tag'] = $tag->getByName($_PAGE['tagname']);
    if($_PAGE['tag']['name']){
    	// 增加点击量
   	 	$tag->clickUp($_PAGE['tag']['tagid']);
	    // 当前使用URL规则
		$_PAGE['urlrule'] = array('name'=>'tag_name','tagname'=>urlencode($_PAGE['tagname']));
    }
    
    $position = array('<a href="' . EXCMS::url('tag') . '">标签</a>', $_PAGE['tagname']);
    $_PAGE['title'] = "{$_PAGE['tagname']}_标签";
    $tpl = 'taglist.html';
    
	if($_PAGE['type'] == 'pinyin'){
		$contentids = $tag->getContentIdsByName(iconv('UTF-8', 'GBK', $_PAGE['tagname']));
		$tags = explode(',', $contentids);
		if(count($tags) < 6){
			rsort($tags);
			include_once LIB_PATH . 'content/Content.class.php';
			$content = new Content();
			include_once LIB_PATH . 'update/ContentFunction.class.php';
			$content_array = $content->getById($tagIdArray[0]);
			$url = ContentFunction::getContentUrl($content_array);
			header("HTTP/1.1 301 Moved Permanently");
			header("Location:" . $url);
			exit;
		}
	}
    unset($tag);
}elseif(is_numeric($_GET['cid'])){ // 分类标签
	include_once LIB_PATH . 'category/Category.class.php';
	$category = new Category();
	$_PAGE['category'] = $category->getValue(1000, $_GET['cid']);
	if($_PAGE['category']['id']){
		$_PAGE['title'] = $_PAGE['category']['name'] . '类标签';
		$position = array('<a href="' . EXCMS::url('tag') . '">标签</a>', $_PAGE['title']);
	}else{
		$position = array('标签');
	}
	
}else{
	$position = &$_PAGE['title'];
}

$_PAGE['keywords'] = $_PAGE['title'];
$_PAGE['description'] = $_PAGE['title'];

// 当前位置
$_PAGE['position'] = EXCMS::position($position);

// 显示
EXCMS::display($tpl);

// excms file's end