<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		updatetoexcms
 * * A product of SINOICAN Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * excms@sinoican.com
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2007-2009 SINOICAN Inc.
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @category EXCMS
 * @author excms@sinoican.com
 */

error_reporting(E_ALL || ~E_NOTICE);

// 加载系统配置文件
require_once ('configuration/inc/common.inc.php');

define('CHARSET', 'UTF-8');
define('OLD_VERSION', '2011(v1.5) 20110111');
define('NEW_VERSION', '2011');

// 更新程序
define('UPDATE_PROGRAM_KEY', md5(NEW_VERSION . $EXCMS['sitename'] . $EXCMS['id_code_key']));
define('UPDATE_PROGRAM_FILENAME', basename(__FILE__));
define('UPDATE_PROGRAM_VERSION', '2011 20110124');

// 更新 SQL
$updatesql = "DELETE FROM `excms_system_config` WHERE `moduleid`='config' AND `name`='safety_code';
INSERT INTO `excms_system_config` (`moduleid`,`name`,`value`,`description`,`group`,`type`,`issystem`,`sort`)  VALUES ('config','safety_code','','网站安全码','安全与加密','3','1','100');
UPDATE `excms_url` SET `url` = 'apps/video.php?contentid={contentid}|{field}|{page}.xml',`rewrite`='apps/video-{contentid}-{field}-{page}.xml' WHERE `moduleid`='system' AND `name`= 'videosrc';
UPDATE `excms_menu` SET `url`='index.php?M=System&A=Url&method=cache' WHERE `id`='51';
UPDATE `excms_system_config` SET `value`='./apps/ads/themes/default' WHERE `moduleid`='ads' AND `name`='template_dir';
UPDATE `excms_url` SET `url`='./apps/ads/js.php?id={id}',`rewrite`='./apps/ads/js-{id}.php' WHERE `moduleid`='ads' AND `name`='php';
";

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" />
<title>更新EXCMS - 更新到 EXCMS <?php echo NEW_VERSION; ?></title>
<style type="text/css">
body,div{font-size:12px;font-family:Tahoma, Geneva, sans-serif}
a{color:#0F74A7}
.updater{margin:20px auto;width:500px;border:1px solid #99C9DD}
.header{border-bottom:1px solid #99C9DD;font-size:14px;font-weight:bold;padding:0px 8px;line-height:24px;background:#E2EFFF;color:#003366}
.body{padding:16px;}
h2{font-size:14px;margin:0;}
.version{padding:6px 0;border-bottom:1px dotted #CCC;color:#090}
.tip{margin:6px 0;line-height:135%}
.note{color:red; font-family:'宋体'}
.button{display:block;margin:20px auto;width:240px;line-height:32px;font-size:14px;border:1px solid #99C9DD;text-align:center;text-decoration:none;font-weight:bold; background:#F2FBFD}
.button:hover{background:#E2EFFF;}
.success, .faild{font-weight:bold;font-size:14px;}
.success{color:green;}
.faild{color:red;}
.copyright{padding:0px 12px;line-height:32px;text-align:right;color:#999}
</style>
</head>

<body>
<div class="updater">
<div class="header">更新EXCMS</div>
<div class="body">
<h2>您正在使用的是 EXCMS 卓越内容管理系统更新程序</h2>
<div class="version">更新程序版本：EXCMS <?php echo UPDATE_PROGRAM_VERSION; ?></div>

<?php 
if($_GET['do'] == UPDATE_PROGRAM_KEY){
	// 加载模型类，创建对象
	include_once LIB_PATH.'modules/Modules.class.php';
	// 创建模型类对象
	$module = new Modules();
	$fields = $GLOBALS['db']->get_fields(TABLE_PREFIX."admin");
	$update = false;
	foreach ($fields as $value){
		if($value['fieldname']=='ssid'){
			$update = false;
			break;
		}else{
			$update = true;
		}
	}
	if($update){
		$GLOBALS['db']->query("ALTER TABLE `".TABLE_PREFIX."admin` ADD COLUMN `ssid` CHAR(32) CHARSET utf8 COLLATE utf8_general_ci NULL AFTER `description`");
	}
	// 执行更新SQL
	if($module->runquery($updatesql)){ // 更新成功
		$class = 'success';
		$msg = '恭喜您，您使用的 EXCMS 已经成功更新到 EXCMS ' . NEW_VERSION . ' 版本。';
		$file = basename(__FILE__);
		//if(!@unlink($file)){ //删除更新程序失败提示
		//	$msg .= '<br><font stylr="color:red">删除更新程序失败，请手工删除更新程序“'.$file.'”完成更新。</font>';
		//}
	}else{ // 更新失败
		$class = 'faild';
		$msg = '更新到 EXCMS ' . NEW_VERSION . ' 版本失败，请与官方人员联系（官方QQ群：85427310）';
	}
?>

<p class="<?php echo $class; ?>"><?php echo $msg ?></p>
<?php if($success){ echo '<a href="./" class="button">进入网站首页</a>'; }?>
<p class="tip">获取更多 EXCMS 模块和插件请登录 EXCMS 官方网站：</p>
<ol>
<li>EXCMS 官方网站 <a href="http://www.excms.cn" target="_blank">http://www.excms.cn</a></li>
<li>EXCMS 官方论坛 <a href="http://bbs.excms.cn" target="_blank">http://bbs.excms.cn</a></li>
<li>EXCMS 官方下载中心 <a href="http://www.excms.cn/download" target="_blank">http://www.excms.cn/download</a></li>
<li>EXCMS 官方模板中心 <a href="http://www.excms.cn/template" target="_blank">http://www.excms.cn/template</a></li>
<li>EXCMS 官方帮助中心 <a href="http://www.excms.cn/help" target="_blank">http://www.excms.cn/help</a></li>
<li>EXCMS 官方用户手册 <a href="http://www.excms.cn/manual" target="_blank">http://www.excms.cn/manual</a></li>
</ol>
</div>

<?php }else{ // 进入更新 ?>
<p class="tip">本更新程序仅对 EXCMS <?php echo OLD_VERSION; ?> 更新到 EXCMS <?php echo NEW_VERSION; ?>，没有更新到 EXCMS <?php echo OLD_VERSION; ?> 版本的用户请先更新到此版本。</p>
<p class="note">特别注意：本更新程序是对数据库的更新，更新前请做好数据库的备份，防止数据意外丢失！如何进行数据备份请参考 EXCMS 用户手册“<a href="http://www.excms.cn/help/system/b56810159f47a447.html" target="_blank">数据备份</a>”一文。</p>
<a href="?do=<?php echo UPDATE_PROGRAM_KEY; ?>" class="button">更新到 EXCMS <?php echo NEW_VERSION; ?></a>
</div>
<?php } ?>

<div class="copyright"><strong>EXCMS</strong> 卓越内容管理系统 <a href="http://www.excms.cn" target="_blank">www.excms.cn</a></div>
</div>
</body>
</html>
