<?php

/**
 * Copyright (C) 2009 Wskm Inc.All rights reserved.  
 * [Gart] www.wskmphp.com 
 * $Id: setting.php 103 2010-10-02 14:07:39Z ws99 $ 
 */

!defined('IN_ART') && exit('Access Denied');

class adminapp_setting extends admin_common
{
	function load()
	{		
		loadLang('admin_setting');
	}

	function doIndex()
	{
		if (!$this->isManageAccess()) {
			adminMessage('access_not');	
		}
		
		$this->model=usingAdminModel('setting');
		if (!IS_POST) {
			WSKM::helper('html');
			$type=requestGet('type',TYPE_ALNUM);
			if (empty($type)) {
				$type='base';
			}
			if (!in_array($type,array('style','base','sys','article','img','reg','login','attach','vcode','mail'))) {
				$type='base';
			}

			$setting=$this->model->getSetting($type);

			if ($type=='base') {
				WSKM::using('wskm_version');
				$timezone_option=html_select_option(wskm_version::$timezone,$setting['timeZone']);
				assign_var('timezone_option',$timezone_option);
			}elseif ($type=='img'){
				$positions=array();
				for ($i=1;$i<10;$i++){
					$positions[$i]=lang('position_'.$i);
				}
				assign_var('imgposition_option',html_select_option($positions,$setting['waterMarkPosition']) );
			}

			if ($type=='base' || $type=='reg') {
				if ($type=='base') {
					$path=ART_ROOT.'languages'.DS;
					$dirhandle=dir($path);
					$dirs=array();
					while (($dirtemp=$dirhandle->read()) !== false) {
						$dirpath=realpath($path.$dirtemp);
						if ( preg_match('/^[a-z0-9_\-]+$/i',$dirtemp ) && is_dir($dirpath) ) {
							$dirs[$dirtemp]=$dirtemp;
						}
					}
					assign_var('weblangs',$dirs);
				}
				assign_var('usergroup_option',html_select_option($this->model->getUserGroups(),$setting[$type=='base'?'groupId':'regGroupId']));
			}

			if ($type=='attach') {
				$setting['attachMaxSize']=round((int)$setting['attachMaxSize']/1048576);
			}

			assign_var('type',$type);
			assign_var('setting',$setting);

			adminTemplate('setting');
		}
		else if(checkToken()){
			$setting=requestPost('setting',TYPE_ARRAY);
			$settype=requestGet('type',TYPE_ALNUM);

			if (!is_array($setting)) {
				exit('err');
			}

			if ($settype=='base') {
				$setting['webUrl']=str_replace('http://','',rtrim($setting['webUrl'],'/'));
				$setting['webBaseUrl']=rtrim($setting['webBaseUrl'],'/');
				$setting['timeFormats']=rtrim(str_replace(array("\r"),'',$setting['timeFormats']),"\n");
			}elseif ($settype=='reg'){
				$setting['unameProtect']=rtrim(str_replace(array("\r",' '),'',$setting['unameProtect']),"\n");
				$setting['emailProtect']=rtrim(str_replace(array("\r",' '),'',$setting['emailProtect']),"\n");
			}elseif ($settype=='attach') {
				$setting['attachMaxSize']=(int)$setting['attachMaxSize']*1048576;
			}elseif ($settype=='style'){
				$setting['popBgColor']='#'.$setting['popBgColor'];
			}

			$this->model->readAll();
			$isupdateall=false;

			$res=$this->model->updateSettings($setting);
			$isupdateall=$this->model->isUpdateAll;
			if ($isupdateall) {
				usingArtClass('cache');
				art_cache::updateAll();

			}
			elseif ($res !== false) {
				$this->model->updateCache();
				adminMessage('edit_basesetting_successed',1);
			}
			adminMessage('edit_basesetting_failure',1);
		}

	}

	function doNav()
	{
		$this->model=usingAdminModel('nav');
		if (checkToken()) {
			$dels=requestPost('del',TYPE_ARRAY);
			if (count($dels) >0 ) {
				foreach ($dels as $id){
					if (!$this->model->del($id)) {
						adminMessage('del_bad','index.php?wskm=setting&act=nav');
					}
				}

				$this->model->updateCache();
				adminMessage('del_ok','index.php?wskm=setting&act=nav');
			}
		}

		$hand=requestGet('hand');
		if ($hand) {
			$nid=(int)requestGet('id');
			if ($nid <1 && $hand != 'add' && !IS_POST) {
				adminMessage('request_error','index.php');
			}
			if ($hand=='edit') {
				if (checkToken()) {
					$nav=array(
					'name'=>requestPost('name',TYPE_STRING,50),
					'target'=>requestPost('target',TYPE_INT),
					'displaysort'=>requestPost('displaysort',TYPE_INT),
					'color'=>'#'.requestPost('color',TYPE_STRING,20),
					'url'=>requestPost('url',TYPE_STRING,255),
					'status'=>requestPost('status',TYPE_INT),
					);
					if (empty($nav['name'])) {
						adminMessage('name_notempty',-1);
					}
					if ($nav['color']=='#FFFFFF') {
						$nav['color']='';
					}
					$nid=requestPost('nid',TYPE_INT);
					if (!$this->model->updateNav($nav,$nid)) {
						adminMessage('nav_edit_bad','index.php?wskm=setting&act=nav&hand=edit&id='.$nid);
					}
					$this->model->updateCache();
					adminMessage('nav_edit_ok','index.php?wskm=setting&act=nav&hand=edit&id='.$nid);

				}else{

					assign_var('info',$this->model->getAdminInfo($nid));
					assign_var('nid',$nid);
				}
			}elseif ($hand=='add'  && checkToken() ){
				$nav=array(
				'name'=>requestPost('name',TYPE_STRING,50),
				'target'=>requestPost('target',TYPE_INT),
				'color'=>'#'.requestPost('color',TYPE_STRING,20),
				'displaysort'=>requestPost('displaysort',TYPE_INT),
				'url'=>requestPost('url',TYPE_STRING,255),
				'status'=>requestPost('status',TYPE_INT),
				);
				if (empty($nav['name'])) {
					adminMessage('name_notempty',-1);
				}
				if ($nav['color']=='#FFFFFF') {
					$nav['color']='';
				}
				if (!$this->model->insertNav($nav)) {
					adminMessage('nav_add_bad','index.php?wskm=setting&act=nav');
				}
				$this->model->updateCache();
				adminMessage('nav_add_ok','index.php?wskm=setting&act=nav');

			}
			elseif ($hand=='del'){
				if (!$this->model->del($nid)) {
					adminMessage('del_bad','index.php?wskm=setting&act=nav');
				}
				$this->model->updateCache();
				adminMessage('del_ok','index.php?wskm=setting&act=nav');
			}

			if ($hand=='add') {
				assign_var('info',array('status'=>1));
			}
			assign_var('hand',$hand);
			adminTemplate('nav_info');
		}else{

			assign_var('navs',$this->model->getAdminList());
			adminTemplate('nav');
		}

	}

	function doFriendLink(){
		$this->model=usingAdminModel('friendlink');

		if (checkToken()) {
			$dels=requestPost('del',TYPE_ARRAY);
			if (count($dels) >0 ) {
				foreach ($dels as $id){
					if (!$this->model->del($id)) {
						adminMessage('del_bad','index.php?wskm=setting&act=friendlink');
					}
				}

				$this->model->updateCache();
				adminMessage('del_ok','index.php?wskm=setting&act=friendlink');
			}
		}

		$hand=requestGet('hand');
		if ($hand) {
			$fid=(int)requestGet('id');
			if ($fid <1 && $hand != 'add' && !IS_POST) {
				adminMessage('request_error','index.php');
			}
			if ($hand=='edit') {
				if (checkToken()) {
					$flink=array(
					'name'=>requestPost('name',TYPE_STRING,50),
					'displaysort'=>requestPost('displaysort',TYPE_INT),
					'url'=> str_replace('http://','', requestPost('url',TYPE_STRING,255)),
					'logo'=>requestPost('logo',TYPE_STRING,255),
					);
					if (empty($flink['name'])) {
						adminMessage('name_notempty',-1);
					}
					if ($_FILES['uploadlogo']['name'][0]) {

						WSKM::using('wskm_fileupload');
						$attch=uploadEasy('uploadlogo',ART_UPLOAD_PATH.'logo'.DIRECTORY_SEPARATOR,'',1);
						$attch=$attch[0];
						if ($attch['err']) {
							adminMessage($attch['err'],-1);
						}
						if ($attch['path']) {
							$flink['logo']=$attch['path'];
						}

					}

					$fid=requestPost('fid',TYPE_INT);
					if (!$this->model->update($flink,$fid)) {
						adminMessage('flink_edit_bad','index.php?wskm=setting&act=friendlink&hand=edit&id='.$fid);
					}
					$this->model->updateCache();
					adminMessage('flink_edit_ok','index.php?wskm=setting&act=friendlink&hand=edit&id='.$fid);

				}else{
					assign_var('info',$this->model->getInfo($fid));
					assign_var('fid',$fid);
				}
			}elseif ($hand=='add'  && checkToken() ){
				$flink=array(
				'name'=>requestPost('name',TYPE_STRING,50),
				'displaysort'=>requestPost('displaysort',TYPE_INT),
				'url'=> str_replace('http://','',requestPost('url',TYPE_STRING,255)),
				'logo'=>requestPost('logo',TYPE_STRING,255),
				);
				if (empty($flink['name'])) {
					adminMessage('name_notempty',-1);
				}


				if ($_FILES) {
					WSKM::using('wskm_fileupload');
					$attch=uploadEasy('uploadlogo',ART_UPLOAD_PATH.'logo'.DIRECTORY_SEPARATOR,'',1);
					$attch=$attch[0];
					if ($attch['err']) {
						adminMessage($attch['err'],-1);
					}
					if ($attch['path']) {
						$flink['logo']=$attch['path'];
					}
				}
				if (!$this->model->insert($flink)) {
					adminMessage('flink_add_bad','index.php?wskm=setting&act=friendlink');
				}
				$this->model->updateCache();
				adminMessage('flink_add_ok','index.php?wskm=setting&act=friendlink');

			}
			elseif ($hand=='del'){
				if (!$this->model->del($fid)) {
					adminMessage('del_bad','index.php?wskm=setting&act=friendlink');
				}
				$this->model->updateCache();
				adminMessage('del_ok','index.php?wskm=setting&act=friendlink');
			}

			assign_var('hand',$hand);
			adminTemplate('friendlink_info');
		}else{
			assign_var('flinks',$this->model->getList());
			adminTemplate('friendlink');
		}
	}


}

?>