<?php

/**
 * Copyright (C) 2009 Wskm Inc.All rights reserved.  
 * [Gart] www.wskmphp.com 
 * $Id: setting.php 28 2010-09-25 13:17:52Z ws99 $ 
 */

!defined('IN_ART') && exit('Access Denied');

class adminmod_setting extends wskm_model_abstract
{
	public $settings=array();
	public $isUpdateAll=false;
	
	function getSetting($type){				
		$wherestr='';
		if(is_array($type)){
			$wherestr= " type IN ( '".implode("','",$type)."' ) ORDER BY type";
		}else{
			$wherestr= " type ='$type' ";
		}
		
		$query=$this->db->query('SELECT variable,value FROM '.TABLE_PREFIX."settings WHERE $wherestr ");
		while ($item=$this->db->fetch($query)) {
			$this->settings[$item['variable']]=$item['value'];
		}

		return $this->settings;
	}
	
	function readAll()
	{
		$query=$this->db->query('SELECT variable,value FROM '.TABLE_PREFIX."settings");
		while ($item=$this->db->fetch($query)) {
			$this->settings[$item['variable']]=$item['value'];
		}

	}

	function updateCache()
	{
		if (count($this->settings)>0) {
			writeCacheSystem('rules',nl2br($this->settings['regRulesText']));
			
			$this->settings['unameProtect']=explode("\n",$this->settings['unameProtect']);
			$this->settings['emailProtect']=explode("\n",$this->settings['emailProtect']);
			$this->settings['timeFormats']=explode("\n",$this->settings['timeFormats']);
			unset($this->settings['regRulesText']);
			
			WSKM::setConfig('urlMode',$this->settings['urlMode']);
			writeCacheSystem('settings',$this->settings);
		}
	}

	function updateSettings($newset)
	{
		foreach ($newset as $k=>$v){
			if (isset($this->settings[$k]) && $this->settings[$k] != $v) {				
				if($this->db->exec("UPDATE ".TABLE_PREFIX."settings SET variable='$k', value='$v' WHERE variable='$k' ") ===false){
					return false;
				}
				
				if ($k=='urlMode' || $k=='language') {
					$this->isUpdateAll=true;
				}
				
				$this->settings[$k]=stripslashes($v);
			}
		}

		return true;
	}

	function getUserGroups(){
		$query=$this->db->query('SELECT groupid,groupname FROM '.TABLE_PREFIX."usergroups " );
		$list=array();
		while ($tempi=$this->db->fetch($query)) {
			$list[$tempi['groupid']]=$tempi['groupname'];
		}
		
		return $list;
	}
	
	function update($args,$where){
		$res=$this->db->update(TABLE_PREFIX.'settings',$args,$where) !==false;		
		return $res;
	}
	
	function updateItem($variable,$value){
		return $this->update(array('value'=>$value)," variable='{$variable}'  ");
	}
}

?>