<?php

/**
 * Copyright (C) 2009 Wskm Inc.All rights reserved.  
 * [Gart] www.wskmphp.com 
 * $Id: article.php 231 2010-11-23 04:02:04Z ws99 $ 
 */

!defined('IN_ART') && exit('Access Denied');

class model_article extends wskm_model_abstract
{
	function getArticleNews($count=15){
		$count=(int)$count;
		$sql='SELECT aid,cid,uname,dateline,title,titlestyle,summary,digest FROM '.TABLE_PREFIX."articles WHERE status=1 ORDER BY dateline DESC limit {$count}";

		$list=array();
		$query=$this->db->query($sql);

		$cate_parent=WSKM::getValue('category');
		$cate_parent=$cate_parent['tree'];
		while ($row=$this->db->fetch($query)) {
			$row['mvcurl']=mvcUrl('',array('news','show',array('id'=>$row['aid'])));
			$list[]=$row;
		}
		return $list;
	}

	function getArticleBests($count=15){
		$count=(int)$count;
		$sql='SELECT aid,cid,uname,dateline,title,titlestyle,summary,digest FROM '.TABLE_PREFIX."articles WHERE status=1 AND digest=1 ORDER BY aid DESC limit {$count}";

		$list=array();
		$query=$this->db->query($sql);

		$cate_parent=WSKM::getValue('category');
		$cate_parent=$cate_parent['tree'];
		while ($row=$this->db->fetch($query)) {		
			$row['mvcurl']=mvcUrl('',array('news','show',array('id'=>$row['aid'])));
			$list[]=$row;
		}
		return $list;
	}

	function getArticleHots($count=15,$cycle=''){
		$count=(int)$count;
		$wherestr='';
		if ($cycle=='week') {
			$wherestr=' AND YEARWEEK(FROM_UNIXTIME(dateline),1)=YEARWEEK(NOW(),1) ';
		}

		$sql='SELECT aid,cid,uname,dateline,title,views FROM '.TABLE_PREFIX."articles WHERE status=1 {$wherestr} ORDER BY views DESC limit {$count}";

		$list=array();
		$query=$this->db->query($sql);

		$cate_parent=WSKM::getValue('category');
		$cate_parent=$cate_parent['tree'];
		while ($row=$this->db->fetch($query)) {
			$row['mvcurl']=mvcUrl('',array('news','show',array('id'=>$row['aid'])));
			$list[]=$row;
		}

		return $list;
	}

	function getArticleCycles($count=6){
		$count=(int)$count;
		$sql='SELECT aid,cid,dateline,title,cover,summary FROM '.TABLE_PREFIX."articles WHERE status=1 AND cover !=''  ORDER BY dateline DESC limit {$count}";

		$list=array();
		$query=$this->db->query($sql);
		while ($row=$this->db->fetch($query)) {
			if (!strExists($row['cover'],'://')) {
				$row['cover'] = ART_URL.$row['cover'];
			}
			$row['mvcurl']=mvcUrl('',array('news','show',array('id'=>$row['aid'])));
			$list[]=$row;
		}

		return $list;
	}

	function getArticlePics($count=8,$cid=0){
		$count=(int)$count;
		$cid=(int)$cid;
		$wherestr=$cid?"  cid='{$cid}' AND ":'';
		$sql='SELECT aid,cid,dateline,title,titlestyle,cover,summary,digest FROM '.TABLE_PREFIX."articles WHERE $wherestr status=1 AND cover !='' ORDER BY views DESC limit {$count}";

		$list=array();
		$query=$this->db->query($sql);

		$cate_parent=WSKM::getValue('category');
		$cate_parent=$cate_parent['tree'];
		while ($row=$this->db->fetch($query)) {
			if (!strExists($row['cover'],'://')) {
				$row['cover'] = ART_URL.$row['cover'];
			}
			$row['mvcurl']=mvcUrl('',array('news','show',array('id'=>$row['aid'])));
			$list[]=$row;
		}
		return $list;
	}

	function getArticleMessage($id){
		$sql='SELECT mid,aid,message,pagetype FROM '.TABLE_PREFIX."articlemessages WHERE aid= '{$id}' ";
		return $this->db->fetch_first($sql);
	}

	function getArticleInfo($aid){
		$data= $this->db->fetch_first('SELECT cid,kindid,title,uid,uname,dateline,title,views,replies,replystate,tags,author,fromname,fromurl,summary,kiss,bury FROM '.TABLE_PREFIX."articles WHERE aid='{$aid}' AND status=1 ");
		if ($data['fromname']) {
			$data['fromurl']=empty($data['fromurl'])?'#':$data['fromurl'];
			$data['comefrom']='<a href="http://'.$data['fromurl'].'" target="_blank" >'.$data['fromname'].'</a>';
		}

		if ($data['tags']) {
			$data['tags']= explode(' ',$data['tags']);
			$data['htmltags']=$data['htmlkeywords']='';
			foreach ($data['tags'] as $tag){
				$data['htmltags'] .='<a href="'. mvcUrl('',array('tag','show',array('name'=>$tag))) .'" target="_blank" >'.$tag.'</a>&nbsp;';
				$data['htmlkeywords'].=$tag.',';
			}

		}

		return $data;
	}

	function updateClicks($aid){
		$this->db->exec('UPDATE '.TABLE_PREFIX.'articles SET views = views+1  WHERE aid= '.$aid);
	}
	
	function updateNewsKiss($aid,$type=1){
		$wherestr=' kiss=kiss+1 ';
		if ($type != 1) {
			$wherestr=' bury=bury+1 ';
		}
		$this->db->exec('UPDATE '.TABLE_PREFIX."articles SET {$wherestr} WHERE aid= '{$aid}' ");
	}

	function getCommentsSome($aid,$ishot=0){
		$wherestr='';
		if ($ishot) {
			$wherestr=' AND kiss > 10 ORDER BY kiss DESC LIMIT 0,5 ';
		}else{
			$wherestr=' ORDER BY dateline DESC LIMIT 0,10 ';
		}

		$query=$this->db->query('SELECT * FROM '.TABLE_PREFIX."comments WHERE aid ='{$aid}' AND status=1 {$wherestr} ");
		$comments=array();
		while ($tempi=$this->db->fetch($query)){

			if ($tempi['uid'] && $tempi['anonym']=='') {
				$tempi['photo']=getUserPhoto($tempi['uid'],'s',true);
				$tempi['spaceurl']=mvcUrl('',array('user','space',array('uid'=>$tempi['uid'])));
			}else{
				$tempi['photo']=getUserPhoto(0,'s',true);
				$tempi['spaceurl']='javascript:void(0);';
				$tempi['uname']=$tempi['anonym'];
			}

			$comments[]=$tempi;
		}
		return $comments;
	}

	function switchArticleID($type,$aid,$cid){
		$wherestr='';
		if ($type=='next') {
			$wherestr=" aid < '$aid' AND cid='$cid' AND status=1 ORDER BY aid DESC ";
		}else{
			$wherestr=" aid > '$aid' AND cid='$cid' AND status=1 ORDER BY aid ";
		}

		return $this->db->fetch_column('SELECT aid FROM '.TABLE_PREFIX."articles WHERE $wherestr LIMIT 1");
	}

	function switchUrl($aid,$cid){

		$list=array();
		$temp=$this->db->fetch_first('SELECT aid,title FROM '.TABLE_PREFIX."articles WHERE aid < '$aid' AND cid='$cid' AND status=1 ORDER BY aid DESC LIMIT 1");
		
		if ($temp) {
			$list['last']='<li>'.lang('last_url').'<a href="'.mvcUrl('',array('news','show',array('id'=>$temp['aid']))).'" >'.$temp['title'].'</a></li>';
		}

		$temp=$this->db->fetch_first('SELECT aid,title FROM '.TABLE_PREFIX."articles WHERE aid > '$aid' AND cid='$cid' AND status=1 ORDER BY aid LIMIT 1");
		if ($temp) {
			$list['next']='<li>'.lang('next_url').'<a href="'.mvcUrl('',array('news','show',array('id'=>$temp['aid']))).'" >'.$temp['title'].'</a></li>';
		}

		return $list;
	}

	function getPoll($aid){
		$poll=$this->db->fetch_first('SELECT ismore,hits,expire FROM '.TABLE_PREFIX."polls WHERE aid='{$aid}' " );

		$polloption=$noteid=array();
		$details='';
		if ($poll !== false) {
			$sumpoll=$this->db->fetch_column('SELECT SUM(total) FROM '.TABLE_PREFIX."pollsoptions WHERE aid='{$aid}' ");
			$query=$this->db->query('SELECT optionid,total,name,detail FROM '.TABLE_PREFIX."pollsoptions WHERE aid='{$aid}'");
			while ($tempi=$this->db->fetch($query)){
				$details.="\r".$tempi['detail'];
				$tempi['ratio']=@sprintf('%01.2f',$tempi['total']*100/$sumpoll) ;
				$tempi['width']=(int)$tempi['ratio']?$tempi['ratio'].'%':'2px';
				$polloption[]=$tempi;
			}

			if(count($polloption)<1)return false;
		}else{
			return false;
		}

		if ($details) {
			$noteid=explode("\r",$details);
		}

		$user=WSKM::user();
		$vaildkey=is_object($user)?($user->getUid()?$user->getUid():USER_IP):USER_IP;
		$poll['inputtype']=$poll['ismore']?'checkbox':'radio';

		if (IS_HTML) {
			$poll['isput']=false;
		}else{
			$poll['isput']=in_array($vaildkey,$noteid);
		}
		$poll['isexpire']=$poll['expire']?(WSKM_TIME >= $poll['expire']):false;

		return array('poll'=>$poll,'options'=>$polloption);
	}

	function putPoll($aid,$optionids){
		$poll=$this->db->fetch_first('SELECT ismore,expire FROM '.TABLE_PREFIX."polls WHERE aid='{$aid}' " );
		if ($poll == false) {
			return 'request_error';
		}
		if ($poll['expire'] && WSKM_TIME >= $poll['expire']) {
			return 'poll_err_expire';
		}
		if (!$poll['ismore'] && count($optionids)>1) {
			return 'poll_err_more';
		}

		$polloptions=$optionlist=array();
		$user=WSKM::user();
		$vaildkey=is_object($user)?($user->getUid()?$user->getUid():USER_IP):USER_IP;
		$query=$this->db->query('SELECT optionid,detail FROM '.TABLE_PREFIX."pollsoptions WHERE aid='{$aid}'  ");
		while ($tempi=$this->db->fetch($query)){
			if (strExists("\r".$tempi['detail']."\r","\r".$vaildkey."\r")) {
				return 'poll_err_alreadyput';
			}
			$polloptions[]=$tempi['optionid'];
		}

		foreach ($optionids as $optionid){
			if (!in_array($optionid,$polloptions)) {
				return 'request_error';
			}
			$optionlist[]=$optionid;
		}

		$optioncolumn=implode("','",$optionlist);
		if($this->db->exec('UPDATE '.TABLE_PREFIX."pollsoptions SET  total=total+1,detail=CONCAT(detail,'{$vaildkey}\r') WHERE optionid IN ('{$optioncolumn}') ") === false){
			return 'poll_bad';
		}

		if ($this->db->exec('UPDATE '.TABLE_PREFIX."polls SET hits=hits+1 WHERE aid='{$aid}'") === false) {
			return 'poll_bad';
		}
		return 'poll_ok';

	}

}




?>