<?php

/**
 * Copyright (C) 2009 Wskm Inc.All rights reserved.  
 * [Gart] www.wskmphp.com 
 * $Id: class_page.php 194 2010-11-14 14:09:14Z ws99 $ 
 */

!defined('IN_ART') && exit('Access Denied');

class art_page extends wskm_page_abstract
{
	private $isHtml=false;
	private $isHome=false;
	public function isHTML($or=true){
		$this->isHtml=(bool)$or;
	}
	public function isHome($or=true){
		$this->isHome=(bool)$or;
	}
	
	public function __construct()
	{
		parent::__construct();

		$this->page_start();
		$this->page_load();

	}

	public function __destruct(){

		if (wskm_note::read('cache')) {
			ob_clean();
			$ucache=array_unique((array)wskm_note::read('cache'));
			if ($ucache) {
				usingArtClass('cache');

				$isall=false;
				foreach ($ucache as $cachename){
					if ($cachename=='settings') {
						$isall=true;
						break;
					}
				}

				if ($isall) {
					art_cache::updateAll();
				}else{
					foreach ($ucache as $cachename){
						art_cache::update($cachename);
					}
				}
			}else{
				exit('unknown');
			}

			exit('Please refresh the page!');
		}
				
		$this->page_end();
		if (IS_HTML && $this->isHtml) {
			$this->cacheHtml();
		}
	}
	public function page_end(){}

	public function page_start(){
		$this->loadCacheSystem();
		$this->loadAssign();
	}

	public function cacheHtml(){
		$url=wskm_http_url::getSingle();
		$url->isHttp();
		$key=$url->htmlKey();
		if (!$key) {
			return ;
		}

		$htmlpath=ART_ROOT.'html'.DS.$key.'.html';
	
		if (!UPDATE_HTML && file_exists($htmlpath) && WSKM_TIME < (int)WSKM::getConfig('cacheHtmlTime') + filemtime($htmlpath)) {
			return ;
		}
		
		$value=ob_get_contents();
		$tourl=str_replace(array('&updatehtml=1','?updatehtml=1'),'',PAGE_SELF);
		$value.= jsWriter('var r=Math.random()*10000000;document.write(\'<script type="text/javascript" src="'.ART_URL.'wskm.php?act=checkhtml&r=\'+ r +\'&url='.rawurlencode($tourl).'&key='.rawurlencode($key).(MVC_APP=='news'?'&update='.requestGet('id',TYPE_INT):'').'" ><\/script>\');',true);
		wskm_io::fWrite($htmlpath,$value); 
		if (!$this->isHome) {
			usingArtClass('cache');
			art_cache::update('static');
			if (MVC_APP=='category') {
				art_cache::update('category');
			}
		}

	}
	
	public function loadCacheSystem(){
		loadCacheSystem('style');
		loadCacheSystem('category');
		loadCacheSystem('nav');
	}

	public function loadAssign()
	{
		if ( is_object($this->user)) {
			$styleid=requestGet('styleid',TYPE_INT);
			if ($styleid < 1) {
				$styleid=$this->user->getStyleid();
			}else{
				wskm_cookie::write('styleid',$styleid,31536000);
			}

			if (!in_array($styleid,array_keys(WSKM::getValue('style')))) {
				$styleid=(int)WSKM::getConfig('styleId');
			}
			$this->user->setStyleid($styleid);
			$temp=getWebStyle($styleid);
			define('STYLEID', $styleid);
			define('STYLENAME',$temp['name']);
			define('STYLEVERSION',$temp['version']);
			define('COOKIEPRE', WSKM::getConfig('cookiePre'));
			define('COOKIEDOMAIN', WSKM::getConfig('cookieDomain'));
			define('COOKIEPATH', WSKM::getConfig('cookiePath'));

			define('UNAME',$this->getUname());
			define('UID',$this->getUid());
			define('ADMINID',$this->getAdminid());
			define('GROUPID',$this->getGroupid());
		}

		assign_var('page_seotitle',WSKM::getConfig('webTitle')?WSKM::getConfig('webTitle').'_':'');
		assign_var('page_seokeywords',WSKM::getConfig('webKeywords'));
		assign_var('page_seodescription',WSKM::getConfig('webDescription'));
		assign_var('page_footer',WSKM::getConfig('pageFooter'));
		assign_var('topnav',WSKM::getValue('nav'));
		assign_var('nav_current','index');
		
		$temp=WSKM::getValue('category');
		assign_var('categorylist',$temp['tree']);
		
		assign_var('popBgShow',(int)WSKM::getConfig('popBgShow'));
		assign_var('popBgColor',WSKM::getConfig('popBgColor'));
		if (!IS_HTML && (bool)WSKM::getConfig('isSwitchTheme')) {
			assign_var('themelist',WSKM::getValue('style'));
		}
		unset($temp);
	}

	public function page_load(){}



}

?>