<?php

/**
 * Copyright (C) 2009 Wskm Inc.All rights reserved.  
 * [Gart] www.wskmphp.com 
 * $Id: fun_common.php 222 2010-11-22 09:20:03Z ws99 $ 
 */

!defined('IN_ART') && exit('Access Denied');


function loadLang($key,$iserr=false)
{
	return wskm_lang::lang($key,LANGUAGE,false,false,$iserr);
}

function readConfig($key,$isp='')
{
	$path=ART_DATA.$key.'config.php';
	return loadArray($path,$isp);
}

function artMessage($message='', $urlForward = '')
{
	showMessage($message,$urlForward);
}

function checkToken($type=URL_POST,$showerr=1) {
	if ($type==URL_POST && IS_POST && isMyReferer()) {
		if (ART_HASH !=  requestPost('arthash')) {
			if($showerr){
				if (!defined('IN_ADMIN')) {
					adminMessage('request_expired','index.php');
				}else{
					artMessage('request_expired','index.php');
				}
			}elseif($showerr===-1){
				xmlMessage('request_expired');
			}
			return false;
		}
		return 	true;
	}else{
		return ART_HASH ==  requestGet('arthash');
	}
}

function usingArtInc($name)
{
	return require_once(ART_INC_PATH.'inc_'.$name.'.php');
}

function usingArtFun($name)
{
	return require_once(ART_INC_PATH.'fun_'.$name.'.php');
}

function usingArtClass($name)
{
	if (class_exists('art_'.$name) || interface_exists('art_'.$name)) {
		return true;
	}
	return require(ART_INC_PATH.'class_'.$name.'.php');
}

function toUrlSeparator($str){
	return str_replace(DIRECTORY_SEPARATOR,'/',$str);
}

function usingAdminModel($model)
{
	$className =WSKM::getConfig('modelAdminPrefix').$model;	
	$path = ART_ADMIN_PATH.'core'.DS.substr(WSKM::getConfig('modelAdminPrefix'),0,-1).DS.$model.'.php';
	if(WSKM::usingBase($className,$path))
	{
		return new $className();
	}
	throw new wskm_exception('Not admin model:'.$model);
}

function usingAdminControl($app)
{
	$className =MVC_APP_PREFIX.$app;
	$path = ART_ADMIN_PATH.'core'.DS.'app'.DS.$app.'.php';
	if(WSKM::usingBase($className,$path))
	{
		return new $className();
	}
	return false;
}

function usingModel($name){
	return WSKM::usingModel($name);
}

function getWebStyle($styleid){
	$style=WSKM::$caches['style'][$styleid];
	if (empty($style)) {
		wskm_note::note('style','cache');
	}else{
		return $style;
	}

	return false;
}

function loadCacheSystem($name){
	$path=ART_CACHE_PATH.'data'.DS.'sys_'.$name.'.php';

	if (file_exists($path)) {
		if (strpos($name,'usergroup') !== false) {
			$name='usergroup';
		}
		WSKM::setValue($name,include($path));
	}else{
		wskm_note::note($name,'cache');
		return false;
	}
	
	return true;
}

function loadCacheConfig($name,$key=''){
	$path=ART_CACHE_PATH.'data'.DS.'sys_'.$name.'.php';

	if (file_exists($path)) {
		WSKM::loadConfig($path,$key);
	}else{
		wskm_note::note($name,'cache');
	}
}

function readCacheSystem($name){
	$path=ART_CACHE_PATH.'data'.DS.'sys_'.$name.'.php';

	if (file_exists($path)) {
		return include($path);
	}
	return false;
}

function writeCacheSystem($name,$arr)
{	
	wskm_cache::writeArray(ART_CACHE_PATH.'data'.DS.'sys_'.$name.'.php',$arr);	
	clearstatcache();	
}

function readCacheStatic($name,$life=0){
	$path=ART_CACHE_PATH.'data'.DS.'static_'.$name.'.php';
	$life=$life==0?(int)WSKM::getConfig('cacheStaticTime'):$life;
	if (file_exists($path) && WSKM_TIME < $life +filemtime($path) ) {
		return include($path);
	}

	return false;
}

function writeCacheStatic($name,$arr){
	wskm_cache::writeArray(ART_CACHE_PATH.'data'.DS.'static_'.$name.'.php',$arr);
	clearstatcache();
}

function removeCacheStatic($name){
	if(wskm_io::fDelete(ART_CACHE_PATH.'data'.DS.'static_'.$name.'.php'))clearstatcache();
}

function getCategoryData($cid){
	return WSKM::$caches['category']['tree'][$cid];
}

function getCategoryParents($cid){
	$parents=array();
	foreach ( WSKM::$caches['category']['parentlist'][$cid] as $parent ){
		if ($parent == 0) {
			continue;
		}
		$parents[$parent]=WSKM::$caches['category']['tree'][$parent];
	}
	return $parents;
}

function getCategoryChilds($cid){
	$childs=array();
	foreach ( WSKM::$caches['category']['childlist'][$cid] as $child ){
		if ($child == 0) {
			continue;
		}
		$childs[$child]=WSKM::$caches['category']['tree'][$child];
	}
	return $childs;
}

function getPhotoDir($uid){
	return ART_ROOT.'photo'.DS.substr(md5( round($uid/100) )  ,0,6).DS;
}

function getUserPhoto($uid,$imgsize='m',$ishtml=true,$addurl=''){
	
	$sizes=array('s'=>'width="50"','m'=>'width="100"','b'=>'width="180"');
	if (WSKM::getConfig('userEngine') == 'ucenter') {
		$sizetype=array('s'=>'small','m'=>'middle','b'=>'big');
		if (isset($sizetype[$imgsize]) && $sizetype[$imgsize]) {
			$size=$sizetype[$imgsize];
		}else{
			$size='middle';
		}
		return $ishtml ? '<img src="'.UC_API.'/avatar.php?uid='.$uid.'&size='.$size.$addurl.'"  '.$sizes[$imgsize].' />':UC_API.'/avatar.php?uid='.$uid.'&size='.$size.$addurl ;
	}else{
		return $ishtml?'<img src="'.ART_URL.'photo.php?uid='.$uid.'&size='.$imgsize.$addurl.'" '.$sizes[$imgsize].' />':ART_URL.'photo.php?uid='.$uid.'&size='.$imgsize.$addurl;
	}
}

function defaultListImage(){
	return '/images/common/default.gif';
}

function tigerUser(){
	$name=WSKM::getConfig('userEngine');
	usingArtClass($name);
	
	$name='art_'.$name;
	return new $name();
}

function getWskm($key,$expire=''){
	$data=array();
	$data=readCacheStatic($key,(int)$expire);
	if (!$data  && !is_array($data)) {
		usingArtClass('util');
		$fun='get'.$key;
		if(!method_exists('art_util',$fun)){
			exit('wskm:'.$key);
		}

		$data = art_util::$fun();
		$data && writeCacheStatic($key,$data);
	}
	return $data;
}

function pluginLang($key){
	wskm_lang::loadPath(PLUGIN_PATH.'lang'.DS.$key.'_'.LANGUAGE.'_lang.php');
}

function isAccessFor($key){
	return (bool)WSKM::getValues('usergroup',$key);
}

function getUserAccess($key){
	return WSKM::getValues('usergroup',$key);
}

?>