<?php

/**
 * Copyright (C) 2009 Wskm Inc.All rights reserved.  
 * [Gart] www.wskmphp.com 
 * $Id: search.php 193 2010-11-14 13:28:18Z ws99 $ 
 */

define('IN_ART',true);
define('IS_MVC',false);

require('includes'.DIRECTORY_SEPARATOR.'inc_common.php');
$wk=requestGet('wk',TYPE_STRING,30);
define('URLMODE', WSKM::getConfig('urlMode'));

WSKM::using('wskm_page_abstract');
WSKM::using('wskm_template_easy');
WSKM::using('wskm_http_mvc');

loadCacheSystem('style');
loadCacheSystem('category');
loadCacheSystem('nav');
if (wskm_note::read('cache')) {
	gotoUrl(URL_HOME);
}

$user=WSKM::user();
if ( is_object($user)) {
	define('STYLEID',$user->getStyleid());
	$temp=getWebStyle(STYLEID);
	define('STYLENAME',$temp['name']);
	define('STYLEVERSION',$temp['version']);

	define('UNAME',$user->getUname());
	define('UID',$user->getUid());
	define('ADMINID',$user->getAdminid());
	define('GROUPID',$user->getGroupid());
}

$searchdata=array();
if ($wk) {
	$searchkey=array(
	'wk'=>rawurlencode($wk),
	);
	$searchtype='title';
	if ($searchtype=='title') {
		$search .= ' AND title LIKE \'%'.$wk.'%\' ';
	}

	$pageCount=15;
	$currpage=1;

	$db=WSKM::SQL();
	$totalcount=$db->fetch_column('SELECT COUNT(*) FROM '.TABLE_PREFIX."articles WHERE status=1  {$search} ");

	$startpage=multiPage_start($currpage,$pageCount,$totalcount);

	$cateCache=null;
	if ($totalcount) {
		$cateCache=WSKM::getValues('category','tree');
	}

	$list=array();
	$query=$db->query('SELECT aid,cid,uid,uname,dateline,title,titlestyle,summary FROM '.TABLE_PREFIX."articles WHERE status=1 {$search} ORDER BY dateline DESC LIMIT {$startpage},{$pageCount} ");
	while ($tempi=$db->fetch($query)){
		$tempi['cateurl']='[<a href="'.$cateCache[$tempi['cid']]['mvcurl'].'" target="_blank" >'.$cateCache[$tempi['cid']]['name'].'</a>]';
		$tempi['mvcurl']=mvcUrl('',array('news','show',array('id'=>$tempi['aid'])));
		$searchdata[]=$tempi;
	}

	assign_var('htmlpage',multiPage($totalcount,$currpage,'search.php'.'&'.http_build_query($searchkey),$pageCount));
}

assign_var('topnav',WSKM::getValue('nav'));
assign_var('nav_current','index');
$temp=WSKM::getValue('category');
assign_var('categorylist',$temp['tree']);

assign_var('popBgShow',(int)WSKM::getConfig('popBgShow'));
assign_var('popBgColor',WSKM::getConfig('popBgColor'));
if (!IS_HTML && (bool)WSKM::getConfig('isSwitchTheme')) {
	assign_var('themelist',WSKM::getValue('style'));
}

assign_var('page_title',lang('search').'_'.$searchkey['wk'].'_');
assign_var('searchdata',$searchdata);
assign_var('wk',$wk);
template('search');

?>