<?php defined('IN_ADMIN') or exit;

abstract class import
{
    protected $db,
    $import_db,
    $relation = array(),
    $relation_base_path,
    $cmscharset,
    $cmstop_charset,
    $pagevar = "<p class=\"mcePageBreak\"></p>",
    $pagetitlevar = "<p class=\"mcePageBreak\">$1</p>",
    $validate_groupid = 4,
    $relations = array(),
    $tables = array(),
    $ids = array(),

    $disable_groupid = 4,
    $default_email = 'no-email@example.com';

    protected $_pagesize = array(
    'category' => 20,
    'article' => 25,
    'picture' => 25,
    'comment' => 50,
    'member' => 50
    );
    /*
    // content
    $c['catid'] = $content[''];
    $c['modelid'] = $content[''];
    $c['title'] = $content[''];
    $c['color'] = $content[''];
    $c['thumb'] = $content[''];
    $c['tags'] = $content[''];
    $c['sourceid'] = $content[''];
    $c['weight'] = $content[''];
    $c['status'] = $content[''];
    $c['created'] = $content[''];
    $c['createdby'] = $content[''];
    $c['published'] = $content[''];
    $c['publishedby'] = $content[''];
    $c['modified'] = $content[''];
    $c['modifiedby'] = $content[''];
    $c['iscontribute'] = $content[''];
    $c['pv'] = $content[''];
    $c['allowcomment'] = $content[''];

    // article
    $a['contentid'] = $content[''];
    $a['subtitle'] = $content[''];
    $a['author'] = $content[''];
    $a['editor'] = $content[''];
    $a['description'] = $content[''];
    $a['content'] = $content[''];
    $a['pagecount'] = $content[''];
    */
    protected static $article = array(
    'modelid' => '1',
    'catid' => '',
    'title' => '',
    'color' => '',
    'subtitle' => '',
    'tags' => 'Tag',
    'source' => '',
    'author' => '',
    'editor' => '',
    'content' => '',
    'saveremoteimage' => '0',
    'description' => '',
    'thumb' => '6/d0/1280376392658.jpg',
    'weight' => '60',
    'sectionids' => '',
    'status' => '6',
    'allowcomment' => '1',
    'published' => '',
    'unpublished' => ''
    ),
    $category = array (
    'parentid' => '',
    'name' => '',
    'alias' => '',
    'workflowid' => '0',
    'model' =>
    array (
    1 => array ('show' => '1', 'template' => 'article/show.html'),
    2 => array ('show' => '1', 'template' => 'picture/show.html'),
    3 => array ('show' => '1'),
    4 => array ('show' => '1', 'template' => 'video/show.html'),
    5 => array ('show' => '1', 'template' => 'interview/show.html'),
    7 => array ('show' => '1', 'template' => 'activity/show.html'),
    8 => array ('show' => '1', 'template' => 'vote/show.html'),
    9 => array ('show' => '1', 'template' => 'survey/show.html'),
    10 => array ('show' => '1')
    ),
    'template_index' => 'system/category.html',
    'template_list' => 'system/list.html',
    'path' => '{PSN:1}',
    'iscreateindex' => '1',
    'urlrule_index' => '{$alias}/index.shtml',
    'urlrule_list' => '{$alias}/{$model}{$page}.shtml',
    'urlrule_show' => '{$year}/{$month}{$day}/{$contentid}{$page}.shtml',
    'sort' => 0,
    'enablecontribute' => '1'
    ),
    $picture = array (
    'modelid' => '2',
    'catid' => '',
    'title' => '',
    'color' => '',
    'tags' => '',
    'source' => '',
    'author' => '',
    'editor' => '',
    'description' => '',
    'thumb' => '',
    /*'pictures' =>
    array (
    1 =>
    array (
    'pictureid' => '0',
    'sort' => '1',
    'aid' => '16',
    'image' => 'c/a3/1280376470100.jpg',
    'note' => '',
    ),
    2 =>
    array (
    'pictureid' => '0',
    'sort' => '2',
    'aid' => '15',
    'image' => '6/d0/1280376392658.jpg',
    'note' => '',
    )
    ),*/
    'weight' => '60',
    'sectionids' => '',
    'status' => '6',
    'allowcomment' => '1',
    'published' => ''
    );
    /* cmstop member group
    `groupid` tinyint(3) unsigned NOT NULL auto_increment,
    `name` char(20) NOT NULL,
    `status` tinyint(1) unsigned NOT NULL default '1',
    `allowlogin` tinyint(1) unsigned NOT NULL default '1',
    `space` tinyint(1) unsigned NOT NULL default '0',
    `allowcontribute` tinyint(3) unsigned NOT NULL default '1',
    `allowcomment` tinyint(3) unsigned NOT NULL default '1',
    `issystem` tinyint(1) unsigned NOT NULL default '0',
    `sort` tinyint(3) unsigned NOT NULL default '0',
    `tabview` tinyint(1) NOT NULL default '0' COMMENT '是否显示于标签',
    `remarks` varchar(255) NOT NULL,
    * */

    protected static $model_article;
    protected static $model_link;
    protected static $model_category;
    protected static $model_comment;
    protected static $model_picture;
    protected static $model_attachment;
    protected static $model_picture_group;
    protected static $model_member_group;

    function __construct($options)
    {
        global $cache_path;

        $this->import_db = & factory::db($options);
        $this->db = & factory::db();
        $this->relation_base_path = $cache_path . 'relation/';
        $this->cmscharset = $options['cmscharset'];
        $this->cmstop_charset = $options['cmstopcharset'];

        import('helper.pinyin');

        self::$model_article = loader::model('admin/article', 'article');
        self::$model_link = loader::model('admin/content', 'system');
        self::$model_category = loader::model('admin/category', 'system');
        self::$model_comment = loader::model('comment', 'comment');
        self::$model_picture = loader::model('admin/picture', 'picture');
        self::$model_attachment = loader::model('admin/attachment', 'system');
        self::$model_picture_group = loader::model('admin/picture_group', 'picture');
        self::$model_member_group = loader::model('member_group', 'member');
    }

    public function pagesize($type = NULL)
    {
        return is_null($type) ? $this->_pagesize : (intval($_REQUEST['pagesize']) ? intval($_REQUEST['pagesize']) : $this->_pagesize[$type]);
    }

    protected function _after_config(& $data)
    {
        if (is_array($this->config))
        {
            $data['config'] = $this->config;
        }
        else
        {
            $data['config'] = array(
            pagesize => array(
            'category' => 30,
            'article' => 20,
            'picture' => 20,
            'comment' => 20,
            'member' => 20
            ),
            data => array(
            'thumb_search' => '',
            'thumb_replace' => '',
            'thumb_prefix' => '',
            'attach_search' => '',
            'attach_replace' => '',
            'attach_prefix' => '',
            'content_search' => array(),
            'content_replace' => array()
            )
            );
        }
    }

    protected function handle_charset(& $data)
    {
        if ($this->cmscharset != $this->cmstop_charset)
        {
            $data = str_charset($this->cmscharset, $this->cmstop_charset . '//IGNORE', $data);
        }
    }

    protected function handle_thumb($path, & $options)
    {
        if (!empty($path))
        {
            if (!empty($options['thumb_search']))
            {
                $path = str_replace($options['thumb_search'], $options['thumb_replace'], $path);
            }
            if (!empty($options['thumb_prefix']))
            {
                $path = $options['thumb_prefix'] . $path;
            }
            return $path;
        }
        return '';
    }

    protected function handle_attach($path, & $options)
    {
        if (!empty($path))
        {
            $path = trim($path);
            if (!empty($options['attach_search']))
            {
                $path = str_replace($options['attach_search'], $options['attach_replace'], $path);
            }
            if (!empty($options['attach_prefix']))
            {
                $path = $options['attach_prefix'] . $path;
            }
            return $path;
        }
        return '';
    }

    protected function handle_content($content, & $options)
    {
        if (!empty($options['content_search']) && is_array($options['content_search'])
        && !empty($options['content_replace']) && is_array($options['content_replace'])
        )
        {
            $content = str_replace($options['content_search'], $options['content_replace'], $content);
        }
        return $content;
    }

    protected function handle_key_value($key_value_array)
    {
        return array(
        'key' => '`' . implode('`, `', array_keys($key_value_array)) . '`',
        'value' => "'" . implode("', '", array_values($key_value_array)) . "'"
        );
    }

    protected function handle_key_value_update($key_value_array)
    {
        $sql = '';
        foreach ($key_value_array as $key => $value)
        {
            $sql .= "`$key` = '$value', ";
        }
        return rtrim($sql, ' ,');
    }

    // TODO
    protected function handle_path($name, $url, $dir, $parentdir = '')
    {
        return self::$category['path'];
        /*
        if (!empty($url) && preg_match('/:\/\//', $url))
        {
            // 以本目录别名结尾，直接给出父栏目 path
            $alias = explode('/', $dir);
            $alias = $dir[count($alias) - 1];
            if (preg_match("/\/$alias\/$/", rtrim($url, '/') . '/'))
            {
                $result = $parentdir . '/';
            }
            else
            {
                // 第一种情况，url
                $find = false;
                $psn = table('psn');
                foreach ($psn as $p)
                {
                    if (preg_match("/^" . preg_quote($p['url']) . "/", $url))
                    {
                        $find = true;
                        $result = '{PSN:' . $p['psnid'] . '}';
                        break;
                    }
                }
                
                if (!$find)
                {
                    $url = rtrim($url, '/') . '/';
                    $path = preg_replace("/(\/\/)/", '/', $parentdir . $dir . '/');
    
                    if ($psn = $this->db->get("SELECT * FROM `#table_psn` WHERE `url` = '$url'"))
                    {
                        if ($psn['path'] != $path)
                        {
                            $this->db->update("UPDATE `#table_psn` SET `path` = $path");
                        }
                        $psnid = $psn['psnid'];
                    }
                    else
                    {
                        $psn = array(
                        'name' => $name,
                        'path' => $path,
                        'url' => $url
                        );
                        $psn = $this->handle_key_value($psn);
                        $psnid = $this->db->insert("INSERT INTO `#table_psn` ({$psn['key']}) VALUES ({$psn['value']})");
                    }
    
                    $result = '{PSN:' . $psnid . '}';
                }
            }
        }
        else
        {
            $result .= $parentdir ? $parentdir . '/' : self::$category['path'];
        }

        $result = preg_replace("/(\/\/)$/", '/', $result);
        return preg_replace("/(\}\/)$/", '}', $result);  
         */
    }

    protected function handle_urlrules(& $category, $indexrule, $listrule, $showrule)
    {

    }

    protected function get_relation($type)
    {
        $relation = cache_read("$type.php", $this->relation_base_path);
        if (!is_array($relation))
        {
            $relation = array();
        }
        return $relation;
    }

    protected function save_relation($type, $relation)
    {
        cache_write("$type.php", $relation, $this->relation_base_path);
    }
}
