<?php defined('IN_ADMIN') or exit;

class dedecms56 extends import implements ICmsImport
{

    protected $config = array(
        pagesize => array(
            'category' => 30,
            'article' => 20,
            'picture' => 20,
            'comment' => 20,
            'member' => 20
        ),
        data => array(
            'thumb_search' => '/uploads/',
            'thumb_replace' => 'uploads/',
            'thumb_prefix' => '',
            'attach_search' => '/uploads/',
            'attach_replace' => 'uploads/',
            'attach_prefix' => '',
            'content_search' => array(
                '="/uploads/'
            ),
            'content_replace' => array(
                "=\"{UPLOAD_URL}uploads/"
            )
        )
    );

    private $status_relation = array(
        0 => 6,
        '-1' => 3,
        '-2' => 0
    );

    function __construct($options) {
        parent::__construct($options);

        $this->relation_base_path .= __CLASS__ . '/';
    }

    function config($options) {
        $data = array();

        if ($options['data']) {
            $query = $this->import_db->get($this->get_category_sql('COUNT(`id`) AS `total`'));
            $data['data']['category'] = $query['total'];
        }

        if ($options['member']) {
            $query = $this->import_db->get("SELECT COUNT(`mid`) AS `total` FROM `#table_member`");
            $data['member']['total'] = $query['total'];
        }

        $this->_after_config($data);
        return $data;
    }

    function detail($options) {
        $data = array();

        if ($options['member']) {
            $query = "SELECT COUNT(`mid`) AS `total` FROM `#table_member`";
            $query = $this->import_db->get($query);
            $data['member']['total'] = $query['total'];
        }

        if ($options['data']) {
            $cat_sql = '';

            // 计算栏目数
            $sql = $this->get_category_sql('COUNT(`id`) AS `total`');
            $query = $this->import_db->get($sql);
            $data['data']['total']['category'] = $query['total'];

            // 计算文章数
            if ($options['data']['article']) {
                $sql = "SELECT COUNT(`aid`) AS `total` FROM `#table_addonarticle`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['article'] = $query['total'];
            }

            // 计算组图数
            if ($options['data']['picture']) {
                $sql = "SELECT COUNT(`aid`) AS `total` FROM `#table_addonimages`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['picture'] = $query['total'];
            }

            // 计算评论数
            $modelid = array();
            if ($options['data']['article']) {
                $modelid[] = 1;
            }
            if ($options['data']['picture']) {
                $modelid[] = 2;
            }
            if (!empty($modelid) && $options['data']['comment']) {
                $sql = "SELECT COUNT(`id`) AS `total` FROM `#table_feedback`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['comment'] = $query['total'];
            }
        }

        return $data;
    }

    function import($options) {
        $type = $options['type'];
        $start = intval($options['start']);
        $pagesize = $this->pagesize($type);
        $data = array();

        switch ($type)
        {
            case 'category':
                if ($categorys = $this->import_db->select($this->get_category_sql('*', "LIMIT $start, $pagesize"))) {
                    $category_relation = $this->get_relation('category');
                    foreach ($categorys as $c)
                    {
                        $catid = $c['id'];

                        // 如果之前的操作已经添加过了，跳过
                        if (isset($category_relation[$catid])) {
                            continue;
                        }

                        $parentids = array($c['id']);
                        $parentid = $c['reid'];
                        while ($parentid)
                        {
                            $parent = $this->import_db->get($this->get_category_sql('`id`, `reid`', " AND `id` = $parentid"));
                            $parentids[] = $parent['id'];
                            $parentid = $parent['reid'];
                        }
                        $parentids = array_reverse($parentids);

                        foreach ($parentids as $parentid)
                        {
                            if (isset($category_relation[$parentid])) {
                                continue;
                            }

                            // 添加栏目，由于是按照从前到后的顺序来添加，假定按照这个顺序添加的栏目，父栏目都已经存在
                            if ($query = $this->import_db->get($this->get_category_sql('*', " AND `id` = $parentid"))) {
                                $category = self::$category;

                                $this->handle_charset($query);

                                $category['parentid'] = $query['reid'] ? $category_relation[$query['reid']] : '';
                                $category['name'] = $query['typename'];
                                $category['alias'] = array_pop(explode('/', $query['typedir']));

                                // 发布点
                                !preg_match('/:\/\//', $query['typedir']) && $query['typedir'] = $category['alias'];
                                $query['parentdir'] = $this->import_db->get($this->get_category_sql('`typedir`', "AND `id` = '{$category['reid']}'"));
                                $query['parentdir'] = $query['parentdir']['typedir'];
                                $category['path'] = $this->handle_path($query['typename'], $query['typedir'], $category['alias'], $query['parentdir']);

                                $category['sort'] = $query['sortrank'];

                                if ($new_catid = self::$model_category->add($category)) {
                                    // 将新的ID关系对应保存起来
                                    $category_relation[$parentid] = $new_catid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $parentid;
                                }
                            }
                            else
                            {
                                continue;
                            }
                        }
                    }
                }

                $this->save_relation('category', $category_relation);
                $data['start'] = $start + $pagesize;
                break;

            case 'article':
                // 根据之前的栏目获得要转换的文章
                $category_relation = $this->get_relation('category');
                $article_relation = $this->get_relation('article');

                if (!empty($category_relation) && ($result = $this->import_db->select("SELECT * FROM `#table_addonarticle` c LEFT JOIN `#table_archives` n ON c.`aid` = n.`id` WHERE n.`typeid` IN (" . implode(',', array_keys($category_relation)) . ") LIMIT $start, $pagesize"))) {
                    foreach ($result as $article)
                    {
                        if (isset($article_relation[$article['id']])) {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($article);

                        $content = self::$article;
                        $content['catid'] = $category_relation[$article['typeid']];
                        $content['title'] = $article['shorttitle'] ? $article['shorttitle'] : $article['title'];
                        $content['titleintact'] = $article['shorttitle'] ? $article['title'] : '';
                        $content['color'] = $article['color'];
                        $content['tags'] = str_replace(',', ' ', $article['keywords']);
                        $content['status'] = $this->status_relation[$article['arcrank']];

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($article['litpic'], $options);

                        if (!empty($article['redirecturl'])) {
                            $content['modelid'] = 3;
                            $content['url'] = $article['redirecturl'];

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['source'] = $article['source'];
                            $content['author'] = $article['writer'];
                            $content['editor'] = $this->username($article['mid']);

                            // 处理内容替换
                            //$article['body'] = preg_replace('/onclick="/.*?"', '', $article['body']);
                            $content['content'] = $this->handle_content($article['body'], $options);
                            if (preg_match('/\#p\#(.*)\#e\#/', $content['content']))
                            {
                                $content['content'] = $this->pagevar . preg_replace('/\#p\#(.*)\#e\#/', $this->pagetitlevar, $content['content']);
                            }

                            $content['description'] = strip_tags(preg_replace("/\#p\#(.*)\#e\#/", '', $article['description']));

                            $contentid = self::$model_article->add($content);
                        }

                        if ($contentid) {
                            $published = '';
                            $publishedby = '';
                            if ($content['status'] == 6) {
                                $published = $article['pubdate'];
                                $publishedby = $article['mid'];
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$article['pubdate']}', `createdby` = '{$article['mid']}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$article['click']}' WHERE `contentid` = $contentid");
                            $article_relation[$article['id']] = $contentid;
                        }
                        else
                        {
                            // 出错
                            $data['error'][] = $article['id'];
                        }
                    }

                    $this->save_relation('article', $article_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'picture':
                // 根据之前的栏目获得要转换的组图
                $category_relation = $this->get_relation('category');
                $picture_relation = $this->get_relation('picture');

                if (!empty($category_relation) && ($result = $this->import_db->select("SELECT * FROM `#table_addonimages` c LEFT JOIN `#table_archives` n ON c.`aid` = n.`id` WHERE n.`typeid` IN (" . implode(',', array_keys($category_relation)) . ") LIMIT $start, " . $pagesize))) {
                    foreach ($result as $picture)
                    {
                        if (isset($picture_relation[$picture['id']])) {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($picture);

                        $content = self::$picture;
                        $content['catid'] = $category_relation[$picture['typeid']];
                        $content['title'] = $picture['shorttitle'] ? $picture['shorttitle'] : $picture['title'];
                        $content['titleintact'] = $picture['shorttitle'] ? $picture['title'] : '';
                        $content['color'] = $picture['color'];
                        $content['tags'] = str_replace(',', ' ', $picture['keywords']);
                        $content['status'] = $this->status_relation[$picture['arcrank']];

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($picture['litpic'], $options);

                        if (!empty($picture['redirecturl'])) {
                            $content['modelid'] = 3;
                            $content['url'] = $picture['redirecturl'];

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['source'] = $picture['source'];
                            $content['author'] = $picture['writer'];
                            $content['editor'] = $this->username($picture['mid']);
                            $content['description'] = strip_tags($picture['description']);

                            $contentid = self::$model_picture->add($content);
                        }

                        if ($contentid) {
                            $published = '';
                            $publishedby = '';
                            if ($content['status'] == 6) {
                                $published = $picture['pubdate'];
                                $publishedby = $picture['mid'];
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$picture['pubdate']}', `createdby` = '{$picture['mid']}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$picture['click']}' WHERE `contentid` = $contentid");

                            if ($picture['imgurls']) {

                                $attachments = explode("\n", stripslashes($picture['imgurls']));
                                array_shift($attachments);
                                $total = 0;

                                foreach ($attachments as $a)
                                {
                                    if (preg_match('/ddimg=\'(.*?)\'.*text=\'(.*?)\'/', $a, $result))
                                    {
                                        $total++;

                                        $attachment['filepath'] = $result[1];
                                        $attachment['description'] = $result[2];

                                        // 处理路径
                                        $attachment['filepath'] = $this->handle_attach($attachment['filepath'], $options);

                                        // 先插入到 attachment
                                        $lastslash = strrpos($attachment['filepath'], '/') + 1;
                                        $filename = substr($attachment['filepath'], $lastslash);
                                        $filepath = substr($attachment['filepath'], 0, $lastslash);
                                        $fileinfo = explode('.', $filename);

                                        $data = array(
                                        'alias' => $filename,
                                        'filename' => $filename,
                                        'filepath' => $filepath,
                                        'filemime' => 'application/octet-stream',
                                        'fileext' => $fileinfo[1],
                                        'filesize' => rand(1,10000),
                                        'isimage' => 1,
                                        'thumb' => 0,
                                        'remote' => 0,
                                        'fid' => 0
                                        );
                                        if ($aid = self::$model_attachment->add($data)) {
                                            // 再插入到 picture_group
                                            $data = array(
                                            'contentid' => $contentid,
                                            'aid' => $aid,
                                            'image' => $attachment['filepath'],
                                            'note' => $attachment['description'],
                                            'url' => '',
                                            'sort' => 0
                                            );
                                            self::$model_picture_group->add($data);
                                        }
                                    }
                                }

                                if ($total) {
                                    $this->db->update("UPDATE `#table_picture` SET `total` = $total WHERE `contentid` = $contentid");
                                }
                            }

                            $picture_relation[$picture['id']] = $contentid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $picture['id'];
                        }
                    }

                    $this->save_relation('picture', $picture_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'comment':
                // 根据之前的内容获得要转换的评论
                $content_relation = $this->get_relation('article');
                foreach ($this->get_relation('picture') as $key => $value)
                {
                    $content_relation[$key] = $value;
                }
                $comment_relation = $this->get_relation('comment');

                if (!empty($content_relation)) {
                    foreach ($content_relation as $key => $value)
                    {
                        if ($comments = $this->import_db->select("SELECT * FROM `#table_feedback` WHERE `aid` = '$key'")) {

                            foreach ($comments as $c)
                            {
                                if (isset($comment_relation[$c['id']])) {
                                    continue;
                                }

                                // 处理编码问题
                                $this->handle_charset($c);

                                $comment['contentid'] = $value;
                                $comment['disabled'] = $c['ischeck'] ? 0 : 1;

                                // 回复(盖楼)
                                $comment['content'] = str_replace(array('{/quote}', '{/title}', '{title}', '{quote}', '{/content}', '{content}'), array('[/floor][reply]', '[/name]', '[name]', '[floor]', '', ''), $c['msg']);

                                if (!$c['mid']) {
                                    $comment['anonymous'] = 1;
                                    $comment['nickname'] = $c['username'];
                                }

                                if ($commentid = self::$model_comment->add($comment)) {
                                    // 更新一些字段
                                    $createdby = $c['mid'];

                                    $this->db->update("UPDATE `#table_comment` SET `support` = '{$c['good']}', `against` = '{$c['bad']}', `ip` = '{$c['ip']}', `created` = '{$c['dtime']}', `createdby` = '$createdby' WHERE `commentid` = $commentid");

                                    $comment_relation[$c['id']] = $commentid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $c['id'];
                                }
                            }
                        }
                    }

                    $this->save_relation('comment', $comment_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'member':
                if ($members = $this->import_db->select("SELECT * FROM `#table_member` LIMIT $start, $pagesize")) 
                {
                    $member_relation = $this->get_relation('member');

                    foreach ($members as $member)
                    {                       
                        if (isset($member_relation[$member['mid']])) {
                            continue;
                        }

                        $member += (array)$this->import_db->get("SELECT * FROM `#table_member_person` WHERE `mid` = '{$member['mid']}'");
                        
                        // 处理编码问题
                        $this->handle_charset($member);

                        // 数据库直接插入
                        $basic = array(
                            'userid' => $member['mid'],
                            'username' => $member['userid'],
                            'password' => $member['pwd'],
                            'email' => $member['email'] ? $member['email'] : $this->default_email,
                            'groupid' => 6,
                            'regip' => $member['joinip'],
                            'regtime' => $member['jointime'],
                            'lastloginip' => $member['loginip'],
                            'lastlogintime' => $member['logintime'],
                            'credits' => $member['scores']
                        );

                        $basic = $this->handle_key_value($basic);
                        if ($userid = $this->db->insert("INSERT INTO `#table_member` ({$basic['key']}) VALUES ({$basic['value']})")) {
                            $detail = array(
                                'userid' => $member['mid'],
                                'name' => $member['uname'],
                                'sex' => ($member['gender'] == '男') ? 1 : 0,
                                'msn' => $member['msn'],
                                'telephone' => $member['tel'],
                                'address' => $member['address'],
                                'qq' => $member['qq'],
                                'birthday' => $member['birthday'],
                                'mobile' => $member['mobile']
                            );

                            $detail = $this->handle_key_value($detail);
                            $this->db->insert("INSERT INTO `#table_member_detail` ({$detail['key']}) VALUES ({$detail['value']})");

                            $member_relation[$member['mid']] = $userid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $member['mid'];
                        }
                        
                        unset($member);
                    }

                    $this->save_relation('member', $member_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            default:
                break;
        }

        return $data;
    }

    private function username($userid)
    {
        $member = $this->import_db->get("SELECT `userid` FROM `#table_member` WHERE `mid` = '$userid");
        return $member ? $member['userid'] : '';
    }

    private function get_category_sql($select, $addon = '') {
        return "SELECT $select FROM `#table_arctype` WHERE (`channeltype` = 1 OR `channeltype` = 2) AND `typedir` NOT LIKE '%://%'" . $addon;
    }
}
