<?php defined('IN_ADMIN') or exit;

class empirecms65 extends import implements ICmsImport
{

    protected $config = array(
        pagesize => array(
            'category' => 30,
            'article' => 20,
            'picture' => 20,
            'comment' => 20,
            'member' => 20
        ),
        data => array(
            'thumb_search' => '/d/file/',
            'thumb_replace' => 'file/',
            'thumb_prefix' => '',
            'attach_search' => '/d/file/',
            'attach_replace' => 'file/',
            'attach_prefix' => '',
            'content_search' => array(
                '="/d/file/'
            ),
            'content_replace' => array(
                "=\"{UPLOAD_URL}d/file/"
            )
        )
    );

    private $status_relation = array(
        1 => 6,
        '0' => 3
    );

    function __construct($options)
    {
        parent::__construct($options);

        $this->relation_base_path .= __CLASS__ . '/';
    }

    function config($options)
    {
        $data = array();

        if ($options['data'])
        {
            $query = $this->import_db->get($this->get_category_sql('COUNT(`classid`) AS `total`'));
            $data['data']['category'] = $query['total'];
        }

        if ($options['member'])
        {
            $query = $this->import_db->get("SELECT COUNT(`userid`) AS `total` FROM `#table_enewsmember`");
            $data['member']['total'] = $query['total'];
        }

        $this->_after_config($data);
        return $data;
    }

    function detail($options)
    {
        $data = array();

        if ($options['member'])
        {
            $query = "SELECT COUNT(`userid`) AS `total` FROM `#table_enewsmember`";
            $query = $this->import_db->get($query);
            $data['member']['total'] = $query['total'];
        }

        if ($options['data'])
        {
            $cat_sql = '';

            // 计算栏目数
            $sql = $this->get_category_sql('COUNT(`classid`) AS `total`');
            $query = $this->import_db->get($sql);
            $data['data']['total']['category'] = $query['total'];

            // 计算新闻数
            if ($options['data']['article'])
            {
                $sql = "SELECT COUNT(`id`) AS `total` FROM `#table_ecms_news`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['article'] = $query['total'];
            }

            // 计算文章数
            if ($options['data']['news'])
            {
                $sql = "SELECT COUNT(`id`) AS `total` FROM `#table_ecms_article`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['news'] = $query['total'];
            }

            // 计算组图数
            if ($options['data']['picture'])
            {
                $sql = "SELECT COUNT(`id`) AS `total` FROM `#table_ecms_photo`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['picture'] = $query['total'];
            }

            // 计算评论数
            $modelid = array();
            if ($options['data']['article'])
            {
                $modelid[] = 1;
            }
            if ($options['data']['picture'])
            {
                $modelid[] = 2;
            }
            if (!empty($modelid) && $options['data']['comment'])
            {
                $sql = "SELECT COUNT(`plid`) AS `total` FROM `#table_enewspl`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['comment'] = $query['total'];
            }
        }

        return $data;
    }

    function import($options)
    {
        $type = $options['type'];
        $start = intval($options['start']);
        $pagesize = $this->pagesize($type);
        $data = array();

        switch ($type)
        {
            case 'category':
                if ($categorys = $this->import_db->select($this->get_category_sql('*', "LIMIT $start, $pagesize")))
                {
                    $category_relation = $this->get_relation('category');
                    foreach ($categorys as $c)
                    {
                        $catid = $c['classid'];

                        // 如果之前的操作已经添加过了，跳过
                        if (isset($category_relation[$catid]))
                        {
                            continue;
                        }

                        $parentids = array($catid);
                        $parentid = $c['bclassid'];
                        while($parentid)
                        {
                            $parent = $this->import_db->get($this->get_category_sql('`classid`, `bclassid`', " AND `classid` = $parentid"));
                            $parentids[] = $parent['classid'];
                            $parentid = $parent['bclassid'];
                        }
                        $parentids = array_reverse($parentids);

                        foreach ($parentids as $parentid)
                        {
                            if (isset($category_relation[$parentid]))
                            {
                                continue;
                            }

                            // 添加栏目，由于是按照从前到后的顺序来添加，假定按照这个顺序添加的栏目，父栏目都已经存在
                            if ($query = $this->import_db->get ( $this->get_category_sql ( '*', " AND `classid` = '$parentid'" ) ))
                            {
                                $category = self::$category;

                                $this->handle_charset ( $query );

                                $category ['parentid'] = $query ['bclassid'] ? $category_relation [$query ['bclassid']] : '';
                                $category ['name'] = $query ['classname'];
                                $alias = explode('/', $query['classpath']);
                                $category ['alias'] = $alias[count($alias) - 1]; 
                                $category ['enablecontribute'] = $query ['openadd'];

                                // 发布点
                                $query ['parentdir'] = $category['bclassid'] ? table('category', $category_relation[$category['bclassid']], 'path') : '';
                                $category ['path'] = $this->handle_path ( $query ['classname'], $query ['classurl'], $category ['alias'], $query ['parentdir'] );

                                $category ['sort'] = $query ['myorder'];

                                if ($new_catid = self::$model_category->add($category))
                                {
                                    // 将新的ID关系对应保存起来
                                    $category_relation[$parentid] = $new_catid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $parentid;
                                }
                            }
                            else
                            {
                                continue;
                            }
                        }
                    }
                }

                $this->save_relation('category', $category_relation);
                $data['start'] = $start + $pagesize;
                break;

            case 'article':
                // 根据之前的栏目获得要转换的文章
                $category_relation = $this->get_relation('category');
                $article_relation = $this->get_relation('article');

                if (!empty($category_relation) && ($result = $this->import_db->select("SELECT * FROM `#table_ecms_news` WHERE `classid` IN (" . implode(',', array_keys($category_relation)) .") LIMIT $start, $pagesize")))
                {
                    foreach ($result as $article)
                    {
                        if (isset($article_relation[$article['id']]))
                        {
                            continue;
                        }

                        // 处理附表
                        $addon_table = $article['stb'];
                        $addon_infos = $this->import_db->get("SELECT * FROM `#table_ecms_news_data_{$addon_table}` WHERE `id` = '{$article['id']}'");
                        $article = array_merge($article, $addon_infos);

                        // 处理编码问题
                        $this->handle_charset($article);

                        $content = self::$article;
                        $content['catid'] = $category_relation[$article['classid']];
                        $content['title'] = str_cut($article['title'], 80, '');
                        preg_match('/^\#([a-zA-Z0-9]{3}|[a-zA-Z0-9]{6})$/', $article['titlefont']) && $content['color'] = $article['titlefont'];
                        $content['tags'] = str_replace(',', ' ', $article['keyboard']);
                        $content['status'] = $this->status_relation[$article['checked']];

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($article['titlepic'], $options);

                        if (!empty($article['titleurl']))
                        {
                            $content['modelid'] = 3;
                            $content['url'] = $article['titleurl'];

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['subtitle'] = $article['ftitle'];
                            $content['source'] = $article['befrom'];
                            $content['author'] = $article['writer'];
                            $content['editor'] = $article['username'];
                            $content['allowcomment'] = $article['closepl'] ? 0 : 1;

                            // 处理内容替换
                            $content['content'] = $this->handle_content(stripslashes($article['newstext']), $options);

                            // 内容分页
                            if (preg_match('/\[!\-\-empirenews\.page\-\-\]/', $content['content']))
                            {
                                $content['content'] = $this->pagevar . preg_replace('/\[!\-\-empirenews\.page\-\-\](.*)\[\/!\-\-empirenews\.page\-\-\]/', $this->pagetitlevar, $content['content']);
                            }

                            $content['description'] = strip_tags(preg_replace("/\[!\-\-empirenews\.page\-\-\](.*)\[\/!\-\-empirenews\.page\-\-\]/", '', $article['smalltext']));

                            $contentid = self::$model_article->add($content);
                        }

                        if ($contentid)
                        {
                            $published = '';
                            $publishedby = '';
                            if ($content['status'] == 6)
                            {
                                $published = $article['newstime'];
                                $publishedby = $article['userid'];
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$article['truetime']}', `createdby` = '{$article['userid']}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$article['onclick']}' WHERE `contentid` = $contentid");
                            $article_relation[$article['id']] = $contentid;
                        }
                        else
                        {
                            // 出错
                            $data['error'][] = $article['id'];
                        }
                    }

                    $this->save_relation('article', $article_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'picture':
                // 根据之前的栏目获得要转换的组图
                $category_relation = $this->get_relation('category');
                $picture_relation = $this->get_relation('picture');

                if (!empty($category_relation) && ($result = $this->import_db->select("SELECT * FROM `#table_ecms_photo` WHERE `classid` IN (" . implode(',', array_keys($category_relation)) .") LIMIT $start, $pagesize")))
                {
                    foreach ($result as $picture)
                    {
                        if (isset($picture_relation[$picture['id']]))
                        {
                            continue;
                        }

                        // 处理附表
                        $addon_table = $picture['stb'];
                        $addon_infos = $this->import_db->get("SELECT * FROM `#table_ecms_photo_data_{$addon_table}` WHERE `id` = '{$picture['id']}'");
                        $picture = array_merge($picture, $addon_infos);

                        // 处理编码问题
                        $this->handle_charset($picture);

                        $content = self::$picture;
                        $content['catid'] = $category_relation[$picture['classid']];
                        $content['title'] = $picture['title'];
                        preg_match('/^\#([a-zA-Z0-9]{3}|[a-zA-Z0-9]{6})$/', $picture['style']) && $content['color'] = $picture['style'];
                        $content['tags'] = str_replace(',', ' ', $picture['keyboard']);
                        $content['status'] = $this->status_relation[$picture['checked']];

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($picture['titlepic'], $options);

                        if (!empty($picture['titleurl']))
                        {
                            $content['modelid'] = 3;
                            $content['url'] = $picture['titleurl'];

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['source'] = $picture['befrom'];
                            $content['author'] = $picture['writer'];
                            $content['editor'] = $picture['username'];
                            $content['allowcomment'] = $picture['closepl'] ? 0 : 1;
                            $content['description'] = strip_tags($picture['picsay']);

                            $contentid = self::$model_picture->add($content);
                        }

                        if ($contentid)
                        {
                            $published = '';
                            $publishedby = '';
                            if ($content['status'] == 6)
                            {
                                $published = $picture['newstime'];
                                $publishedby = $picture['userid'];
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$picture['truetime']}', `createdby` = '{$picture['userid']}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$picture['onclick']}' WHERE `contentid` = $contentid");
                            $article_relation[$picture['id']] = $contentid;

                            if (empty($picture['morepic']) && !empty($picture['picurl']))
                            {
                                $picture['morepic'] = $picture['picurl'];
                            }

                            if ($picture['morepic'])
                            {
                                $attachments = array_filter(array_map('trim', explode("\n", $picture['morepic'])));
                                $total = 0;

                                foreach ($attachments as $attachment)
                                {
                                    $temp = explode('::::::', $attachment);
                                    $attachment = array();

                                    if (count($temp) == 1)
                                    {
                                        $attachment['filepath'] = $temp[0];
                                        $attachment['description'] = '';
                                    }
                                    else
                                    {
                                        $attachment['filepath'] = $temp[1];
                                        $attachment['description'] = $temp[2];
                                    }

                                    if (preg_match('/\:\/\//', $attachment['filepath']))
                                    {
                                        continue;
                                    }

                                    $total++;

                                    // 处理路径
                                    $attachment['filepath'] = $this->handle_attach($attachment['filepath'], $options);

                                    // 先插入到 attachment
                                    $lastslash = strrpos($attachment['filepath'], '/') + 1;
                                    $filename = substr($attachment['filepath'], $lastslash);
                                    $filepath = substr($attachment['filepath'], 0, $lastslash);
                                    $fileinfo = explode('.', $filename);

                                    $data = array(
                                    'alias' => $filename,
                                    'filename' => $filename,
                                    'filepath' => $filepath,
                                    'filemime' => 'application/octet-stream',
                                    'fileext' => $fileinfo[1],
                                    'filesize' => mt_rand(10000,900000),
                                    'isimage' => 1,
                                    'thumb' => 0,
                                    'remote' => 0,
                                    'fid' => 0
                                    );
                                    if ($aid = self::$model_attachment->add($data))
                                    {
                                        // 再插入到 picture_group
                                        $data = array(
                                        'contentid' => $contentid,
                                        'aid' => $aid,
                                        'image' => $attachment['filepath'],
                                        'note' => $attachment['description'],
                                        'url' => ''
                                        );
                                        self::$model_picture_group->add($data);
                                    }
                                }

                                if ($total)
                                {
                                    $this->db->update("UPDATE `#table_picture` SET `total` = $total WHERE `contentid` = $contentid");
                                }
                            }

                            $picture_relation[$picture['id']] = $contentid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $picture['id'];
                        }
                    }

                    $this->save_relation('picture', $picture_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'comment':
                // 根据之前的内容获得要转换的评论
                $content_relation = $this->get_relation('article');
                foreach ($this->get_relation('picture') as $key => $value)
                {
                    $content_relation[$key] = $value;
                }
                $comment_relation = $this->get_relation('comment');

                if (!empty($content_relation))
                {
                    foreach ($content_relation as $key => $value)
                    {
                        if ($comments = $this->import_db->select("SELECT * FROM `#table_enewspl` WHERE `id` = '$key'"))
                        {
                            foreach ($comments as $c)
                            {
                                if (isset($comment_relation[$c['plid']]))
                                {
                                    continue;
                                }
                                // 处理附表
                                $addon_table = $c['stb'];
                                $addon_infos = $this->import_db->get("SELECT * FROM `#table_enewspl_data_{$addon_table}` WHERE `plid` = '{$c['plid']}'");
                                $c = array_merge($c, $addon_infos);

                                // 处理编码问题
                                $this->handle_charset($c);

                                $comment['contentid'] = $value;
                                $comment['disabled'] = $c['checked'] ? 0 : 1;

                                // 回复(盖楼)
                                $comment['content'] = preg_replace('/<.*\\\'>(.*)<br>(.*)<.*>(.*)/', "[floor][name]$1[/name]$2[/floor][reply]$3", $c['saytext']);

                                if (!$c['userid'])
                                {
                                    $comment['anonymous'] = 1;
                                }

                                if ($commentid = self::$model_comment->add($comment))
                                {
                                    // 更新一些字段
                                    $created = strtotime($c['saytime']);

                                    $this->db->update("UPDATE `#table_comment` SET `support` = '{$c['zcnum']}', `against` = '{$c['fdnum']}', `ip` = '{$c['sayip']}', `created` = '{$created}', `createdby` = '{$c['userid']}' WHERE `commentid` = $commentid");

                                    $comment_relation[$c['plid']] = $commentid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $c['plid'];
                                }
                            }
                        }
                    }

                    $this->save_relation('comment', $comment_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'member':
                if ($members = $this->import_db->select("SELECT * FROM `#table_enewsmember` m LEFT JOIN `#table_enewsmemberadd` d ON m.`userid` = d.`userid` LIMIT $start, " . $pagesize))
                {
                    $member_relation = $this->get_relation('member');
                    $member_group_relation = $this->get_relation('member_group');

                    // 转换会员组
                    if (empty($member_group_relation))
                    {
                        if ($groups = $this->import_db->select("SELECT * FROM `#table_enewsmembergroup`"))
                        {
                            $cmstop_group_relation = array(
                            1 => 6
                            );

                            foreach ($groups as $g)
                            {
                                $this->handle_charset($g);

                                $group = array(
                                'name' => $g['groupname'],
                                'status' => $g['canreg'] ? 1 : 0,
                                'allowlogin' => $g['checked'] ? 0 : 1,
                                'allowcontribute' => $g['infochecked'] ? 0 : 1
                                );

                                // 如果在对应关系里面，直接更新
                                if (isset($cmstop_group_relation[$g['groupid']]))
                                {
                                    $groupid = $cmstop_group_relation[$g['groupid']];
                                    $this->db->update("UPDATE `#table_member_group` SET " . $this->handle_key_value_update($group) . " WHERE `groupid` = $groupid");
                                }
                                else
                                {
                                    // 插入
                                    $groupid = self::$model_member_group->add($group);
                                }
                                $member_group_relation[$g['groupid']] = $groupid;
                            }
                        }
                        $this->save_relation('member_group', $member_group_relation);
                    }

                    foreach ($members as $m)
                    {
                        if (isset($member_relation[$m['userid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($m);

                        // 数据库直接插入
                        $member = array(
                        'userid' => $m['userid'],
                        'username' => $m['username'],
                        'password' => $m['password'],
                        'salt' => $m['rnd'],
                        'email' => $m['email'] ? $m['email'] : $this->default_email,
                        'groupid' => $m['checked'] ? $member_group_relation[$m['groupid']] : $this->disable_groupid,
                        'regip' => $m['regip'],
                        'regtime' => strtotime($m['registertime']),
                        'credits' => $m['userfen']
                        );

                        $member = $this->handle_key_value($member);
                        if ($userid = $this->db->insert("INSERT INTO `#table_member` ({$member['key']}) VALUES ({$member['value']})"))
                        {
                            $userid = $m['userid'];

                            // 详细信息
                            $member = array(
                            'userid' => $userid,
                            'name' => $m['truename'],
                            'msn' => $m['msn'],
                            'telephone' => $m['call'],
                            'address' => $m['address'],
                            'qq' => $m['oicq'],
                            'zipcode' => $m['zip'],
                            'mobile' => $m['phone'],
                            'remarks' => $m['saytext']
                            );

                            $member = $this->handle_key_value($member);
                            $this->db->insert("INSERT INTO `#table_member_detail` ({$member['key']}) VALUES ({$member['value']})");

                            $member_relation[$m['userid']] = $userid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $m['userid'];
                        }
                    }

                    $this->save_relation('member', $member_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            default:
                break;
        }

        return $data;
    }

    private function get_category_sql($select, $addon = '')
    {
        return "SELECT $select FROM `#table_enewsclass` WHERE (`tbname` = 'news' OR `tbname` = 'photo') " . $addon;
    }
}
