<?php defined('IN_ADMIN') or exit;

class excms132 extends import implements ICmsImport
{
    private $status_relation = array(
    1 => 6,
    0 => 3,
    2 => 0
    );

    function __construct($options)
    {
        parent::__construct($options);

        $this->relation_base_path .= __CLASS__ . '/';
    }

    function config($options)
    {
        $data = array();

        if ($options['data'])
        {
            $query = $this->import_db->get($this->get_category_sql('COUNT(`fid`) AS `total`'));
            $data['data']['category'] = $query['total'];
        }

        if ($options['member'])
        {
            $query = $this->import_db->get("SELECT COUNT(`uid`) AS `total` FROM `#table_members`");
            $data['member']['total'] = $query['total'];
        }
        return $data;
    }

    function detail($options)
    {
        $data = array();

        if ($options['member'])
        {
            $query = "SELECT COUNT(`uid`) AS `total` FROM `#table_members`";
            $query = $this->import_db->get($query);
            $data['member']['total'] = $query['total'];
        }

        if ($options['data'])
        {
            $cat_sql = '';

            // 计算栏目数
            $sql = $this->get_category_sql('COUNT(`fid`) AS `total`');
            $query = $this->import_db->get($sql);
            $data['data']['total']['category'] = $query['total'];

            // 计算文章数
            if ($options['data']['article'])
            {
                $sql = "SELECT COUNT(`aid`) AS `total` FROM `#table_article` WHERE `mid` = 0";
                $query = $this->import_db->get($sql);
                $data['data']['total']['article'] = $query['total'];
            }

            // 计算组图数
            if ($options['data']['picture'])
            {
                $sql = "SELECT COUNT(`aid`) AS `total` FROM `#table_article` WHERE `mid` = 100";
                $query = $this->import_db->get($sql);
                $data['data']['total']['picture'] = $query['total'];
            }

            // 计算评论数
            $modelid = array();
            if ($options['data']['article'])
            {
                $modelid[] = 1;
            }
            if ($options['data']['picture'])
            {
                $modelid[] = 2;
            }
            if (!empty($modelid) && $options['data']['comment'])
            {
                $sql = "SELECT COUNT(`cid`) AS `total` FROM `#table_comment`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['comment'] = $query['total'];
            }
        }

        return $data;
    }

    function import($options)
    {
        $type = $options['type'];
        $start = intval($options['start']);
        $data = array();

        switch ($type)
        {
            case 'category':
                $pagesize = $this->data_pagesize['category'];

                if ($categorys = $this->import_db->select($this->get_category_sql('`fid`', "LIMIT $start, $pagesize")))
                {
                    $category_relation = $this->get_relation('category');
                    foreach ($categorys as $c)
                    {
                        $catid = $c['catid'];

                        // 如果之前的操作已经添加过了，跳过
                        if (isset($category_relation[$catid]))
                        {
                            continue;
                        }

                        $parentids = array($c['fid']);
                        $parentid = $c['fup'];
                        while($parentid)
                        {
                            $parent = $this->import_db->get($this->get_category_sql('`fid`, `fup`', " AND `fid` = $parentid"));
                            $parentids[] = $parent['fid'];
                            $parentid = $parent['fup'];
                        }
                        $parentids = array_reverse($parentids);

                        $cat_sql = $this->get_category_sql("*", "AND `fid` = '$catid'");

                        foreach ($parentids as $parentid)
                        {
                            if (isset($category_relation[$parentid]))
                            {
                                continue;
                            }

                            // 添加栏目，由于是按照从前到后的顺序来添加，假定按照这个顺序添加的栏目，父栏目都已经存在
                            if ($query = $this->import_db->get ( $this->get_category_sql ( '*', " AND `fid` = $parentid" ) ))
                            {
                                $category = self::$category;
                                $this->handle_charset ( $query );

                                $category ['parentid'] = $query ['fup'] ? $category_relation [$query ['fup']] : '';
                                $category ['name'] = $query ['name'];
                                $category ['alias'] = $this->get_alias($query['fid'], $query['domain_dir']);
                                $category ['path'] = $this->handle_path ( $query ['name'], $query ['domain'], $category ['alias'], $this->get_alias($query['fup']));
                                $category ['sort'] = $query ['listorder'];
                                $category ['enablecontribute'] = $query ['allowpost'];

                                if ($new_catid = self::$model_category->add($category))
                                {
                                    // 将新的ID关系对应保存起来
                                    $category_relation[$parentid] = $new_catid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $parentid;
                                }
                            }
                            else
                            {
                                continue;
                            }
                        }
                    }
                }

                $this->save_relation('category', $category_relation);
                $data['start'] = $start + $pagesize;
                break;

            case 'article':
                // 分页大小
                $pagesize = $this->data_pagesize['article'];

                // 根据之前的栏目获得要转换的文章
                $category_relation = $this->get_relation('category');
                $article_relation = $this->get_relation('article');

                if (!empty($category_relation) && ($result = $this->import_db->select("SELECT * FROM `#table_article` n LEFT JOIN `#table_reply` c ON n.`aid` = c.`aid` WHERE n.`mid` = 0 AND c.`fid` IN (" . implode(',', array_keys($category_relation)) .") LIMIT $start, " . $pagesize)))
                {
                    foreach ($result as $article)
                    {
                        if (isset($article_relation[$article['aid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($article);

                        $content = self::$article;
                        $content['catid'] = $category_relation[$article['fid']];
                        $content['title'] = $article['title'];
                        $content['subtitle'] = $article['subhead'];
                        $content['color'] = $article['titlecolor'];
                        $content['tags'] = $article['keywords'];
                        $content['status'] = $this->status_relation[$article['yz']];
                        $content['allowcomment'] = $article['forbidcomment'] ? 0 : 1;

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($article['picurl'], $options);

                        if (!empty($article['jumpurl']))
                        {
                            $content['modelid'] = 3;
                            $content['url'] = $article['jumpurl'];

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['subtitle'] = $article['titleintact'] ? $article['title'] : '';
                            $content['source'] = $article['copyfrom'];
                            $content['author'] = $article['author'];
                            $content['editor'] = $article['username'];

                            // 处理内容替换
                            $content['content'] = $this->handle_content($article['content'], $options);

                            if ($article['pages'] && preg_match('/\[\-page\-\]/', $content['content']))
                            {
                                $content['content'] = $this->pagevar . preg_replace('/\[\-page\-\]/', $this->pagevar, $content['content']);
                            }

                            $content['description'] = strip_tags(preg_replace("/\[\-page\-\]/", '', $article['description']));

                            $contentid = self::$model_article->add($content);
                        }

                        if ($contentid)
                        {
                            // 浏览量
                            $published = '';
                            $publishedby = '';
                            if ($content['status'] == 6)
                            {
                                $published = $article['posttime'];
                                $publishedby = $article['uid'];
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$article['posttime']}', `createdby` = '{$article['uid']}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$article['hits']}' WHERE `contentid` = $contentid");
                            $article_relation[$article['aid']] = $contentid;
                        }
                        else
                        {
                            // 出错
                            $data['error'][] = $article['aid'];
                        }
                    }

                    $this->save_relation('article', $article_relation);
                }

                $data['start'] = $start + $pagesize;
                console($data['start']);
                break;

            case 'picture':
                // 分页大小
                $pagesize = $this->data_pagesize['picture'];

                // 根据之前的栏目获得要转换的组图
                $category_relation = $this->get_relation('category');
                $picture_relation = $this->get_relation('picture');

                if (!empty($category_relation) && ($result = $this->import_db->select("SELECT * FROM `#table_article` a LEFT JOIN `#table_article_content_100` m ON a.`aid` = m.`aid` LEFT JOIN `#table_reply` c ON m.`aid` = c.`aid` WHERE a.`mid` = 100 AND a.`fid` IN (" . implode(',', array_keys($category_relation)) .") LIMIT $start, " . $pagesize)))
                {
                    foreach ($result as $picture)
                    {
                        if (isset($picture_relation[$picture['aid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($picture);

                        $content = self::$picture;
                        $content['catid'] = $category_relation[$picture['fid']];
                        $content['title'] = $picture['title'];
                        $content['subtitle'] = $picture['subhead'];
                        $content['color'] = $this->style_relation[$picture['titlecolor']];
                        $content['tags'] = $picture['keywords'];
                        $content['status'] = $this->status_relation[$picture['yz']];
                        $content['allowcomment'] = $picture['forbidcomment'] ? 0 : 1;

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($picture['picurl'], $options);

                        if (!empty($picture['jumpurl']))
                        {
                            $content['modelid'] = 3;
                            $content['url'] = $picture['jumpurl'];

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['source'] = $picture['copyfrom'];
                            $content['author'] = $picture['author'];
                            $content['editor'] = $picture['username'];
                            $content['description'] = strip_tags($picture['description']);

                            $contentid = self::$model_picture->add($content);
                        }

                        if ($contentid)
                        {
                            $published = '';
                            $publishedby = '';
                            if ($content['status'] == 6)
                            {
                                $published = $picture['posttime'];
                                $publishedby = $picture['uid'];
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$picture['posttime']}', `createdby` = '{$picture['uid']}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$picture['hits']}' WHERE `contentid` = $contentid");

                            if ($picture['photourl'])
                            {
                                $picture['photourl'] = explode('@@@', $picture['photourl']);
                                $picture_size = count($picture['photourl']);
                                for ($i = 0; $i < $picture_size; $i+=2)
                                {
                                    $attachments[] = array('filepath' => $picture['photourl'][$i], 'description' => $picture['photourl'][$i+1]);
                                }

                                foreach ($attachments as $attachment)
                                {
                                    // 处理路径
                                    $attachment['filepath'] = $this->handle_attach($attachment['filepath'], $options);

                                    // 先插入到 attachment
                                    $lastslash = strrpos($attachment['filepath'], '/') + 1;
                                    $filename = substr($attachment['filepath'], $lastslash);
                                    $fileinfo = explode('.', $filename);

                                    $data = array(
                                    'alias' => $fileinfo[0],
                                    'filename' => $filename,
                                    'filepath' => substr($attachment['filepath'], 0, $lastslash),
                                    'filemime' => 'application/octet-stream',
                                    'fileext' => $fileinfo[1],
                                    'filesize' => 0,
                                    'isimage' => 1,
                                    'thumb' => 0,
                                    'remote' => 0,
                                    'fid' => 0
                                    );
                                    if ($aid = self::$model_attachment->add($data))
                                    {
                                        // 再插入到 picture_group
                                        $data = array(
                                        'contentid' => $contentid,
                                        'aid' => $aid,
                                        'image' => $attachment['filepath'],
                                        'note' => $attachment['description'],
                                        'url' => '',
                                        'sort' => 0
                                        );
                                        self::$model_picture_group->add($data);
                                    }
                                }

                                if ($total = count($attachments))
                                {
                                    $total /= 2;
                                    $this->db->update("UPDATE `#table_picture` SET `total` = $total WHERE `contentid` = $contentid");
                                }
                            }

                            $picture_relation[$picture['aid']] = $contentid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $picture['aid'];
                        }
                    }

                    $this->save_relation('picture', $picture_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'comment':
                // 分页大小
                $pagesize = $this->data_pagesize['comment'];

                // 根据之前的内容获得要转换的评论
                $content_relation = $this->get_relation('article');
                foreach ($this->get_relation('picture') as $key => $value)
                {
                    $content_relation[$key] = $value;
                }
                $comment_relation = $this->get_relation('comment');

                if (!empty($content_relation))
                {
                    foreach ($content_relation as $key => $value)
                    {
                        if ($comments = $this->import_db->select("SELECT * FROM `#table_comment` WHERE `aid` = '$key'"))
                        {
                            foreach ($comments as $c)
                            {
                                if (isset($comment_relation[$c['cid']]))
                                {
                                    continue;
                                }

                                // 处理编码问题
                                $this->handle_charset($c);

                                $comment['contentid'] = $value;
                                $comment['disabled'] = $c['yz'] ? 0 : 1;

                                // 回复(盖楼)
                                $comment['content'] = preg_replace('/引用ID编号为(\d+),称呼为(.*)于(.*)发表的  :/', "[name]$2 $3[/name]", $c['content']);
                                $comment['content'] = str_replace(array('[/quote]', '[/blue]', '[blue]', '[quote]'), array('[/floor][reply]', '[/name]', '[name]', '[floor]'), $c['content']);

                                if (!$c['uid'])
                                {
                                    $comment['anonymous'] = 1;
                                }

                                if ($commentid = self::$model_comment->add($comment))
                                {
                                    // 更新一些字段
                                    $createdby = $c['uid'];

                                    $this->db->update("UPDATE `#table_comment` SET `support` = '{$c['agree']}', `against` = '{$c['disagree']}', `ip` = '{$c['ip']}', `created` = '{$c['posttime']}', `createdby` = '$createdby' WHERE `commentid` = $commentid");

                                    $comment_relation[$c['cid']] = $commentid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $c['cid'];
                                }
                            }
                        }
                    }

                    $this->save_relation('comment', $comment_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'member':
                if ($members = $this->import_db->select("SELECT * FROM `#table_members` m LEFT JOIN `#table_memberdata` d ON m.`uid` = d.`uid` LIMIT $start, " . $this->member_pagesize))
                {
                    $member_relation = $this->get_relation('member');
                    $member_group_relation = $this->get_relation('member_group');

                    // 转换会员组
                    if (empty($member_group_relation))
                    {
                        if ($groups = $this->import_db->select("SELECT * FROM `#table_group`"))
                        {
                            $cmstop_group_relation = array(
                            8 => 6,
                            3 => 1,
                            2 => 2
                            );

                            foreach ($groups as $g)
                            {
                                if (isset($member_group_relation[$g['gid']]))
                                {
                                    continue;
                                }

                                $this->handle_charset($g);
                                $group = array(
                                'name' => $g['grouptitle'],
                                'status' => 1,
                                'allowlogin' => 1,
                                'allowcontribute' => 1,
                                'sort' => 0,
                                'remarks' => ''
                                );

                                // 如果在对应关系里面，直接更新
                                if (isset($cmstop_group_relation[$g['gid']]))
                                {
                                    $groupid = $cmstop_group_relation[$g['gid']];
                                    $this->db->update("UPDATE `#table_member_group` SET " . $this->handle_key_value_update($group) . " WHERE `groupid` = $groupid");
                                }
                                else
                                {
                                    // 插入
                                    $groupid = self::$model_member_group->add($group);
                                }
                                $member_group_relation[$g['gid']] = $groupid;
                            }
                        }
                        $this->save_relation('member_group', $member_group_relation);
                    }

                    foreach ($members as $m)
                    {
                        if (isset($member_relation[$m['uid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($m);

                        // 数据库直接插入
                        $member = array(
                        'userid' => $m['uid'],
                        'username' => $m['username'],
                        'password' => $m['password'],
                        'email' => $m['email'] ? $m['email'] : 'no-email@example.com',
                        'groupid' => $member_group_relation[$m['groupid']],
                        'regip' => $m['regip'],
                        'regtime' => $m['regdate'],
                        'lastloginip' => $m['lastip'],
                        'lastlogintime' => $m['lastvist'],
                        'logintimes' => $m['logintimes']
                        );

                        $member = $this->handle_key_value($member);
                        if ($userid = $this->db->insert("INSERT INTO `#table_member` ({$member['key']}) VALUES ({$member['value']})"))
                        {
                            $userid = $m['uid'];

                            $member = array(
                            'userid' => $userid,
                            'name' => $m['truename'],
                            'sex' => $m['gender'],
                            'msn' => $m['msn'],
                            'telephone' => $m['telephone'],
                            'address' => $m['address'],
                            'qq' => $m['oicq'],
                            'birthday' => $m['bday'],
                            'zipcode' => $m['postalcode'],
                            'mobile' => $m['mobphone'],
                            'remarks' => $m['introduce'],
                            'authstr' => $m['email_yz']
                            );

                            $member = $this->handle_key_value($member);
                            $this->db->insert("INSERT INTO `#table_member_detail` ({$member['key']}) VALUES ({$member['value']})");

                            $member_relation[$m['uid']] = $userid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $m['uid'];
                        }
                    }

                    $this->save_relation('member', $member_relation);
                }

                $data['start'] = $start + $this->member_pagesize;
                break;

            default:
                break;
        }

        return $data;
    }

    private function get_category_sql($select, $addon = '')
    {
        return "SELECT $select FROM `#table_sort` WHERE (`fmid` = 0 OR `fmid` = 100) " . $addon;
    }

    private function get_alias($catid)
    {
        /*
        if ($category = $this->import_db->get($this->get_category_sql('list_html', "AND `fid` = '$catid'")))
        {
        return empty($category['list_html']) ? $catid : $category['list_html'];
        }
        */
        return $catid;
    }
}
