<?php defined('IN_ADMIN') or exit;

class phpcms2007 extends import implements ICmsImport
{

    protected $config = array(
        pagesize => array(
            'category' => 30,
            'article' => 20,
            'picture' => 20,
            'comment' => 20,
            'member' => 20
        ),
        data => array(
            'thumb_search' => '',
            'thumb_replace' => '',
            'thumb_prefix' => '',
            'attach_search' => '',
            'attach_replace' => '',
            'attach_prefix' => 'uploadfile/picture/uploadpics/',
            'content_search' => array(
                '="/uploadfile/'
            ),
            'content_replace' => array(
                "=\"{UPLOAD_URL}uploadfile/"
            )
        )
    );

    private $module_extra_table_relation = array(
        'article' => 'data',
        'picture' => ''
    );
    
    private $status_relation = array(
        0 => 1,
        1 => 3,
        2 => 2,
        3 => 6
    );

    function __construct($options)
    {
        parent::__construct($options);

        $this->relation_base_path .= __CLASS__ . '/';
    }

    function config($options)
    {
        $data = array();

        if ($options['data'])
        {
            $query = $this->import_db->get($this->get_category_sql('COUNT(`catid`) AS `total`'));
            $data['data']['category'] = $query['total'];
        }

        if ($options['member'])
        {
            $query = $this->import_db->get("SELECT COUNT(`userid`) AS `total` FROM `#table_member`");
            $data['member']['total'] = $query['total'];
        }

        $this->_after_config($data);
        return $data;
    }

    function detail($options)
    {
        $data = array();

        if ($options['member'])
        {
            $query = "SELECT COUNT(`userid`) AS `total` FROM `#table_member`";
            $query = $this->import_db->get($query);
            $data['member']['total'] = $query['total'];
        }

        if ($options['data'])
        {
            $cat_sql = '';

            // 计算栏目数
            $sql = $this->get_category_sql('COUNT(`catid`) AS `total`');
            $query = $this->import_db->get($sql);
            $data['data']['total']['category'] = $query['total'];

            // 计算文章数
            if ($options['data']['article'])
            {
                $data['data']['total']['article'] = $this->content_info('article');
            }

            // 计算组图数
            if ($options['data']['picture'])
            {
                $data['data']['total']['picture'] = $this->content_info('picture');
            }

            // 计算评论数
            $modelid = array();
            if ($options['data']['article'])
            {
                $modelid[] = 1;
            }
            if ($options['data']['picture'])
            {
                $modelid[] = 2;
            }
            if (!empty($modelid) && $options['data']['comment'])
            {
                $sql = "SELECT COUNT(`cid`) AS `total` FROM `#table_comment`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['comment'] = $query['total'];
            }
        }

        return $data;
    }

    function import($options)
    {
        $type = $options['type'];
        $start = intval($options['start']);
        $pagesize = $this->pagesize($type);
        $data = array();

        switch ($type)
        {
            case 'category':
                $channel_relation = $this->get_relation('channel');

                // 先导入频道
                if (empty($channel_relation))
                {
                    if ($channels = $this->import_db->select("SELECT * FROM `#table_channel` WHERE `module` = 'article' OR `module` = 'picture'"))
                    {
                        foreach ($channels as $channel)
                        {
                            $this->handle_charset($channel);

                            $category = self::$category;
                            $category['name'] = $channel['channelname'];
                            $category['alias'] = $channel['channeldir'];
                            $category['sort'] = $channel['listorder'];

                            if ($catid = self::$model_category->add($category))
                            {
                                $channel_relation[$channel['channelid']] = $catid;
                            }
                            else
                            {
                                $data['error'][] = '频道：' . $channel['channelid'];
                            }
                        }

                        $this->save_relation('channel', $channel_relation);
                    }
                }

                if (!empty($channel_relation) && $categorys = $this->import_db->select($this->get_category_sql('`catid`', "AND `channelid` IN (" . implode(',', array_keys($channel_relation)) . ") LIMIT $start, $pagesize")))
                {
                    $category_relation = $this->get_relation('category');
                    foreach ($categorys as $c)
                    {
                        $catid = $c['catid'];

                        // 如果之前的操作已经添加过了，跳过
                        if (isset($category_relation[$catid]))
                        {
                            continue;
                        }

                        // 否则，转换栏目数据并添加
                        $cat_sql = "SELECT `catid`, `parentid`, `channelid`, `arrparentid`, `catname`, `catdir`, `parentdir`, `linkurl`,`listorder` FROM `#table_category` WHERE `catid` = ";
                        $query = $this->import_db->get($cat_sql . $catid);
                        $this->handle_charset($query);

                        $parentids = explode(',', $query['arrparentid']);
                        array_shift($parentids);
                        $parentids[] = $catid;

                        foreach ($parentids as $parentid)
                        {
                            if (isset($category_relation[$parentid]))
                            {
                                continue;
                            }

                            // 默认是一个频道
                            $category = self::$category;

                            // 如果 arrparentid 为真，则假定是一个子栏目
                            if ($query['arrparentid'])
                            {
                                // 添加栏目，由于是按照从前到后的顺序来添加，假定按照这个顺序添加的栏目，父栏目都已经存在
                                if ($pquery = $this->import_db->get($cat_sql . $parentid))
                                {
                                    $this->handle_charset($pquery);
                                    $category['parentid'] = $category_relation[$pquery['parentid']];
                                    $category['name'] = $pquery['catname'];
                                    $category['alias'] = $pquery['catdir'];
                                    // 获得父栏目新的 path
                                    $path = $this->db->get("SELECT `path` FROM `#table_category` WHERE `catid` = " . $category_relation[$pquery['parentid']]);
                                    $category['path'] = $path['path'];
                                    $category['sort'] = $pquery['listorder'];
                                }
                                else
                                {
                                    continue;
                                }
                            }
                            else
                            {
                                // 频道下的一级栏目
                                $category['name'] = $query['catname'];
                                $category['alias'] = $query['catdir'];
                                $category['sort'] = $query['listorder'];
                                $category['parentid'] = $channel_relation[$query['channelid']];
                                $path = $this->db->get("SELECT `path` FROM `#table_category` WHERE `catid` = " . $channel_relation[$query['channelid']]);
                                $category['path'] = $path['path'];
                            }

                            if ($new_catid = self::$model_category->add($category))
                            {
                                // 将新的ID关系对应保存起来
                                $category_relation[$parentid] = $new_catid;
                            }
                            else
                            {
                                // error
                                $data['error'][] = $parentid;
                            }
                        }
                    }
                }

                $this->save_relation('category', $category_relation);
                $data['start'] = $start + $pagesize;
                break;

            case 'article':
                $orgi_start = $start;

                // 根据之前的栏目获得要转换的文章
                $category_relation = $this->get_relation('category');
                $article_relation = $this->get_relation('article');

                $cache = $this->get_relation('cache');

                $prev_total = 0;
                foreach ($cache['article'] as $total => $_tables)
                {
                    if ($start < $total)
                    {
                        $tables = $_tables;
                        if (($start - $prev_total) < $pagesize)
                        {
                            $start = 0;
                        }
                        break;
                    }
                    $prev_total = $total;
                }

                $converted = $pagesize;

                if (!empty($category_relation) && $tables && ($result = $this->import_db->select("SELECT * FROM `{$tables[0]}` n LEFT JOIN `{$tables[1]}` c ON n.`articleid` = c.`articleid` WHERE n.`catid` IN (" . implode(',', array_keys($category_relation)) .") LIMIT $start, $pagesize")))
                {
                    // 得到实际转换的条数
                    $converted = count($result);

                    foreach ($result as $article)
                    {
                        if (isset($article_relation[$article['catid']][$article['articleid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($article);

                        $content = self::$article;
                        $content['catid'] = $category_relation[$article['catid']];
                        $content['title'] = $article['titleintact'] ? $article['titleintact'] : $article['title'];
                        $content['color'] = str_replace('color:', '', $article['style']);
                        $content['tags'] = str_replace(',', ' ', $article['keywords']);
                        $content['status'] = $this->status_relation[$article['status']];

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($article['thumb'], $options);

                        if ($article['islink'])
                        {
                            $content['modelid'] = 3;
                            $content['url'] = $article['linkurl'];

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['subtitle'] = $article['subheading'];
                            $content['source'] = $this->get_copyfrom($article['copyfrom']);
                            $content['author'] = $article['author'];
                            $content['editor'] = $article['username'];
                            $content['allowcomment'] = $article['showcommentlink'];

                            // 处理内容替换
                            $content['content'] = $this->handle_content($article['content'], $options);

                            if ($article['paginationtype'] == 2 && (preg_match('/\[next\]/', $content['content'])))
                            {
                                $content['content'] = $this->pagevar . preg_replace('/\[next\]/', $this->pagevar, $content['content']);
                            }

                            $content['description'] = strip_tags(preg_replace("/\[next\]/", '', $article['introduce']));

                            $contentid = self::$model_article->add($content);
                        }

                        //print_r($content);

                        if ($contentid)
                        {
                            $userid = $this->userid($article['username']);

                            if ($content['status'] == 6)
                            {
                                $published = $article['addtime'];
                                $publishedby = $userid;
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$article['addtime']}', `createdby` = '$userid',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$article['hits']}' WHERE `contentid` = $contentid");
                            $article_relation[$article['catid']][$article['articleid']] = $contentid;
                        }
                        else
                        {
                            // 出错
                            $data['error'][] = $article['articleid'];
                        }
                    }

                    $this->save_relation('article', $article_relation);
                }

                $data['start'] = $orgi_start + $converted;
                break;

            case 'picture':
                $orgi_start = $start;

                // 根据之前的栏目获得要转换的组图
                $category_relation = $this->get_relation('category');
                $picture_relation = $this->get_relation('picture');
                $cache = $this->get_relation('cache');

                $prev_total = 0;
                foreach ($cache['picture'] as $total => $_tables)
                {
                    if ($start < $total)
                    {
                        $tables = $_tables;
                        if (($start - $prev_total) < $pagesize)
                        {
                            $start = 0;
                        }
                        break;
                    }
                    $prev_total = $total;
                }

                $converted = $pagesize;

                if (!empty($category_relation) && $tables && ($result = $this->import_db->select("SELECT * FROM `{$tables[0]}` WHERE `catid` IN (" . implode(',', array_keys($category_relation)) .") LIMIT $start, $pagesize")))
                {
                    // 得到实际转换的条数
                    $converted = count($result);

                    foreach ($result as $picture)
                    {
                        if (isset($picture_relation[$picture['catid']][$picture['pictureid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($picture);

                        $content = self::$picture;
                        $content['catid'] = $category_relation[$picture['catid']];
                        $content['title'] = $picture['title'];
                        $content['color'] = str_replace('color:', '', $picture['style']);
                        $content['tags'] = str_replace(',', ' ', $picture['keywords']);
                        $content['status'] = $this->status_relation[$picture['status']];

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($picture['thumb'], $options);

                        if ($picture['islink'])
                        {
                            $content['modelid'] = 3;
                            $content['url'] = $picture['linkurl'];

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['source'] = $this->get_copyfrom($picture['copyfrom']);
                            $content['author'] = $picture['author'];
                            $content['editor'] = $picture['username'];
                            $content['description'] = strip_tags($picture['introduce']);

                            $contentid = self::$model_picture->add($content);
                        }

                        if ($contentid)
                        {
                            $userid = $this->userid($picture['username']);

                            if ($content['status'] == 6)
                            {
                                $published = $picture['addtime'];
                                $publishedby = $userid;
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$picture['addtime']}', `createdby` = '$userid',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$picture['hits']}' WHERE `contentid` = $contentid");

                            if ($picture['pictureurls'])
                            {
                                $attachments = array_filter(explode("\n", $picture['pictureurls']));

                                foreach ($attachments as $attachment)
                                {
                                    $attachment = array_map('trim', explode('|', $attachment));

                                    // 处理路径
                                    $attachment['filepath'] = $this->handle_attach($attachment[1], $options);

                                    // 先插入到 attachment
                                    $lastslash = strrpos($attachment['filepath'], '/') + 1;
                                    $filename = substr($attachment['filepath'], $lastslash);
                                    $fileext = explode('.', $filename);

                                    $a = array(
                                    'alias' => $attachment['filename'],
                                    'filename' => $filename,
                                    'filepath' => substr($attachment['filepath'], 0, $lastslash),
                                    'filemime' => 'application/octet-stream',
                                    'fileext' => $fileext[1],
                                    'filesize' => 0,
                                    'isimage' => 1,
                                    'thumb' => 0,
                                    'remote' => 0,
                                    'fid' => 0
                                    );
                                    if ($aid = self::$model_attachment->add($a))
                                    {
                                        // 再插入到 picture_group
                                        $g = array(
                                        'contentid' => $contentid,
                                        'aid' => $aid,
                                        'image' => $attachment['filepath'],
                                        'note' => $attachment[0],
                                        'url' => '',
                                        'sort' => 0
                                        );
                                        self::$model_picture_group->add($g);
                                    }
                                }

                                if ($total = count($attachments))
                                {
                                    $this->db->update("UPDATE `#table_picture` SET `total` = $total WHERE `contentid` = $contentid");
                                }
                            }

                            $picture_relation[$picture['catid']][$picture['pictureid']] = $contentid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $picture['pictureid'];
                        }
                    }

                    $this->save_relation('picture', $picture_relation);
                }

                $data['start'] = $orgi_start + $converted;
                break;

            case 'comment':
                // 根据之前的内容获得要转换的评论
                $content_relation = $this->get_relation('article');
                foreach ($this->get_relation('picture') as $key => $value)
                {
                    $content_relation[$key] = $value;
                }

                $comment_relation = $this->get_relation('comment');

                if (!empty($content_relation))
                {
                    foreach ($content_relation as $catid => $value)
                    {
                        $keyid = $this->import_db->get("SELECT `channelid` FROM `#table_category` WHERE `catid` = $catid");
                        $keyid = $keyid['channelid'];

                        if (is_array($value))
                        {
                            foreach ($value as $itemid => $contentid)
                            {
                                if ($comments = $this->import_db->select("SELECT * FROM `#table_comment` WHERE `keyid` = '$keyid' AND `itemid` = '$itemid'"))
                                {
                                    $query = $this->db->get("SELECT `allowcomment` FROM `#table_content` WHERE `contentid` = $contentid");
                                    if ($query['allowcomment'] == 0)
                                    {
                                        $after_update = true;
                                        $this->db->update("UPDATE `#table_content` SET `allowcomment` = 1 WHERE `contentid` = $contentid");
                                    }
                                    foreach ($comments as $c)
                                    {
                                        if (isset($comment_relation[$c['cid']]))
                                        {
                                            continue;
                                        }

                                        // 处理编码问题
                                        $this->handle_charset($c);

                                        $comment['contentid'] = $contentid;
                                        $comment['disabled'] = $c['passed'] ? 0 : 1;

                                        // 回复(盖楼)
                                        $comment['content'] = str_replace(array('[/quote]', '[/blue]', '[blue]', '[quote]'), array('[/floor][reply]', '[/name]', '[name]', '[floor]'), $c['content']);

                                        if (!$c['username'])
                                        {
                                            $comment['anonymous'] = 1;
                                        }

                                        if ($commentid = self::$model_comment->add($comment))
                                        {
                                            // 更新一些字段
                                            $createdby = $this->userid($c['username']);

                                            $this->db->update("UPDATE `#table_comment` SET `support` = '{$c['support']}', `against` = '{$c['against']}', `ip` = '{$c['ip']}', `created` = '{$c['addtime']}', `createdby` = '$createdby' WHERE `commentid` = $commentid");

                                            $comment_relation[$c['cid']] = $commentid;
                                        }
                                        else
                                        {
                                            $data['error'][] = $c['cid'];
                                        }
                                    }
                                    if ($after_update)
                                    {
                                        $this->db->update("UPDATE `#table_content` SET `allowcomment` = 0 WHERE `contentid` = $contentid");
                                    }
                                }
                            }
                        }
                    }

                    $this->save_relation('comment', $comment_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'member':
                if ($members = $this->import_db->select("SELECT * FROM `#table_member` m LEFT JOIN `#table_member_info` i ON m.`userid` = i.`userid` LIMIT $start, " . $pagesize))
                {
                    $member_relation = $this->get_relation('member');
                    $member_group_relation = $this->get_relation('member_group');

                    // 转换会员组
                    if (empty($member_group_relation))
                    {
                        if ($groups = $this->import_db->select("SELECT * FROM `#table_member_group`"))
                        {
                            $cmstop_group_relation = array(
                                1 => 1,
                                2 => 5,
                                3 => 2,
                                4 => 3,
                                5 => 4,
                                6 => 6
                            );

                            foreach ($groups as $g)
                            {
                                $this->handle_charset($g);

                                $group = array(
                                'name' => $g['groupname'],
                                'remarks' => $g['introduce']
                                );

                                // 如果在对应关系里面，直接更新
                                if (isset($cmstop_group_relation[$g['groupid']]))
                                {
                                    $groupid = $cmstop_group_relation[$g['groupid']];
                                    $this->db->update("UPDATE `#table_member_group` SET " . $this->handle_key_value_update($group) . " WHERE `groupid` = $groupid");
                                }
                                else
                                {
                                    // 插入
                                    $groupid = self::$model_member_group->add($group);
                                }
                                $member_group_relation[$g['groupid']] = $groupid;
                            }
                        }
                        $this->save_relation('member_group', $member_group_relation);
                    }

                    foreach ($members as $m)
                    {
                        if (isset($member_relation[$m['userid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($m);

                        // 数据库直接插入
                        $member = array(
                            'userid' => $m['userid'],
                            'username' => $m['username'],
                            'password' => $m['password'],
                            'email' => $m['email'] ? $m['email'] : $this->default_email,
                            'groupid' => $member_group_relation[$m['groupid']],
                            'regip' => $m['regip'],
                            'regtime' => $m['regtime'],
                            'lastloginip' => $m['lastloginip'],
                            'lastlogintime' => $m['lastlogintime'],
                            'logintimes' => $m['logintimes'],
                            'posts' => $m['items'],
                            'pv' => $m['hits'],
                            'credits' => $m['credit']
                        );

                        $member = $this->handle_key_value($member);
                        if ($userid = $this->db->insert("INSERT INTO `#table_member` ({$member['key']}) VALUES ({$member['value']})"))
                        {
                            $userid = $m['userid'];

                            // 详细信息
                            $member = array(
                                'userid' => $userid,
                                'name' => $m['truename'],
                                'sex' => $m['gender'],
                                'msn' => $m['msn'],
                                'telephone' => $m['telephone'],
                                'address' => $m['address'],
                                'qq' => $m['qq'],
                                'birthday' => $m['birthday'],
                                'zipcode' => $m['postid'],
                                'mobile' => $m['mobile'],
                                'authstr' => $m['authstr'],
                                'remarks' => $m['note'],
                            );
                            $member = $this->handle_key_value($member);
                            $this->db->insert("INSERT INTO `#table_member_detail` ({$member['key']}) VALUES ({$member['value']})");

                            $member_relation[$m['userid']] = $userid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $m['userid'];
                        }
                    }

                    $this->save_relation('member', $member_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            default:
                break;
        }

        return $data;
    }

    private function get_category_sql($select, $addon = '')
    {
        return "SELECT $select FROM `#table_category` WHERE `channelid` IN (SELECT `channelid` FROM `#table_channel` WHERE (`module` = 'article' OR `module` = 'picture')) " . $addon;
    }

    private function userid($username)
    {
        static $_users = array();

        if (!empty($username))
        {
            if (!isset($_users[$username]))
            {
                if ($userid = $this->import_db->get("SELECT `userid` FROM `#table_member` WHERE `username` = '$username'"))
                {
                    $_users[$username] = $userid['userid'];
                    return $userid['userid'];
                }
                return 0;
            }
            return $_users[$username];
        }
        return 0;
    }

    private function get_copyfrom($copyform)
    {
        $copyform = explode('|', $copyform);
        return $copyform[0];
    }

    private function content_info($module)
    {
        $total = 0;
        $cache = $this->get_relation('cache');
        $cache[$module] = array();
        if ($channels = $this->import_db->select("SELECT `channelid` FROM `#table_channel` WHERE `module` = '$module'"))
        {
            // 计算指定模型的总数
            foreach ($channels as $channleid)
            {
                $channleid = $channleid['channelid'];
                $query = $this->import_db->get("SELECT COUNT(`{$module}id`) AS `total` FROM `#table_{$module}_{$channleid}`");
                if ($query['total'])
                {
                    $total += $query['total'];
                    $cache[$module][$total] = array("#table_{$module}_{$channleid}", "#table_{$module}_" . $this->module_extra_table_relation[$module] . "_{$channleid}");
                }
            }
        }
        $this->save_relation('cache', $cache);
        return $total;
    }
}
