<?php defined('IN_ADMIN') or exit;

class phpcms2008 extends import implements ICmsImport
{
    protected $config = array(
        pagesize => array(
            'category' => 30,
            'article' => 20,
            'picture' => 20,
            'comment' => 20,
            'member' => 20
        ),
        data => array(
            'thumb_search' => '',
            'thumb_replace' => '',
            'thumb_prefix' => '',
            'attach_search' => '',
            'attach_replace' => '',
            'attach_prefix' => 'uploadfile/',
            'content_search' => array(
                '="/uploadfile/'
            ),
            'content_replace' => array(
                "=\"{UPLOAD_URL}uploadfile/"
            )
        )
    );

    private $style_relation = array(
        "c1" => "#000",
        "c2" => "#fff",
        "c3" => "#008000",
        "c4" => "#800000",
        "c5" => "#808000",
        "c6" => "#000080",
        "c7" => "#800080",
        "c8" => "#808080",
        "c9" => "#ff0",
        "c10" => "#0f0",
        "c11" => "#0ff",
        "c12" => "#f0f",
        "c13" => "#f00",
        "c14" => "#00f",
        "c15" => "#008080"
    );
    
    private $status_relation = array(
        99 => 6,
        3 => 3,
        2 => 1
    );

    function __construct($options)
    {
        parent::__construct($options);

        $this->relation_base_path .= __CLASS__ . '/';
    }

    function config($options)
    {
        $data = array();

        if ($options['data'])
        {
            $query = $this->import_db->get($this->get_category_sql('COUNT(`catid`) AS `total`'));
            $data['data']['category'] = $query['total'];
        }

        if ($options['member'])
        {
            $query = $this->import_db->get("SELECT COUNT(`userid`) AS `total` FROM `#table_member`");
            $data['member']['total'] = $query['total'];
        }

        $this->_after_config($data);
        return $data;
    }

    function detail($options)
    {
        $data = array();

        if ($options['member'])
        {
            $query = "SELECT COUNT(`userid`) AS `total` FROM `#table_member`";
            $query = $this->import_db->get($query);
            $data['member']['total'] = $query['total'];
        }

        if ($options['data'])
        {
            $cat_sql = '';

            // 计算栏目数
            $sql = $this->get_category_sql('COUNT(`catid`) AS `total`');
            $query = $this->import_db->get($sql);
            $data['data']['total']['category'] = $query['total'];

            // 计算文章数
            if ($options['data']['article'])
            {
                $sql = "SELECT COUNT(m.`contentid`) AS `total` FROM `#table_c_news` m LEFT JOIN `#table_content` c ON m.`contentid` = c.`contentid`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['article'] = $query['total'];
            }

            // 计算组图数
            if ($options['data']['picture'])
            {
                $sql = "SELECT COUNT(m.`contentid`) AS `total` FROM `#table_c_picture` m LEFT JOIN `#table_content` c ON m.`contentid` = c.`contentid`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['picture'] = $query['total'];
            }

            // 计算评论数
            $modelid = array();
            if ($options['data']['article'])
            {
                $modelid[] = 1;
            }
            if ($options['data']['picture'])
            {
                $modelid[] = 2;
            }
            if (!empty($modelid) && $options['data']['comment'])
            {
                $sql = "SELECT COUNT(`commentid`) AS `total` FROM `#table_comment`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['comment'] = $query['total'];
            }
        }

        return $data;
    }

    function import($options)
    {
        $type = $options['type'];
        $start = intval($options['start']);
        $pagesize = $this->pagesize($type);
        $data = array();

        switch ($type)
        {
            case 'category':
                if ($categorys = $this->import_db->select($this->get_category_sql('`catid`', "LIMIT $start, $pagesize")))
                {
                    $category_relation = $this->get_relation('category');
                    foreach ($categorys as $c)
                    {
                        $catid = $c['catid'];

                        // 如果之前的操作已经添加过了，跳过
                        if (isset($category_relation[$catid]))
                        {
                            continue;
                        }

                        // 否则，转换栏目数据并添加
                        $cat_sql = "SELECT `catid`, `parentid`, `arrparentid`, `catname`, `parentdir`, `catdir`, `url`, `setting`, `listorder` FROM `#table_category` WHERE `catid` = ";

                        $query = $this->import_db->get($cat_sql . $catid);
                        $this->handle_charset($query);
                        $parentids = explode(',', $query['arrparentid']);
                        array_shift($parentids);
                        $parentids[] = $catid;
                        foreach ($parentids as $parentid)
                        {
                            if (isset($category_relation[$parentid]))
                            {
                                continue;
                            }

                            // 默认是一个频道
                            $category = self::$category;

                            // 如果 arrparentid 为真，则假定是一个子栏目
                            if ($query['arrparentid'])
                            {
                                // 添加栏目，由于是按照从前到后的顺序来添加，假定按照这个顺序添加的栏目，父栏目都已经存在
                                if ($pquery = $this->import_db->get($cat_sql . $parentid))
                                {
                                    $this->handle_charset($pquery);
                                    $category['parentid'] = $category_relation[$pquery['parentid']];
                                    $category['name'] = $pquery['catname'];
                                    $category['alias'] = $pquery['catdir'];

                                    // 发布点
                                    $category['path'] = $this->handle_path($pquery['catname'], $pquery['url'], $pquery['catdir'], $pquery['parentdir']);

                                    $category['sort'] = $pquery['listorder'];
                                }
                                else
                                {
                                    continue;
                                }
                            }
                            else
                            {
                                $category['name'] = $query['catname'];
                                $category['alias'] = $query['catdir'];
                                $category['sort'] = $query['listorder'];

                                // 发布点
                                $category['path'] = $this->handle_path($query['catname'], $query['url'], $query['catdir'], $query['parentdir']);
                            }

                            if ($new_catid = self::$model_category->add($category))
                            {
                                // 将新的ID关系对应保存起来
                                $category_relation[$parentid] = $new_catid;
                            }
                            else
                            {
                                // error
                                $data['error'][] = $parentid;
                            }
                        }
                    }
                }

                $this->save_relation('category', $category_relation);
                $data['start'] = $start + $pagesize;
                break;

            case 'article':
                // 根据之前的栏目获得要转换的文章
                $category_relation = $this->get_relation('category');
                $article_relation = $this->get_relation('article');

                if (!empty($category_relation) && ($result = $this->import_db->select("SELECT * FROM `#table_c_news` n LEFT JOIN `#table_content` c ON n.`contentid` = c.`contentid` WHERE c.`catid` IN (" . implode(',', array_keys($category_relation)) .") LIMIT $start, " . $pagesize)))
                {
                    foreach ($result as $article)
                    {
                        if (isset($article_relation[$article['contentid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($article);

                        $content = self::$article;
                        $content['catid'] = $category_relation[$article['catid']];
                        $content['title'] = $article['titleintact'] ? $article['titleintact'] : $article['title'];
                        $content['color'] = $this->style_relation[$article['style']];
                        $content['tags'] = $article['keywords'];
                        $content['status'] = $this->status_relation[$article['status']];

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($article['thumb'], $options);

                        if ($article['islink'])
                        {
                            $content['modelid'] = 3;
                            $content['url'] = $article['url'];

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['subtitle'] = $article['titleintact'] ? $article['title'] : '';
                            $content['source'] = $article['copyfrom'];
                            $content['author'] = $article['author'];
                            $content['editor'] = $article['username'];

                            // 处理内容替换
                            $content['content'] = $this->handle_content($article['content'], $options);

                            if ($article['paginationtype'] == 2 && preg_match('/\[page\]/', $content['content']))
                            {
                                $content['content'] = preg_replace('/\[page\](.*)\[\/page\]/', $this->pagetitlevar, $content['content']);
                                $content['content'] = preg_replace('/\[page\]/', $this->pagevar, $content['content']);
                            }

                            $content['description'] = strip_tags(preg_replace("/\[page\].*\[\/page\]/", '', $article['description']));

                            $contentid = self::$model_article->add($content);
                        }

                        if ($contentid)
                        {
                            // 浏览量
                            $pv = $this->import_db->get("SELECT `hits` FROM `#table_content_count` WHERE `contentid` = $contentid");

                            $published = '';
                            $publishedby = '';
                            if ($content['status'] == 6)
                            {
                                $published = $article['inputtime'];
                                $publishedby = $article['userid'];
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$article['inputtime']}', `createdby` = '{$article['userid']}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$pv['hits']}' WHERE `contentid` = $contentid");
                            $article_relation[$article['contentid']] = $contentid;
                        }
                        else
                        {
                            // 出错
                            $data['error'][] = $article['contentid'];
                        }
                    }

                    $this->save_relation('article', $article_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'picture':
                // 根据之前的栏目获得要转换的组图
                $category_relation = $this->get_relation('category');
                $picture_relation = $this->get_relation('picture');

                if (!empty($category_relation) && ($result = $this->import_db->select("SELECT * FROM `#table_c_picture` m LEFT JOIN `#table_content` c ON m.`contentid` = c.`contentid` WHERE c.`catid` IN (" . implode(',', array_keys($category_relation)) .") LIMIT $start, " . $pagesize)))
                {
                    foreach ($result as $picture)
                    {
                        if (isset($picture_relation[$picture['contentid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($picture);

                        $content = self::$picture;
                        $content['catid'] = $category_relation[$picture['catid']];
                        $content['title'] = $picture['title'];
                        $content['color'] = $this->style_relation[$picture['style']];
                        $content['tags'] = $picture['keywords'];
                        $content['status'] = $this->status_relation[$picture['status']];

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($picture['thumb'], $options);

                        if ($picture['islink'])
                        {
                            $content['modelid'] = 3;
                            $content['url'] = $picture['url'];

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['source'] = $picture['copyfrom'];
                            $content['author'] = $picture['author'];
                            $content['editor'] = $picture['username'];
                            $content['description'] = strip_tags($picture['description']);

                            $contentid = self::$model_picture->add($content);
                        }

                        if ($contentid)
                        {
                            // 浏览量
                            $pv = $this->import_db->get("SELECT `hits` FROM `#table_content_count` WHERE `contentid` = $contentid");


                            $published = '';
                            $publishedby = '';
                            if ($content['status'] == 6)
                            {
                                $published = $picture['inputtime'];
                                $publishedby = $picture['userid'];
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$picture['inputtime']}', `createdby` = '{$picture['userid']}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$pv['hits']}' WHERE `contentid` = $contentid");

                            if ($picture['pictureurls'] && ($attachments = $this->import_db->select("SELECT * FROM `#table_attachment` WHERE `contentid` = {$picture['contentid']} AND `isimage` = 1 AND `field` = 'pictureurls'")))
                            {
                                foreach ($attachments as $attachment)
                                {
                                    // 处理编码
                                    $this->handle_charset($attachment, $options);

                                    // 处理路径
                                    $attachment['filepath'] = $this->handle_attach($attachment['filepath'], $options);

                                    // 先插入到 attachment
                                    $lastslash = strrpos($attachment['filepath'], '/') + 1;

                                    $data = array(
                                    'alias' => $attachment['filename'],
                                    'filename' => substr($attachment['filepath'], $lastslash),
                                    'filepath' => substr($attachment['filepath'], 0, $lastslash),
                                    'filemime' => $attachment['filetype'],
                                    'fileext' => $attachment['fileext'],
                                    'filesize' => $attachment['filesize'],
                                    'isimage' => 1,
                                    'thumb' => 0,
                                    'remote' => 0,
                                    'fid' => 0
                                    );
                                    if ($aid = self::$model_attachment->add($data))
                                    {
                                        // 再插入到 picture_group
                                        $data = array(
                                        'contentid' => $contentid,
                                        'aid' => $aid,
                                        'image' => $attachment['filepath'],
                                        'note' => $attachment['description'],
                                        'url' => '',
                                        'sort' => $attachment['listorder']
                                        );
                                        self::$model_picture_group->add($data);
                                    }
                                }

                                if ($total = count($attachments))
                                {
                                    $this->db->update("UPDATE `#table_picture` SET `total` = $total WHERE `contentid` = $contentid");
                                }
                            }

                            $picture_relation[$picture['contentid']] = $contentid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $picture['contentid'];
                        }
                    }

                    $this->save_relation('picture', $picture_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'comment':
                // 根据之前的内容获得要转换的评论
                $content_relation = $this->get_relation('article');
                foreach ($this->get_relation('picture') as $key => $value)
                {
                    $content_relation[$key] = $value;
                }
                $comment_relation = $this->get_relation('comment');

                if (!empty($content_relation))
                {
                    foreach ($content_relation as $key => $value)
                    {
                        if ($comments = $this->import_db->select("SELECT * FROM `#table_comment` WHERE `keyid` = 'phpcms-content-title-$key'"))
                        {
                            foreach ($comments as $c)
                            {
                                if (isset($comment_relation[$c['commentid']]))
                                {
                                    continue;
                                }

                                // 处理编码问题
                                $this->handle_charset($c);

                                $comment['contentid'] = $value;
                                $comment['disabled'] = $c['status'] ? 0 : 1;

                                // 回复(盖楼)
                                $comment['content'] = str_replace(array('[/quote]', '[/blue]', '[blue]', '[quote]'), array('[/floor][reply]', '[/name]', '[name]', '[floor]'), $c['content']);

                                if (!$c['userid'])
                                {
                                    $comment['anonymous'] = 1;
                                }

                                if ($commentid = self::$model_comment->add($comment))
                                {
                                    // 更新一些字段
                                    $createdby = $c['userid'];

                                    $this->db->update("UPDATE `#table_comment` SET `support` = '{$c['support']}', `against` = '{$c['against']}', `ip` = '{$c['ip']}', `created` = '{$c['addtime']}', `createdby` = '$createdby' WHERE `commentid` = $commentid");

                                    $comment_relation[$c['commentid']] = $commentid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $c['commentid'];
                                }
                            }
                        }
                    }

                    $this->save_relation('comment', $comment_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'member':
                if ($members = $this->import_db->select("SELECT * FROM `#table_member` m LEFT JOIN `#table_member_detail` d ON m.`userid` = d.`userid` LEFT JOIN `#table_member_info` i ON m.`userid` = i.`userid` LIMIT $start, " . $pagesize))
                {
                    $member_relation = $this->get_relation('member');
                    $member_group_relation = $this->get_relation('member_group');

                    // 转换会员组
                    if (empty($member_group_relation))
                    {
                        if ($groups = $this->import_db->select("SELECT * FROM `#table_member_group`"))
                        {
                            $cmstop_group_relation = array(
                            1 => 1,
                            2 => 5,
                            3 => 2,
                            4 => 3,
                            5 => 4,
                            6 => 6
                            );

                            foreach ($groups as $g)
                            {
                                $this->handle_charset($g);

                                $group = array(
                                'name' => $g['name'],
                                'status' => $g['disabled'] ? 0 : 1,
                                'allowlogin' => $g['allowvisit'],
                                'allowcontribute' => $g['allowpost'],
                                'sort' => $g['listorder'],
                                'remarks' => $g['description']
                                );

                                // 如果在对应关系里面，直接更新
                                if (isset($cmstop_group_relation[$g['groupid']]))
                                {
                                    $groupid = $cmstop_group_relation[$g['groupid']];
                                    $this->db->update("UPDATE `#table_member_group` SET " . $this->handle_key_value_update($group) . " WHERE `groupid` = $groupid");
                                }
                                else
                                {
                                    // 插入
                                    $groupid = self::$model_member_group->add($group);
                                }
                                $member_group_relation[$g['groupid']] = $groupid;
                            }
                        }
                        $this->save_relation('member_group', $member_group_relation);
                    }

                    $member_authkey = $options['authkey'];

                    foreach ($members as $m)
                    {
                        if (isset($member_relation[$m['userid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($m);

                        // 数据库直接插入
                        $member = array(
                        'userid' => $m['userid'],
                        'username' => $m['username'],
                        'password' => $m['password'],
                        'salt' => $member_authkey,
                        'email' => $m['email'] ? $m['email'] : $this->default_email,
                        'groupid' => $member_group_relation[$m['groupid']],
                        'regip' => $m['regip'],
                        'regtime' => $m['regtime'],
                        'lastloginip' => $m['lastloginip'],
                        'lastlogintime' => $m['lastlogintime'],
                        'logintimes' => $m['logintimes'],
                        'credits' => $m['point']
                        );

                        $member = $this->handle_key_value($member);
                        if ($userid = $this->db->insert("INSERT INTO `#table_member` ({$member['key']}) VALUES ({$member['value']})"))
                        {
                            $userid = $m['userid'];

                            // 详细信息
                            $birthday = explode(' ', $m['birthday']);
                            if (strtotime($birthday[0]))
                            {
                                $birthday = $birthday[0];
                            }
                            else
                            {
                                $birthday = date('Y-m-d');
                            }
                            $member = array(
                            'userid' => $userid,
                            'name' => $m['truename'],
                            'sex' => $m['gender'],
                            'msn' => $m['msn'],
                            'telephone' => $m['telephone'],
                            'address' => $m['address'],
                            'qq' => $m['qq'],
                            'birthday' => $birthday,
                            'zipcode' => $m['postcode'],
                            'mobile' => $m['mobile'],
                            'remarks' => $m['note'],
                            );

                            $member = $this->handle_key_value($member);
                            $this->db->insert("INSERT INTO `#table_member_detail` ({$member['key']}) VALUES ({$member['value']})");

                            $member_relation[$m['userid']] = $userid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $m['userid'];
                        }
                    }

                    $this->save_relation('member', $member_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            default:
                break;
        }

        return $data;
    }

    private function get_category_sql($select, $addon = '')
    {
        return "SELECT $select FROM `#table_category` WHERE `type` = 0 AND `module` = 'phpcms' " . $addon;
    }
}
