<?php defined('IN_ADMIN') or exit;

class sitefactory3500 extends import implements ICmsImport
{

    protected $config = array(
    pagesize => array(
    'category' => 30,
    'article' => 20,
    'picture' => 20,
    'comment' => 20,
    'member' => 20
    ),
    data => array(
    'thumb_search' => '',
    'thumb_replace' => '',
    'thumb_prefix' => 'UploadFiles/',
    'attach_search' => '',
    'attach_replace' => '',
    'attach_prefix' => 'UploadFiles/',
    'content_search' => array(
    '="/UploadFiles/'
    ),
    'content_replace' => array(
    "=\"{UPLOAD_URL}UploadFiles/"
    )
    )
    );

    private $status_relation = array(
    99 => 6,
    0 => 3,
    '-1' => 1
    );

    function __construct($options)
    {
        parent::__construct($options);

        $this->relation_base_path .= __CLASS__ . '/';
    }

    function config($options)
    {
        $data = array();

        if ($options['data'])
        {
            $query = $this->import_db->get($this->get_category_sql('COUNT([NodeID]) AS [total]'));
            $data['data']['category'] = $query['total'];
        }

        if ($options['member'])
        {
            $query = $this->import_db->get("SELECT COUNT([UserID]) AS [total] FROM [#table_Users]");
            $data['member']['total'] = $query['total'];
        }

        $this->_after_config($data);
        return $data;
    }

    function detail($options)
    {
        $data = array();

        if ($options['member'])
        {
            $query = "SELECT COUNT([UserID]) AS [total] FROM [#table_Users]";
            $query = $this->import_db->get($query);
            $data['member']['total'] = $query['total'];
        }

        if ($options['data'])
        {
            $cat_sql = '';

            // 计算栏目数
            $sql = $this->get_category_sql('COUNT([NodeID]) AS [total]');
            $query = $this->import_db->get($sql);
            $data['data']['total']['category'] = $query['total'];

            // 计算文章数
            if ($options['data']['article'])
            {
                $sql = "SELECT COUNT([ID]) AS [total] FROM [#table_U_Article]";
                $query = $this->import_db->get($sql);
                $data['data']['total']['article'] = $query['total'];
            }

            // 计算组图数
            if ($options['data']['picture'])
            {
                $sql = "SELECT COUNT([ID]) AS [total] FROM [#table_U_Photo]";
                $query = $this->import_db->get($sql);
                $data['data']['total']['picture'] = $query['total'];
            }

            // 计算评论数
            $modelid = array();
            if ($options['data']['article'])
            {
                $modelid[] = 1;
            }
            if ($options['data']['picture'])
            {
                $modelid[] = 2;
            }
            if (!empty($modelid) && $options['data']['comment'])
            {
                $sql = "SELECT COUNT([CommentID]) AS [total] FROM [#table_Comment]";
                $query = $this->import_db->get($sql);
                $data['data']['total']['comment'] = $query['total'];
            }
        }

        return $data;
    }

    function import($options)
    {
        $type = $options['type'];
        $start = intval($options['start']);
        $pagesize = $this->pagesize($type);
        $data = array();

        switch ($type)
        {
            case 'category':
                if ($categorys = $this->import_db->select($this->get_category_sql('[NodeID], [ParentID]', $start, $pagesize)))
                {
                    $category_relation = $this->get_relation('category');
                    foreach ($categorys as $c)
                    {
                        $catid = $c['NodeID'];

                        // 如果之前的操作已经添加过了，跳过
                        if (isset($category_relation[$catid]))
                        {
                            continue;
                        }

                        $parentids = array($c['NodeID']);
                        $parentid = $c['ParentID'];
                        while($parentid)
                        {
                            $parent = $this->import_db->get($this->get_category_sql('[NodeID], [ParentID]') .  " AND [NodeID] = $parentid");
                            $parentids[] = $parent['NodeID'];
                            $parentid = $parent['ParentID'];
                        }
                        $parentids = array_reverse($parentids);

                        foreach ($parentids as $parentid)
                        {
                            if (isset($category_relation[$parentid]))
                            {
                                continue;
                            }

                            // 添加栏目，由于是按照从前到后的顺序来添加，假定按照这个顺序添加的栏目，父栏目都已经存在
                            if ($query = $this->import_db->get($this->get_category_sql('[NodeID], [ParentID], c|[NodeDir], c|[ParentDir], c|[NodeName], [IsCreateListPage], [EnableSubDomain], c|[SubDomain]') . " AND [NodeID] = $parentid"))
                            {
                                $category = self::$category;
                                $this->handle_charset($query);

                                $category['parentid'] = $query['ParentID'] ? $category_relation[$query['ParentID']] : '';
                                $category['name'] = $query['NodeName'];
                                $category['alias'] = $query['NodeDir'];

                                if ($query['EnableSubDomain'])
                                {
                                    $category ['path'] = $this->handle_path ( $category ['name'], $query ['domain'], $category ['alias'], $query['ParentDir']);
                                }
                                else
                                {
                                    $category ['path'] = $this->handle_path ( $category ['name'], '', $category ['alias'], $query['ParentDir']);
                                }

                                if ($new_catid = self::$model_category->add($category))
                                {
                                    // 将新的ID关系对应保存起来
                                    $category_relation[$parentid] = $new_catid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $parentid;
                                }
                            }
                            else
                            {
                                continue;
                            }
                        }
                    }
                }

                $this->save_relation('category', $category_relation);
                $data['start'] = $start + $pagesize;
                break;

            case 'article':
                // 根据之前的栏目获得要转换的文章
                $category_relation = $this->get_relation('category');
                $article_relation = $this->get_relation('article');

                $category_condition = implode(',', array_keys($category_relation));
                $offset = max($start - 1, 0);

                if (!empty($category_relation) && ($result = $this->import_db->select($this->_sql("SELECT TOP $pagesize [ID], c|[TitleIntact], c|[Subheading], c|[Author], c|[CopyFrom], c|[Keyword], c|[Intro], c|[PaginationType], c|[Content], [NodeID], [ItemID], c|[Title], c|[Inputer], [Hits], [LinkType], [InputTime], [Status], [PassedTime], c|[Editor], c|[DefaultPicUrl], c|[TitleFontColor], c|[IncludePic], [ShowCommentLink] FROM [#table_U_Article] n LEFT JOIN [#table_CommonModel] c ON [ID] = [ItemID] WHERE [NodeID] IN ($category_condition) AND [ID] NOT IN (SELECT TOP $offset [ItemID] FROM [#table_CommonModel] WHERE [NodeID] IN ($category_condition))"))))
                {
                    foreach ($result as $article)
                    {
                        if (isset($article_relation[$article['ID']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($article);

                        $content = self::$article;
                        $content['catid'] = $category_relation[$article['NodeID']];
                        $content['title'] = $article['Title'];
                        $content['subtitle'] = $article['Subheading'];
                        $content['color'] = $article['TitleFontColor'];
                        $content['tags'] = str_replace('|', ' ', $article['Keyword']);
                        $content['status'] = $this->status_relation[$article['Status']];
                        $content['allowcomment'] = $article['ShowCommentLink'];

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($article['DefaultPicUrl'], $options);

                        $content['source'] = $article['CopyFrom'];
                        $content['author'] = $article['Author'];
                        $content['editor'] = $article['Editor'];

                        // 处理内容替换
                        $content['content'] = $this->handle_content($article['Content'], $options);

                        if ($article['PaginationType'] == '手动分页' && preg_match('/<p>\[NextPage(.*?)\]<\/p>/', $content['content']))
                        {
                            $content['content'] = preg_replace('/<p>\[NextPage\]<\/p>/', $this->pagevar, $content['content']);
                            $content['content'] = $this->pagevar . preg_replace('/<p>\[NextPage(.*?)\]<\/p>/', $this->pagetitlevar, $content['content']);
                        }

                        $content['description'] = strip_tags(preg_replace("/<p>\[NextPage(.*?)\]<\/p>/", '', $article['Intro']));

                        if ($contentid = self::$model_article->add($content))
                        {
                            $published = '';
                            $publishedby = '';
                            $inputtime = $this->_strtotime($article['InputTime']);
                            if ($content['status'] == 6)
                            {
                                $published = $this->_strtotime($article['PassedTime']);
                                $publishedby = $this->userid($article['Inputer']);
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$inputtime}', `createdby` = '{$publishedby}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$article['Hits']}' WHERE `contentid` = $contentid");
                            $article_relation[$article['ID']] = $contentid;
                        }
                        else
                        {
                            // 出错
                            $data['error'][] = $article['ID'];
                        }
                    }

                    $this->save_relation('article', $article_relation);
                }

                $data['start'] = $start + $pagesize;
                console($data['start']);
                break;

            case 'picture':
                // 根据之前的栏目获得要转换的组图
                $category_relation = $this->get_relation('category');
                $picture_relation = $this->get_relation('picture');

                $category_condition = implode(',', array_keys($category_relation));
                $offset = max($start - 1, 0);

                if (!empty($category_relation) && ($result = $this->import_db->select($this->_sql("SELECT TOP $pagesize [ID], c|[Author], c|[CopyFrom], c|[Keyword], c|[PhotoUrl], c|[PhotoIntro], [NodeID], [ItemID], c|[Title], c|[Inputer], [Hits], [LinkType], [InputTime], [Status], [PassedTime], c|[Editor], c|[DefaultPicUrl], c|[TitleFontColor], c|[IncludePic], [ShowCommentLink] FROM [#table_U_Photo] n LEFT JOIN [#table_CommonModel] c ON n.[ID] = c.[ItemID] WHERE c.[NodeID] IN ($category_condition) AND n.[ID] NOT IN (SELECT TOP $offset [ItemID] FROM [#table_CommonModel] WHERE [NodeID] IN ($category_condition))"))))
                {
                    foreach ($result as $picture)
                    {
                        if (isset($picture_relation[$picture['ID']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($picture);

                        $content = self::$picture;
                        $content['catid'] = $category_relation[$picture['NodeID']];
                        $content['title'] = $picture['Title'];
                        $content['color'] = $picture['TitleFontColor'];
                        $content['tags'] = str_replace('|', ' ', $picture['Keyword']);
                        $content['status'] = $this->status_relation[$picture['Status']];
                        $content['allowcomment'] = $picture['ShowCommentLink'];

                        // 处理缩略图
                        $content['thumb'] = $this->handle_thumb($picture['DefaultPicUrl'], $options);

                        $content['source'] = $picture['CopyFrom'];
                        $content['author'] = $picture['Author'];
                        $content['editor'] = $picture['Inputer'];
                        $content['description'] = strip_tags($picture['PhotoIntro']);

                        if ($contentid = self::$model_picture->add($content))
                        {
                            $published = '';
                            $publishedby = '';
                            $inputtime = $this->_strtotime($picture['InputTime']);

                            if ($content['status'] == 6)
                            {
                                $published = $this->_strtotime($picture['PassedTime']);
                                $publishedby = $this->userid($picture['Inputer']);
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$inputtime}', `createdby` = '{$publishedby}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$picture['Hits']}' WHERE `contentid` = $contentid");

                            if ($picture['PhotoUrl'])
                            {
                                $picture['PhotoUrl'] = explode('$$$', $picture['PhotoUrl']);
                                foreach ($picture['PhotoUrl'] as $p)
                                {
                                    $p = explode('|', $p);
                                    // 跳过远程链接（如果自动下载远程图片，在网络不稳定时很容易造成导入超时）
                                    if (preg_match('/:\/\//', $p[1]))
                                    {
                                        continue;
                                    }
                                    $attachments[] = array('filepath' => $p[1], 'description' => $p[0]);
                                }

                                foreach ($attachments as $attachment)
                                {
                                    // 处理路径
                                    $attachment['filepath'] = $this->handle_attach($attachment['filepath'], $options);

                                    // 先插入到 attachment
                                    $lastslash = strrpos($attachment['filepath'], '/') + 1;
                                    $filename = substr($attachment['filepath'], $lastslash);
                                    $fileinfo = explode('.', $filename);

                                    $data = array(
                                    'alias' => $fileinfo[0],
                                    'filename' => $filename,
                                    'filepath' => substr($attachment['filepath'], 0, $lastslash),
                                    'filemime' => 'application/octet-stream',
                                    'fileext' => $fileinfo[1],
                                    'filesize' => mt_rand(1000, 100000),
                                    'isimage' => 1,
                                    'thumb' => 0,
                                    'remote' => 0,
                                    'fid' => 0
                                    );
                                    if ($aid = self::$model_attachment->add($data))
                                    {
                                        // 再插入到 picture_group
                                        $data = array(
                                        'contentid' => $contentid,
                                        'aid' => $aid,
                                        'image' => $attachment['filepath'],
                                        'note' => $attachment['description'],
                                        'url' => '',
                                        'sort' => 0
                                        );
                                        self::$model_picture_group->add($data);
                                    }
                                }

                                if ($total = count($attachments))
                                {
                                    $this->db->update("UPDATE `#table_picture` SET `total` = $total WHERE `contentid` = $contentid");
                                }
                            }

                            $picture_relation[$picture['ID']] = $contentid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $picture['ID'];
                        }
                    }

                    $this->save_relation('picture', $picture_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'comment':
                // 根据之前的内容获得要转换的评论
                $content_relation = $this->get_relation('article');
                foreach ($this->get_relation('picture') as $key => $value)
                {
                    $content_relation[$key] = $value;
                }
                $comment_relation = $this->get_relation('comment');

                if (!empty($content_relation))
                {
                    foreach ($content_relation as $key => $value)
                    {
                        if ($comments = $this->import_db->select($this->_sql("SELECT [CommentID], [GeneralID], c|[Content], [UpdateTime], [Status], [Agree], [Oppose], c|[IP], [IsPrivate], c|[UserName] FROM [#table_Comment] WHERE [GeneralID] = '$key'")))
                        {
                            foreach ($comments as $c)
                            {
                                if (isset($comment_relation[$c['CommentID']]))
                                {
                                    continue;
                                }

                                // 处理编码问题
                                $this->handle_charset($c);

                                $comment['contentid'] = $value;
                                $comment['disabled'] = $c['Status'] ? 0 : 1;
                                $comment['content'] = $c['Content'];

                                if ($c['UserName'] == '游客')
                                {
                                    $comment['anonymous'] = 1;
                                }

                                if ($commentid = self::$model_comment->add($comment))
                                {
                                    // 更新一些字段
                                    $created = $this->_strtotime($c['UpdateTime']);
                                    $createdby = $this->userid($c['UserName']);
                                    $this->db->update("UPDATE `#table_comment` SET `support` = '{$c['Agree']}', `against` = '{$c['Oppose']}', `ip` = '{$c['IP']}', `created` = '{$created}', `createdby` = '$createdby' WHERE `commentid` = $commentid");

                                    $comment_relation[$c['CommentID']] = $commentid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $c['CommentID'];
                                }
                            }
                        }
                    }

                    $this->save_relation('comment', $comment_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'member':
                $offset = max($start - 1, 0);
                if ($members = $this->import_db->select($this->_sql("SELECT TOP $pagesize [UserID], [GroupID], c|[UserName], c|[TrueName], c|[UserPassword], c|[Email], [Sex], [RegTime], [LoginTimes], [LastLoginTime], c|[LastLoginIP], [Status], c|[CheckNum], c|[Sign], [UserPoint], [PostItems], c|[GetPasswordSid] FROM [#table_Users] WHERE [UserID] NOT IN (SELECT TOP $offset [UserID] FROM [#table_Users])")))
                {
                    $member_relation = $this->get_relation('member');
                    $member_group_relation = $this->get_relation('member_group');

                    // 转换会员组
                    if (empty($member_group_relation))
                    {
                        if ($groups = $this->import_db->select($this->_sql("SELECT [GroupID], c|[GroupName], c|[Description] FROM [#table_UserGroups]")))
                        {
                            $cmstop_group_relation = array(
                            '-2' => 2,
                            1 => 6
                            );

                            foreach ($groups as $g)
                            {
                                if (isset($member_group_relation[$g['GroupID']]))
                                {
                                    continue;
                                }

                                $this->handle_charset($g);
                                $group = array(
                                'name' => $g['GroupName'],
                                'status' => 1,
                                'allowlogin' => 1,
                                'allowcontribute' => 1,
                                'sort' => 0,
                                'remarks' => $g['Description']
                                );

                                // 如果在对应关系里面，直接更新
                                if (isset($cmstop_group_relation[$g['GroupID']]))
                                {
                                    $groupid = $cmstop_group_relation[$g['GroupID']];
                                    $this->db->update("UPDATE `#table_member_group` SET " . $this->handle_key_value_update($group) . " WHERE `groupid` = $groupid");
                                }
                                else
                                {
                                    // 插入
                                    $groupid = self::$model_member_group->add($group);
                                }
                                $member_group_relation[$g['GroupID']] = $groupid;
                            }
                        }
                        $this->save_relation('member_group', $member_group_relation);
                    }

                    foreach ($members as $m)
                    {
                        if (isset($member_relation[$m['uid']]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($m);

                        // 数据库直接插入
                        $member = array(
                        'userid' => $m['UserID'],
                        'username' => $m['UserName'],
                        'password' => $m['UserPassword'],
                        'email' => $m['Email'] ? $m['Email'] : $this->default_email,
                        'groupid' => $member_group_relation[$m['GroupID']],
                        'regip' => $m['127.0.0.1'],
                        'regtime' => $this->_strtotime($m['RegTime']),
                        'lastloginip' => $m['LastLoginIP'],
                        'lastlogintime' => $this->_strtotime($m['LastLoginTime']),
                        'logintimes' => $m['LoginTimes']
                        );

                        $member = $this->handle_key_value($member);
                        if ($userid = $this->db->insert("INSERT INTO `#table_member` ({$member['key']}) VALUES ({$member['value']})"))
                        {
                            $userid = $m['UserID'];

                            $member = array(
                            'userid' => $userid,
                            'name' => $m['truename'],
                            'sex' => $m['gender'],
                            'msn' => $m['msn'],
                            'telephone' => $m['telephone'],
                            'address' => $m['address'],
                            'qq' => $m['qq'],
                            'zipcode' => $m['postcode'],
                            'mobile' => $m['mobile'],
                            'remarks' => $m['note'],
                            );

                            $member = array(
                            'userid' => $userid,
                            'name' => $m['TrueName'],
                            'sex' => $m['Sex'],
                            'remarks' => $m['Sign'],
                            'authstr' => $m['CheckNum']
                            );

                            if ($more_info = $this->import_db->get($this->_sql("SELECT c|[MSN], c|[OfficePhone], c|[Address], c|[QQ], [Birthday], c|[ZipCode], c|[Mobile] FROM [#table_Contacter] WHERE [ContacterID] = '$userid'")))
                            {
                                if ($more_info['Birthday'])
                                {
                                    $more_info['Birthday'] = explode(' ', preg_replace('/\s+/', ' ', $more_info['Birthday']));
                                    array_pop($more_info['Birthday']);
                                }

                                $member['msn'] = $more_info['MSN'];
                                $member['telephone'] = $more_info['OfficePhone'];
                                $member['address'] = $more_info['Address'];
                                $member['qq'] = $more_info['QQ'];
                                $member['birthday'] = $more_info['Birthday'] ? date('Y-m-d', strtotime(implode('/', $more_info['Birthday']))) : '';
                                $member['zipcode'] = $more_info['ZipCode'];
                                $member['mobile'] = $more_info['Mobile'];
                            }

                            $member = $this->handle_key_value($member);
                            $this->db->insert("INSERT INTO `#table_member_detail` ({$member['key']}) VALUES ({$member['value']})");

                            $member_relation[$m['UserID']] = $userid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $m['UserID'];
                        }
                    }

                    $this->save_relation('member', $member_relation);
                }

                $data['start'] = $start + $this->pagesize;
                break;

            default:
                break;
        }

        return $data;
    }

    private function get_category_sql($select, $start = -1, $pagesize = 0)
    {
        if ($start >= 0)
        {
            $top = max($start - 1, 0);
            return $this->_sql("SELECT TOP $pagesize $select FROM [#table_Nodes] WHERE ([NodeType] = 1) AND [NodeID] NOT IN (SELECT TOP $top [NodeID] FROM [#table_Nodes])");
        }
        else
        {
            return $this->_sql("SELECT $select FROM [#table_Nodes] WHERE ([NodeType] = 1) ");
        }
    }

    private function _sql($sql)
    {
        return preg_replace('/c\|(.*?\])/', "Convert(text, $1) AS $1", $sql);
    }

    private function _strtotime($str)
    {
        $str = explode(' ', preg_replace('/\s+/', ' ', $str));
        $time = array_pop($str);
        $date = implode('/', $str);
        return strtotime($date . ' ' . $time);
    }

    private function userid($username)
    {
        global $user;
        $query = $this->import_db->get("SELECT [UserID] FROM [#table_Users] WHERE [UserName] = '$username'");
        return $query ? $query['UserID'] : $user['userid'];
    }

    private function get_alias($catid)
    {
        return $catid;
    }
}
